// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> A2A unprotected disk details. </summary>
    public partial class A2AUnprotectedDiskDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="A2AUnprotectedDiskDetails"/>. </summary>
        internal A2AUnprotectedDiskDetails()
        {
        }

        /// <summary> Initializes a new instance of <see cref="A2AUnprotectedDiskDetails"/>. </summary>
        /// <param name="diskLunId"> The source lun Id for the data disk. </param>
        /// <param name="diskAutoProtectionStatus"> A value indicating whether the disk auto protection is enabled. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal A2AUnprotectedDiskDetails(int? diskLunId, AutoProtectionOfDataDisk? diskAutoProtectionStatus, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DiskLunId = diskLunId;
            DiskAutoProtectionStatus = diskAutoProtectionStatus;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The source lun Id for the data disk. </summary>
        public int? DiskLunId { get; }
        /// <summary> A value indicating whether the disk auto protection is enabled. </summary>
        public AutoProtectionOfDataDisk? DiskAutoProtectionStatus { get; }
    }
}
