// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> The recovery point type. </summary>
    public readonly partial struct A2ARpRecoveryPointType : IEquatable<A2ARpRecoveryPointType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="A2ARpRecoveryPointType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public A2ARpRecoveryPointType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string LatestValue = "Latest";
        private const string LatestApplicationConsistentValue = "LatestApplicationConsistent";
        private const string LatestCrashConsistentValue = "LatestCrashConsistent";
        private const string LatestProcessedValue = "LatestProcessed";

        /// <summary> Latest. </summary>
        public static A2ARpRecoveryPointType Latest { get; } = new A2ARpRecoveryPointType(LatestValue);
        /// <summary> LatestApplicationConsistent. </summary>
        public static A2ARpRecoveryPointType LatestApplicationConsistent { get; } = new A2ARpRecoveryPointType(LatestApplicationConsistentValue);
        /// <summary> LatestCrashConsistent. </summary>
        public static A2ARpRecoveryPointType LatestCrashConsistent { get; } = new A2ARpRecoveryPointType(LatestCrashConsistentValue);
        /// <summary> LatestProcessed. </summary>
        public static A2ARpRecoveryPointType LatestProcessed { get; } = new A2ARpRecoveryPointType(LatestProcessedValue);
        /// <summary> Determines if two <see cref="A2ARpRecoveryPointType"/> values are the same. </summary>
        public static bool operator ==(A2ARpRecoveryPointType left, A2ARpRecoveryPointType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="A2ARpRecoveryPointType"/> values are not the same. </summary>
        public static bool operator !=(A2ARpRecoveryPointType left, A2ARpRecoveryPointType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="A2ARpRecoveryPointType"/>. </summary>
        public static implicit operator A2ARpRecoveryPointType(string value) => new A2ARpRecoveryPointType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is A2ARpRecoveryPointType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(A2ARpRecoveryPointType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
