// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> Azure specific reprotect input. </summary>
    public partial class A2AReprotectContent : ReverseReplicationProviderSpecificContent
    {
        /// <summary> Initializes a new instance of <see cref="A2AReprotectContent"/>. </summary>
        public A2AReprotectContent()
        {
            VmDisks = new ChangeTrackingList<A2AVmDiskDetails>();
            InstanceType = "A2A";
        }

        /// <summary> Initializes a new instance of <see cref="A2AReprotectContent"/>. </summary>
        /// <param name="instanceType"> The class type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="recoveryContainerId"> The recovery container Id. </param>
        /// <param name="vmDisks"> The list of vm disk details. </param>
        /// <param name="recoveryResourceGroupId"> The recovery resource group Id. Valid for V2 scenarios. </param>
        /// <param name="recoveryCloudServiceId"> The recovery cloud service Id. Valid for V1 scenarios. </param>
        /// <param name="recoveryAvailabilitySetId"> The recovery availability set. </param>
        /// <param name="policyId"> The Policy Id. </param>
        internal A2AReprotectContent(string instanceType, IDictionary<string, BinaryData> serializedAdditionalRawData, ResourceIdentifier recoveryContainerId, IList<A2AVmDiskDetails> vmDisks, ResourceIdentifier recoveryResourceGroupId, string recoveryCloudServiceId, ResourceIdentifier recoveryAvailabilitySetId, ResourceIdentifier policyId) : base(instanceType, serializedAdditionalRawData)
        {
            RecoveryContainerId = recoveryContainerId;
            VmDisks = vmDisks;
            RecoveryResourceGroupId = recoveryResourceGroupId;
            RecoveryCloudServiceId = recoveryCloudServiceId;
            RecoveryAvailabilitySetId = recoveryAvailabilitySetId;
            PolicyId = policyId;
            InstanceType = instanceType ?? "A2A";
        }

        /// <summary> The recovery container Id. </summary>
        public ResourceIdentifier RecoveryContainerId { get; set; }
        /// <summary> The list of vm disk details. </summary>
        public IList<A2AVmDiskDetails> VmDisks { get; }
        /// <summary> The recovery resource group Id. Valid for V2 scenarios. </summary>
        public ResourceIdentifier RecoveryResourceGroupId { get; set; }
        /// <summary> The recovery cloud service Id. Valid for V1 scenarios. </summary>
        public string RecoveryCloudServiceId { get; set; }
        /// <summary> The recovery availability set. </summary>
        public ResourceIdentifier RecoveryAvailabilitySetId { get; set; }
        /// <summary> The Policy Id. </summary>
        public ResourceIdentifier PolicyId { get; set; }
    }
}
