// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> A2A provider specific settings. </summary>
    public partial class A2AReplicationIntentDetails : ReplicationProtectionIntentProviderSpecificSettings
    {
        /// <summary> Initializes a new instance of <see cref="A2AReplicationIntentDetails"/>. </summary>
        /// <param name="recoveryAvailabilityType"> The recovery availability type of the virtual machine. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="recoveryAvailabilityType"/> is null. </exception>
        internal A2AReplicationIntentDetails(string recoveryAvailabilityType)
        {
            Argument.AssertNotNull(recoveryAvailabilityType, nameof(recoveryAvailabilityType));

            VmDisks = new ChangeTrackingList<A2AProtectionIntentDiskDetails>();
            VmManagedDisks = new ChangeTrackingList<A2AProtectionIntentManagedDiskDetails>();
            RecoveryAvailabilityType = recoveryAvailabilityType;
            InstanceType = "A2A";
        }

        /// <summary> Initializes a new instance of <see cref="A2AReplicationIntentDetails"/>. </summary>
        /// <param name="instanceType"> Gets the Instance type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="fabricObjectId"> The fabric specific object Id of the virtual machine. </param>
        /// <param name="primaryLocation"> The primary location for the virtual machine. </param>
        /// <param name="recoveryLocation"> The recovery location for the virtual machine. </param>
        /// <param name="recoverySubscriptionId"> The recovery subscription Id of the virtual machine. </param>
        /// <param name="vmDisks"> The list of vm disk details. </param>
        /// <param name="vmManagedDisks"> The list of vm managed disk details. </param>
        /// <param name="recoveryResourceGroupId"> The recovery resource group id. </param>
        /// <param name="protectionProfile">
        /// The protection profile custom details.
        /// Please note <see cref="ProtectionProfileCustomDetails"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="ExistingProtectionProfile"/> and <see cref="NewProtectionProfile"/>.
        /// </param>
        /// <param name="primaryStagingStorageAccount">
        /// The primary staging storage account details.
        /// Please note <see cref="StorageAccountCustomDetails"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="ExistingStorageAccount"/>.
        /// </param>
        /// <param name="recoveryAvailabilitySet">
        /// The recovery availability set details.
        /// Please note <see cref="RecoveryAvailabilitySetCustomDetails"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="ExistingRecoveryAvailabilitySet"/>.
        /// </param>
        /// <param name="recoveryVirtualNetwork">
        /// The recovery virtual network details.
        /// Please note <see cref="RecoveryVirtualNetworkCustomDetails"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="ExistingRecoveryVirtualNetwork"/> and <see cref="NewRecoveryVirtualNetwork"/>.
        /// </param>
        /// <param name="recoveryProximityPlacementGroup">
        /// The recovery proximity placement group custom details.
        /// Please note <see cref="RecoveryProximityPlacementGroupCustomDetails"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="ExistingRecoveryProximityPlacementGroup"/>.
        /// </param>
        /// <param name="autoProtectionOfDataDisk"> A value indicating whether the auto protection is enabled. </param>
        /// <param name="multiVmGroupName"> The multi vm group name. </param>
        /// <param name="multiVmGroupId"> The multi vm group id. </param>
        /// <param name="recoveryBootDiagStorageAccount">
        /// The boot diagnostic storage account.
        /// Please note <see cref="StorageAccountCustomDetails"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="ExistingStorageAccount"/>.
        /// </param>
        /// <param name="diskEncryptionInfo"> The recovery disk encryption information (for two pass flows). </param>
        /// <param name="recoveryAvailabilityZone"> The recovery availability zone. </param>
        /// <param name="recoveryAvailabilityType"> The recovery availability type of the virtual machine. </param>
        /// <param name="agentAutoUpdateStatus"> A value indicating whether the auto update is enabled. </param>
        /// <param name="automationAccountArmId"> The automation account arm id. </param>
        /// <param name="automationAccountAuthenticationType"> A value indicating the type authentication to use for automation Account. </param>
        internal A2AReplicationIntentDetails(string instanceType, IDictionary<string, BinaryData> serializedAdditionalRawData, ResourceIdentifier fabricObjectId, AzureLocation? primaryLocation, AzureLocation? recoveryLocation, string recoverySubscriptionId, IReadOnlyList<A2AProtectionIntentDiskDetails> vmDisks, IReadOnlyList<A2AProtectionIntentManagedDiskDetails> vmManagedDisks, ResourceIdentifier recoveryResourceGroupId, ProtectionProfileCustomDetails protectionProfile, StorageAccountCustomDetails primaryStagingStorageAccount, RecoveryAvailabilitySetCustomDetails recoveryAvailabilitySet, RecoveryVirtualNetworkCustomDetails recoveryVirtualNetwork, RecoveryProximityPlacementGroupCustomDetails recoveryProximityPlacementGroup, AutoProtectionOfDataDisk? autoProtectionOfDataDisk, string multiVmGroupName, string multiVmGroupId, StorageAccountCustomDetails recoveryBootDiagStorageAccount, SiteRecoveryDiskEncryptionInfo diskEncryptionInfo, string recoveryAvailabilityZone, string recoveryAvailabilityType, SiteRecoveryAgentAutoUpdateStatus? agentAutoUpdateStatus, ResourceIdentifier automationAccountArmId, AutomationAccountAuthenticationType? automationAccountAuthenticationType) : base(instanceType, serializedAdditionalRawData)
        {
            FabricObjectId = fabricObjectId;
            PrimaryLocation = primaryLocation;
            RecoveryLocation = recoveryLocation;
            RecoverySubscriptionId = recoverySubscriptionId;
            VmDisks = vmDisks;
            VmManagedDisks = vmManagedDisks;
            RecoveryResourceGroupId = recoveryResourceGroupId;
            ProtectionProfile = protectionProfile;
            PrimaryStagingStorageAccount = primaryStagingStorageAccount;
            RecoveryAvailabilitySet = recoveryAvailabilitySet;
            RecoveryVirtualNetwork = recoveryVirtualNetwork;
            RecoveryProximityPlacementGroup = recoveryProximityPlacementGroup;
            AutoProtectionOfDataDisk = autoProtectionOfDataDisk;
            MultiVmGroupName = multiVmGroupName;
            MultiVmGroupId = multiVmGroupId;
            RecoveryBootDiagStorageAccount = recoveryBootDiagStorageAccount;
            DiskEncryptionInfo = diskEncryptionInfo;
            RecoveryAvailabilityZone = recoveryAvailabilityZone;
            RecoveryAvailabilityType = recoveryAvailabilityType;
            AgentAutoUpdateStatus = agentAutoUpdateStatus;
            AutomationAccountArmId = automationAccountArmId;
            AutomationAccountAuthenticationType = automationAccountAuthenticationType;
            InstanceType = instanceType ?? "A2A";
        }

        /// <summary> Initializes a new instance of <see cref="A2AReplicationIntentDetails"/> for deserialization. </summary>
        internal A2AReplicationIntentDetails()
        {
        }

        /// <summary> The fabric specific object Id of the virtual machine. </summary>
        public ResourceIdentifier FabricObjectId { get; }
        /// <summary> The primary location for the virtual machine. </summary>
        public AzureLocation? PrimaryLocation { get; }
        /// <summary> The recovery location for the virtual machine. </summary>
        public AzureLocation? RecoveryLocation { get; }
        /// <summary> The recovery subscription Id of the virtual machine. </summary>
        public string RecoverySubscriptionId { get; }
        /// <summary> The list of vm disk details. </summary>
        public IReadOnlyList<A2AProtectionIntentDiskDetails> VmDisks { get; }
        /// <summary> The list of vm managed disk details. </summary>
        public IReadOnlyList<A2AProtectionIntentManagedDiskDetails> VmManagedDisks { get; }
        /// <summary> The recovery resource group id. </summary>
        public ResourceIdentifier RecoveryResourceGroupId { get; }
        /// <summary>
        /// The protection profile custom details.
        /// Please note <see cref="ProtectionProfileCustomDetails"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="ExistingProtectionProfile"/> and <see cref="NewProtectionProfile"/>.
        /// </summary>
        public ProtectionProfileCustomDetails ProtectionProfile { get; }
        /// <summary>
        /// The primary staging storage account details.
        /// Please note <see cref="StorageAccountCustomDetails"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="ExistingStorageAccount"/>.
        /// </summary>
        public StorageAccountCustomDetails PrimaryStagingStorageAccount { get; }
        /// <summary>
        /// The recovery availability set details.
        /// Please note <see cref="RecoveryAvailabilitySetCustomDetails"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="ExistingRecoveryAvailabilitySet"/>.
        /// </summary>
        public RecoveryAvailabilitySetCustomDetails RecoveryAvailabilitySet { get; }
        /// <summary>
        /// The recovery virtual network details.
        /// Please note <see cref="RecoveryVirtualNetworkCustomDetails"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="ExistingRecoveryVirtualNetwork"/> and <see cref="NewRecoveryVirtualNetwork"/>.
        /// </summary>
        public RecoveryVirtualNetworkCustomDetails RecoveryVirtualNetwork { get; }
        /// <summary>
        /// The recovery proximity placement group custom details.
        /// Please note <see cref="RecoveryProximityPlacementGroupCustomDetails"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="ExistingRecoveryProximityPlacementGroup"/>.
        /// </summary>
        public RecoveryProximityPlacementGroupCustomDetails RecoveryProximityPlacementGroup { get; }
        /// <summary> A value indicating whether the auto protection is enabled. </summary>
        public AutoProtectionOfDataDisk? AutoProtectionOfDataDisk { get; }
        /// <summary> The multi vm group name. </summary>
        public string MultiVmGroupName { get; }
        /// <summary> The multi vm group id. </summary>
        public string MultiVmGroupId { get; }
        /// <summary>
        /// The boot diagnostic storage account.
        /// Please note <see cref="StorageAccountCustomDetails"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="ExistingStorageAccount"/>.
        /// </summary>
        public StorageAccountCustomDetails RecoveryBootDiagStorageAccount { get; }
        /// <summary> The recovery disk encryption information (for two pass flows). </summary>
        public SiteRecoveryDiskEncryptionInfo DiskEncryptionInfo { get; }
        /// <summary> The recovery availability zone. </summary>
        public string RecoveryAvailabilityZone { get; }
        /// <summary> The recovery availability type of the virtual machine. </summary>
        public string RecoveryAvailabilityType { get; }
        /// <summary> A value indicating whether the auto update is enabled. </summary>
        public SiteRecoveryAgentAutoUpdateStatus? AgentAutoUpdateStatus { get; }
        /// <summary> The automation account arm id. </summary>
        public ResourceIdentifier AutomationAccountArmId { get; }
        /// <summary> A value indicating the type authentication to use for automation Account. </summary>
        public AutomationAccountAuthenticationType? AutomationAccountAuthenticationType { get; }
    }
}
