// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> A2A provider specific settings. </summary>
    public partial class A2AReplicationDetails : ReplicationProviderSpecificSettings
    {
        /// <summary> Initializes a new instance of <see cref="A2AReplicationDetails"/>. </summary>
        internal A2AReplicationDetails()
        {
            ProtectedDisks = new ChangeTrackingList<A2AProtectedDiskDetails>();
            UnprotectedDisks = new ChangeTrackingList<A2AUnprotectedDiskDetails>();
            ProtectedManagedDisks = new ChangeTrackingList<A2AProtectedManagedDiskDetails>();
            VmNics = new ChangeTrackingList<VmNicDetails>();
            InstanceType = "A2A";
        }

        /// <summary> Initializes a new instance of <see cref="A2AReplicationDetails"/>. </summary>
        /// <param name="instanceType"> Gets the Instance type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="fabricObjectId"> The fabric specific object Id of the virtual machine. </param>
        /// <param name="initialPrimaryZone"> The initial primary availability zone. </param>
        /// <param name="initialPrimaryFabricLocation"> The initial primary fabric location. </param>
        /// <param name="initialRecoveryZone"> The initial recovery availability zone. </param>
        /// <param name="initialPrimaryExtendedLocation"> The initial primary extended location. </param>
        /// <param name="initialRecoveryExtendedLocation"> The initial recovery extended location. </param>
        /// <param name="initialRecoveryFabricLocation"> The initial recovery fabric location. </param>
        /// <param name="multiVmGroupId"> The multi vm group Id. </param>
        /// <param name="multiVmGroupName"> The multi vm group name. </param>
        /// <param name="multiVmGroupCreateOption"> Whether Multi VM group is auto created or specified by user. </param>
        /// <param name="managementId"> The management Id. </param>
        /// <param name="protectedDisks"> The list of protected disks. </param>
        /// <param name="unprotectedDisks"> The list of unprotected disks. </param>
        /// <param name="protectedManagedDisks"> The list of protected managed disks. </param>
        /// <param name="recoveryBootDiagStorageAccountId"> The recovery boot diagnostic storage account Arm Id. </param>
        /// <param name="primaryFabricLocation"> Primary fabric location. </param>
        /// <param name="recoveryFabricLocation"> The recovery fabric location. </param>
        /// <param name="osType"> The type of operating system. </param>
        /// <param name="recoveryAzureVmSize"> The size of recovery virtual machine. </param>
        /// <param name="recoveryAzureVmName"> The name of recovery virtual machine. </param>
        /// <param name="recoveryAzureResourceGroupId"> The recovery resource group. </param>
        /// <param name="recoveryCloudService"> The recovery cloud service. </param>
        /// <param name="recoveryAvailabilitySet"> The recovery availability set. </param>
        /// <param name="selectedRecoveryAzureNetworkId"> The recovery virtual network. </param>
        /// <param name="selectedTfoAzureNetworkId"> The test failover virtual network. </param>
        /// <param name="vmNics"> The virtual machine nic details. </param>
        /// <param name="vmSyncedConfigDetails"> The synced configuration details. </param>
        /// <param name="monitoringPercentageCompletion"> The percentage of the monitoring job. The type of the monitoring job is defined by MonitoringJobType property. </param>
        /// <param name="monitoringJobType"> The type of the monitoring job. The progress is contained in MonitoringPercentageCompletion property. </param>
        /// <param name="lastHeartbeat"> The last heartbeat received from the source server. </param>
        /// <param name="agentVersion"> The agent version. </param>
        /// <param name="agentExpireOn"> Agent expiry date. </param>
        /// <param name="isReplicationAgentUpdateRequired"> A value indicating whether replication agent update is required. </param>
        /// <param name="agentCertificateExpireOn"> Agent certificate expiry date. </param>
        /// <param name="isReplicationAgentCertificateUpdateRequired"> A value indicating whether agent certificate update is required. </param>
        /// <param name="recoveryFabricObjectId"> The recovery fabric object Id. </param>
        /// <param name="vmProtectionState"> The protection state for the vm. </param>
        /// <param name="vmProtectionStateDescription"> The protection state description for the vm. </param>
        /// <param name="lifecycleId"> An id associated with the PE that survives actions like switch protection which change the backing PE/CPE objects internally.The lifecycle id gets carried forward to have a link/continuity in being able to have an Id that denotes the "same" protected item even though other internal Ids/ARM Id might be changing. </param>
        /// <param name="testFailoverRecoveryFabricObjectId"> The test failover fabric object Id. </param>
        /// <param name="rpoInSeconds"> The last RPO value in seconds. </param>
        /// <param name="lastRpoCalculatedOn"> The time (in UTC) when the last RPO value was calculated by Protection Service. </param>
        /// <param name="primaryAvailabilityZone"> The primary availability zone. </param>
        /// <param name="recoveryAvailabilityZone"> The recovery availability zone. </param>
        /// <param name="primaryExtendedLocation"> The primary Extended Location. </param>
        /// <param name="recoveryExtendedLocation"> The recovery Extended Location. </param>
        /// <param name="vmEncryptionType"> The encryption type of the VM. </param>
        /// <param name="tfoAzureVmName"> The test failover vm name. </param>
        /// <param name="recoveryAzureGeneration"> The recovery azure generation. </param>
        /// <param name="recoveryProximityPlacementGroupId"> The recovery proximity placement group Id. </param>
        /// <param name="autoProtectionOfDataDisk"> A value indicating whether the auto protection is enabled. </param>
        /// <param name="recoveryVirtualMachineScaleSetId"> The recovery virtual machine scale set id. </param>
        /// <param name="recoveryCapacityReservationGroupId"> The recovery capacity reservation group Id. </param>
        /// <param name="churnOptionSelected"> A value indicating the churn option selected by user. </param>
        internal A2AReplicationDetails(string instanceType, IDictionary<string, BinaryData> serializedAdditionalRawData, ResourceIdentifier fabricObjectId, string initialPrimaryZone, AzureLocation? initialPrimaryFabricLocation, string initialRecoveryZone, SiteRecoveryExtendedLocation initialPrimaryExtendedLocation, SiteRecoveryExtendedLocation initialRecoveryExtendedLocation, AzureLocation? initialRecoveryFabricLocation, string multiVmGroupId, string multiVmGroupName, MultiVmGroupCreateOption? multiVmGroupCreateOption, string managementId, IReadOnlyList<A2AProtectedDiskDetails> protectedDisks, IReadOnlyList<A2AUnprotectedDiskDetails> unprotectedDisks, IReadOnlyList<A2AProtectedManagedDiskDetails> protectedManagedDisks, ResourceIdentifier recoveryBootDiagStorageAccountId, AzureLocation? primaryFabricLocation, AzureLocation? recoveryFabricLocation, string osType, string recoveryAzureVmSize, string recoveryAzureVmName, ResourceIdentifier recoveryAzureResourceGroupId, string recoveryCloudService, string recoveryAvailabilitySet, ResourceIdentifier selectedRecoveryAzureNetworkId, ResourceIdentifier selectedTfoAzureNetworkId, IReadOnlyList<VmNicDetails> vmNics, A2AVmSyncedConfigDetails vmSyncedConfigDetails, int? monitoringPercentageCompletion, string monitoringJobType, DateTimeOffset? lastHeartbeat, string agentVersion, DateTimeOffset? agentExpireOn, bool? isReplicationAgentUpdateRequired, DateTimeOffset? agentCertificateExpireOn, bool? isReplicationAgentCertificateUpdateRequired, ResourceIdentifier recoveryFabricObjectId, string vmProtectionState, string vmProtectionStateDescription, string lifecycleId, ResourceIdentifier testFailoverRecoveryFabricObjectId, long? rpoInSeconds, DateTimeOffset? lastRpoCalculatedOn, string primaryAvailabilityZone, string recoveryAvailabilityZone, SiteRecoveryExtendedLocation primaryExtendedLocation, SiteRecoveryExtendedLocation recoveryExtendedLocation, SiteRecoveryVmEncryptionType? vmEncryptionType, string tfoAzureVmName, string recoveryAzureGeneration, ResourceIdentifier recoveryProximityPlacementGroupId, AutoProtectionOfDataDisk? autoProtectionOfDataDisk, ResourceIdentifier recoveryVirtualMachineScaleSetId, ResourceIdentifier recoveryCapacityReservationGroupId, ChurnOptionSelected? churnOptionSelected) : base(instanceType, serializedAdditionalRawData)
        {
            FabricObjectId = fabricObjectId;
            InitialPrimaryZone = initialPrimaryZone;
            InitialPrimaryFabricLocation = initialPrimaryFabricLocation;
            InitialRecoveryZone = initialRecoveryZone;
            InitialPrimaryExtendedLocation = initialPrimaryExtendedLocation;
            InitialRecoveryExtendedLocation = initialRecoveryExtendedLocation;
            InitialRecoveryFabricLocation = initialRecoveryFabricLocation;
            MultiVmGroupId = multiVmGroupId;
            MultiVmGroupName = multiVmGroupName;
            MultiVmGroupCreateOption = multiVmGroupCreateOption;
            ManagementId = managementId;
            ProtectedDisks = protectedDisks;
            UnprotectedDisks = unprotectedDisks;
            ProtectedManagedDisks = protectedManagedDisks;
            RecoveryBootDiagStorageAccountId = recoveryBootDiagStorageAccountId;
            PrimaryFabricLocation = primaryFabricLocation;
            RecoveryFabricLocation = recoveryFabricLocation;
            OSType = osType;
            RecoveryAzureVmSize = recoveryAzureVmSize;
            RecoveryAzureVmName = recoveryAzureVmName;
            RecoveryAzureResourceGroupId = recoveryAzureResourceGroupId;
            RecoveryCloudService = recoveryCloudService;
            RecoveryAvailabilitySet = recoveryAvailabilitySet;
            SelectedRecoveryAzureNetworkId = selectedRecoveryAzureNetworkId;
            SelectedTfoAzureNetworkId = selectedTfoAzureNetworkId;
            VmNics = vmNics;
            VmSyncedConfigDetails = vmSyncedConfigDetails;
            MonitoringPercentageCompletion = monitoringPercentageCompletion;
            MonitoringJobType = monitoringJobType;
            LastHeartbeat = lastHeartbeat;
            AgentVersion = agentVersion;
            AgentExpireOn = agentExpireOn;
            IsReplicationAgentUpdateRequired = isReplicationAgentUpdateRequired;
            AgentCertificateExpireOn = agentCertificateExpireOn;
            IsReplicationAgentCertificateUpdateRequired = isReplicationAgentCertificateUpdateRequired;
            RecoveryFabricObjectId = recoveryFabricObjectId;
            VmProtectionState = vmProtectionState;
            VmProtectionStateDescription = vmProtectionStateDescription;
            LifecycleId = lifecycleId;
            TestFailoverRecoveryFabricObjectId = testFailoverRecoveryFabricObjectId;
            RpoInSeconds = rpoInSeconds;
            LastRpoCalculatedOn = lastRpoCalculatedOn;
            PrimaryAvailabilityZone = primaryAvailabilityZone;
            RecoveryAvailabilityZone = recoveryAvailabilityZone;
            PrimaryExtendedLocation = primaryExtendedLocation;
            RecoveryExtendedLocation = recoveryExtendedLocation;
            VmEncryptionType = vmEncryptionType;
            TfoAzureVmName = tfoAzureVmName;
            RecoveryAzureGeneration = recoveryAzureGeneration;
            RecoveryProximityPlacementGroupId = recoveryProximityPlacementGroupId;
            AutoProtectionOfDataDisk = autoProtectionOfDataDisk;
            RecoveryVirtualMachineScaleSetId = recoveryVirtualMachineScaleSetId;
            RecoveryCapacityReservationGroupId = recoveryCapacityReservationGroupId;
            ChurnOptionSelected = churnOptionSelected;
            InstanceType = instanceType ?? "A2A";
        }

        /// <summary> The fabric specific object Id of the virtual machine. </summary>
        public ResourceIdentifier FabricObjectId { get; }
        /// <summary> The initial primary availability zone. </summary>
        public string InitialPrimaryZone { get; }
        /// <summary> The initial primary fabric location. </summary>
        public AzureLocation? InitialPrimaryFabricLocation { get; }
        /// <summary> The initial recovery availability zone. </summary>
        public string InitialRecoveryZone { get; }
        /// <summary> The initial primary extended location. </summary>
        public SiteRecoveryExtendedLocation InitialPrimaryExtendedLocation { get; }
        /// <summary> The initial recovery extended location. </summary>
        public SiteRecoveryExtendedLocation InitialRecoveryExtendedLocation { get; }
        /// <summary> The initial recovery fabric location. </summary>
        public AzureLocation? InitialRecoveryFabricLocation { get; }
        /// <summary> The multi vm group Id. </summary>
        public string MultiVmGroupId { get; }
        /// <summary> The multi vm group name. </summary>
        public string MultiVmGroupName { get; }
        /// <summary> Whether Multi VM group is auto created or specified by user. </summary>
        public MultiVmGroupCreateOption? MultiVmGroupCreateOption { get; }
        /// <summary> The management Id. </summary>
        public string ManagementId { get; }
        /// <summary> The list of protected disks. </summary>
        public IReadOnlyList<A2AProtectedDiskDetails> ProtectedDisks { get; }
        /// <summary> The list of unprotected disks. </summary>
        public IReadOnlyList<A2AUnprotectedDiskDetails> UnprotectedDisks { get; }
        /// <summary> The list of protected managed disks. </summary>
        public IReadOnlyList<A2AProtectedManagedDiskDetails> ProtectedManagedDisks { get; }
        /// <summary> The recovery boot diagnostic storage account Arm Id. </summary>
        public ResourceIdentifier RecoveryBootDiagStorageAccountId { get; }
        /// <summary> Primary fabric location. </summary>
        public AzureLocation? PrimaryFabricLocation { get; }
        /// <summary> The recovery fabric location. </summary>
        public AzureLocation? RecoveryFabricLocation { get; }
        /// <summary> The type of operating system. </summary>
        public string OSType { get; }
        /// <summary> The size of recovery virtual machine. </summary>
        public string RecoveryAzureVmSize { get; }
        /// <summary> The name of recovery virtual machine. </summary>
        public string RecoveryAzureVmName { get; }
        /// <summary> The recovery resource group. </summary>
        public ResourceIdentifier RecoveryAzureResourceGroupId { get; }
        /// <summary> The recovery cloud service. </summary>
        public string RecoveryCloudService { get; }
        /// <summary> The recovery availability set. </summary>
        public string RecoveryAvailabilitySet { get; }
        /// <summary> The recovery virtual network. </summary>
        public ResourceIdentifier SelectedRecoveryAzureNetworkId { get; }
        /// <summary> The test failover virtual network. </summary>
        public ResourceIdentifier SelectedTfoAzureNetworkId { get; }
        /// <summary> The virtual machine nic details. </summary>
        public IReadOnlyList<VmNicDetails> VmNics { get; }
        /// <summary> The synced configuration details. </summary>
        public A2AVmSyncedConfigDetails VmSyncedConfigDetails { get; }
        /// <summary> The percentage of the monitoring job. The type of the monitoring job is defined by MonitoringJobType property. </summary>
        public int? MonitoringPercentageCompletion { get; }
        /// <summary> The type of the monitoring job. The progress is contained in MonitoringPercentageCompletion property. </summary>
        public string MonitoringJobType { get; }
        /// <summary> The last heartbeat received from the source server. </summary>
        public DateTimeOffset? LastHeartbeat { get; }
        /// <summary> The agent version. </summary>
        public string AgentVersion { get; }
        /// <summary> Agent expiry date. </summary>
        public DateTimeOffset? AgentExpireOn { get; }
        /// <summary> A value indicating whether replication agent update is required. </summary>
        public bool? IsReplicationAgentUpdateRequired { get; }
        /// <summary> Agent certificate expiry date. </summary>
        public DateTimeOffset? AgentCertificateExpireOn { get; }
        /// <summary> A value indicating whether agent certificate update is required. </summary>
        public bool? IsReplicationAgentCertificateUpdateRequired { get; }
        /// <summary> The recovery fabric object Id. </summary>
        public ResourceIdentifier RecoveryFabricObjectId { get; }
        /// <summary> The protection state for the vm. </summary>
        public string VmProtectionState { get; }
        /// <summary> The protection state description for the vm. </summary>
        public string VmProtectionStateDescription { get; }
        /// <summary> An id associated with the PE that survives actions like switch protection which change the backing PE/CPE objects internally.The lifecycle id gets carried forward to have a link/continuity in being able to have an Id that denotes the "same" protected item even though other internal Ids/ARM Id might be changing. </summary>
        public string LifecycleId { get; }
        /// <summary> The test failover fabric object Id. </summary>
        public ResourceIdentifier TestFailoverRecoveryFabricObjectId { get; }
        /// <summary> The last RPO value in seconds. </summary>
        public long? RpoInSeconds { get; }
        /// <summary> The time (in UTC) when the last RPO value was calculated by Protection Service. </summary>
        public DateTimeOffset? LastRpoCalculatedOn { get; }
        /// <summary> The primary availability zone. </summary>
        public string PrimaryAvailabilityZone { get; }
        /// <summary> The recovery availability zone. </summary>
        public string RecoveryAvailabilityZone { get; }
        /// <summary> The primary Extended Location. </summary>
        public SiteRecoveryExtendedLocation PrimaryExtendedLocation { get; }
        /// <summary> The recovery Extended Location. </summary>
        public SiteRecoveryExtendedLocation RecoveryExtendedLocation { get; }
        /// <summary> The encryption type of the VM. </summary>
        public SiteRecoveryVmEncryptionType? VmEncryptionType { get; }
        /// <summary> The test failover vm name. </summary>
        public string TfoAzureVmName { get; }
        /// <summary> The recovery azure generation. </summary>
        public string RecoveryAzureGeneration { get; }
        /// <summary> The recovery proximity placement group Id. </summary>
        public ResourceIdentifier RecoveryProximityPlacementGroupId { get; }
        /// <summary> A value indicating whether the auto protection is enabled. </summary>
        public AutoProtectionOfDataDisk? AutoProtectionOfDataDisk { get; }
        /// <summary> The recovery virtual machine scale set id. </summary>
        public ResourceIdentifier RecoveryVirtualMachineScaleSetId { get; }
        /// <summary> The recovery capacity reservation group Id. </summary>
        public ResourceIdentifier RecoveryCapacityReservationGroupId { get; }
        /// <summary> A value indicating the churn option selected by user. </summary>
        public ChurnOptionSelected? ChurnOptionSelected { get; }
    }
}
