// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> The recovery availability type of the virtual machine. </summary>
    public readonly partial struct A2ARecoveryAvailabilityType : IEquatable<A2ARecoveryAvailabilityType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="A2ARecoveryAvailabilityType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public A2ARecoveryAvailabilityType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SingleValue = "Single";
        private const string AvailabilitySetValue = "AvailabilitySet";
        private const string AvailabilityZoneValue = "AvailabilityZone";

        /// <summary> Single. </summary>
        public static A2ARecoveryAvailabilityType Single { get; } = new A2ARecoveryAvailabilityType(SingleValue);
        /// <summary> AvailabilitySet. </summary>
        public static A2ARecoveryAvailabilityType AvailabilitySet { get; } = new A2ARecoveryAvailabilityType(AvailabilitySetValue);
        /// <summary> AvailabilityZone. </summary>
        public static A2ARecoveryAvailabilityType AvailabilityZone { get; } = new A2ARecoveryAvailabilityType(AvailabilityZoneValue);
        /// <summary> Determines if two <see cref="A2ARecoveryAvailabilityType"/> values are the same. </summary>
        public static bool operator ==(A2ARecoveryAvailabilityType left, A2ARecoveryAvailabilityType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="A2ARecoveryAvailabilityType"/> values are not the same. </summary>
        public static bool operator !=(A2ARecoveryAvailabilityType left, A2ARecoveryAvailabilityType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="A2ARecoveryAvailabilityType"/>. </summary>
        public static implicit operator A2ARecoveryAvailabilityType(string value) => new A2ARecoveryAvailabilityType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is A2ARecoveryAvailabilityType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(A2ARecoveryAvailabilityType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
