// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    public partial class A2AProtectedManagedDiskDetails : IUtf8JsonSerializable, IJsonModel<A2AProtectedManagedDiskDetails>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<A2AProtectedManagedDiskDetails>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<A2AProtectedManagedDiskDetails>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<A2AProtectedManagedDiskDetails>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(A2AProtectedManagedDiskDetails)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(DiskId))
            {
                writer.WritePropertyName("diskId"u8);
                writer.WriteStringValue(DiskId);
            }
            if (Optional.IsDefined(RecoveryResourceGroupId))
            {
                writer.WritePropertyName("recoveryResourceGroupId"u8);
                writer.WriteStringValue(RecoveryResourceGroupId);
            }
            if (Optional.IsDefined(RecoveryTargetDiskId))
            {
                writer.WritePropertyName("recoveryTargetDiskId"u8);
                writer.WriteStringValue(RecoveryTargetDiskId);
            }
            if (Optional.IsDefined(RecoveryReplicaDiskId))
            {
                writer.WritePropertyName("recoveryReplicaDiskId"u8);
                writer.WriteStringValue(RecoveryReplicaDiskId);
            }
            if (Optional.IsDefined(RecoveryOrignalTargetDiskId))
            {
                writer.WritePropertyName("recoveryOrignalTargetDiskId"u8);
                writer.WriteStringValue(RecoveryOrignalTargetDiskId);
            }
            if (Optional.IsDefined(RecoveryReplicaDiskAccountType))
            {
                writer.WritePropertyName("recoveryReplicaDiskAccountType"u8);
                writer.WriteStringValue(RecoveryReplicaDiskAccountType);
            }
            if (Optional.IsDefined(RecoveryTargetDiskAccountType))
            {
                writer.WritePropertyName("recoveryTargetDiskAccountType"u8);
                writer.WriteStringValue(RecoveryTargetDiskAccountType);
            }
            if (Optional.IsDefined(RecoveryDiskEncryptionSetId))
            {
                writer.WritePropertyName("recoveryDiskEncryptionSetId"u8);
                writer.WriteStringValue(RecoveryDiskEncryptionSetId);
            }
            if (Optional.IsDefined(PrimaryDiskEncryptionSetId))
            {
                writer.WritePropertyName("primaryDiskEncryptionSetId"u8);
                writer.WriteStringValue(PrimaryDiskEncryptionSetId);
            }
            if (Optional.IsDefined(DiskName))
            {
                writer.WritePropertyName("diskName"u8);
                writer.WriteStringValue(DiskName);
            }
            if (Optional.IsDefined(DiskCapacityInBytes))
            {
                writer.WritePropertyName("diskCapacityInBytes"u8);
                writer.WriteNumberValue(DiskCapacityInBytes.Value);
            }
            if (Optional.IsDefined(PrimaryStagingAzureStorageAccountId))
            {
                writer.WritePropertyName("primaryStagingAzureStorageAccountId"u8);
                writer.WriteStringValue(PrimaryStagingAzureStorageAccountId);
            }
            if (Optional.IsDefined(DiskType))
            {
                writer.WritePropertyName("diskType"u8);
                writer.WriteStringValue(DiskType);
            }
            if (Optional.IsDefined(IsResyncRequired))
            {
                writer.WritePropertyName("resyncRequired"u8);
                writer.WriteBooleanValue(IsResyncRequired.Value);
            }
            if (Optional.IsDefined(MonitoringPercentageCompletion))
            {
                writer.WritePropertyName("monitoringPercentageCompletion"u8);
                writer.WriteNumberValue(MonitoringPercentageCompletion.Value);
            }
            if (Optional.IsDefined(MonitoringJobType))
            {
                writer.WritePropertyName("monitoringJobType"u8);
                writer.WriteStringValue(MonitoringJobType);
            }
            if (Optional.IsDefined(DataPendingInStagingStorageAccountInMB))
            {
                writer.WritePropertyName("dataPendingInStagingStorageAccountInMB"u8);
                writer.WriteNumberValue(DataPendingInStagingStorageAccountInMB.Value);
            }
            if (Optional.IsDefined(DataPendingAtSourceAgentInMB))
            {
                writer.WritePropertyName("dataPendingAtSourceAgentInMB"u8);
                writer.WriteNumberValue(DataPendingAtSourceAgentInMB.Value);
            }
            if (Optional.IsDefined(DiskState))
            {
                writer.WritePropertyName("diskState"u8);
                writer.WriteStringValue(DiskState);
            }
            if (Optional.IsCollectionDefined(AllowedDiskLevelOperation))
            {
                writer.WritePropertyName("allowedDiskLevelOperation"u8);
                writer.WriteStartArray();
                foreach (var item in AllowedDiskLevelOperation)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(IsDiskEncrypted))
            {
                writer.WritePropertyName("isDiskEncrypted"u8);
                writer.WriteBooleanValue(IsDiskEncrypted.Value);
            }
            if (Optional.IsDefined(SecretIdentifier))
            {
                writer.WritePropertyName("secretIdentifier"u8);
                writer.WriteStringValue(SecretIdentifier);
            }
            if (Optional.IsDefined(DekKeyVaultArmId))
            {
                writer.WritePropertyName("dekKeyVaultArmId"u8);
                writer.WriteStringValue(DekKeyVaultArmId);
            }
            if (Optional.IsDefined(IsDiskKeyEncrypted))
            {
                writer.WritePropertyName("isDiskKeyEncrypted"u8);
                writer.WriteBooleanValue(IsDiskKeyEncrypted.Value);
            }
            if (Optional.IsDefined(KeyIdentifier))
            {
                writer.WritePropertyName("keyIdentifier"u8);
                writer.WriteStringValue(KeyIdentifier);
            }
            if (Optional.IsDefined(KekKeyVaultArmId))
            {
                writer.WritePropertyName("kekKeyVaultArmId"u8);
                writer.WriteStringValue(KekKeyVaultArmId);
            }
            if (Optional.IsDefined(FailoverDiskName))
            {
                writer.WritePropertyName("failoverDiskName"u8);
                writer.WriteStringValue(FailoverDiskName);
            }
            if (Optional.IsDefined(TfoDiskName))
            {
                writer.WritePropertyName("tfoDiskName"u8);
                writer.WriteStringValue(TfoDiskName);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        A2AProtectedManagedDiskDetails IJsonModel<A2AProtectedManagedDiskDetails>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<A2AProtectedManagedDiskDetails>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(A2AProtectedManagedDiskDetails)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeA2AProtectedManagedDiskDetails(document.RootElement, options);
        }

        internal static A2AProtectedManagedDiskDetails DeserializeA2AProtectedManagedDiskDetails(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string diskId = default;
            ResourceIdentifier recoveryResourceGroupId = default;
            ResourceIdentifier recoveryTargetDiskId = default;
            ResourceIdentifier recoveryReplicaDiskId = default;
            ResourceIdentifier recoveryOrignalTargetDiskId = default;
            string recoveryReplicaDiskAccountType = default;
            string recoveryTargetDiskAccountType = default;
            ResourceIdentifier recoveryDiskEncryptionSetId = default;
            ResourceIdentifier primaryDiskEncryptionSetId = default;
            string diskName = default;
            long? diskCapacityInBytes = default;
            ResourceIdentifier primaryStagingAzureStorageAccountId = default;
            string diskType = default;
            bool? resyncRequired = default;
            int? monitoringPercentageCompletion = default;
            string monitoringJobType = default;
            double? dataPendingInStagingStorageAccountInMB = default;
            double? dataPendingAtSourceAgentInMB = default;
            string diskState = default;
            IReadOnlyList<string> allowedDiskLevelOperation = default;
            bool? isDiskEncrypted = default;
            string secretIdentifier = default;
            ResourceIdentifier dekKeyVaultArmId = default;
            bool? isDiskKeyEncrypted = default;
            string keyIdentifier = default;
            ResourceIdentifier kekKeyVaultArmId = default;
            string failoverDiskName = default;
            string tfoDiskName = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("diskId"u8))
                {
                    diskId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("recoveryResourceGroupId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    recoveryResourceGroupId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("recoveryTargetDiskId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    recoveryTargetDiskId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("recoveryReplicaDiskId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    recoveryReplicaDiskId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("recoveryOrignalTargetDiskId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    recoveryOrignalTargetDiskId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("recoveryReplicaDiskAccountType"u8))
                {
                    recoveryReplicaDiskAccountType = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("recoveryTargetDiskAccountType"u8))
                {
                    recoveryTargetDiskAccountType = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("recoveryDiskEncryptionSetId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    recoveryDiskEncryptionSetId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("primaryDiskEncryptionSetId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    primaryDiskEncryptionSetId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("diskName"u8))
                {
                    diskName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("diskCapacityInBytes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    diskCapacityInBytes = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("primaryStagingAzureStorageAccountId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    primaryStagingAzureStorageAccountId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("diskType"u8))
                {
                    diskType = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("resyncRequired"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    resyncRequired = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("monitoringPercentageCompletion"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    monitoringPercentageCompletion = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("monitoringJobType"u8))
                {
                    monitoringJobType = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("dataPendingInStagingStorageAccountInMB"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    dataPendingInStagingStorageAccountInMB = property.Value.GetDouble();
                    continue;
                }
                if (property.NameEquals("dataPendingAtSourceAgentInMB"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    dataPendingAtSourceAgentInMB = property.Value.GetDouble();
                    continue;
                }
                if (property.NameEquals("diskState"u8))
                {
                    diskState = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("allowedDiskLevelOperation"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    allowedDiskLevelOperation = array;
                    continue;
                }
                if (property.NameEquals("isDiskEncrypted"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isDiskEncrypted = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("secretIdentifier"u8))
                {
                    secretIdentifier = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("dekKeyVaultArmId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    dekKeyVaultArmId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("isDiskKeyEncrypted"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isDiskKeyEncrypted = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("keyIdentifier"u8))
                {
                    keyIdentifier = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("kekKeyVaultArmId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    kekKeyVaultArmId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("failoverDiskName"u8))
                {
                    failoverDiskName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("tfoDiskName"u8))
                {
                    tfoDiskName = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new A2AProtectedManagedDiskDetails(
                diskId,
                recoveryResourceGroupId,
                recoveryTargetDiskId,
                recoveryReplicaDiskId,
                recoveryOrignalTargetDiskId,
                recoveryReplicaDiskAccountType,
                recoveryTargetDiskAccountType,
                recoveryDiskEncryptionSetId,
                primaryDiskEncryptionSetId,
                diskName,
                diskCapacityInBytes,
                primaryStagingAzureStorageAccountId,
                diskType,
                resyncRequired,
                monitoringPercentageCompletion,
                monitoringJobType,
                dataPendingInStagingStorageAccountInMB,
                dataPendingAtSourceAgentInMB,
                diskState,
                allowedDiskLevelOperation ?? new ChangeTrackingList<string>(),
                isDiskEncrypted,
                secretIdentifier,
                dekKeyVaultArmId,
                isDiskKeyEncrypted,
                keyIdentifier,
                kekKeyVaultArmId,
                failoverDiskName,
                tfoDiskName,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<A2AProtectedManagedDiskDetails>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<A2AProtectedManagedDiskDetails>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(A2AProtectedManagedDiskDetails)} does not support writing '{options.Format}' format.");
            }
        }

        A2AProtectedManagedDiskDetails IPersistableModel<A2AProtectedManagedDiskDetails>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<A2AProtectedManagedDiskDetails>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeA2AProtectedManagedDiskDetails(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(A2AProtectedManagedDiskDetails)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<A2AProtectedManagedDiskDetails>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
