// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> A2A Policy creation input. </summary>
    public partial class A2APolicyCreationContent : PolicyProviderSpecificContent
    {
        /// <summary> Initializes a new instance of <see cref="A2APolicyCreationContent"/>. </summary>
        /// <param name="multiVmSyncStatus"> A value indicating whether multi-VM sync has to be enabled. Value should be 'Enabled' or 'Disabled'. </param>
        public A2APolicyCreationContent(SetMultiVmSyncStatus multiVmSyncStatus)
        {
            MultiVmSyncStatus = multiVmSyncStatus;
            InstanceType = "A2A";
        }

        /// <summary> Initializes a new instance of <see cref="A2APolicyCreationContent"/>. </summary>
        /// <param name="instanceType"> The class type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="recoveryPointHistory"> The duration in minutes until which the recovery points need to be stored. </param>
        /// <param name="crashConsistentFrequencyInMinutes"> The crash consistent snapshot frequency (in minutes). </param>
        /// <param name="appConsistentFrequencyInMinutes"> The app consistent snapshot frequency (in minutes). </param>
        /// <param name="multiVmSyncStatus"> A value indicating whether multi-VM sync has to be enabled. Value should be 'Enabled' or 'Disabled'. </param>
        internal A2APolicyCreationContent(string instanceType, IDictionary<string, BinaryData> serializedAdditionalRawData, int? recoveryPointHistory, int? crashConsistentFrequencyInMinutes, int? appConsistentFrequencyInMinutes, SetMultiVmSyncStatus multiVmSyncStatus) : base(instanceType, serializedAdditionalRawData)
        {
            RecoveryPointHistory = recoveryPointHistory;
            CrashConsistentFrequencyInMinutes = crashConsistentFrequencyInMinutes;
            AppConsistentFrequencyInMinutes = appConsistentFrequencyInMinutes;
            MultiVmSyncStatus = multiVmSyncStatus;
            InstanceType = instanceType ?? "A2A";
        }

        /// <summary> Initializes a new instance of <see cref="A2APolicyCreationContent"/> for deserialization. </summary>
        internal A2APolicyCreationContent()
        {
        }

        /// <summary> The duration in minutes until which the recovery points need to be stored. </summary>
        public int? RecoveryPointHistory { get; set; }
        /// <summary> The crash consistent snapshot frequency (in minutes). </summary>
        public int? CrashConsistentFrequencyInMinutes { get; set; }
        /// <summary> The app consistent snapshot frequency (in minutes). </summary>
        public int? AppConsistentFrequencyInMinutes { get; set; }
        /// <summary> A value indicating whether multi-VM sync has to be enabled. Value should be 'Enabled' or 'Disabled'. </summary>
        public SetMultiVmSyncStatus MultiVmSyncStatus { get; }
    }
}
