// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> ExtendedLocation details data. </summary>
    public partial class A2AFabricSpecificLocationDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="A2AFabricSpecificLocationDetails"/>. </summary>
        internal A2AFabricSpecificLocationDetails()
        {
        }

        /// <summary> Initializes a new instance of <see cref="A2AFabricSpecificLocationDetails"/>. </summary>
        /// <param name="initialPrimaryZone"> The initial source zone info. </param>
        /// <param name="initialRecoveryZone"> The initial target zone info. </param>
        /// <param name="initialPrimaryExtendedLocation"> The initial primary ExtendedLocation. </param>
        /// <param name="initialRecoveryExtendedLocation"> The initial recovery ExtendedLocation. </param>
        /// <param name="initialPrimaryFabricLocation"> Initial primary fabric location info. </param>
        /// <param name="initialRecoveryFabricLocation"> The initial recovery fabric location info. </param>
        /// <param name="primaryZone"> Source zone info. </param>
        /// <param name="recoveryZone"> The target zone info. </param>
        /// <param name="primaryExtendedLocation"> The primary ExtendedLocation. </param>
        /// <param name="recoveryExtendedLocation"> The recovery ExtendedLocation. </param>
        /// <param name="primaryFabricLocation"> Primary fabric location info. </param>
        /// <param name="recoveryFabricLocation"> The recovery fabric location info. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal A2AFabricSpecificLocationDetails(string initialPrimaryZone, string initialRecoveryZone, SiteRecoveryExtendedLocation initialPrimaryExtendedLocation, SiteRecoveryExtendedLocation initialRecoveryExtendedLocation, AzureLocation? initialPrimaryFabricLocation, AzureLocation? initialRecoveryFabricLocation, string primaryZone, string recoveryZone, SiteRecoveryExtendedLocation primaryExtendedLocation, SiteRecoveryExtendedLocation recoveryExtendedLocation, AzureLocation? primaryFabricLocation, AzureLocation? recoveryFabricLocation, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            InitialPrimaryZone = initialPrimaryZone;
            InitialRecoveryZone = initialRecoveryZone;
            InitialPrimaryExtendedLocation = initialPrimaryExtendedLocation;
            InitialRecoveryExtendedLocation = initialRecoveryExtendedLocation;
            InitialPrimaryFabricLocation = initialPrimaryFabricLocation;
            InitialRecoveryFabricLocation = initialRecoveryFabricLocation;
            PrimaryZone = primaryZone;
            RecoveryZone = recoveryZone;
            PrimaryExtendedLocation = primaryExtendedLocation;
            RecoveryExtendedLocation = recoveryExtendedLocation;
            PrimaryFabricLocation = primaryFabricLocation;
            RecoveryFabricLocation = recoveryFabricLocation;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The initial source zone info. </summary>
        public string InitialPrimaryZone { get; }
        /// <summary> The initial target zone info. </summary>
        public string InitialRecoveryZone { get; }
        /// <summary> The initial primary ExtendedLocation. </summary>
        public SiteRecoveryExtendedLocation InitialPrimaryExtendedLocation { get; }
        /// <summary> The initial recovery ExtendedLocation. </summary>
        public SiteRecoveryExtendedLocation InitialRecoveryExtendedLocation { get; }
        /// <summary> Initial primary fabric location info. </summary>
        public AzureLocation? InitialPrimaryFabricLocation { get; }
        /// <summary> The initial recovery fabric location info. </summary>
        public AzureLocation? InitialRecoveryFabricLocation { get; }
        /// <summary> Source zone info. </summary>
        public string PrimaryZone { get; }
        /// <summary> The target zone info. </summary>
        public string RecoveryZone { get; }
        /// <summary> The primary ExtendedLocation. </summary>
        public SiteRecoveryExtendedLocation PrimaryExtendedLocation { get; }
        /// <summary> The recovery ExtendedLocation. </summary>
        public SiteRecoveryExtendedLocation RecoveryExtendedLocation { get; }
        /// <summary> Primary fabric location info. </summary>
        public AzureLocation? PrimaryFabricLocation { get; }
        /// <summary> The recovery fabric location info. </summary>
        public AzureLocation? RecoveryFabricLocation { get; }
    }
}
