// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> ExtendedLocation details data. </summary>
    public partial class A2AExtendedLocationDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="A2AExtendedLocationDetails"/>. </summary>
        internal A2AExtendedLocationDetails()
        {
        }

        /// <summary> Initializes a new instance of <see cref="A2AExtendedLocationDetails"/>. </summary>
        /// <param name="primaryExtendedLocation"> The primary ExtendedLocation. </param>
        /// <param name="recoveryExtendedLocation"> The recovery ExtendedLocation. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal A2AExtendedLocationDetails(SiteRecoveryExtendedLocation primaryExtendedLocation, SiteRecoveryExtendedLocation recoveryExtendedLocation, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PrimaryExtendedLocation = primaryExtendedLocation;
            RecoveryExtendedLocation = recoveryExtendedLocation;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The primary ExtendedLocation. </summary>
        public SiteRecoveryExtendedLocation PrimaryExtendedLocation { get; }
        /// <summary> The recovery ExtendedLocation. </summary>
        public SiteRecoveryExtendedLocation RecoveryExtendedLocation { get; }
    }
}
