// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    public partial class A2ACrossClusterMigrationApplyRecoveryPointContent : IUtf8JsonSerializable, IJsonModel<A2ACrossClusterMigrationApplyRecoveryPointContent>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<A2ACrossClusterMigrationApplyRecoveryPointContent>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<A2ACrossClusterMigrationApplyRecoveryPointContent>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<A2ACrossClusterMigrationApplyRecoveryPointContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(A2ACrossClusterMigrationApplyRecoveryPointContent)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
        }

        A2ACrossClusterMigrationApplyRecoveryPointContent IJsonModel<A2ACrossClusterMigrationApplyRecoveryPointContent>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<A2ACrossClusterMigrationApplyRecoveryPointContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(A2ACrossClusterMigrationApplyRecoveryPointContent)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeA2ACrossClusterMigrationApplyRecoveryPointContent(document.RootElement, options);
        }

        internal static A2ACrossClusterMigrationApplyRecoveryPointContent DeserializeA2ACrossClusterMigrationApplyRecoveryPointContent(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string instanceType = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("instanceType"u8))
                {
                    instanceType = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new A2ACrossClusterMigrationApplyRecoveryPointContent(instanceType, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<A2ACrossClusterMigrationApplyRecoveryPointContent>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<A2ACrossClusterMigrationApplyRecoveryPointContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(A2ACrossClusterMigrationApplyRecoveryPointContent)} does not support writing '{options.Format}' format.");
            }
        }

        A2ACrossClusterMigrationApplyRecoveryPointContent IPersistableModel<A2ACrossClusterMigrationApplyRecoveryPointContent>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<A2ACrossClusterMigrationApplyRecoveryPointContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeA2ACrossClusterMigrationApplyRecoveryPointContent(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(A2ACrossClusterMigrationApplyRecoveryPointContent)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<A2ACrossClusterMigrationApplyRecoveryPointContent>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
