// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> Create network mappings input properties/behavior specific to Azure to Azure Network mapping. </summary>
    public partial class A2ACreateNetworkMappingContent : FabricSpecificCreateNetworkMappingContent
    {
        /// <summary> Initializes a new instance of <see cref="A2ACreateNetworkMappingContent"/>. </summary>
        /// <param name="primaryNetworkId"> The primary azure vnet Id. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="primaryNetworkId"/> is null. </exception>
        public A2ACreateNetworkMappingContent(ResourceIdentifier primaryNetworkId)
        {
            Argument.AssertNotNull(primaryNetworkId, nameof(primaryNetworkId));

            PrimaryNetworkId = primaryNetworkId;
            InstanceType = "AzureToAzure";
        }

        /// <summary> Initializes a new instance of <see cref="A2ACreateNetworkMappingContent"/>. </summary>
        /// <param name="instanceType"> The instance type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="primaryNetworkId"> The primary azure vnet Id. </param>
        internal A2ACreateNetworkMappingContent(string instanceType, IDictionary<string, BinaryData> serializedAdditionalRawData, ResourceIdentifier primaryNetworkId) : base(instanceType, serializedAdditionalRawData)
        {
            PrimaryNetworkId = primaryNetworkId;
            InstanceType = instanceType ?? "AzureToAzure";
        }

        /// <summary> Initializes a new instance of <see cref="A2ACreateNetworkMappingContent"/> for deserialization. </summary>
        internal A2ACreateNetworkMappingContent()
        {
        }

        /// <summary> The primary azure vnet Id. </summary>
        public ResourceIdentifier PrimaryNetworkId { get; }
    }
}
