// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery
{
    internal class StorageClassificationMappingOperationSource : IOperationSource<StorageClassificationMappingResource>
    {
        private readonly ArmClient _client;

        internal StorageClassificationMappingOperationSource(ArmClient client)
        {
            _client = client;
        }

        StorageClassificationMappingResource IOperationSource<StorageClassificationMappingResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = StorageClassificationMappingData.DeserializeStorageClassificationMappingData(document.RootElement);
            return new StorageClassificationMappingResource(_client, data);
        }

        async ValueTask<StorageClassificationMappingResource> IOperationSource<StorageClassificationMappingResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = StorageClassificationMappingData.DeserializeStorageClassificationMappingData(document.RootElement);
            return new StorageClassificationMappingResource(_client, data);
        }
    }
}
