// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery
{
    internal class SiteRecoveryVaultSettingOperationSource : IOperationSource<SiteRecoveryVaultSettingResource>
    {
        private readonly ArmClient _client;

        internal SiteRecoveryVaultSettingOperationSource(ArmClient client)
        {
            _client = client;
        }

        SiteRecoveryVaultSettingResource IOperationSource<SiteRecoveryVaultSettingResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = SiteRecoveryVaultSettingData.DeserializeSiteRecoveryVaultSettingData(document.RootElement);
            return new SiteRecoveryVaultSettingResource(_client, data);
        }

        async ValueTask<SiteRecoveryVaultSettingResource> IOperationSource<SiteRecoveryVaultSettingResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = SiteRecoveryVaultSettingData.DeserializeSiteRecoveryVaultSettingData(document.RootElement);
            return new SiteRecoveryVaultSettingResource(_client, data);
        }
    }
}
