// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery
{
    internal class SiteRecoveryVCenterOperationSource : IOperationSource<SiteRecoveryVCenterResource>
    {
        private readonly ArmClient _client;

        internal SiteRecoveryVCenterOperationSource(ArmClient client)
        {
            _client = client;
        }

        SiteRecoveryVCenterResource IOperationSource<SiteRecoveryVCenterResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = SiteRecoveryVCenterData.DeserializeSiteRecoveryVCenterData(document.RootElement);
            return new SiteRecoveryVCenterResource(_client, data);
        }

        async ValueTask<SiteRecoveryVCenterResource> IOperationSource<SiteRecoveryVCenterResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = SiteRecoveryVCenterData.DeserializeSiteRecoveryVCenterData(document.RootElement);
            return new SiteRecoveryVCenterResource(_client, data);
        }
    }
}
