// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery
{
    internal class SiteRecoveryRecoveryPlanOperationSource : IOperationSource<SiteRecoveryRecoveryPlanResource>
    {
        private readonly ArmClient _client;

        internal SiteRecoveryRecoveryPlanOperationSource(ArmClient client)
        {
            _client = client;
        }

        SiteRecoveryRecoveryPlanResource IOperationSource<SiteRecoveryRecoveryPlanResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = SiteRecoveryRecoveryPlanData.DeserializeSiteRecoveryRecoveryPlanData(document.RootElement);
            return new SiteRecoveryRecoveryPlanResource(_client, data);
        }

        async ValueTask<SiteRecoveryRecoveryPlanResource> IOperationSource<SiteRecoveryRecoveryPlanResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = SiteRecoveryRecoveryPlanData.DeserializeSiteRecoveryRecoveryPlanData(document.RootElement);
            return new SiteRecoveryRecoveryPlanResource(_client, data);
        }
    }
}
