// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery
{
    internal class SiteRecoveryProtectionContainerOperationSource : IOperationSource<SiteRecoveryProtectionContainerResource>
    {
        private readonly ArmClient _client;

        internal SiteRecoveryProtectionContainerOperationSource(ArmClient client)
        {
            _client = client;
        }

        SiteRecoveryProtectionContainerResource IOperationSource<SiteRecoveryProtectionContainerResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = SiteRecoveryProtectionContainerData.DeserializeSiteRecoveryProtectionContainerData(document.RootElement);
            return new SiteRecoveryProtectionContainerResource(_client, data);
        }

        async ValueTask<SiteRecoveryProtectionContainerResource> IOperationSource<SiteRecoveryProtectionContainerResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = SiteRecoveryProtectionContainerData.DeserializeSiteRecoveryProtectionContainerData(document.RootElement);
            return new SiteRecoveryProtectionContainerResource(_client, data);
        }
    }
}
