// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery
{
    internal class SiteRecoveryMigrationItemOperationSource : IOperationSource<SiteRecoveryMigrationItemResource>
    {
        private readonly ArmClient _client;

        internal SiteRecoveryMigrationItemOperationSource(ArmClient client)
        {
            _client = client;
        }

        SiteRecoveryMigrationItemResource IOperationSource<SiteRecoveryMigrationItemResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = SiteRecoveryMigrationItemData.DeserializeSiteRecoveryMigrationItemData(document.RootElement);
            return new SiteRecoveryMigrationItemResource(_client, data);
        }

        async ValueTask<SiteRecoveryMigrationItemResource> IOperationSource<SiteRecoveryMigrationItemResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = SiteRecoveryMigrationItemData.DeserializeSiteRecoveryMigrationItemData(document.RootElement);
            return new SiteRecoveryMigrationItemResource(_client, data);
        }
    }
}
