// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery
{
    internal class ReplicationProtectedItemOperationSource : IOperationSource<ReplicationProtectedItemResource>
    {
        private readonly ArmClient _client;

        internal ReplicationProtectedItemOperationSource(ArmClient client)
        {
            _client = client;
        }

        ReplicationProtectedItemResource IOperationSource<ReplicationProtectedItemResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ReplicationProtectedItemData.DeserializeReplicationProtectedItemData(document.RootElement);
            return new ReplicationProtectedItemResource(_client, data);
        }

        async ValueTask<ReplicationProtectedItemResource> IOperationSource<ReplicationProtectedItemResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ReplicationProtectedItemData.DeserializeReplicationProtectedItemData(document.RootElement);
            return new ReplicationProtectedItemResource(_client, data);
        }
    }
}
