// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery
{
    internal class ProtectionContainerMappingOperationSource : IOperationSource<ProtectionContainerMappingResource>
    {
        private readonly ArmClient _client;

        internal ProtectionContainerMappingOperationSource(ArmClient client)
        {
            _client = client;
        }

        ProtectionContainerMappingResource IOperationSource<ProtectionContainerMappingResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ProtectionContainerMappingData.DeserializeProtectionContainerMappingData(document.RootElement);
            return new ProtectionContainerMappingResource(_client, data);
        }

        async ValueTask<ProtectionContainerMappingResource> IOperationSource<ProtectionContainerMappingResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ProtectionContainerMappingData.DeserializeProtectionContainerMappingData(document.RootElement);
            return new ProtectionContainerMappingResource(_client, data);
        }
    }
}
