// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Net;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmRecoveryServicesSiteRecoveryModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="RecoveryServicesSiteRecovery.SiteRecoveryAlertData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> Alert related data. </param>
        /// <param name="location"> Resource Location. </param>
        /// <returns> A new <see cref="RecoveryServicesSiteRecovery.SiteRecoveryAlertData"/> instance for mocking. </returns>
        public static SiteRecoveryAlertData SiteRecoveryAlertData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, SiteRecoveryAlertProperties properties = null, AzureLocation? location = null)
        {
            return new SiteRecoveryAlertData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                location,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SiteRecoveryAlertProperties"/>. </summary>
        /// <param name="sendToOwners"> A value indicating whether to send email to subscription administrator. </param>
        /// <param name="customEmailAddresses"> The custom email address for sending emails. </param>
        /// <param name="locale"> The locale for the email notification. </param>
        /// <returns> A new <see cref="Models.SiteRecoveryAlertProperties"/> instance for mocking. </returns>
        public static SiteRecoveryAlertProperties SiteRecoveryAlertProperties(string sendToOwners = null, IEnumerable<string> customEmailAddresses = null, string locale = null)
        {
            customEmailAddresses ??= new List<string>();

            return new SiteRecoveryAlertProperties(sendToOwners, customEmailAddresses?.ToList(), locale, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SiteRecoveryReplicationAppliance"/>. </summary>
        /// <param name="siteRecoveryReplicationApplianceProviderSpecificDetails"> Appliance related data. </param>
        /// <returns> A new <see cref="Models.SiteRecoveryReplicationAppliance"/> instance for mocking. </returns>
        public static SiteRecoveryReplicationAppliance SiteRecoveryReplicationAppliance(SiteRecoveryApplianceSpecificDetails siteRecoveryReplicationApplianceProviderSpecificDetails = null)
        {
            return new SiteRecoveryReplicationAppliance(siteRecoveryReplicationApplianceProviderSpecificDetails != null ? new SiteRecoveryReplicationApplianceProperties(siteRecoveryReplicationApplianceProviderSpecificDetails, serializedAdditionalRawData: null) : null, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="RecoveryServicesSiteRecovery.ReplicationEligibilityResultData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> Gets properties model for replication eligibility results API. </param>
        /// <returns> A new <see cref="RecoveryServicesSiteRecovery.ReplicationEligibilityResultData"/> instance for mocking. </returns>
        public static ReplicationEligibilityResultData ReplicationEligibilityResultData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ReplicationEligibilityResultProperties properties = null)
        {
            return new ReplicationEligibilityResultData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ReplicationEligibilityResultProperties"/>. </summary>
        /// <param name="clientRequestId"> The client request Id. </param>
        /// <param name="errors"> The error details. </param>
        /// <returns> A new <see cref="Models.ReplicationEligibilityResultProperties"/> instance for mocking. </returns>
        public static ReplicationEligibilityResultProperties ReplicationEligibilityResultProperties(string clientRequestId = null, IEnumerable<ReplicationEligibilityResultErrorInfo> errors = null)
        {
            errors ??= new List<ReplicationEligibilityResultErrorInfo>();

            return new ReplicationEligibilityResultProperties(clientRequestId, errors?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ReplicationEligibilityResultErrorInfo"/>. </summary>
        /// <param name="code"> The error code. </param>
        /// <param name="message"> The error message. </param>
        /// <param name="possibleCauses"> The possible causes. </param>
        /// <param name="recommendedAction"> The recommended action. </param>
        /// <param name="status"> The error status. </param>
        /// <returns> A new <see cref="Models.ReplicationEligibilityResultErrorInfo"/> instance for mocking. </returns>
        public static ReplicationEligibilityResultErrorInfo ReplicationEligibilityResultErrorInfo(string code = null, string message = null, string possibleCauses = null, string recommendedAction = null, string status = null)
        {
            return new ReplicationEligibilityResultErrorInfo(
                code,
                message,
                possibleCauses,
                recommendedAction,
                status,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="RecoveryServicesSiteRecovery.SiteRecoveryEventData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> Event related data. </param>
        /// <param name="location"> Resource Location. </param>
        /// <returns> A new <see cref="RecoveryServicesSiteRecovery.SiteRecoveryEventData"/> instance for mocking. </returns>
        public static SiteRecoveryEventData SiteRecoveryEventData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, SiteRecoveryEventProperties properties = null, AzureLocation? location = null)
        {
            return new SiteRecoveryEventData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                location,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SiteRecoveryEventProperties"/>. </summary>
        /// <param name="eventCode"> The Id of the monitoring event. </param>
        /// <param name="description"> The event name. </param>
        /// <param name="eventType"> The type of the event. for example: VM Health, Server Health, Job Failure etc. </param>
        /// <param name="affectedObjectFriendlyName"> The friendly name of the source of the event on which it is raised (for example, VM, VMM etc). </param>
        /// <param name="affectedObjectCorrelationId"> The affected object correlationId for the event. </param>
        /// <param name="severity"> The severity of the event. </param>
        /// <param name="occurredOn"> The time of occurrence of the event. </param>
        /// <param name="fabricId"> The ARM ID of the fabric. </param>
        /// <param name="providerSpecificDetails">
        /// The provider specific settings.
        /// Please note <see cref="SiteRecoveryEventProviderSpecificDetails"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.A2AEventDetails"/>, <see cref="Models.HyperVReplica2012EventDetails"/>, <see cref="Models.HyperVReplica2012R2EventDetails"/>, <see cref="Models.HyperVReplicaAzureEventDetails"/>, <see cref="Models.HyperVReplicaBaseEventDetails"/>, <see cref="Models.InMageAzureV2EventDetails"/>, <see cref="Models.InMageRcmEventDetails"/>, <see cref="Models.InMageRcmFailbackEventDetails"/> and <see cref="Models.VMwareCbtEventDetails"/>.
        /// </param>
        /// <param name="eventSpecificDetails">
        /// The event specific settings.
        /// Please note <see cref="SiteRecoveryEventSpecificDetails"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.SiteRecoveryJobStatusEventDetails"/>.
        /// </param>
        /// <param name="healthErrors"> The list of errors / warnings capturing details associated with the issue(s). </param>
        /// <returns> A new <see cref="Models.SiteRecoveryEventProperties"/> instance for mocking. </returns>
        public static SiteRecoveryEventProperties SiteRecoveryEventProperties(string eventCode = null, string description = null, string eventType = null, string affectedObjectFriendlyName = null, string affectedObjectCorrelationId = null, string severity = null, DateTimeOffset? occurredOn = null, ResourceIdentifier fabricId = null, SiteRecoveryEventProviderSpecificDetails providerSpecificDetails = null, SiteRecoveryEventSpecificDetails eventSpecificDetails = null, IEnumerable<SiteRecoveryHealthError> healthErrors = null)
        {
            healthErrors ??= new List<SiteRecoveryHealthError>();

            return new SiteRecoveryEventProperties(
                eventCode,
                description,
                eventType,
                affectedObjectFriendlyName,
                affectedObjectCorrelationId,
                severity,
                occurredOn,
                fabricId,
                providerSpecificDetails,
                eventSpecificDetails,
                healthErrors?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SiteRecoveryHealthError"/>. </summary>
        /// <param name="innerHealthErrors"> The inner health errors. HealthError having a list of HealthError as child errors is problematic. InnerHealthError is used because this will prevent an infinite loop of structures when Hydra tries to auto-generate the contract. We are exposing the related health errors as inner health errors and all API consumers can utilize this in the same fashion as Exception -&gt; InnerException. </param>
        /// <param name="errorSource"> Source of error. </param>
        /// <param name="errorType"> Type of error. </param>
        /// <param name="errorLevel"> Level of error. </param>
        /// <param name="errorCategory"> Category of error. </param>
        /// <param name="errorCode"> Error code. </param>
        /// <param name="summaryMessage"> Summary message of the entity. </param>
        /// <param name="errorMessage"> Error message. </param>
        /// <param name="possibleCauses"> Possible causes of error. </param>
        /// <param name="recommendedAction"> Recommended action to resolve error. </param>
        /// <param name="creationTimeUtc"> Error creation time (UTC). </param>
        /// <param name="recoveryProviderErrorMessage"> DRA error message. </param>
        /// <param name="entityId"> ID of the entity. </param>
        /// <param name="errorId"> The health error unique id. </param>
        /// <param name="customerResolvability"> Value indicating whether the health error is customer resolvable. </param>
        /// <returns> A new <see cref="Models.SiteRecoveryHealthError"/> instance for mocking. </returns>
        public static SiteRecoveryHealthError SiteRecoveryHealthError(IEnumerable<SiteRecoveryInnerHealthError> innerHealthErrors = null, string errorSource = null, string errorType = null, string errorLevel = null, string errorCategory = null, string errorCode = null, string summaryMessage = null, string errorMessage = null, string possibleCauses = null, string recommendedAction = null, DateTimeOffset? creationTimeUtc = null, string recoveryProviderErrorMessage = null, string entityId = null, string errorId = null, HealthErrorCustomerResolvability? customerResolvability = null)
        {
            innerHealthErrors ??= new List<SiteRecoveryInnerHealthError>();

            return new SiteRecoveryHealthError(
                innerHealthErrors?.ToList(),
                errorSource,
                errorType,
                errorLevel,
                errorCategory,
                errorCode,
                summaryMessage,
                errorMessage,
                possibleCauses,
                recommendedAction,
                creationTimeUtc,
                recoveryProviderErrorMessage,
                entityId,
                errorId,
                customerResolvability,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SiteRecoveryInnerHealthError"/>. </summary>
        /// <param name="errorSource"> Source of error. </param>
        /// <param name="errorType"> Type of error. </param>
        /// <param name="errorLevel"> Level of error. </param>
        /// <param name="errorCategory"> Category of error. </param>
        /// <param name="errorCode"> Error code. </param>
        /// <param name="summaryMessage"> Summary message of the entity. </param>
        /// <param name="errorMessage"> Error message. </param>
        /// <param name="possibleCauses"> Possible causes of error. </param>
        /// <param name="recommendedAction"> Recommended action to resolve error. </param>
        /// <param name="createdOn"> Error creation time (UTC). </param>
        /// <param name="recoveryProviderErrorMessage"> DRA error message. </param>
        /// <param name="entityId"> ID of the entity. </param>
        /// <param name="errorId"> The health error unique id. </param>
        /// <param name="customerResolvability"> Value indicating whether the health error is customer resolvable. </param>
        /// <returns> A new <see cref="Models.SiteRecoveryInnerHealthError"/> instance for mocking. </returns>
        public static SiteRecoveryInnerHealthError SiteRecoveryInnerHealthError(string errorSource = null, string errorType = null, string errorLevel = null, string errorCategory = null, string errorCode = null, string summaryMessage = null, string errorMessage = null, string possibleCauses = null, string recommendedAction = null, DateTimeOffset? createdOn = null, string recoveryProviderErrorMessage = null, string entityId = null, string errorId = null, HealthErrorCustomerResolvability? customerResolvability = null)
        {
            return new SiteRecoveryInnerHealthError(
                errorSource,
                errorType,
                errorLevel,
                errorCategory,
                errorCode,
                summaryMessage,
                errorMessage,
                possibleCauses,
                recommendedAction,
                createdOn,
                recoveryProviderErrorMessage,
                entityId,
                errorId,
                customerResolvability,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="RecoveryServicesSiteRecovery.SiteRecoveryFabricData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> Fabric related data. </param>
        /// <param name="location"> Resource Location. </param>
        /// <returns> A new <see cref="RecoveryServicesSiteRecovery.SiteRecoveryFabricData"/> instance for mocking. </returns>
        public static SiteRecoveryFabricData SiteRecoveryFabricData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, SiteRecoveryFabricProperties properties = null, AzureLocation? location = null)
        {
            return new SiteRecoveryFabricData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                location,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SiteRecoveryFabricProperties"/>. </summary>
        /// <param name="friendlyName"> Friendly name of the fabric. </param>
        /// <param name="encryptionDetails"> Encryption details for the fabric. </param>
        /// <param name="rolloverEncryptionDetails"> Rollover encryption details for the fabric. </param>
        /// <param name="internalIdentifier"> Dra Registration Id. </param>
        /// <param name="bcdrState"> BCDR state of the fabric. </param>
        /// <param name="customDetails">
        /// Fabric specific settings.
        /// Please note <see cref="FabricSpecificDetails"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.SiteRecoveryFabricProviderSpecificDetails"/>, <see cref="Models.HyperVSiteDetails"/>, <see cref="Models.InMageRcmFabricSpecificDetails"/>, <see cref="VmmFabricDetails"/>, <see cref="Models.VMwareDetails"/> and <see cref="Models.VMwareV2FabricSpecificDetails"/>.
        /// </param>
        /// <param name="healthErrorDetails"> Fabric health error details. </param>
        /// <param name="health"> Health of fabric. </param>
        /// <returns> A new <see cref="Models.SiteRecoveryFabricProperties"/> instance for mocking. </returns>
        public static SiteRecoveryFabricProperties SiteRecoveryFabricProperties(string friendlyName = null, SiteRecoveryEncryptionDetails encryptionDetails = null, SiteRecoveryEncryptionDetails rolloverEncryptionDetails = null, string internalIdentifier = null, string bcdrState = null, FabricSpecificDetails customDetails = null, IEnumerable<SiteRecoveryHealthError> healthErrorDetails = null, string health = null)
        {
            healthErrorDetails ??= new List<SiteRecoveryHealthError>();

            return new SiteRecoveryFabricProperties(
                friendlyName,
                encryptionDetails,
                rolloverEncryptionDetails,
                internalIdentifier,
                bcdrState,
                customDetails,
                healthErrorDetails?.ToList(),
                health,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SiteRecoveryEncryptionDetails"/>. </summary>
        /// <param name="kekState"> The key encryption key state for the Vmm. </param>
        /// <param name="kekCertThumbprint"> The key encryption key certificate thumbprint. </param>
        /// <param name="kekCertExpireOn"> The key encryption key certificate expiry date. </param>
        /// <returns> A new <see cref="Models.SiteRecoveryEncryptionDetails"/> instance for mocking. </returns>
        public static SiteRecoveryEncryptionDetails SiteRecoveryEncryptionDetails(string kekState = null, string kekCertThumbprint = null, DateTimeOffset? kekCertExpireOn = null)
        {
            return new SiteRecoveryEncryptionDetails(kekState, kekCertThumbprint, kekCertExpireOn, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="RecoveryServicesSiteRecovery.SiteRecoveryLogicalNetworkData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> The Logical Network Properties. </param>
        /// <param name="location"> Resource Location. </param>
        /// <returns> A new <see cref="RecoveryServicesSiteRecovery.SiteRecoveryLogicalNetworkData"/> instance for mocking. </returns>
        public static SiteRecoveryLogicalNetworkData SiteRecoveryLogicalNetworkData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, SiteRecoveryLogicalNetworkProperties properties = null, AzureLocation? location = null)
        {
            return new SiteRecoveryLogicalNetworkData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                location,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SiteRecoveryLogicalNetworkProperties"/>. </summary>
        /// <param name="friendlyName"> The Friendly Name. </param>
        /// <param name="networkVirtualizationStatus"> A value indicating whether Network Virtualization is enabled for the logical network. </param>
        /// <param name="logicalNetworkUsage"> A value indicating whether logical network is used as private test network by test failover. </param>
        /// <param name="logicalNetworkDefinitionsStatus"> A value indicating whether logical network definitions are isolated. </param>
        /// <returns> A new <see cref="Models.SiteRecoveryLogicalNetworkProperties"/> instance for mocking. </returns>
        public static SiteRecoveryLogicalNetworkProperties SiteRecoveryLogicalNetworkProperties(string friendlyName = null, string networkVirtualizationStatus = null, string logicalNetworkUsage = null, string logicalNetworkDefinitionsStatus = null)
        {
            return new SiteRecoveryLogicalNetworkProperties(friendlyName, networkVirtualizationStatus, logicalNetworkUsage, logicalNetworkDefinitionsStatus, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="RecoveryServicesSiteRecovery.SiteRecoveryNetworkData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> The Network Properties. </param>
        /// <param name="location"> Resource Location. </param>
        /// <returns> A new <see cref="RecoveryServicesSiteRecovery.SiteRecoveryNetworkData"/> instance for mocking. </returns>
        public static SiteRecoveryNetworkData SiteRecoveryNetworkData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, SiteRecoveryNetworkProperties properties = null, AzureLocation? location = null)
        {
            return new SiteRecoveryNetworkData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                location,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SiteRecoveryNetworkProperties"/>. </summary>
        /// <param name="fabricType"> The Fabric Type. </param>
        /// <param name="subnets"> The List of subnets. </param>
        /// <param name="friendlyName"> The Friendly Name. </param>
        /// <param name="networkType"> The Network Type. </param>
        /// <returns> A new <see cref="Models.SiteRecoveryNetworkProperties"/> instance for mocking. </returns>
        public static SiteRecoveryNetworkProperties SiteRecoveryNetworkProperties(string fabricType = null, IEnumerable<SiteRecoverySubnet> subnets = null, string friendlyName = null, string networkType = null)
        {
            subnets ??= new List<SiteRecoverySubnet>();

            return new SiteRecoveryNetworkProperties(fabricType, subnets?.ToList(), friendlyName, networkType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SiteRecoverySubnet"/>. </summary>
        /// <param name="name"> The subnet name. </param>
        /// <param name="friendlyName"> The subnet friendly name. </param>
        /// <param name="addressList"> The list of addresses for the subnet. </param>
        /// <returns> A new <see cref="Models.SiteRecoverySubnet"/> instance for mocking. </returns>
        public static SiteRecoverySubnet SiteRecoverySubnet(string name = null, string friendlyName = null, IEnumerable<string> addressList = null)
        {
            addressList ??= new List<string>();

            return new SiteRecoverySubnet(name, friendlyName, addressList?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="RecoveryServicesSiteRecovery.SiteRecoveryNetworkMappingData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> The Network Mapping Properties. </param>
        /// <param name="location"> Resource Location. </param>
        /// <returns> A new <see cref="RecoveryServicesSiteRecovery.SiteRecoveryNetworkMappingData"/> instance for mocking. </returns>
        public static SiteRecoveryNetworkMappingData SiteRecoveryNetworkMappingData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, SiteRecoveryNetworkMappingProperties properties = null, AzureLocation? location = null)
        {
            return new SiteRecoveryNetworkMappingData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                location,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SiteRecoveryNetworkMappingProperties"/>. </summary>
        /// <param name="state"> The pairing state for network mapping. </param>
        /// <param name="primaryNetworkFriendlyName"> The primary network friendly name. </param>
        /// <param name="primaryNetworkId"> The primary network id for network mapping. </param>
        /// <param name="primaryFabricFriendlyName"> The primary fabric friendly name. </param>
        /// <param name="recoveryNetworkFriendlyName"> The recovery network friendly name. </param>
        /// <param name="recoveryNetworkId"> The recovery network id for network mapping. </param>
        /// <param name="recoveryFabricArmId"> The recovery fabric ARM id. </param>
        /// <param name="recoveryFabricFriendlyName"> The recovery fabric friendly name. </param>
        /// <param name="fabricSpecificSettings">
        /// The fabric specific settings.
        /// Please note <see cref="NetworkMappingFabricSpecificSettings"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.A2ANetworkMappingSettings"/>, <see cref="VmmToAzureNetworkMappingSettings"/> and <see cref="VmmToVmmNetworkMappingSettings"/>.
        /// </param>
        /// <returns> A new <see cref="Models.SiteRecoveryNetworkMappingProperties"/> instance for mocking. </returns>
        public static SiteRecoveryNetworkMappingProperties SiteRecoveryNetworkMappingProperties(string state = null, string primaryNetworkFriendlyName = null, ResourceIdentifier primaryNetworkId = null, string primaryFabricFriendlyName = null, string recoveryNetworkFriendlyName = null, ResourceIdentifier recoveryNetworkId = null, ResourceIdentifier recoveryFabricArmId = null, string recoveryFabricFriendlyName = null, NetworkMappingFabricSpecificSettings fabricSpecificSettings = null)
        {
            return new SiteRecoveryNetworkMappingProperties(
                state,
                primaryNetworkFriendlyName,
                primaryNetworkId,
                primaryFabricFriendlyName,
                recoveryNetworkFriendlyName,
                recoveryNetworkId,
                recoveryFabricArmId,
                recoveryFabricFriendlyName,
                fabricSpecificSettings,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SiteRecoveryCreateReplicationNetworkMappingProperties"/>. </summary>
        /// <param name="recoveryFabricName"> Recovery fabric Name. </param>
        /// <param name="recoveryNetworkId"> Recovery network Id. </param>
        /// <param name="fabricSpecificDetails">
        /// Fabric specific input properties.
        /// Please note <see cref="FabricSpecificCreateNetworkMappingContent"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.A2ACreateNetworkMappingContent"/>, <see cref="VmmToAzureCreateNetworkMappingContent"/> and <see cref="VmmToVmmCreateNetworkMappingContent"/>.
        /// </param>
        /// <returns> A new <see cref="Models.SiteRecoveryCreateReplicationNetworkMappingProperties"/> instance for mocking. </returns>
        public static SiteRecoveryCreateReplicationNetworkMappingProperties SiteRecoveryCreateReplicationNetworkMappingProperties(string recoveryFabricName = null, ResourceIdentifier recoveryNetworkId = null, FabricSpecificCreateNetworkMappingContent fabricSpecificDetails = null)
        {
            return new SiteRecoveryCreateReplicationNetworkMappingProperties(recoveryFabricName, recoveryNetworkId, fabricSpecificDetails, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="RecoveryServicesSiteRecovery.SiteRecoveryProtectionContainerData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> The custom data. </param>
        /// <param name="location"> Resource Location. </param>
        /// <returns> A new <see cref="RecoveryServicesSiteRecovery.SiteRecoveryProtectionContainerData"/> instance for mocking. </returns>
        public static SiteRecoveryProtectionContainerData SiteRecoveryProtectionContainerData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, SiteRecoveryProtectionContainerProperties properties = null, AzureLocation? location = null)
        {
            return new SiteRecoveryProtectionContainerData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                location,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SiteRecoveryProtectionContainerProperties"/>. </summary>
        /// <param name="fabricFriendlyName"> Fabric friendly name. </param>
        /// <param name="friendlyName"> The name. </param>
        /// <param name="fabricType"> The fabric type. </param>
        /// <param name="protectedItemCount"> Number of protected PEs. </param>
        /// <param name="pairingStatus"> The pairing status of this cloud. </param>
        /// <param name="role"> The role of this cloud. </param>
        /// <param name="fabricSpecificDetailsInstanceType"> Fabric specific details. </param>
        /// <returns> A new <see cref="Models.SiteRecoveryProtectionContainerProperties"/> instance for mocking. </returns>
        public static SiteRecoveryProtectionContainerProperties SiteRecoveryProtectionContainerProperties(string fabricFriendlyName = null, string friendlyName = null, string fabricType = null, int? protectedItemCount = null, string pairingStatus = null, string role = null, string fabricSpecificDetailsInstanceType = null)
        {
            return new SiteRecoveryProtectionContainerProperties(
                fabricFriendlyName,
                friendlyName,
                fabricType,
                protectedItemCount,
                pairingStatus,
                role,
                fabricSpecificDetailsInstanceType != null ? new ProtectionContainerFabricSpecificDetails(fabricSpecificDetailsInstanceType, serializedAdditionalRawData: null) : null,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="RecoveryServicesSiteRecovery.SiteRecoveryMigrationItemData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> The migration item properties. </param>
        /// <param name="location"> Resource Location. </param>
        /// <returns> A new <see cref="RecoveryServicesSiteRecovery.SiteRecoveryMigrationItemData"/> instance for mocking. </returns>
        public static SiteRecoveryMigrationItemData SiteRecoveryMigrationItemData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, SiteRecoveryMigrationItemProperties properties = null, AzureLocation? location = null)
        {
            return new SiteRecoveryMigrationItemData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                location,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SiteRecoveryMigrationItemProperties"/>. </summary>
        /// <param name="machineName"> The on-premise virtual machine name. </param>
        /// <param name="policyId"> The ARM Id of policy governing this item. </param>
        /// <param name="policyFriendlyName"> The name of policy governing this item. </param>
        /// <param name="recoveryServicesProviderId"> The recovery services provider ARM Id. </param>
        /// <param name="replicationStatus"> The replication status. </param>
        /// <param name="migrationState"> The migration status. </param>
        /// <param name="migrationStateDescription"> The migration state description. </param>
        /// <param name="lastTestMigrationOn"> The last test migration time. </param>
        /// <param name="lastTestMigrationStatus"> The status of the last test migration. </param>
        /// <param name="lastMigrationOn"> The last migration time. </param>
        /// <param name="lastMigrationStatus"> The status of the last migration. </param>
        /// <param name="testMigrateState"> The test migrate state. </param>
        /// <param name="testMigrateStateDescription"> The test migrate state description. </param>
        /// <param name="health"> The consolidated health. </param>
        /// <param name="healthErrors"> The list of health errors. </param>
        /// <param name="allowedOperations"> The allowed operations on the migration item based on the current migration state of the item. </param>
        /// <param name="currentJob"> The current job details. </param>
        /// <param name="criticalJobHistory"> The critical past job details. </param>
        /// <param name="eventCorrelationId"> The correlation Id for events associated with this migration item. </param>
        /// <param name="providerSpecificDetails">
        /// The migration provider custom settings.
        /// Please note <see cref="MigrationProviderSpecificSettings"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.VMwareCbtMigrationDetails"/>.
        /// </param>
        /// <returns> A new <see cref="Models.SiteRecoveryMigrationItemProperties"/> instance for mocking. </returns>
        public static SiteRecoveryMigrationItemProperties SiteRecoveryMigrationItemProperties(string machineName = null, ResourceIdentifier policyId = null, string policyFriendlyName = null, string recoveryServicesProviderId = null, string replicationStatus = null, SiteRecoveryMigrationState? migrationState = null, string migrationStateDescription = null, DateTimeOffset? lastTestMigrationOn = null, string lastTestMigrationStatus = null, DateTimeOffset? lastMigrationOn = null, string lastMigrationStatus = null, TestMigrationState? testMigrateState = null, string testMigrateStateDescription = null, SiteRecoveryProtectionHealth? health = null, IEnumerable<SiteRecoveryHealthError> healthErrors = null, IEnumerable<MigrationItemOperation> allowedOperations = null, CurrentJobDetails currentJob = null, IEnumerable<CriticalJobHistoryDetails> criticalJobHistory = null, string eventCorrelationId = null, MigrationProviderSpecificSettings providerSpecificDetails = null)
        {
            healthErrors ??= new List<SiteRecoveryHealthError>();
            allowedOperations ??= new List<MigrationItemOperation>();
            criticalJobHistory ??= new List<CriticalJobHistoryDetails>();

            return new SiteRecoveryMigrationItemProperties(
                machineName,
                policyId,
                policyFriendlyName,
                recoveryServicesProviderId,
                replicationStatus,
                migrationState,
                migrationStateDescription,
                lastTestMigrationOn,
                lastTestMigrationStatus,
                lastMigrationOn,
                lastMigrationStatus,
                testMigrateState,
                testMigrateStateDescription,
                health,
                healthErrors?.ToList(),
                allowedOperations?.ToList(),
                currentJob,
                criticalJobHistory?.ToList(),
                eventCorrelationId,
                providerSpecificDetails,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CurrentJobDetails"/>. </summary>
        /// <param name="jobName"> The job name. </param>
        /// <param name="jobId"> The ARM Id of the job being executed. </param>
        /// <param name="startOn"> The start time of the job. </param>
        /// <returns> A new <see cref="Models.CurrentJobDetails"/> instance for mocking. </returns>
        public static CurrentJobDetails CurrentJobDetails(string jobName = null, ResourceIdentifier jobId = null, DateTimeOffset? startOn = null)
        {
            return new CurrentJobDetails(jobName, jobId, startOn, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CriticalJobHistoryDetails"/>. </summary>
        /// <param name="jobName"> The job name. </param>
        /// <param name="jobId"> The ARM Id of the job being executed. </param>
        /// <param name="startOn"> The start time of the job. </param>
        /// <param name="jobStatus"> The job state. </param>
        /// <returns> A new <see cref="Models.CriticalJobHistoryDetails"/> instance for mocking. </returns>
        public static CriticalJobHistoryDetails CriticalJobHistoryDetails(string jobName = null, ResourceIdentifier jobId = null, DateTimeOffset? startOn = null, string jobStatus = null)
        {
            return new CriticalJobHistoryDetails(jobName, jobId, startOn, jobStatus, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="RecoveryServicesSiteRecovery.MigrationRecoveryPointData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> Recovery point properties. </param>
        /// <param name="location"> Resource Location. </param>
        /// <returns> A new <see cref="RecoveryServicesSiteRecovery.MigrationRecoveryPointData"/> instance for mocking. </returns>
        public static MigrationRecoveryPointData MigrationRecoveryPointData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, MigrationRecoveryPointProperties properties = null, AzureLocation? location = null)
        {
            return new MigrationRecoveryPointData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                location,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrationRecoveryPointProperties"/>. </summary>
        /// <param name="recoveryPointOn"> The recovery point time. </param>
        /// <param name="recoveryPointType"> The recovery point type. </param>
        /// <returns> A new <see cref="Models.MigrationRecoveryPointProperties"/> instance for mocking. </returns>
        public static MigrationRecoveryPointProperties MigrationRecoveryPointProperties(DateTimeOffset? recoveryPointOn = null, MigrationRecoveryPointType? recoveryPointType = null)
        {
            return new MigrationRecoveryPointProperties(recoveryPointOn, recoveryPointType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="RecoveryServicesSiteRecovery.SiteRecoveryProtectableItemData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> The custom data. </param>
        /// <param name="location"> Resource Location. </param>
        /// <returns> A new <see cref="RecoveryServicesSiteRecovery.SiteRecoveryProtectableItemData"/> instance for mocking. </returns>
        public static SiteRecoveryProtectableItemData SiteRecoveryProtectableItemData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, SiteRecoveryProtectableItemProperties properties = null, AzureLocation? location = null)
        {
            return new SiteRecoveryProtectableItemData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                location,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SiteRecoveryProtectableItemProperties"/>. </summary>
        /// <param name="friendlyName"> The name. </param>
        /// <param name="protectionStatus"> The protection status. </param>
        /// <param name="replicationProtectedItemId"> The ARM resource of protected items. </param>
        /// <param name="recoveryServicesProviderId"> The recovery provider ARM Id. </param>
        /// <param name="protectionReadinessErrors"> The Current protection readiness errors. </param>
        /// <param name="supportedReplicationProviders"> The list of replication providers supported for the protectable item. </param>
        /// <param name="customDetails">
        /// The Replication provider custom settings.
        /// Please note <see cref="SiteRecoveryReplicationProviderSettings"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.HyperVVmDetails"/>, <see cref="ReplicationGroupDetails"/>, <see cref="Models.VmmVmDetails"/> and <see cref="Models.VMwareVmDetails"/>.
        /// </param>
        /// <returns> A new <see cref="Models.SiteRecoveryProtectableItemProperties"/> instance for mocking. </returns>
        public static SiteRecoveryProtectableItemProperties SiteRecoveryProtectableItemProperties(string friendlyName = null, string protectionStatus = null, ResourceIdentifier replicationProtectedItemId = null, ResourceIdentifier recoveryServicesProviderId = null, IEnumerable<string> protectionReadinessErrors = null, IEnumerable<string> supportedReplicationProviders = null, SiteRecoveryReplicationProviderSettings customDetails = null)
        {
            protectionReadinessErrors ??= new List<string>();
            supportedReplicationProviders ??= new List<string>();

            return new SiteRecoveryProtectableItemProperties(
                friendlyName,
                protectionStatus,
                replicationProtectedItemId,
                recoveryServicesProviderId,
                protectionReadinessErrors?.ToList(),
                supportedReplicationProviders?.ToList(),
                customDetails,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="RecoveryServicesSiteRecovery.ReplicationProtectedItemData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> The custom data. </param>
        /// <param name="location"> Resource Location. </param>
        /// <returns> A new <see cref="RecoveryServicesSiteRecovery.ReplicationProtectedItemData"/> instance for mocking. </returns>
        public static ReplicationProtectedItemData ReplicationProtectedItemData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ReplicationProtectedItemProperties properties = null, AzureLocation? location = null)
        {
            return new ReplicationProtectedItemData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                location,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ReplicationProtectedItemProperties"/>. </summary>
        /// <param name="friendlyName"> The name. </param>
        /// <param name="protectedItemType"> The type of protected item type. </param>
        /// <param name="protectableItemId"> The protected item ARM Id. </param>
        /// <param name="recoveryServicesProviderId"> The recovery provider ARM Id. </param>
        /// <param name="primaryFabricFriendlyName"> The friendly name of the primary fabric. </param>
        /// <param name="primaryFabricProvider"> The fabric provider of the primary fabric. </param>
        /// <param name="recoveryFabricFriendlyName"> The friendly name of recovery fabric. </param>
        /// <param name="recoveryFabricId"> The Arm Id of recovery fabric. </param>
        /// <param name="primaryProtectionContainerFriendlyName"> The name of primary protection container friendly name. </param>
        /// <param name="recoveryProtectionContainerFriendlyName"> The name of recovery container friendly name. </param>
        /// <param name="protectionState"> The protection status. </param>
        /// <param name="protectionStateDescription"> The protection state description. </param>
        /// <param name="activeLocation"> The Current active location of the PE. </param>
        /// <param name="testFailoverState"> The Test failover state. </param>
        /// <param name="testFailoverStateDescription"> The Test failover state description. </param>
        /// <param name="switchProviderState"> The switch provider state. </param>
        /// <param name="switchProviderStateDescription"> The switch provider state description. </param>
        /// <param name="allowedOperations"> The allowed operations on the Replication protected item. </param>
        /// <param name="replicationHealth"> The consolidated protection health for the VM taking any issues with SRS as well as all the replication units associated with the VM's replication group into account. This is a string representation of the ProtectionHealth enumeration. </param>
        /// <param name="failoverHealth"> The consolidated failover health for the VM. </param>
        /// <param name="healthErrors"> List of health errors. </param>
        /// <param name="policyId"> The ID of Policy governing this PE. </param>
        /// <param name="policyFriendlyName"> The name of Policy governing this PE. </param>
        /// <param name="lastSuccessfulFailoverOn"> The Last successful failover time. </param>
        /// <param name="lastSuccessfulTestFailoverOn"> The Last successful test failover time. </param>
        /// <param name="currentScenario"> The current scenario. </param>
        /// <param name="failoverRecoveryPointId"> The recovery point ARM Id to which the Vm was failed over. </param>
        /// <param name="providerSpecificDetails">
        /// The Replication provider custom settings.
        /// Please note <see cref="ReplicationProviderSpecificSettings"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.A2AReplicationDetails"/>, <see cref="Models.A2ACrossClusterMigrationReplicationDetails"/>, <see cref="Models.HyperVReplicaReplicationDetails"/>, <see cref="Models.HyperVReplicaBlueReplicationDetails"/>, <see cref="Models.HyperVReplicaAzureReplicationDetails"/>, <see cref="Models.HyperVReplicaBaseReplicationDetails"/>, <see cref="Models.InMageReplicationDetails"/>, <see cref="Models.InMageAzureV2ReplicationDetails"/>, <see cref="Models.InMageRcmReplicationDetails"/> and <see cref="Models.InMageRcmFailbackReplicationDetails"/>.
        /// </param>
        /// <param name="recoveryContainerId"> The recovery container Id. </param>
        /// <param name="eventCorrelationId"> The correlation Id for events associated with this protected item. </param>
        /// <returns> A new <see cref="Models.ReplicationProtectedItemProperties"/> instance for mocking. </returns>
        public static ReplicationProtectedItemProperties ReplicationProtectedItemProperties(string friendlyName = null, string protectedItemType = null, ResourceIdentifier protectableItemId = null, string recoveryServicesProviderId = null, string primaryFabricFriendlyName = null, string primaryFabricProvider = null, string recoveryFabricFriendlyName = null, ResourceIdentifier recoveryFabricId = null, string primaryProtectionContainerFriendlyName = null, string recoveryProtectionContainerFriendlyName = null, string protectionState = null, string protectionStateDescription = null, string activeLocation = null, string testFailoverState = null, string testFailoverStateDescription = null, string switchProviderState = null, string switchProviderStateDescription = null, IEnumerable<string> allowedOperations = null, string replicationHealth = null, string failoverHealth = null, IEnumerable<SiteRecoveryHealthError> healthErrors = null, ResourceIdentifier policyId = null, string policyFriendlyName = null, DateTimeOffset? lastSuccessfulFailoverOn = null, DateTimeOffset? lastSuccessfulTestFailoverOn = null, CurrentScenarioDetails currentScenario = null, ResourceIdentifier failoverRecoveryPointId = null, ReplicationProviderSpecificSettings providerSpecificDetails = null, ResourceIdentifier recoveryContainerId = null, Guid? eventCorrelationId = null)
        {
            allowedOperations ??= new List<string>();
            healthErrors ??= new List<SiteRecoveryHealthError>();

            return new ReplicationProtectedItemProperties(
                friendlyName,
                protectedItemType,
                protectableItemId,
                recoveryServicesProviderId,
                primaryFabricFriendlyName,
                primaryFabricProvider,
                recoveryFabricFriendlyName,
                recoveryFabricId,
                primaryProtectionContainerFriendlyName,
                recoveryProtectionContainerFriendlyName,
                protectionState,
                protectionStateDescription,
                activeLocation,
                testFailoverState,
                testFailoverStateDescription,
                switchProviderState,
                switchProviderStateDescription,
                allowedOperations?.ToList(),
                replicationHealth,
                failoverHealth,
                healthErrors?.ToList(),
                policyId,
                policyFriendlyName,
                lastSuccessfulFailoverOn,
                lastSuccessfulTestFailoverOn,
                currentScenario,
                failoverRecoveryPointId,
                providerSpecificDetails,
                recoveryContainerId,
                eventCorrelationId,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CurrentScenarioDetails"/>. </summary>
        /// <param name="scenarioName"> Scenario name. </param>
        /// <param name="jobId"> ARM Id of the job being executed. </param>
        /// <param name="startOn"> Start time of the workflow. </param>
        /// <returns> A new <see cref="Models.CurrentScenarioDetails"/> instance for mocking. </returns>
        public static CurrentScenarioDetails CurrentScenarioDetails(string scenarioName = null, ResourceIdentifier jobId = null, DateTimeOffset? startOn = null)
        {
            return new CurrentScenarioDetails(scenarioName, jobId, startOn, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SiteRecoveryApplyRecoveryPointProperties"/>. </summary>
        /// <param name="recoveryPointId"> The recovery point Id. </param>
        /// <param name="providerSpecificDetails">
        /// Provider specific input for applying recovery point.
        /// Please note <see cref="SiteRecoveryApplyRecoveryPointProviderSpecificContent"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="A2AApplyRecoveryPointContent"/>, <see cref="A2ACrossClusterMigrationApplyRecoveryPointContent"/>, <see cref="HyperVReplicaAzureApplyRecoveryPointContent"/>, <see cref="InMageAzureV2ApplyRecoveryPointContent"/> and <see cref="Models.InMageRcmApplyRecoveryPointContent"/>.
        /// </param>
        /// <returns> A new <see cref="Models.SiteRecoveryApplyRecoveryPointProperties"/> instance for mocking. </returns>
        public static SiteRecoveryApplyRecoveryPointProperties SiteRecoveryApplyRecoveryPointProperties(ResourceIdentifier recoveryPointId = null, SiteRecoveryApplyRecoveryPointProviderSpecificContent providerSpecificDetails = null)
        {
            return new SiteRecoveryApplyRecoveryPointProperties(recoveryPointId, providerSpecificDetails, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="RecoveryServicesSiteRecovery.SiteRecoveryPointData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> The recovery point properties. </param>
        /// <param name="location"> Resource Location. </param>
        /// <returns> A new <see cref="RecoveryServicesSiteRecovery.SiteRecoveryPointData"/> instance for mocking. </returns>
        public static SiteRecoveryPointData SiteRecoveryPointData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, SiteRecoveryPointProperties properties = null, AzureLocation? location = null)
        {
            return new SiteRecoveryPointData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                location,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SiteRecoveryPointProperties"/>. </summary>
        /// <param name="recoveryPointOn"> The recovery point time. </param>
        /// <param name="recoveryPointType"> The recovery point type: ApplicationConsistent, CrashConsistent. </param>
        /// <param name="providerSpecificDetails">
        /// The provider specific details for the recovery point.
        /// Please note <see cref="ProviderSpecificRecoveryPointDetails"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.A2ARecoveryPointDetails"/>, <see cref="Models.InMageAzureV2RecoveryPointDetails"/> and <see cref="Models.InMageRcmRecoveryPointDetails"/>.
        /// </param>
        /// <returns> A new <see cref="Models.SiteRecoveryPointProperties"/> instance for mocking. </returns>
        public static SiteRecoveryPointProperties SiteRecoveryPointProperties(DateTimeOffset? recoveryPointOn = null, string recoveryPointType = null, ProviderSpecificRecoveryPointDetails providerSpecificDetails = null)
        {
            return new SiteRecoveryPointProperties(recoveryPointOn, recoveryPointType, providerSpecificDetails, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.TargetComputeSize"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> The custom data. </param>
        /// <returns> A new <see cref="Models.TargetComputeSize"/> instance for mocking. </returns>
        public static TargetComputeSize TargetComputeSize(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, TargetComputeSizeProperties properties = null)
        {
            return new TargetComputeSize(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.TargetComputeSizeProperties"/>. </summary>
        /// <param name="name"> Target compute size name. </param>
        /// <param name="friendlyName"> Target compute size display name. </param>
        /// <param name="cpuCoresCount"> The maximum cpu cores count supported by target compute size. </param>
        /// <param name="vCpusAvailable"> The Available vCPUs supported by target compute size. </param>
        /// <param name="memoryInGB"> The maximum memory in GB supported by target compute size. </param>
        /// <param name="maxDataDiskCount"> The maximum data disks count supported by target compute size. </param>
        /// <param name="maxNicsCount"> The maximum Nics count supported by target compute size. </param>
        /// <param name="errors"> The reasons why the target compute size is not applicable for the protected item. </param>
        /// <param name="highIopsSupported"> The value indicating whether the target compute size supports high Iops. </param>
        /// <param name="hyperVGenerations"> The supported HyperV Generations. </param>
        /// <returns> A new <see cref="Models.TargetComputeSizeProperties"/> instance for mocking. </returns>
        public static TargetComputeSizeProperties TargetComputeSizeProperties(string name = null, string friendlyName = null, int? cpuCoresCount = null, int? vCpusAvailable = null, double? memoryInGB = null, int? maxDataDiskCount = null, int? maxNicsCount = null, IEnumerable<SiteRecoveryComputeSizeErrorDetails> errors = null, string highIopsSupported = null, IEnumerable<string> hyperVGenerations = null)
        {
            errors ??= new List<SiteRecoveryComputeSizeErrorDetails>();
            hyperVGenerations ??= new List<string>();

            return new TargetComputeSizeProperties(
                name,
                friendlyName,
                cpuCoresCount,
                vCpusAvailable,
                memoryInGB,
                maxDataDiskCount,
                maxNicsCount,
                errors?.ToList(),
                highIopsSupported,
                hyperVGenerations?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SiteRecoveryComputeSizeErrorDetails"/>. </summary>
        /// <param name="message"> The error message. </param>
        /// <param name="severity"> The severity of the error. </param>
        /// <returns> A new <see cref="Models.SiteRecoveryComputeSizeErrorDetails"/> instance for mocking. </returns>
        public static SiteRecoveryComputeSizeErrorDetails SiteRecoveryComputeSizeErrorDetails(string message = null, string severity = null)
        {
            return new SiteRecoveryComputeSizeErrorDetails(message, severity, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="RecoveryServicesSiteRecovery.ProtectionContainerMappingData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> The custom data. </param>
        /// <param name="location"> Resource Location. </param>
        /// <returns> A new <see cref="RecoveryServicesSiteRecovery.ProtectionContainerMappingData"/> instance for mocking. </returns>
        public static ProtectionContainerMappingData ProtectionContainerMappingData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ProtectionContainerMappingProperties properties = null, AzureLocation? location = null)
        {
            return new ProtectionContainerMappingData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                location,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ProtectionContainerMappingProperties"/>. </summary>
        /// <param name="targetProtectionContainerId"> Paired protection container ARM ID. </param>
        /// <param name="targetProtectionContainerFriendlyName"> Friendly name of paired container. </param>
        /// <param name="providerSpecificDetails">
        /// Provider specific provider details.
        /// Please note <see cref="ProtectionContainerMappingProviderSpecificDetails"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.A2AProtectionContainerMappingDetails"/>, <see cref="Models.InMageRcmProtectionContainerMappingDetails"/> and <see cref="Models.VMwareCbtProtectionContainerMappingDetails"/>.
        /// </param>
        /// <param name="health"> Health of pairing. </param>
        /// <param name="healthErrorDetails"> Health error. </param>
        /// <param name="policyId"> Policy ARM Id. </param>
        /// <param name="state"> Association Status. </param>
        /// <param name="sourceProtectionContainerFriendlyName"> Friendly name of source protection container. </param>
        /// <param name="sourceFabricFriendlyName"> Friendly name of source fabric. </param>
        /// <param name="targetFabricFriendlyName"> Friendly name of target fabric. </param>
        /// <param name="policyFriendlyName"> Friendly name of replication policy. </param>
        /// <returns> A new <see cref="Models.ProtectionContainerMappingProperties"/> instance for mocking. </returns>
        public static ProtectionContainerMappingProperties ProtectionContainerMappingProperties(ResourceIdentifier targetProtectionContainerId = null, string targetProtectionContainerFriendlyName = null, ProtectionContainerMappingProviderSpecificDetails providerSpecificDetails = null, string health = null, IEnumerable<SiteRecoveryHealthError> healthErrorDetails = null, ResourceIdentifier policyId = null, string state = null, string sourceProtectionContainerFriendlyName = null, string sourceFabricFriendlyName = null, string targetFabricFriendlyName = null, string policyFriendlyName = null)
        {
            healthErrorDetails ??= new List<SiteRecoveryHealthError>();

            return new ProtectionContainerMappingProperties(
                targetProtectionContainerId,
                targetProtectionContainerFriendlyName,
                providerSpecificDetails,
                health,
                healthErrorDetails?.ToList(),
                policyId,
                state,
                sourceProtectionContainerFriendlyName,
                sourceFabricFriendlyName,
                targetFabricFriendlyName,
                policyFriendlyName,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="RecoveryServicesSiteRecovery.SiteRecoveryServicesProviderData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> Provider properties. </param>
        /// <param name="location"> Resource Location. </param>
        /// <returns> A new <see cref="RecoveryServicesSiteRecovery.SiteRecoveryServicesProviderData"/> instance for mocking. </returns>
        public static SiteRecoveryServicesProviderData SiteRecoveryServicesProviderData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, SiteRecoveryServicesProviderProperties properties = null, AzureLocation? location = null)
        {
            return new SiteRecoveryServicesProviderData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                location,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SiteRecoveryServicesProviderProperties"/>. </summary>
        /// <param name="fabricType"> Type of the site. </param>
        /// <param name="friendlyName"> Friendly name of the DRA. </param>
        /// <param name="providerVersion"> The provider version. </param>
        /// <param name="serverVersion"> The fabric provider. </param>
        /// <param name="providerVersionState"> DRA version status. </param>
        /// <param name="providerVersionExpireOn"> Expiry date of the version. </param>
        /// <param name="fabricFriendlyName"> The fabric friendly name. </param>
        /// <param name="lastHeartbeatReceivedOn"> Time when last heartbeat was sent by the DRA. </param>
        /// <param name="connectionStatus"> A value indicating whether DRA is responsive. </param>
        /// <param name="protectedItemCount"> Number of protected VMs currently managed by the DRA. </param>
        /// <param name="allowedScenarios"> The scenarios allowed on this provider. </param>
        /// <param name="healthErrorDetails"> The recovery services provider health error details. </param>
        /// <param name="draIdentifier"> The DRA Id. </param>
        /// <param name="machineId"> The machine Id. </param>
        /// <param name="machineName"> The machine name. </param>
        /// <param name="biosId"> The Bios Id. </param>
        /// <param name="authenticationIdentityDetails"> The authentication identity details. </param>
        /// <param name="resourceAccessIdentityDetails"> The resource access identity details. </param>
        /// <param name="dataPlaneAuthenticationIdentityDetails"> The data plane authentication identity details. </param>
        /// <param name="providerVersionDetails"> The provider version details. </param>
        /// <returns> A new <see cref="Models.SiteRecoveryServicesProviderProperties"/> instance for mocking. </returns>
        public static SiteRecoveryServicesProviderProperties SiteRecoveryServicesProviderProperties(string fabricType = null, string friendlyName = null, string providerVersion = null, string serverVersion = null, string providerVersionState = null, DateTimeOffset? providerVersionExpireOn = null, string fabricFriendlyName = null, DateTimeOffset? lastHeartbeatReceivedOn = null, string connectionStatus = null, int? protectedItemCount = null, IEnumerable<string> allowedScenarios = null, IEnumerable<SiteRecoveryHealthError> healthErrorDetails = null, string draIdentifier = null, string machineId = null, string machineName = null, string biosId = null, IdentityProviderDetails authenticationIdentityDetails = null, IdentityProviderDetails resourceAccessIdentityDetails = null, IdentityProviderDetails dataPlaneAuthenticationIdentityDetails = null, SiteRecoveryVersionDetails providerVersionDetails = null)
        {
            allowedScenarios ??= new List<string>();
            healthErrorDetails ??= new List<SiteRecoveryHealthError>();

            return new SiteRecoveryServicesProviderProperties(
                fabricType,
                friendlyName,
                providerVersion,
                serverVersion,
                providerVersionState,
                providerVersionExpireOn,
                fabricFriendlyName,
                lastHeartbeatReceivedOn,
                connectionStatus,
                protectedItemCount,
                allowedScenarios?.ToList(),
                healthErrorDetails?.ToList(),
                draIdentifier,
                machineId,
                machineName,
                biosId,
                authenticationIdentityDetails,
                resourceAccessIdentityDetails,
                dataPlaneAuthenticationIdentityDetails,
                providerVersionDetails,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.IdentityProviderDetails"/>. </summary>
        /// <param name="tenantId"> The tenant Id for the service principal with which the on-premise management/data plane components would communicate with our Azure services. </param>
        /// <param name="applicationId"> The application/client Id for the service principal with which the on-premise management/data plane components would communicate with our Azure services. </param>
        /// <param name="objectId"> The object Id of the service principal with which the on-premise management/data plane components would communicate with our Azure services. </param>
        /// <param name="audience"> The intended Audience of the service principal with which the on-premise management/data plane components would communicate with our Azure services. </param>
        /// <param name="aadAuthority"> The base authority for Azure Active Directory authentication. </param>
        /// <returns> A new <see cref="Models.IdentityProviderDetails"/> instance for mocking. </returns>
        public static IdentityProviderDetails IdentityProviderDetails(Guid? tenantId = null, string applicationId = null, string objectId = null, string audience = null, string aadAuthority = null)
        {
            return new IdentityProviderDetails(
                tenantId,
                applicationId,
                objectId,
                audience,
                aadAuthority,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SiteRecoveryVersionDetails"/>. </summary>
        /// <param name="version"> The agent version. </param>
        /// <param name="expireOn"> Version expiry date. </param>
        /// <param name="status"> A value indicating whether security update required. </param>
        /// <returns> A new <see cref="Models.SiteRecoveryVersionDetails"/> instance for mocking. </returns>
        public static SiteRecoveryVersionDetails SiteRecoveryVersionDetails(string version = null, DateTimeOffset? expireOn = null, SiteRecoveryAgentVersionStatus? status = null)
        {
            return new SiteRecoveryVersionDetails(version, expireOn, status, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SiteRecoveryAddRecoveryServicesProviderProperties"/>. </summary>
        /// <param name="machineName"> The name of the machine where the provider is getting added. </param>
        /// <param name="machineId"> The Id of the machine where the provider is getting added. </param>
        /// <param name="biosId"> The Bios Id of the machine. </param>
        /// <param name="authenticationIdentityContent"> The identity provider input for DRA authentication. </param>
        /// <param name="resourceAccessIdentityContent"> The identity provider input for resource access. </param>
        /// <param name="dataPlaneAuthenticationIdentityContent"> The identity provider input for data plane authentication. </param>
        /// <returns> A new <see cref="Models.SiteRecoveryAddRecoveryServicesProviderProperties"/> instance for mocking. </returns>
        public static SiteRecoveryAddRecoveryServicesProviderProperties SiteRecoveryAddRecoveryServicesProviderProperties(string machineName = null, string machineId = null, string biosId = null, IdentityProviderContent authenticationIdentityContent = null, IdentityProviderContent resourceAccessIdentityContent = null, IdentityProviderContent dataPlaneAuthenticationIdentityContent = null)
        {
            return new SiteRecoveryAddRecoveryServicesProviderProperties(
                machineName,
                machineId,
                biosId,
                authenticationIdentityContent,
                resourceAccessIdentityContent,
                dataPlaneAuthenticationIdentityContent,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="RecoveryServicesSiteRecovery.StorageClassificationData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="storageClassificationFriendlyName"> Properties of the storage object. </param>
        /// <param name="location"> Resource Location. </param>
        /// <returns> A new <see cref="RecoveryServicesSiteRecovery.StorageClassificationData"/> instance for mocking. </returns>
        public static StorageClassificationData StorageClassificationData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string storageClassificationFriendlyName = null, AzureLocation? location = null)
        {
            return new StorageClassificationData(
                id,
                name,
                resourceType,
                systemData,
                storageClassificationFriendlyName != null ? new StorageClassificationProperties(storageClassificationFriendlyName, serializedAdditionalRawData: null) : null,
                location,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="RecoveryServicesSiteRecovery.StorageClassificationMappingData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="targetStorageClassificationId"> Properties of the storage mapping object. </param>
        /// <param name="location"> Resource Location. </param>
        /// <returns> A new <see cref="RecoveryServicesSiteRecovery.StorageClassificationMappingData"/> instance for mocking. </returns>
        public static StorageClassificationMappingData StorageClassificationMappingData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ResourceIdentifier targetStorageClassificationId = null, AzureLocation? location = null)
        {
            return new StorageClassificationMappingData(
                id,
                name,
                resourceType,
                systemData,
                targetStorageClassificationId != null ? new StorageClassificationMappingProperties(targetStorageClassificationId, serializedAdditionalRawData: null) : null,
                location,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="RecoveryServicesSiteRecovery.SiteRecoveryVCenterData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> VCenter related data. </param>
        /// <param name="location"> Resource Location. </param>
        /// <returns> A new <see cref="RecoveryServicesSiteRecovery.SiteRecoveryVCenterData"/> instance for mocking. </returns>
        public static SiteRecoveryVCenterData SiteRecoveryVCenterData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, SiteRecoveryVCenterProperties properties = null, AzureLocation? location = null)
        {
            return new SiteRecoveryVCenterData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                location,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SiteRecoveryVCenterProperties"/>. </summary>
        /// <param name="friendlyName"> Friendly name of the vCenter. </param>
        /// <param name="internalId"> VCenter internal ID. </param>
        /// <param name="lastHeartbeatReceivedOn"> The time when the last heartbeat was received by vCenter. </param>
        /// <param name="discoveryStatus"> The VCenter discovery status. </param>
        /// <param name="processServerId"> The process server Id. </param>
        /// <param name="ipAddress"> The IP address of the vCenter. </param>
        /// <param name="infrastructureId"> The infrastructure Id of vCenter. </param>
        /// <param name="port"> The port number for discovery. </param>
        /// <param name="runAsAccountId"> The account Id which has privileges to discover the vCenter. </param>
        /// <param name="fabricArmResourceName"> The ARM resource name of the fabric containing this VCenter. </param>
        /// <param name="healthErrors"> The health errors for this VCenter. </param>
        /// <returns> A new <see cref="Models.SiteRecoveryVCenterProperties"/> instance for mocking. </returns>
        public static SiteRecoveryVCenterProperties SiteRecoveryVCenterProperties(string friendlyName = null, string internalId = null, DateTimeOffset? lastHeartbeatReceivedOn = null, string discoveryStatus = null, Guid? processServerId = null, IPAddress ipAddress = null, string infrastructureId = null, string port = null, string runAsAccountId = null, string fabricArmResourceName = null, IEnumerable<SiteRecoveryHealthError> healthErrors = null)
        {
            healthErrors ??= new List<SiteRecoveryHealthError>();

            return new SiteRecoveryVCenterProperties(
                friendlyName,
                internalId,
                lastHeartbeatReceivedOn,
                discoveryStatus,
                processServerId,
                ipAddress,
                infrastructureId,
                port,
                runAsAccountId,
                fabricArmResourceName,
                healthErrors?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="RecoveryServicesSiteRecovery.SiteRecoveryJobData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> The custom data. </param>
        /// <param name="location"> Resource Location. </param>
        /// <returns> A new <see cref="RecoveryServicesSiteRecovery.SiteRecoveryJobData"/> instance for mocking. </returns>
        public static SiteRecoveryJobData SiteRecoveryJobData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, SiteRecoveryJobProperties properties = null, AzureLocation? location = null)
        {
            return new SiteRecoveryJobData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                location,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SiteRecoveryJobProperties"/>. </summary>
        /// <param name="activityId"> The activity id. </param>
        /// <param name="scenarioName"> The ScenarioName. </param>
        /// <param name="friendlyName"> The DisplayName. </param>
        /// <param name="state"> The status of the Job. It is one of these values - NotStarted, InProgress, Succeeded, Failed, Cancelled, Suspended or Other. </param>
        /// <param name="stateDescription"> The description of the state of the Job. For e.g. - For Succeeded state, description can be Completed, PartiallySucceeded, CompletedWithInformation or Skipped. </param>
        /// <param name="tasks"> The tasks. </param>
        /// <param name="errors"> The errors. </param>
        /// <param name="startOn"> The start time. </param>
        /// <param name="endOn"> The end time. </param>
        /// <param name="allowedActions"> The Allowed action the job. </param>
        /// <param name="targetObjectId"> The affected Object Id. </param>
        /// <param name="targetObjectName"> The name of the affected object. </param>
        /// <param name="targetInstanceType"> The type of the affected object which is of Microsoft.Azure.SiteRecovery.V2015_11_10.AffectedObjectType class. </param>
        /// <param name="customDetails">
        /// The custom job details like test failover job details.
        /// Please note <see cref="Models.SiteRecoveryJobDetails"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.AsrJobDetails"/>, <see cref="Models.ExportJobDetails"/>, <see cref="Models.FailoverJobDetails"/>, <see cref="Models.SwitchProtectionJobDetails"/> and <see cref="Models.TestFailoverJobDetails"/>.
        /// </param>
        /// <returns> A new <see cref="Models.SiteRecoveryJobProperties"/> instance for mocking. </returns>
        public static SiteRecoveryJobProperties SiteRecoveryJobProperties(string activityId = null, string scenarioName = null, string friendlyName = null, string state = null, string stateDescription = null, IEnumerable<AsrTask> tasks = null, IEnumerable<SiteRecoveryJobErrorDetails> errors = null, DateTimeOffset? startOn = null, DateTimeOffset? endOn = null, IEnumerable<string> allowedActions = null, string targetObjectId = null, string targetObjectName = null, string targetInstanceType = null, SiteRecoveryJobDetails customDetails = null)
        {
            tasks ??= new List<AsrTask>();
            errors ??= new List<SiteRecoveryJobErrorDetails>();
            allowedActions ??= new List<string>();

            return new SiteRecoveryJobProperties(
                activityId,
                scenarioName,
                friendlyName,
                state,
                stateDescription,
                tasks?.ToList(),
                errors?.ToList(),
                startOn,
                endOn,
                allowedActions?.ToList(),
                targetObjectId,
                targetObjectName,
                targetInstanceType,
                customDetails,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AsrTask"/>. </summary>
        /// <param name="taskId"> The Id. </param>
        /// <param name="name"> The unique Task name. </param>
        /// <param name="startOn"> The start time. </param>
        /// <param name="endOn"> The end time. </param>
        /// <param name="allowedActions"> The state/actions applicable on this task. </param>
        /// <param name="friendlyName"> The name. </param>
        /// <param name="state"> The State. It is one of these values - NotStarted, InProgress, Succeeded, Failed, Cancelled, Suspended or Other. </param>
        /// <param name="stateDescription"> The description of the task state. For example - For Succeeded state, description can be Completed, PartiallySucceeded, CompletedWithInformation or Skipped. </param>
        /// <param name="taskType"> The type of task. Details in CustomDetails property depend on this type. </param>
        /// <param name="customDetails">
        /// The custom task details based on the task type.
        /// Please note <see cref="SiteRecoveryTaskTypeDetails"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.AutomationRunbookTaskDetails"/>, <see cref="Models.ConsistencyCheckTaskDetails"/>, <see cref="Models.FabricReplicationGroupTaskDetails"/>, <see cref="Models.SiteRecoveryJobTaskDetails"/>, <see cref="Models.ManualActionTaskDetails"/>, <see cref="Models.ScriptActionTaskDetails"/>, <see cref="Models.SiteRecoveryVmTaskDetails"/> and <see cref="Models.VmNicUpdatesTaskDetails"/>.
        /// </param>
        /// <param name="groupTaskCustomDetails">
        /// The custom task details based on the task type, if the task type is GroupTaskDetails or one of the types derived from it.
        /// Please note <see cref="Models.SiteRecoveryGroupTaskDetails"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.InlineWorkflowTaskDetails"/>, <see cref="Models.RecoveryPlanGroupTaskDetails"/> and <see cref="Models.RecoveryPlanShutdownGroupTaskDetails"/>.
        /// </param>
        /// <param name="errors"> The task error details. </param>
        /// <returns> A new <see cref="Models.AsrTask"/> instance for mocking. </returns>
        public static AsrTask AsrTask(string taskId = null, string name = null, DateTimeOffset? startOn = null, DateTimeOffset? endOn = null, IEnumerable<string> allowedActions = null, string friendlyName = null, string state = null, string stateDescription = null, string taskType = null, SiteRecoveryTaskTypeDetails customDetails = null, SiteRecoveryGroupTaskDetails groupTaskCustomDetails = null, IEnumerable<SiteRecoveryJobErrorDetails> errors = null)
        {
            allowedActions ??= new List<string>();
            errors ??= new List<SiteRecoveryJobErrorDetails>();

            return new AsrTask(
                taskId,
                name,
                startOn,
                endOn,
                allowedActions?.ToList(),
                friendlyName,
                state,
                stateDescription,
                taskType,
                customDetails,
                groupTaskCustomDetails,
                errors?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SiteRecoveryGroupTaskDetails"/>. </summary>
        /// <param name="instanceType"> The type of task details. </param>
        /// <param name="childTasks"> The child tasks. </param>
        /// <returns> A new <see cref="Models.SiteRecoveryGroupTaskDetails"/> instance for mocking. </returns>
        public static SiteRecoveryGroupTaskDetails SiteRecoveryGroupTaskDetails(string instanceType = null, IEnumerable<AsrTask> childTasks = null)
        {
            childTasks ??= new List<AsrTask>();

            return new UnknownGroupTaskDetails(instanceType, childTasks?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SiteRecoveryJobErrorDetails"/>. </summary>
        /// <param name="serviceErrorDetails"> The Service error details. </param>
        /// <param name="providerErrorDetails"> The Provider error details. </param>
        /// <param name="errorLevel"> Error level of error. </param>
        /// <param name="createdOn"> The creation time of job error. </param>
        /// <param name="taskId"> The Id of the task. </param>
        /// <returns> A new <see cref="Models.SiteRecoveryJobErrorDetails"/> instance for mocking. </returns>
        public static SiteRecoveryJobErrorDetails SiteRecoveryJobErrorDetails(SiteRecoveryServiceError serviceErrorDetails = null, SiteRecoveryJobProviderError providerErrorDetails = null, string errorLevel = null, DateTimeOffset? createdOn = null, string taskId = null)
        {
            return new SiteRecoveryJobErrorDetails(
                serviceErrorDetails,
                providerErrorDetails,
                errorLevel,
                createdOn,
                taskId,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SiteRecoveryServiceError"/>. </summary>
        /// <param name="code"> Error code. </param>
        /// <param name="message"> Error message. </param>
        /// <param name="possibleCauses"> Possible causes of error. </param>
        /// <param name="recommendedAction"> Recommended action to resolve error. </param>
        /// <param name="activityId"> Activity Id. </param>
        /// <returns> A new <see cref="Models.SiteRecoveryServiceError"/> instance for mocking. </returns>
        public static SiteRecoveryServiceError SiteRecoveryServiceError(string code = null, string message = null, string possibleCauses = null, string recommendedAction = null, string activityId = null)
        {
            return new SiteRecoveryServiceError(
                code,
                message,
                possibleCauses,
                recommendedAction,
                activityId,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SiteRecoveryJobProviderError"/>. </summary>
        /// <param name="errorCode"> The Error code. </param>
        /// <param name="errorMessage"> The Error message. </param>
        /// <param name="errorId"> The Provider error Id. </param>
        /// <param name="possibleCauses"> The possible causes for the error. </param>
        /// <param name="recommendedAction"> The recommended action to resolve the error. </param>
        /// <returns> A new <see cref="Models.SiteRecoveryJobProviderError"/> instance for mocking. </returns>
        public static SiteRecoveryJobProviderError SiteRecoveryJobProviderError(int? errorCode = null, string errorMessage = null, string errorId = null, string possibleCauses = null, string recommendedAction = null)
        {
            return new SiteRecoveryJobProviderError(
                errorCode,
                errorMessage,
                errorId,
                possibleCauses,
                recommendedAction,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SiteRecoveryJobDetails"/>. </summary>
        /// <param name="instanceType"> Gets the type of job details (see JobDetailsTypes enum for possible values). </param>
        /// <param name="affectedObjectDetails"> The affected object properties like source server, source cloud, target server, target cloud etc. based on the workflow object details. </param>
        /// <returns> A new <see cref="Models.SiteRecoveryJobDetails"/> instance for mocking. </returns>
        public static SiteRecoveryJobDetails SiteRecoveryJobDetails(string instanceType = null, IReadOnlyDictionary<string, string> affectedObjectDetails = null)
        {
            affectedObjectDetails ??= new Dictionary<string, string>();

            return new UnknownJobDetails(instanceType, affectedObjectDetails, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="RecoveryServicesSiteRecovery.SiteRecoveryPolicyData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> The custom data. </param>
        /// <param name="location"> Resource Location. </param>
        /// <returns> A new <see cref="RecoveryServicesSiteRecovery.SiteRecoveryPolicyData"/> instance for mocking. </returns>
        public static SiteRecoveryPolicyData SiteRecoveryPolicyData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, SiteRecoveryPolicyProperties properties = null, AzureLocation? location = null)
        {
            return new SiteRecoveryPolicyData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                location,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SiteRecoveryPolicyProperties"/>. </summary>
        /// <param name="friendlyName"> The FriendlyName. </param>
        /// <param name="providerSpecificDetails">
        /// The ReplicationChannelSetting.
        /// Please note <see cref="PolicyProviderSpecificDetails"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.A2APolicyDetails"/>, <see cref="Models.HyperVReplicaPolicyDetails"/>, <see cref="Models.HyperVReplicaBluePolicyDetails"/>, <see cref="Models.HyperVReplicaAzurePolicyDetails"/>, <see cref="Models.HyperVReplicaBasePolicyDetails"/>, <see cref="Models.InMagePolicyDetails"/>, <see cref="Models.InMageAzureV2PolicyDetails"/>, <see cref="Models.InMageBasePolicyDetails"/>, <see cref="Models.InMageRcmPolicyDetails"/>, <see cref="Models.InMageRcmFailbackPolicyDetails"/> and <see cref="Models.VMwareCbtPolicyDetails"/>.
        /// </param>
        /// <returns> A new <see cref="Models.SiteRecoveryPolicyProperties"/> instance for mocking. </returns>
        public static SiteRecoveryPolicyProperties SiteRecoveryPolicyProperties(string friendlyName = null, PolicyProviderSpecificDetails providerSpecificDetails = null)
        {
            return new SiteRecoveryPolicyProperties(friendlyName, providerSpecificDetails, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="RecoveryServicesSiteRecovery.ReplicationProtectionIntentData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> The custom data. </param>
        /// <param name="location"> Resource Location. </param>
        /// <returns> A new <see cref="RecoveryServicesSiteRecovery.ReplicationProtectionIntentData"/> instance for mocking. </returns>
        public static ReplicationProtectionIntentData ReplicationProtectionIntentData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ReplicationProtectionIntentProperties properties = null, AzureLocation? location = null)
        {
            return new ReplicationProtectionIntentData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                location,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ReplicationProtectionIntentProperties"/>. </summary>
        /// <param name="friendlyName"> The name. </param>
        /// <param name="jobId"> The job Id. </param>
        /// <param name="jobState"> The job state. </param>
        /// <param name="isActive"> A value indicating whether the intent object is active. </param>
        /// <param name="createdOn"> The creation time in UTC. </param>
        /// <param name="providerSpecificDetails">
        /// The Replication provider custom settings.
        /// Please note <see cref="ReplicationProtectionIntentProviderSpecificSettings"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.A2AReplicationIntentDetails"/>.
        /// </param>
        /// <returns> A new <see cref="Models.ReplicationProtectionIntentProperties"/> instance for mocking. </returns>
        public static ReplicationProtectionIntentProperties ReplicationProtectionIntentProperties(string friendlyName = null, ResourceIdentifier jobId = null, string jobState = null, bool? isActive = null, string createdOn = null, ReplicationProtectionIntentProviderSpecificSettings providerSpecificDetails = null)
        {
            return new ReplicationProtectionIntentProperties(
                friendlyName,
                jobId,
                jobState,
                isActive,
                createdOn,
                providerSpecificDetails,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="RecoveryServicesSiteRecovery.SiteRecoveryRecoveryPlanData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> The custom details. </param>
        /// <param name="location"> Resource Location. </param>
        /// <returns> A new <see cref="RecoveryServicesSiteRecovery.SiteRecoveryRecoveryPlanData"/> instance for mocking. </returns>
        public static SiteRecoveryRecoveryPlanData SiteRecoveryRecoveryPlanData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, SiteRecoveryRecoveryPlanProperties properties = null, AzureLocation? location = null)
        {
            return new SiteRecoveryRecoveryPlanData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                location,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SiteRecoveryRecoveryPlanProperties"/>. </summary>
        /// <param name="friendlyName"> The friendly name. </param>
        /// <param name="primaryFabricId"> The primary fabric Id. </param>
        /// <param name="primaryFabricFriendlyName"> The primary fabric friendly name. </param>
        /// <param name="recoveryFabricId"> The recovery fabric Id. </param>
        /// <param name="recoveryFabricFriendlyName"> The recovery fabric friendly name. </param>
        /// <param name="failoverDeploymentModel"> The failover deployment model. </param>
        /// <param name="replicationProviders"> The list of replication providers. </param>
        /// <param name="allowedOperations"> The list of allowed operations. </param>
        /// <param name="lastPlannedFailoverOn"> The start time of the last planned failover. </param>
        /// <param name="lastUnplannedFailoverOn"> The start time of the last unplanned failover. </param>
        /// <param name="lastTestFailoverOn"> The start time of the last test failover. </param>
        /// <param name="currentScenario"> The current scenario details. </param>
        /// <param name="currentScenarioStatus"> The recovery plan status. </param>
        /// <param name="currentScenarioStatusDescription"> The recovery plan status description. </param>
        /// <param name="groups"> The recovery plan groups. </param>
        /// <param name="providerSpecificDetails">
        /// The provider id and provider specific details.
        /// Please note <see cref="RecoveryPlanProviderSpecificDetails"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.RecoveryPlanA2ADetails"/>.
        /// </param>
        /// <returns> A new <see cref="Models.SiteRecoveryRecoveryPlanProperties"/> instance for mocking. </returns>
        public static SiteRecoveryRecoveryPlanProperties SiteRecoveryRecoveryPlanProperties(string friendlyName = null, ResourceIdentifier primaryFabricId = null, string primaryFabricFriendlyName = null, ResourceIdentifier recoveryFabricId = null, string recoveryFabricFriendlyName = null, string failoverDeploymentModel = null, IEnumerable<string> replicationProviders = null, IEnumerable<string> allowedOperations = null, DateTimeOffset? lastPlannedFailoverOn = null, DateTimeOffset? lastUnplannedFailoverOn = null, DateTimeOffset? lastTestFailoverOn = null, CurrentScenarioDetails currentScenario = null, string currentScenarioStatus = null, string currentScenarioStatusDescription = null, IEnumerable<SiteRecoveryPlanGroup> groups = null, IEnumerable<RecoveryPlanProviderSpecificDetails> providerSpecificDetails = null)
        {
            replicationProviders ??= new List<string>();
            allowedOperations ??= new List<string>();
            groups ??= new List<SiteRecoveryPlanGroup>();
            providerSpecificDetails ??= new List<RecoveryPlanProviderSpecificDetails>();

            return new SiteRecoveryRecoveryPlanProperties(
                friendlyName,
                primaryFabricId,
                primaryFabricFriendlyName,
                recoveryFabricId,
                recoveryFabricFriendlyName,
                failoverDeploymentModel,
                replicationProviders?.ToList(),
                allowedOperations?.ToList(),
                lastPlannedFailoverOn,
                lastUnplannedFailoverOn,
                lastTestFailoverOn,
                currentScenario,
                currentScenarioStatus,
                currentScenarioStatusDescription,
                groups?.ToList(),
                providerSpecificDetails?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SiteRecoveryCreateRecoveryPlanProperties"/>. </summary>
        /// <param name="primaryFabricId"> The primary fabric Id. </param>
        /// <param name="recoveryFabricId"> The recovery fabric Id. </param>
        /// <param name="failoverDeploymentModel"> The failover deployment model. </param>
        /// <param name="groups"> The recovery plan groups. </param>
        /// <param name="providerSpecificContent">
        /// The provider specific input.
        /// Please note <see cref="RecoveryPlanProviderSpecificContent"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="RecoveryPlanA2AContent"/>.
        /// </param>
        /// <returns> A new <see cref="Models.SiteRecoveryCreateRecoveryPlanProperties"/> instance for mocking. </returns>
        public static SiteRecoveryCreateRecoveryPlanProperties SiteRecoveryCreateRecoveryPlanProperties(ResourceIdentifier primaryFabricId = null, ResourceIdentifier recoveryFabricId = null, FailoverDeploymentModel? failoverDeploymentModel = null, IEnumerable<SiteRecoveryPlanGroup> groups = null, IEnumerable<RecoveryPlanProviderSpecificContent> providerSpecificContent = null)
        {
            groups ??= new List<SiteRecoveryPlanGroup>();
            providerSpecificContent ??= new List<RecoveryPlanProviderSpecificContent>();

            return new SiteRecoveryCreateRecoveryPlanProperties(
                primaryFabricId,
                recoveryFabricId,
                failoverDeploymentModel,
                groups?.ToList(),
                providerSpecificContent?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RecoveryPlanPlannedFailoverProperties"/>. </summary>
        /// <param name="failoverDirection"> The failover direction. </param>
        /// <param name="providerSpecificDetails">
        /// The provider specific properties.
        /// Please note <see cref="RecoveryPlanProviderSpecificFailoverContent"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.RecoveryPlanA2AFailoverContent"/>, <see cref="RecoveryPlanHyperVReplicaAzureFailoverContent"/>, <see cref="Models.RecoveryPlanHyperVReplicaAzureFailbackContent"/>, <see cref="Models.RecoveryPlanInMageFailoverContent"/>, <see cref="Models.RecoveryPlanInMageAzureV2FailoverContent"/>, <see cref="Models.RecoveryPlanInMageRcmFailoverContent"/> and <see cref="Models.RecoveryPlanInMageRcmFailbackFailoverContent"/>.
        /// </param>
        /// <returns> A new <see cref="Models.RecoveryPlanPlannedFailoverProperties"/> instance for mocking. </returns>
        public static RecoveryPlanPlannedFailoverProperties RecoveryPlanPlannedFailoverProperties(PossibleOperationsDirection failoverDirection = default, IEnumerable<RecoveryPlanProviderSpecificFailoverContent> providerSpecificDetails = null)
        {
            providerSpecificDetails ??= new List<RecoveryPlanProviderSpecificFailoverContent>();

            return new RecoveryPlanPlannedFailoverProperties(failoverDirection, providerSpecificDetails?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RecoveryPlanTestFailoverProperties"/>. </summary>
        /// <param name="failoverDirection"> The failover direction. </param>
        /// <param name="networkType"> The network type to be used for test failover. </param>
        /// <param name="networkId"> The Id of the network to be used for test failover. </param>
        /// <param name="providerSpecificDetails">
        /// The provider specific properties.
        /// Please note <see cref="RecoveryPlanProviderSpecificFailoverContent"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.RecoveryPlanA2AFailoverContent"/>, <see cref="RecoveryPlanHyperVReplicaAzureFailoverContent"/>, <see cref="Models.RecoveryPlanHyperVReplicaAzureFailbackContent"/>, <see cref="Models.RecoveryPlanInMageFailoverContent"/>, <see cref="Models.RecoveryPlanInMageAzureV2FailoverContent"/>, <see cref="Models.RecoveryPlanInMageRcmFailoverContent"/> and <see cref="Models.RecoveryPlanInMageRcmFailbackFailoverContent"/>.
        /// </param>
        /// <returns> A new <see cref="Models.RecoveryPlanTestFailoverProperties"/> instance for mocking. </returns>
        public static RecoveryPlanTestFailoverProperties RecoveryPlanTestFailoverProperties(PossibleOperationsDirection failoverDirection = default, string networkType = null, ResourceIdentifier networkId = null, IEnumerable<RecoveryPlanProviderSpecificFailoverContent> providerSpecificDetails = null)
        {
            providerSpecificDetails ??= new List<RecoveryPlanProviderSpecificFailoverContent>();

            return new RecoveryPlanTestFailoverProperties(failoverDirection, networkType, networkId, providerSpecificDetails?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RecoveryPlanUnplannedFailoverProperties"/>. </summary>
        /// <param name="failoverDirection"> The failover direction. </param>
        /// <param name="sourceSiteOperation"> A value indicating whether source site operations are required. </param>
        /// <param name="providerSpecificDetails">
        /// The provider specific properties.
        /// Please note <see cref="RecoveryPlanProviderSpecificFailoverContent"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.RecoveryPlanA2AFailoverContent"/>, <see cref="RecoveryPlanHyperVReplicaAzureFailoverContent"/>, <see cref="Models.RecoveryPlanHyperVReplicaAzureFailbackContent"/>, <see cref="Models.RecoveryPlanInMageFailoverContent"/>, <see cref="Models.RecoveryPlanInMageAzureV2FailoverContent"/>, <see cref="Models.RecoveryPlanInMageRcmFailoverContent"/> and <see cref="Models.RecoveryPlanInMageRcmFailbackFailoverContent"/>.
        /// </param>
        /// <returns> A new <see cref="Models.RecoveryPlanUnplannedFailoverProperties"/> instance for mocking. </returns>
        public static RecoveryPlanUnplannedFailoverProperties RecoveryPlanUnplannedFailoverProperties(PossibleOperationsDirection failoverDirection = default, SourceSiteOperation sourceSiteOperation = default, IEnumerable<RecoveryPlanProviderSpecificFailoverContent> providerSpecificDetails = null)
        {
            providerSpecificDetails ??= new List<RecoveryPlanProviderSpecificFailoverContent>();

            return new RecoveryPlanUnplannedFailoverProperties(failoverDirection, sourceSiteOperation, providerSpecificDetails?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SiteRecoverySupportedOperatingSystems"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="supportedOSList"> The supported operating systems properties. </param>
        /// <param name="location"> Resource Location. </param>
        /// <returns> A new <see cref="Models.SiteRecoverySupportedOperatingSystems"/> instance for mocking. </returns>
        public static SiteRecoverySupportedOperatingSystems SiteRecoverySupportedOperatingSystems(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IEnumerable<SiteRecoverySupportedOSProperty> supportedOSList = null, AzureLocation? location = null)
        {
            supportedOSList ??= new List<SiteRecoverySupportedOSProperty>();

            return new SiteRecoverySupportedOperatingSystems(
                id,
                name,
                resourceType,
                systemData,
                supportedOSList != null ? new SiteRecoverySupportedOSProperties(supportedOSList?.ToList(), serializedAdditionalRawData: null) : null,
                location,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SiteRecoverySupportedOSProperty"/>. </summary>
        /// <param name="instanceType"> The replication provider type. </param>
        /// <param name="supportedOS"> The list of supported operating systems. </param>
        /// <returns> A new <see cref="Models.SiteRecoverySupportedOSProperty"/> instance for mocking. </returns>
        public static SiteRecoverySupportedOSProperty SiteRecoverySupportedOSProperty(string instanceType = null, IEnumerable<SiteRecoverySupportedOSDetails> supportedOS = null)
        {
            supportedOS ??= new List<SiteRecoverySupportedOSDetails>();

            return new SiteRecoverySupportedOSProperty(instanceType, supportedOS?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SiteRecoverySupportedOSDetails"/>. </summary>
        /// <param name="osName"> The name. </param>
        /// <param name="osType"> The type. </param>
        /// <param name="osVersions"> The list of version for operating system. </param>
        /// <returns> A new <see cref="Models.SiteRecoverySupportedOSDetails"/> instance for mocking. </returns>
        public static SiteRecoverySupportedOSDetails SiteRecoverySupportedOSDetails(string osName = null, string osType = null, IEnumerable<SiteRecoveryOSVersionWrapper> osVersions = null)
        {
            osVersions ??= new List<SiteRecoveryOSVersionWrapper>();

            return new SiteRecoverySupportedOSDetails(osName, osType, osVersions?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SiteRecoveryOSVersionWrapper"/>. </summary>
        /// <param name="version"> The version. </param>
        /// <param name="servicePack"> The service pack. </param>
        /// <returns> A new <see cref="Models.SiteRecoveryOSVersionWrapper"/> instance for mocking. </returns>
        public static SiteRecoveryOSVersionWrapper SiteRecoveryOSVersionWrapper(string version = null, string servicePack = null)
        {
            return new SiteRecoveryOSVersionWrapper(version, servicePack, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.VaultHealthDetails"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> The vault health related data. </param>
        /// <param name="location"> Resource Location. </param>
        /// <returns> A new <see cref="Models.VaultHealthDetails"/> instance for mocking. </returns>
        public static VaultHealthDetails VaultHealthDetails(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, VaultHealthProperties properties = null, AzureLocation? location = null)
        {
            return new VaultHealthDetails(
                id,
                name,
                resourceType,
                systemData,
                properties,
                location,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.VaultHealthProperties"/>. </summary>
        /// <param name="vaultErrors"> The list of errors on the vault. </param>
        /// <param name="protectedItemsHealth"> The list of the health detail of the protected items in the vault. </param>
        /// <param name="fabricsHealth"> The list of the health detail of the fabrics in the vault. </param>
        /// <param name="containersHealth"> The list of the health detail of the containers in the vault. </param>
        /// <returns> A new <see cref="Models.VaultHealthProperties"/> instance for mocking. </returns>
        public static VaultHealthProperties VaultHealthProperties(IEnumerable<SiteRecoveryHealthError> vaultErrors = null, ResourceHealthSummary protectedItemsHealth = null, ResourceHealthSummary fabricsHealth = null, ResourceHealthSummary containersHealth = null)
        {
            vaultErrors ??= new List<SiteRecoveryHealthError>();

            return new VaultHealthProperties(vaultErrors?.ToList(), protectedItemsHealth, fabricsHealth, containersHealth, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ResourceHealthSummary"/>. </summary>
        /// <param name="resourceCount"> The count of total resources under the container. </param>
        /// <param name="issues"> The list of summary of health errors across the resources under the container. </param>
        /// <param name="categorizedResourceCounts"> The categorized resource counts. </param>
        /// <returns> A new <see cref="Models.ResourceHealthSummary"/> instance for mocking. </returns>
        public static ResourceHealthSummary ResourceHealthSummary(int? resourceCount = null, IEnumerable<HealthErrorSummary> issues = null, IReadOnlyDictionary<string, int> categorizedResourceCounts = null)
        {
            issues ??= new List<HealthErrorSummary>();
            categorizedResourceCounts ??= new Dictionary<string, int>();

            return new ResourceHealthSummary(resourceCount, issues?.ToList(), categorizedResourceCounts, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HealthErrorSummary"/>. </summary>
        /// <param name="summaryCode"> The code of the health error. </param>
        /// <param name="category"> The category of the health error. </param>
        /// <param name="severity"> Severity of error. </param>
        /// <param name="summaryMessage"> The summary message of the health error. </param>
        /// <param name="affectedResourceType"> The type of affected ARM resource. </param>
        /// <param name="affectedResourceSubtype"> The sub type of any subcomponent within the ARM resource that this might be applicable. Value remains null if not applicable. </param>
        /// <param name="affectedResourceCorrelationIds"> The list of affected resource correlation Ids. This can be used to uniquely identify the count of items affected by a specific category and severity as well as count of item affected by an specific issue. </param>
        /// <returns> A new <see cref="Models.HealthErrorSummary"/> instance for mocking. </returns>
        public static HealthErrorSummary HealthErrorSummary(string summaryCode = null, HealthErrorCategory? category = null, SiteRecoveryErrorSeverity? severity = null, string summaryMessage = null, string affectedResourceType = null, string affectedResourceSubtype = null, IEnumerable<string> affectedResourceCorrelationIds = null)
        {
            affectedResourceCorrelationIds ??= new List<string>();

            return new HealthErrorSummary(
                summaryCode,
                category,
                severity,
                summaryMessage,
                affectedResourceType,
                affectedResourceSubtype,
                affectedResourceCorrelationIds?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="RecoveryServicesSiteRecovery.SiteRecoveryVaultSettingData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> The vault setting properties. </param>
        /// <param name="location"> Resource Location. </param>
        /// <returns> A new <see cref="RecoveryServicesSiteRecovery.SiteRecoveryVaultSettingData"/> instance for mocking. </returns>
        public static SiteRecoveryVaultSettingData SiteRecoveryVaultSettingData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, SiteRecoveryVaultSettingProperties properties = null, AzureLocation? location = null)
        {
            return new SiteRecoveryVaultSettingData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                location,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SiteRecoveryVaultSettingProperties"/>. </summary>
        /// <param name="migrationSolutionId"> The migration solution ARM Id. </param>
        /// <param name="vmwareToAzureProviderType"> VMware to Azure provider type. </param>
        /// <returns> A new <see cref="Models.SiteRecoveryVaultSettingProperties"/> instance for mocking. </returns>
        public static SiteRecoveryVaultSettingProperties SiteRecoveryVaultSettingProperties(ResourceIdentifier migrationSolutionId = null, string vmwareToAzureProviderType = null)
        {
            return new SiteRecoveryVaultSettingProperties(migrationSolutionId, vmwareToAzureProviderType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.A2AVmManagedDiskDetails"/>. </summary>
        /// <param name="diskId"> The disk Id. </param>
        /// <param name="primaryStagingAzureStorageAccountId"> The primary staging storage account Arm Id. </param>
        /// <param name="recoveryResourceGroupId"> The target resource group Arm Id. </param>
        /// <param name="recoveryReplicaDiskAccountType"> The replica disk type. Its an optional value and will be same as source disk type if not user provided. </param>
        /// <param name="recoveryTargetDiskAccountType"> The target disk type after failover. Its an optional value and will be same as source disk type if not user provided. </param>
        /// <param name="recoveryDiskEncryptionSetId"> The recovery disk encryption set Id. </param>
        /// <param name="diskEncryptionInfo"> The recovery disk encryption information (for one / single pass flows). </param>
        /// <returns> A new <see cref="Models.A2AVmManagedDiskDetails"/> instance for mocking. </returns>
        public static A2AVmManagedDiskDetails A2AVmManagedDiskDetails(string diskId = null, ResourceIdentifier primaryStagingAzureStorageAccountId = null, ResourceIdentifier recoveryResourceGroupId = null, string recoveryReplicaDiskAccountType = null, string recoveryTargetDiskAccountType = null, ResourceIdentifier recoveryDiskEncryptionSetId = null, SiteRecoveryDiskEncryptionInfo diskEncryptionInfo = null)
        {
            return new A2AVmManagedDiskDetails(
                diskId,
                primaryStagingAzureStorageAccountId,
                recoveryResourceGroupId,
                recoveryReplicaDiskAccountType,
                recoveryTargetDiskAccountType,
                recoveryDiskEncryptionSetId,
                diskEncryptionInfo,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.A2ACreateProtectionIntentContent"/>. </summary>
        /// <param name="fabricObjectId"> The fabric specific object Id of the virtual machine. </param>
        /// <param name="primaryLocation"> The primary location for the virtual machine. </param>
        /// <param name="recoveryLocation"> The recovery location for the virtual machine. </param>
        /// <param name="recoverySubscriptionId"> The recovery subscription Id of the virtual machine. </param>
        /// <param name="recoveryAvailabilityType"> The recovery availability type of the virtual machine. </param>
        /// <param name="protectionProfileCustomContent">
        /// The protection profile custom inputs.
        /// Please note <see cref="ProtectionProfileCustomDetails"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="ExistingProtectionProfile"/> and <see cref="NewProtectionProfile"/>.
        /// </param>
        /// <param name="recoveryResourceGroupId"> The recovery resource group Id. Valid for V2 scenarios. </param>
        /// <param name="primaryStagingStorageAccountCustomContent">
        /// The primary staging storage account input.
        /// Please note <see cref="StorageAccountCustomDetails"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="ExistingStorageAccount"/>.
        /// </param>
        /// <param name="recoveryAvailabilitySetCustomContent">
        /// The recovery availability set input.
        /// Please note <see cref="RecoveryAvailabilitySetCustomDetails"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="ExistingRecoveryAvailabilitySet"/>.
        /// </param>
        /// <param name="recoveryVirtualNetworkCustomContent">
        /// The recovery virtual network input.
        /// Please note <see cref="RecoveryVirtualNetworkCustomDetails"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="ExistingRecoveryVirtualNetwork"/> and <see cref="NewRecoveryVirtualNetwork"/>.
        /// </param>
        /// <param name="recoveryProximityPlacementGroupCustomContent">
        /// The recovery proximity placement group custom input.
        /// Please note <see cref="RecoveryProximityPlacementGroupCustomDetails"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="ExistingRecoveryProximityPlacementGroup"/>.
        /// </param>
        /// <param name="autoProtectionOfDataDisk"> A value indicating whether the auto protection is enabled. </param>
        /// <param name="vmDisks"> The list of vm disk inputs. </param>
        /// <param name="vmManagedDisks"> The list of vm managed disk inputs. </param>
        /// <param name="multiVmGroupName"> The multi vm group name. </param>
        /// <param name="multiVmGroupId"> The multi vm group id. </param>
        /// <param name="recoveryBootDiagStorageAccount">
        /// The boot diagnostic storage account.
        /// Please note <see cref="StorageAccountCustomDetails"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="ExistingStorageAccount"/>.
        /// </param>
        /// <param name="diskEncryptionInfo"> The recovery disk encryption information (for two pass flows). </param>
        /// <param name="recoveryAvailabilityZone"> The recovery availability zone. </param>
        /// <param name="agentAutoUpdateStatus"> A value indicating whether the auto update is enabled. </param>
        /// <param name="automationAccountAuthenticationType"> A value indicating the authentication type for automation account. The default value is "RunAsAccount". </param>
        /// <param name="automationAccountArmId"> The automation account arm id. </param>
        /// <returns> A new <see cref="Models.A2ACreateProtectionIntentContent"/> instance for mocking. </returns>
        public static A2ACreateProtectionIntentContent A2ACreateProtectionIntentContent(ResourceIdentifier fabricObjectId = null, AzureLocation primaryLocation = default, AzureLocation recoveryLocation = default, string recoverySubscriptionId = null, A2ARecoveryAvailabilityType recoveryAvailabilityType = default, ProtectionProfileCustomDetails protectionProfileCustomContent = null, ResourceIdentifier recoveryResourceGroupId = null, StorageAccountCustomDetails primaryStagingStorageAccountCustomContent = null, RecoveryAvailabilitySetCustomDetails recoveryAvailabilitySetCustomContent = null, RecoveryVirtualNetworkCustomDetails recoveryVirtualNetworkCustomContent = null, RecoveryProximityPlacementGroupCustomDetails recoveryProximityPlacementGroupCustomContent = null, AutoProtectionOfDataDisk? autoProtectionOfDataDisk = null, IEnumerable<A2AProtectionIntentDiskDetails> vmDisks = null, IEnumerable<A2AProtectionIntentManagedDiskDetails> vmManagedDisks = null, string multiVmGroupName = null, string multiVmGroupId = null, StorageAccountCustomDetails recoveryBootDiagStorageAccount = null, SiteRecoveryDiskEncryptionInfo diskEncryptionInfo = null, string recoveryAvailabilityZone = null, SiteRecoveryAgentAutoUpdateStatus? agentAutoUpdateStatus = null, AutomationAccountAuthenticationType? automationAccountAuthenticationType = null, ResourceIdentifier automationAccountArmId = null)
        {
            vmDisks ??= new List<A2AProtectionIntentDiskDetails>();
            vmManagedDisks ??= new List<A2AProtectionIntentManagedDiskDetails>();

            return new A2ACreateProtectionIntentContent(
                "A2A",
                serializedAdditionalRawData: null,
                fabricObjectId,
                primaryLocation,
                recoveryLocation,
                recoverySubscriptionId,
                recoveryAvailabilityType,
                protectionProfileCustomContent,
                recoveryResourceGroupId,
                primaryStagingStorageAccountCustomContent,
                recoveryAvailabilitySetCustomContent,
                recoveryVirtualNetworkCustomContent,
                recoveryProximityPlacementGroupCustomContent,
                autoProtectionOfDataDisk,
                vmDisks?.ToList(),
                vmManagedDisks?.ToList(),
                multiVmGroupName,
                multiVmGroupId,
                recoveryBootDiagStorageAccount,
                diskEncryptionInfo,
                recoveryAvailabilityZone,
                agentAutoUpdateStatus,
                automationAccountAuthenticationType,
                automationAccountArmId);
        }

        /// <summary> Initializes a new instance of <see cref="Models.A2ACrossClusterMigrationReplicationDetails"/>. </summary>
        /// <param name="fabricObjectId"> The fabric specific object Id of the virtual machine. </param>
        /// <param name="primaryFabricLocation"> Primary fabric location. </param>
        /// <param name="osType"> The type of operating system. </param>
        /// <param name="vmProtectionState"> The protection state for the vm. </param>
        /// <param name="vmProtectionStateDescription"> The protection state description for the vm. </param>
        /// <param name="lifecycleId"> An id associated with the PE that survives actions like switch protection which change the backing PE/CPE objects internally.The lifecycle id gets carried forward to have a link/continuity in being able to have an Id that denotes the "same" protected item even though other internal Ids/ARM Id might be changing. </param>
        /// <returns> A new <see cref="Models.A2ACrossClusterMigrationReplicationDetails"/> instance for mocking. </returns>
        public static A2ACrossClusterMigrationReplicationDetails A2ACrossClusterMigrationReplicationDetails(ResourceIdentifier fabricObjectId = null, AzureLocation? primaryFabricLocation = null, string osType = null, string vmProtectionState = null, string vmProtectionStateDescription = null, string lifecycleId = null)
        {
            return new A2ACrossClusterMigrationReplicationDetails(
                "A2ACrossClusterMigration",
                serializedAdditionalRawData: null,
                fabricObjectId,
                primaryFabricLocation,
                osType,
                vmProtectionState,
                vmProtectionStateDescription,
                lifecycleId);
        }

        /// <summary> Initializes a new instance of <see cref="Models.A2AEnableProtectionContent"/>. </summary>
        /// <param name="fabricObjectId"> The fabric specific object Id of the virtual machine. </param>
        /// <param name="recoveryContainerId"> The recovery container Id. </param>
        /// <param name="recoveryResourceGroupId"> The recovery resource group Id. Valid for V2 scenarios. </param>
        /// <param name="recoveryCloudServiceId"> The recovery cloud service Id. Valid for V1 scenarios. </param>
        /// <param name="recoveryAvailabilitySetId"> The recovery availability set Id. </param>
        /// <param name="recoveryProximityPlacementGroupId"> The recovery proximity placement group Id. </param>
        /// <param name="vmDisks"> The list of vm disk details. </param>
        /// <param name="vmManagedDisks"> The list of vm managed disk details. </param>
        /// <param name="multiVmGroupName"> The multi vm group name. </param>
        /// <param name="multiVmGroupId"> The multi vm group id. </param>
        /// <param name="recoveryBootDiagStorageAccountId"> The boot diagnostic storage account. </param>
        /// <param name="diskEncryptionInfo"> The recovery disk encryption information (for two pass flows). </param>
        /// <param name="recoveryAvailabilityZone"> The recovery availability zone. </param>
        /// <param name="recoveryExtendedLocation"> The recovery extended location. </param>
        /// <param name="recoveryAzureNetworkId"> The recovery Azure virtual network ARM id. </param>
        /// <param name="recoverySubnetName"> The recovery subnet name. </param>
        /// <param name="recoveryVirtualMachineScaleSetId"> The virtual machine scale set Id. </param>
        /// <param name="recoveryCapacityReservationGroupId"> The recovery capacity reservation group Id. </param>
        /// <param name="autoProtectionOfDataDisk"> A value indicating whether the auto protection is enabled. </param>
        /// <returns> A new <see cref="Models.A2AEnableProtectionContent"/> instance for mocking. </returns>
        public static A2AEnableProtectionContent A2AEnableProtectionContent(ResourceIdentifier fabricObjectId = null, ResourceIdentifier recoveryContainerId = null, ResourceIdentifier recoveryResourceGroupId = null, string recoveryCloudServiceId = null, ResourceIdentifier recoveryAvailabilitySetId = null, ResourceIdentifier recoveryProximityPlacementGroupId = null, IEnumerable<A2AVmDiskDetails> vmDisks = null, IEnumerable<A2AVmManagedDiskDetails> vmManagedDisks = null, string multiVmGroupName = null, string multiVmGroupId = null, ResourceIdentifier recoveryBootDiagStorageAccountId = null, SiteRecoveryDiskEncryptionInfo diskEncryptionInfo = null, string recoveryAvailabilityZone = null, SiteRecoveryExtendedLocation recoveryExtendedLocation = null, ResourceIdentifier recoveryAzureNetworkId = null, string recoverySubnetName = null, ResourceIdentifier recoveryVirtualMachineScaleSetId = null, ResourceIdentifier recoveryCapacityReservationGroupId = null, AutoProtectionOfDataDisk? autoProtectionOfDataDisk = null)
        {
            vmDisks ??= new List<A2AVmDiskDetails>();
            vmManagedDisks ??= new List<A2AVmManagedDiskDetails>();

            return new A2AEnableProtectionContent(
                "A2A",
                serializedAdditionalRawData: null,
                fabricObjectId,
                recoveryContainerId,
                recoveryResourceGroupId,
                recoveryCloudServiceId,
                recoveryAvailabilitySetId,
                recoveryProximityPlacementGroupId,
                vmDisks?.ToList(),
                vmManagedDisks?.ToList(),
                multiVmGroupName,
                multiVmGroupId,
                recoveryBootDiagStorageAccountId,
                diskEncryptionInfo,
                recoveryAvailabilityZone,
                recoveryExtendedLocation,
                recoveryAzureNetworkId,
                recoverySubnetName,
                recoveryVirtualMachineScaleSetId,
                recoveryCapacityReservationGroupId,
                autoProtectionOfDataDisk);
        }

        /// <summary> Initializes a new instance of <see cref="Models.A2AEventDetails"/>. </summary>
        /// <param name="protectedItemName"> The protected item arm name. </param>
        /// <param name="fabricObjectId"> The azure vm arm id. </param>
        /// <param name="fabricName"> Fabric arm name. </param>
        /// <param name="fabricLocation"> The fabric location. </param>
        /// <param name="remoteFabricName"> Remote fabric arm name. </param>
        /// <param name="remoteFabricLocation"> Remote fabric location. </param>
        /// <returns> A new <see cref="Models.A2AEventDetails"/> instance for mocking. </returns>
        public static A2AEventDetails A2AEventDetails(string protectedItemName = null, ResourceIdentifier fabricObjectId = null, string fabricName = null, AzureLocation? fabricLocation = null, string remoteFabricName = null, AzureLocation? remoteFabricLocation = null)
        {
            return new A2AEventDetails(
                "A2A",
                serializedAdditionalRawData: null,
                protectedItemName,
                fabricObjectId,
                fabricName,
                fabricLocation,
                remoteFabricName,
                remoteFabricLocation);
        }

        /// <summary> Initializes a new instance of <see cref="Models.A2AExtendedLocationDetails"/>. </summary>
        /// <param name="primaryExtendedLocation"> The primary ExtendedLocation. </param>
        /// <param name="recoveryExtendedLocation"> The recovery ExtendedLocation. </param>
        /// <returns> A new <see cref="Models.A2AExtendedLocationDetails"/> instance for mocking. </returns>
        public static A2AExtendedLocationDetails A2AExtendedLocationDetails(SiteRecoveryExtendedLocation primaryExtendedLocation = null, SiteRecoveryExtendedLocation recoveryExtendedLocation = null)
        {
            return new A2AExtendedLocationDetails(primaryExtendedLocation, recoveryExtendedLocation, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.A2AFabricSpecificLocationDetails"/>. </summary>
        /// <param name="initialPrimaryZone"> The initial source zone info. </param>
        /// <param name="initialRecoveryZone"> The initial target zone info. </param>
        /// <param name="initialPrimaryExtendedLocation"> The initial primary ExtendedLocation. </param>
        /// <param name="initialRecoveryExtendedLocation"> The initial recovery ExtendedLocation. </param>
        /// <param name="initialPrimaryFabricLocation"> Initial primary fabric location info. </param>
        /// <param name="initialRecoveryFabricLocation"> The initial recovery fabric location info. </param>
        /// <param name="primaryZone"> Source zone info. </param>
        /// <param name="recoveryZone"> The target zone info. </param>
        /// <param name="primaryExtendedLocation"> The primary ExtendedLocation. </param>
        /// <param name="recoveryExtendedLocation"> The recovery ExtendedLocation. </param>
        /// <param name="primaryFabricLocation"> Primary fabric location info. </param>
        /// <param name="recoveryFabricLocation"> The recovery fabric location info. </param>
        /// <returns> A new <see cref="Models.A2AFabricSpecificLocationDetails"/> instance for mocking. </returns>
        public static A2AFabricSpecificLocationDetails A2AFabricSpecificLocationDetails(string initialPrimaryZone = null, string initialRecoveryZone = null, SiteRecoveryExtendedLocation initialPrimaryExtendedLocation = null, SiteRecoveryExtendedLocation initialRecoveryExtendedLocation = null, AzureLocation? initialPrimaryFabricLocation = null, AzureLocation? initialRecoveryFabricLocation = null, string primaryZone = null, string recoveryZone = null, SiteRecoveryExtendedLocation primaryExtendedLocation = null, SiteRecoveryExtendedLocation recoveryExtendedLocation = null, AzureLocation? primaryFabricLocation = null, AzureLocation? recoveryFabricLocation = null)
        {
            return new A2AFabricSpecificLocationDetails(
                initialPrimaryZone,
                initialRecoveryZone,
                initialPrimaryExtendedLocation,
                initialRecoveryExtendedLocation,
                initialPrimaryFabricLocation,
                initialRecoveryFabricLocation,
                primaryZone,
                recoveryZone,
                primaryExtendedLocation,
                recoveryExtendedLocation,
                primaryFabricLocation,
                recoveryFabricLocation,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.A2APolicyCreationContent"/>. </summary>
        /// <param name="recoveryPointHistory"> The duration in minutes until which the recovery points need to be stored. </param>
        /// <param name="crashConsistentFrequencyInMinutes"> The crash consistent snapshot frequency (in minutes). </param>
        /// <param name="appConsistentFrequencyInMinutes"> The app consistent snapshot frequency (in minutes). </param>
        /// <param name="multiVmSyncStatus"> A value indicating whether multi-VM sync has to be enabled. Value should be 'Enabled' or 'Disabled'. </param>
        /// <returns> A new <see cref="Models.A2APolicyCreationContent"/> instance for mocking. </returns>
        public static A2APolicyCreationContent A2APolicyCreationContent(int? recoveryPointHistory = null, int? crashConsistentFrequencyInMinutes = null, int? appConsistentFrequencyInMinutes = null, SetMultiVmSyncStatus multiVmSyncStatus = default)
        {
            return new A2APolicyCreationContent(
                "A2A",
                serializedAdditionalRawData: null,
                recoveryPointHistory,
                crashConsistentFrequencyInMinutes,
                appConsistentFrequencyInMinutes,
                multiVmSyncStatus);
        }

        /// <summary> Initializes a new instance of <see cref="Models.A2APolicyDetails"/>. </summary>
        /// <param name="recoveryPointThresholdInMinutes"> The recovery point threshold in minutes. </param>
        /// <param name="recoveryPointHistory"> The duration in minutes until which the recovery points need to be stored. </param>
        /// <param name="appConsistentFrequencyInMinutes"> The app consistent snapshot frequency in minutes. </param>
        /// <param name="multiVmSyncStatus"> A value indicating whether multi-VM sync has to be enabled. </param>
        /// <param name="crashConsistentFrequencyInMinutes"> The crash consistent snapshot frequency in minutes. </param>
        /// <returns> A new <see cref="Models.A2APolicyDetails"/> instance for mocking. </returns>
        public static A2APolicyDetails A2APolicyDetails(int? recoveryPointThresholdInMinutes = null, int? recoveryPointHistory = null, int? appConsistentFrequencyInMinutes = null, string multiVmSyncStatus = null, int? crashConsistentFrequencyInMinutes = null)
        {
            return new A2APolicyDetails(
                "A2A",
                serializedAdditionalRawData: null,
                recoveryPointThresholdInMinutes,
                recoveryPointHistory,
                appConsistentFrequencyInMinutes,
                multiVmSyncStatus,
                crashConsistentFrequencyInMinutes);
        }

        /// <summary> Initializes a new instance of <see cref="Models.A2AProtectedDiskDetails"/>. </summary>
        /// <param name="diskUri"> The disk uri. </param>
        /// <param name="recoveryAzureStorageAccountId"> The recovery disk storage account. </param>
        /// <param name="primaryDiskAzureStorageAccountId"> The primary disk storage account. </param>
        /// <param name="recoveryDiskUri"> Recovery disk uri. </param>
        /// <param name="diskName"> The disk name. </param>
        /// <param name="diskCapacityInBytes"> The disk capacity in bytes. </param>
        /// <param name="primaryStagingAzureStorageAccountId"> The primary staging storage account. </param>
        /// <param name="diskType"> The type of disk. </param>
        /// <param name="isResyncRequired"> A value indicating whether resync is required for this disk. </param>
        /// <param name="monitoringPercentageCompletion"> The percentage of the monitoring job. The type of the monitoring job is defined by MonitoringJobType property. </param>
        /// <param name="monitoringJobType"> The type of the monitoring job. The progress is contained in MonitoringPercentageCompletion property. </param>
        /// <param name="dataPendingInStagingStorageAccountInMB"> The data pending for replication in MB at staging account. </param>
        /// <param name="dataPendingAtSourceAgentInMB"> The data pending at source virtual machine in MB. </param>
        /// <param name="diskState"> The disk state. </param>
        /// <param name="allowedDiskLevelOperation"> The disk level operations list. </param>
        /// <param name="isDiskEncrypted"> A value indicating whether vm has encrypted os disk or not. </param>
        /// <param name="secretIdentifier"> The secret URL / identifier (BEK). </param>
        /// <param name="dekKeyVaultArmId"> The KeyVault resource id for secret (BEK). </param>
        /// <param name="isDiskKeyEncrypted"> A value indicating whether disk key got encrypted or not. </param>
        /// <param name="keyIdentifier"> The key URL / identifier (KEK). </param>
        /// <param name="kekKeyVaultArmId"> The KeyVault resource id for key (KEK). </param>
        /// <param name="failoverDiskName"> The failover name for the managed disk. </param>
        /// <param name="tfoDiskName"> The test failover name for the managed disk. </param>
        /// <returns> A new <see cref="Models.A2AProtectedDiskDetails"/> instance for mocking. </returns>
        public static A2AProtectedDiskDetails A2AProtectedDiskDetails(Uri diskUri = null, ResourceIdentifier recoveryAzureStorageAccountId = null, ResourceIdentifier primaryDiskAzureStorageAccountId = null, Uri recoveryDiskUri = null, string diskName = null, long? diskCapacityInBytes = null, ResourceIdentifier primaryStagingAzureStorageAccountId = null, string diskType = null, bool? isResyncRequired = null, int? monitoringPercentageCompletion = null, string monitoringJobType = null, double? dataPendingInStagingStorageAccountInMB = null, double? dataPendingAtSourceAgentInMB = null, string diskState = null, IEnumerable<string> allowedDiskLevelOperation = null, bool? isDiskEncrypted = null, string secretIdentifier = null, ResourceIdentifier dekKeyVaultArmId = null, bool? isDiskKeyEncrypted = null, string keyIdentifier = null, ResourceIdentifier kekKeyVaultArmId = null, string failoverDiskName = null, string tfoDiskName = null)
        {
            allowedDiskLevelOperation ??= new List<string>();

            return new A2AProtectedDiskDetails(
                diskUri,
                recoveryAzureStorageAccountId,
                primaryDiskAzureStorageAccountId,
                recoveryDiskUri,
                diskName,
                diskCapacityInBytes,
                primaryStagingAzureStorageAccountId,
                diskType,
                isResyncRequired,
                monitoringPercentageCompletion,
                monitoringJobType,
                dataPendingInStagingStorageAccountInMB,
                dataPendingAtSourceAgentInMB,
                diskState,
                allowedDiskLevelOperation?.ToList(),
                isDiskEncrypted,
                secretIdentifier,
                dekKeyVaultArmId,
                isDiskKeyEncrypted,
                keyIdentifier,
                kekKeyVaultArmId,
                failoverDiskName,
                tfoDiskName,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.A2AProtectedManagedDiskDetails"/>. </summary>
        /// <param name="diskId"> The managed disk Arm id. </param>
        /// <param name="recoveryResourceGroupId"> The recovery disk resource group Arm Id. </param>
        /// <param name="recoveryTargetDiskId"> Recovery target disk Arm Id. </param>
        /// <param name="recoveryReplicaDiskId"> Recovery replica disk Arm Id. </param>
        /// <param name="recoveryOrignalTargetDiskId"> Recovery original target disk Arm Id. </param>
        /// <param name="recoveryReplicaDiskAccountType"> The replica disk type. Its an optional value and will be same as source disk type if not user provided. </param>
        /// <param name="recoveryTargetDiskAccountType"> The target disk type after failover. Its an optional value and will be same as source disk type if not user provided. </param>
        /// <param name="recoveryDiskEncryptionSetId"> The recovery disk encryption set Id. </param>
        /// <param name="primaryDiskEncryptionSetId"> The primary disk encryption set Id. </param>
        /// <param name="diskName"> The disk name. </param>
        /// <param name="diskCapacityInBytes"> The disk capacity in bytes. </param>
        /// <param name="primaryStagingAzureStorageAccountId"> The primary staging storage account. </param>
        /// <param name="diskType"> The type of disk. </param>
        /// <param name="isResyncRequired"> A value indicating whether resync is required for this disk. </param>
        /// <param name="monitoringPercentageCompletion"> The percentage of the monitoring job. The type of the monitoring job is defined by MonitoringJobType property. </param>
        /// <param name="monitoringJobType"> The type of the monitoring job. The progress is contained in MonitoringPercentageCompletion property. </param>
        /// <param name="dataPendingInStagingStorageAccountInMB"> The data pending for replication in MB at staging account. </param>
        /// <param name="dataPendingAtSourceAgentInMB"> The data pending at source virtual machine in MB. </param>
        /// <param name="diskState"> The disk state. </param>
        /// <param name="allowedDiskLevelOperation"> The disk level operations list. </param>
        /// <param name="isDiskEncrypted"> A value indicating whether vm has encrypted os disk or not. </param>
        /// <param name="secretIdentifier"> The secret URL / identifier (BEK). </param>
        /// <param name="dekKeyVaultArmId"> The KeyVault resource id for secret (BEK). </param>
        /// <param name="isDiskKeyEncrypted"> A value indicating whether disk key got encrypted or not. </param>
        /// <param name="keyIdentifier"> The key URL / identifier (KEK). </param>
        /// <param name="kekKeyVaultArmId"> The KeyVault resource id for key (KEK). </param>
        /// <param name="failoverDiskName"> The failover name for the managed disk. </param>
        /// <param name="tfoDiskName"> The test failover name for the managed disk. </param>
        /// <returns> A new <see cref="Models.A2AProtectedManagedDiskDetails"/> instance for mocking. </returns>
        public static A2AProtectedManagedDiskDetails A2AProtectedManagedDiskDetails(string diskId = null, ResourceIdentifier recoveryResourceGroupId = null, ResourceIdentifier recoveryTargetDiskId = null, ResourceIdentifier recoveryReplicaDiskId = null, ResourceIdentifier recoveryOrignalTargetDiskId = null, string recoveryReplicaDiskAccountType = null, string recoveryTargetDiskAccountType = null, ResourceIdentifier recoveryDiskEncryptionSetId = null, ResourceIdentifier primaryDiskEncryptionSetId = null, string diskName = null, long? diskCapacityInBytes = null, ResourceIdentifier primaryStagingAzureStorageAccountId = null, string diskType = null, bool? isResyncRequired = null, int? monitoringPercentageCompletion = null, string monitoringJobType = null, double? dataPendingInStagingStorageAccountInMB = null, double? dataPendingAtSourceAgentInMB = null, string diskState = null, IEnumerable<string> allowedDiskLevelOperation = null, bool? isDiskEncrypted = null, string secretIdentifier = null, ResourceIdentifier dekKeyVaultArmId = null, bool? isDiskKeyEncrypted = null, string keyIdentifier = null, ResourceIdentifier kekKeyVaultArmId = null, string failoverDiskName = null, string tfoDiskName = null)
        {
            allowedDiskLevelOperation ??= new List<string>();

            return new A2AProtectedManagedDiskDetails(
                diskId,
                recoveryResourceGroupId,
                recoveryTargetDiskId,
                recoveryReplicaDiskId,
                recoveryOrignalTargetDiskId,
                recoveryReplicaDiskAccountType,
                recoveryTargetDiskAccountType,
                recoveryDiskEncryptionSetId,
                primaryDiskEncryptionSetId,
                diskName,
                diskCapacityInBytes,
                primaryStagingAzureStorageAccountId,
                diskType,
                isResyncRequired,
                monitoringPercentageCompletion,
                monitoringJobType,
                dataPendingInStagingStorageAccountInMB,
                dataPendingAtSourceAgentInMB,
                diskState,
                allowedDiskLevelOperation?.ToList(),
                isDiskEncrypted,
                secretIdentifier,
                dekKeyVaultArmId,
                isDiskKeyEncrypted,
                keyIdentifier,
                kekKeyVaultArmId,
                failoverDiskName,
                tfoDiskName,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.A2AProtectionContainerMappingDetails"/>. </summary>
        /// <param name="agentAutoUpdateStatus"> A value indicating whether the auto update is enabled. </param>
        /// <param name="automationAccountArmId"> The automation account arm id. </param>
        /// <param name="automationAccountAuthenticationType"> A value indicating the type authentication to use for automation Account. </param>
        /// <param name="scheduleName"> The schedule arm name. </param>
        /// <param name="jobScheduleName"> The job schedule arm name. </param>
        /// <returns> A new <see cref="Models.A2AProtectionContainerMappingDetails"/> instance for mocking. </returns>
        public static A2AProtectionContainerMappingDetails A2AProtectionContainerMappingDetails(SiteRecoveryAgentAutoUpdateStatus? agentAutoUpdateStatus = null, ResourceIdentifier automationAccountArmId = null, AutomationAccountAuthenticationType? automationAccountAuthenticationType = null, string scheduleName = null, string jobScheduleName = null)
        {
            return new A2AProtectionContainerMappingDetails(
                "A2A",
                serializedAdditionalRawData: null,
                agentAutoUpdateStatus,
                automationAccountArmId,
                automationAccountAuthenticationType,
                scheduleName,
                jobScheduleName);
        }

        /// <summary> Initializes a new instance of <see cref="Models.A2ARecoveryPointDetails"/>. </summary>
        /// <param name="recoveryPointSyncType"> A value indicating whether the recovery point is multi VM consistent. </param>
        /// <param name="disks"> List of disk ids representing a recovery point. </param>
        /// <returns> A new <see cref="Models.A2ARecoveryPointDetails"/> instance for mocking. </returns>
        public static A2ARecoveryPointDetails A2ARecoveryPointDetails(RecoveryPointSyncType? recoveryPointSyncType = null, IEnumerable<string> disks = null)
        {
            disks ??= new List<string>();

            return new A2ARecoveryPointDetails("A2A", serializedAdditionalRawData: null, recoveryPointSyncType, disks?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.A2AReplicationDetails"/>. </summary>
        /// <param name="fabricObjectId"> The fabric specific object Id of the virtual machine. </param>
        /// <param name="initialPrimaryZone"> The initial primary availability zone. </param>
        /// <param name="initialPrimaryFabricLocation"> The initial primary fabric location. </param>
        /// <param name="initialRecoveryZone"> The initial recovery availability zone. </param>
        /// <param name="initialPrimaryExtendedLocation"> The initial primary extended location. </param>
        /// <param name="initialRecoveryExtendedLocation"> The initial recovery extended location. </param>
        /// <param name="initialRecoveryFabricLocation"> The initial recovery fabric location. </param>
        /// <param name="multiVmGroupId"> The multi vm group Id. </param>
        /// <param name="multiVmGroupName"> The multi vm group name. </param>
        /// <param name="multiVmGroupCreateOption"> Whether Multi VM group is auto created or specified by user. </param>
        /// <param name="managementId"> The management Id. </param>
        /// <param name="protectedDisks"> The list of protected disks. </param>
        /// <param name="unprotectedDisks"> The list of unprotected disks. </param>
        /// <param name="protectedManagedDisks"> The list of protected managed disks. </param>
        /// <param name="recoveryBootDiagStorageAccountId"> The recovery boot diagnostic storage account Arm Id. </param>
        /// <param name="primaryFabricLocation"> Primary fabric location. </param>
        /// <param name="recoveryFabricLocation"> The recovery fabric location. </param>
        /// <param name="osType"> The type of operating system. </param>
        /// <param name="recoveryAzureVmSize"> The size of recovery virtual machine. </param>
        /// <param name="recoveryAzureVmName"> The name of recovery virtual machine. </param>
        /// <param name="recoveryAzureResourceGroupId"> The recovery resource group. </param>
        /// <param name="recoveryCloudService"> The recovery cloud service. </param>
        /// <param name="recoveryAvailabilitySet"> The recovery availability set. </param>
        /// <param name="selectedRecoveryAzureNetworkId"> The recovery virtual network. </param>
        /// <param name="selectedTfoAzureNetworkId"> The test failover virtual network. </param>
        /// <param name="vmNics"> The virtual machine nic details. </param>
        /// <param name="vmSyncedConfigDetails"> The synced configuration details. </param>
        /// <param name="monitoringPercentageCompletion"> The percentage of the monitoring job. The type of the monitoring job is defined by MonitoringJobType property. </param>
        /// <param name="monitoringJobType"> The type of the monitoring job. The progress is contained in MonitoringPercentageCompletion property. </param>
        /// <param name="lastHeartbeat"> The last heartbeat received from the source server. </param>
        /// <param name="agentVersion"> The agent version. </param>
        /// <param name="agentExpireOn"> Agent expiry date. </param>
        /// <param name="isReplicationAgentUpdateRequired"> A value indicating whether replication agent update is required. </param>
        /// <param name="agentCertificateExpireOn"> Agent certificate expiry date. </param>
        /// <param name="isReplicationAgentCertificateUpdateRequired"> A value indicating whether agent certificate update is required. </param>
        /// <param name="recoveryFabricObjectId"> The recovery fabric object Id. </param>
        /// <param name="vmProtectionState"> The protection state for the vm. </param>
        /// <param name="vmProtectionStateDescription"> The protection state description for the vm. </param>
        /// <param name="lifecycleId"> An id associated with the PE that survives actions like switch protection which change the backing PE/CPE objects internally.The lifecycle id gets carried forward to have a link/continuity in being able to have an Id that denotes the "same" protected item even though other internal Ids/ARM Id might be changing. </param>
        /// <param name="testFailoverRecoveryFabricObjectId"> The test failover fabric object Id. </param>
        /// <param name="rpoInSeconds"> The last RPO value in seconds. </param>
        /// <param name="lastRpoCalculatedOn"> The time (in UTC) when the last RPO value was calculated by Protection Service. </param>
        /// <param name="primaryAvailabilityZone"> The primary availability zone. </param>
        /// <param name="recoveryAvailabilityZone"> The recovery availability zone. </param>
        /// <param name="primaryExtendedLocation"> The primary Extended Location. </param>
        /// <param name="recoveryExtendedLocation"> The recovery Extended Location. </param>
        /// <param name="vmEncryptionType"> The encryption type of the VM. </param>
        /// <param name="tfoAzureVmName"> The test failover vm name. </param>
        /// <param name="recoveryAzureGeneration"> The recovery azure generation. </param>
        /// <param name="recoveryProximityPlacementGroupId"> The recovery proximity placement group Id. </param>
        /// <param name="autoProtectionOfDataDisk"> A value indicating whether the auto protection is enabled. </param>
        /// <param name="recoveryVirtualMachineScaleSetId"> The recovery virtual machine scale set id. </param>
        /// <param name="recoveryCapacityReservationGroupId"> The recovery capacity reservation group Id. </param>
        /// <param name="churnOptionSelected"> A value indicating the churn option selected by user. </param>
        /// <returns> A new <see cref="Models.A2AReplicationDetails"/> instance for mocking. </returns>
        public static A2AReplicationDetails A2AReplicationDetails(ResourceIdentifier fabricObjectId = null, string initialPrimaryZone = null, AzureLocation? initialPrimaryFabricLocation = null, string initialRecoveryZone = null, SiteRecoveryExtendedLocation initialPrimaryExtendedLocation = null, SiteRecoveryExtendedLocation initialRecoveryExtendedLocation = null, AzureLocation? initialRecoveryFabricLocation = null, string multiVmGroupId = null, string multiVmGroupName = null, MultiVmGroupCreateOption? multiVmGroupCreateOption = null, string managementId = null, IEnumerable<A2AProtectedDiskDetails> protectedDisks = null, IEnumerable<A2AUnprotectedDiskDetails> unprotectedDisks = null, IEnumerable<A2AProtectedManagedDiskDetails> protectedManagedDisks = null, ResourceIdentifier recoveryBootDiagStorageAccountId = null, AzureLocation? primaryFabricLocation = null, AzureLocation? recoveryFabricLocation = null, string osType = null, string recoveryAzureVmSize = null, string recoveryAzureVmName = null, ResourceIdentifier recoveryAzureResourceGroupId = null, string recoveryCloudService = null, string recoveryAvailabilitySet = null, ResourceIdentifier selectedRecoveryAzureNetworkId = null, ResourceIdentifier selectedTfoAzureNetworkId = null, IEnumerable<VmNicDetails> vmNics = null, A2AVmSyncedConfigDetails vmSyncedConfigDetails = null, int? monitoringPercentageCompletion = null, string monitoringJobType = null, DateTimeOffset? lastHeartbeat = null, string agentVersion = null, DateTimeOffset? agentExpireOn = null, bool? isReplicationAgentUpdateRequired = null, DateTimeOffset? agentCertificateExpireOn = null, bool? isReplicationAgentCertificateUpdateRequired = null, ResourceIdentifier recoveryFabricObjectId = null, string vmProtectionState = null, string vmProtectionStateDescription = null, string lifecycleId = null, ResourceIdentifier testFailoverRecoveryFabricObjectId = null, long? rpoInSeconds = null, DateTimeOffset? lastRpoCalculatedOn = null, string primaryAvailabilityZone = null, string recoveryAvailabilityZone = null, SiteRecoveryExtendedLocation primaryExtendedLocation = null, SiteRecoveryExtendedLocation recoveryExtendedLocation = null, SiteRecoveryVmEncryptionType? vmEncryptionType = null, string tfoAzureVmName = null, string recoveryAzureGeneration = null, ResourceIdentifier recoveryProximityPlacementGroupId = null, AutoProtectionOfDataDisk? autoProtectionOfDataDisk = null, ResourceIdentifier recoveryVirtualMachineScaleSetId = null, ResourceIdentifier recoveryCapacityReservationGroupId = null, ChurnOptionSelected? churnOptionSelected = null)
        {
            protectedDisks ??= new List<A2AProtectedDiskDetails>();
            unprotectedDisks ??= new List<A2AUnprotectedDiskDetails>();
            protectedManagedDisks ??= new List<A2AProtectedManagedDiskDetails>();
            vmNics ??= new List<VmNicDetails>();

            return new A2AReplicationDetails(
                "A2A",
                serializedAdditionalRawData: null,
                fabricObjectId,
                initialPrimaryZone,
                initialPrimaryFabricLocation,
                initialRecoveryZone,
                initialPrimaryExtendedLocation,
                initialRecoveryExtendedLocation,
                initialRecoveryFabricLocation,
                multiVmGroupId,
                multiVmGroupName,
                multiVmGroupCreateOption,
                managementId,
                protectedDisks?.ToList(),
                unprotectedDisks?.ToList(),
                protectedManagedDisks?.ToList(),
                recoveryBootDiagStorageAccountId,
                primaryFabricLocation,
                recoveryFabricLocation,
                osType,
                recoveryAzureVmSize,
                recoveryAzureVmName,
                recoveryAzureResourceGroupId,
                recoveryCloudService,
                recoveryAvailabilitySet,
                selectedRecoveryAzureNetworkId,
                selectedTfoAzureNetworkId,
                vmNics?.ToList(),
                vmSyncedConfigDetails,
                monitoringPercentageCompletion,
                monitoringJobType,
                lastHeartbeat,
                agentVersion,
                agentExpireOn,
                isReplicationAgentUpdateRequired,
                agentCertificateExpireOn,
                isReplicationAgentCertificateUpdateRequired,
                recoveryFabricObjectId,
                vmProtectionState,
                vmProtectionStateDescription,
                lifecycleId,
                testFailoverRecoveryFabricObjectId,
                rpoInSeconds,
                lastRpoCalculatedOn,
                primaryAvailabilityZone,
                recoveryAvailabilityZone,
                primaryExtendedLocation,
                recoveryExtendedLocation,
                vmEncryptionType,
                tfoAzureVmName,
                recoveryAzureGeneration,
                recoveryProximityPlacementGroupId,
                autoProtectionOfDataDisk,
                recoveryVirtualMachineScaleSetId,
                recoveryCapacityReservationGroupId,
                churnOptionSelected);
        }

        /// <summary> Initializes a new instance of <see cref="Models.A2AUnprotectedDiskDetails"/>. </summary>
        /// <param name="diskLunId"> The source lun Id for the data disk. </param>
        /// <param name="diskAutoProtectionStatus"> A value indicating whether the disk auto protection is enabled. </param>
        /// <returns> A new <see cref="Models.A2AUnprotectedDiskDetails"/> instance for mocking. </returns>
        public static A2AUnprotectedDiskDetails A2AUnprotectedDiskDetails(int? diskLunId = null, AutoProtectionOfDataDisk? diskAutoProtectionStatus = null)
        {
            return new A2AUnprotectedDiskDetails(diskLunId, diskAutoProtectionStatus, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.VmNicDetails"/>. </summary>
        /// <param name="nicId"> The nic Id. </param>
        /// <param name="replicaNicId"> The replica nic Id. </param>
        /// <param name="sourceNicArmId"> The source nic ARM Id. </param>
        /// <param name="vmNetworkName"> VM network name. </param>
        /// <param name="recoveryVmNetworkId"> Recovery VM network Id. </param>
        /// <param name="ipConfigs"> The IP configurations of the NIC. </param>
        /// <param name="selectionType"> Selection type for failover. </param>
        /// <param name="recoveryNetworkSecurityGroupId"> The id of the NSG associated with the NIC. </param>
        /// <param name="isAcceleratedNetworkingOnRecoveryEnabled"> A value indicating whether the NIC has accelerated networking enabled. </param>
        /// <param name="tfoVmNetworkId"> The network to be used by NIC during test failover. </param>
        /// <param name="tfoNetworkSecurityGroupId"> The NSG to be used by NIC during test failover. </param>
        /// <param name="isAcceleratedNetworkingOnTfoEnabled"> Whether the TFO NIC has accelerated networking enabled. </param>
        /// <param name="recoveryNicName"> The name of the NIC to be used when creating target NICs. </param>
        /// <param name="recoveryNicResourceGroupName"> The resource group of the NIC to be used when creating target NICs. </param>
        /// <param name="isReuseExistingNicAllowed"> A value indicating whether an existing NIC is allowed to be reused during failover subject to availability. </param>
        /// <param name="tfoRecoveryNicName"> The name of the NIC to be used when creating target NICs in TFO. </param>
        /// <param name="tfoRecoveryNicResourceGroupName"> The resource group of the NIC to be used when creating target NICs in TFO. </param>
        /// <param name="isTfoReuseExistingNicAllowed"> A value indicating whether an existing NIC is allowed to be reused during test failover subject to availability. </param>
        /// <param name="targetNicName"> Target NIC name. </param>
        /// <returns> A new <see cref="Models.VmNicDetails"/> instance for mocking. </returns>
        public static VmNicDetails VmNicDetails(string nicId = null, string replicaNicId = null, ResourceIdentifier sourceNicArmId = null, string vmNetworkName = null, ResourceIdentifier recoveryVmNetworkId = null, IEnumerable<HyperVIPConfigDetails> ipConfigs = null, string selectionType = null, string recoveryNetworkSecurityGroupId = null, bool? isAcceleratedNetworkingOnRecoveryEnabled = null, ResourceIdentifier tfoVmNetworkId = null, string tfoNetworkSecurityGroupId = null, bool? isAcceleratedNetworkingOnTfoEnabled = null, string recoveryNicName = null, string recoveryNicResourceGroupName = null, bool? isReuseExistingNicAllowed = null, string tfoRecoveryNicName = null, string tfoRecoveryNicResourceGroupName = null, bool? isTfoReuseExistingNicAllowed = null, string targetNicName = null)
        {
            ipConfigs ??= new List<HyperVIPConfigDetails>();

            return new VmNicDetails(
                nicId,
                replicaNicId,
                sourceNicArmId,
                vmNetworkName,
                recoveryVmNetworkId,
                ipConfigs?.ToList(),
                selectionType,
                recoveryNetworkSecurityGroupId,
                isAcceleratedNetworkingOnRecoveryEnabled,
                tfoVmNetworkId,
                tfoNetworkSecurityGroupId,
                isAcceleratedNetworkingOnTfoEnabled,
                recoveryNicName,
                recoveryNicResourceGroupName,
                isReuseExistingNicAllowed,
                tfoRecoveryNicName,
                tfoRecoveryNicResourceGroupName,
                isTfoReuseExistingNicAllowed,
                targetNicName,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HyperVIPConfigDetails"/>. </summary>
        /// <param name="name"></param>
        /// <param name="isPrimary"></param>
        /// <param name="subnetName"></param>
        /// <param name="staticIPAddress"></param>
        /// <param name="ipAddressType"></param>
        /// <param name="isSeletedForFailover"></param>
        /// <param name="recoverySubnetName"></param>
        /// <param name="recoveryStaticIPAddress"></param>
        /// <param name="recoveryIPAddressType"></param>
        /// <param name="recoveryPublicIPAddressId"></param>
        /// <param name="recoveryLBBackendAddressPoolIds"></param>
        /// <param name="tfoSubnetName"></param>
        /// <param name="tfoStaticIPAddress"></param>
        /// <param name="tfoPublicIPAddressId"></param>
        /// <param name="tfoLBBackendAddressPoolIds"></param>
        /// <returns> A new <see cref="Models.HyperVIPConfigDetails"/> instance for mocking. </returns>
        public static HyperVIPConfigDetails HyperVIPConfigDetails(string name = null, bool? isPrimary = null, string subnetName = null, IPAddress staticIPAddress = null, string ipAddressType = null, bool? isSeletedForFailover = null, string recoverySubnetName = null, IPAddress recoveryStaticIPAddress = null, string recoveryIPAddressType = null, ResourceIdentifier recoveryPublicIPAddressId = null, IEnumerable<string> recoveryLBBackendAddressPoolIds = null, string tfoSubnetName = null, IPAddress tfoStaticIPAddress = null, ResourceIdentifier tfoPublicIPAddressId = null, IEnumerable<string> tfoLBBackendAddressPoolIds = null)
        {
            recoveryLBBackendAddressPoolIds ??= new List<string>();
            tfoLBBackendAddressPoolIds ??= new List<string>();

            return new HyperVIPConfigDetails(
                name,
                isPrimary,
                subnetName,
                staticIPAddress,
                ipAddressType,
                isSeletedForFailover,
                recoverySubnetName,
                recoveryStaticIPAddress,
                recoveryIPAddressType,
                recoveryPublicIPAddressId,
                recoveryLBBackendAddressPoolIds?.ToList(),
                tfoSubnetName,
                tfoStaticIPAddress,
                tfoPublicIPAddressId,
                tfoLBBackendAddressPoolIds?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.A2AVmSyncedConfigDetails"/>. </summary>
        /// <param name="tags"> The Azure VM tags. </param>
        /// <param name="vmEndpoints"> The Azure VM input endpoints. </param>
        /// <returns> A new <see cref="Models.A2AVmSyncedConfigDetails"/> instance for mocking. </returns>
        public static A2AVmSyncedConfigDetails A2AVmSyncedConfigDetails(IReadOnlyDictionary<string, string> tags = null, IEnumerable<SiteRecoveryVmEndpoint> vmEndpoints = null)
        {
            tags ??= new Dictionary<string, string>();
            vmEndpoints ??= new List<SiteRecoveryVmEndpoint>();

            return new A2AVmSyncedConfigDetails(tags, vmEndpoints?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SiteRecoveryVmEndpoint"/>. </summary>
        /// <param name="endpointName"></param>
        /// <param name="privatePort"></param>
        /// <param name="publicPort"></param>
        /// <param name="protocol"></param>
        /// <returns> A new <see cref="Models.SiteRecoveryVmEndpoint"/> instance for mocking. </returns>
        public static SiteRecoveryVmEndpoint SiteRecoveryVmEndpoint(string endpointName = null, int? privatePort = null, int? publicPort = null, string protocol = null)
        {
            return new SiteRecoveryVmEndpoint(endpointName, privatePort, publicPort, protocol, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.A2AReplicationIntentDetails"/>. </summary>
        /// <param name="fabricObjectId"> The fabric specific object Id of the virtual machine. </param>
        /// <param name="primaryLocation"> The primary location for the virtual machine. </param>
        /// <param name="recoveryLocation"> The recovery location for the virtual machine. </param>
        /// <param name="recoverySubscriptionId"> The recovery subscription Id of the virtual machine. </param>
        /// <param name="vmDisks"> The list of vm disk details. </param>
        /// <param name="vmManagedDisks"> The list of vm managed disk details. </param>
        /// <param name="recoveryResourceGroupId"> The recovery resource group id. </param>
        /// <param name="protectionProfile">
        /// The protection profile custom details.
        /// Please note <see cref="ProtectionProfileCustomDetails"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="ExistingProtectionProfile"/> and <see cref="NewProtectionProfile"/>.
        /// </param>
        /// <param name="primaryStagingStorageAccount">
        /// The primary staging storage account details.
        /// Please note <see cref="StorageAccountCustomDetails"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="ExistingStorageAccount"/>.
        /// </param>
        /// <param name="recoveryAvailabilitySet">
        /// The recovery availability set details.
        /// Please note <see cref="RecoveryAvailabilitySetCustomDetails"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="ExistingRecoveryAvailabilitySet"/>.
        /// </param>
        /// <param name="recoveryVirtualNetwork">
        /// The recovery virtual network details.
        /// Please note <see cref="RecoveryVirtualNetworkCustomDetails"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="ExistingRecoveryVirtualNetwork"/> and <see cref="NewRecoveryVirtualNetwork"/>.
        /// </param>
        /// <param name="recoveryProximityPlacementGroup">
        /// The recovery proximity placement group custom details.
        /// Please note <see cref="RecoveryProximityPlacementGroupCustomDetails"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="ExistingRecoveryProximityPlacementGroup"/>.
        /// </param>
        /// <param name="autoProtectionOfDataDisk"> A value indicating whether the auto protection is enabled. </param>
        /// <param name="multiVmGroupName"> The multi vm group name. </param>
        /// <param name="multiVmGroupId"> The multi vm group id. </param>
        /// <param name="recoveryBootDiagStorageAccount">
        /// The boot diagnostic storage account.
        /// Please note <see cref="StorageAccountCustomDetails"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="ExistingStorageAccount"/>.
        /// </param>
        /// <param name="diskEncryptionInfo"> The recovery disk encryption information (for two pass flows). </param>
        /// <param name="recoveryAvailabilityZone"> The recovery availability zone. </param>
        /// <param name="recoveryAvailabilityType"> The recovery availability type of the virtual machine. </param>
        /// <param name="agentAutoUpdateStatus"> A value indicating whether the auto update is enabled. </param>
        /// <param name="automationAccountArmId"> The automation account arm id. </param>
        /// <param name="automationAccountAuthenticationType"> A value indicating the type authentication to use for automation Account. </param>
        /// <returns> A new <see cref="Models.A2AReplicationIntentDetails"/> instance for mocking. </returns>
        public static A2AReplicationIntentDetails A2AReplicationIntentDetails(ResourceIdentifier fabricObjectId = null, AzureLocation? primaryLocation = null, AzureLocation? recoveryLocation = null, string recoverySubscriptionId = null, IEnumerable<A2AProtectionIntentDiskDetails> vmDisks = null, IEnumerable<A2AProtectionIntentManagedDiskDetails> vmManagedDisks = null, ResourceIdentifier recoveryResourceGroupId = null, ProtectionProfileCustomDetails protectionProfile = null, StorageAccountCustomDetails primaryStagingStorageAccount = null, RecoveryAvailabilitySetCustomDetails recoveryAvailabilitySet = null, RecoveryVirtualNetworkCustomDetails recoveryVirtualNetwork = null, RecoveryProximityPlacementGroupCustomDetails recoveryProximityPlacementGroup = null, AutoProtectionOfDataDisk? autoProtectionOfDataDisk = null, string multiVmGroupName = null, string multiVmGroupId = null, StorageAccountCustomDetails recoveryBootDiagStorageAccount = null, SiteRecoveryDiskEncryptionInfo diskEncryptionInfo = null, string recoveryAvailabilityZone = null, string recoveryAvailabilityType = null, SiteRecoveryAgentAutoUpdateStatus? agentAutoUpdateStatus = null, ResourceIdentifier automationAccountArmId = null, AutomationAccountAuthenticationType? automationAccountAuthenticationType = null)
        {
            vmDisks ??= new List<A2AProtectionIntentDiskDetails>();
            vmManagedDisks ??= new List<A2AProtectionIntentManagedDiskDetails>();

            return new A2AReplicationIntentDetails(
                "A2A",
                serializedAdditionalRawData: null,
                fabricObjectId,
                primaryLocation,
                recoveryLocation,
                recoverySubscriptionId,
                vmDisks?.ToList(),
                vmManagedDisks?.ToList(),
                recoveryResourceGroupId,
                protectionProfile,
                primaryStagingStorageAccount,
                recoveryAvailabilitySet,
                recoveryVirtualNetwork,
                recoveryProximityPlacementGroup,
                autoProtectionOfDataDisk,
                multiVmGroupName,
                multiVmGroupId,
                recoveryBootDiagStorageAccount,
                diskEncryptionInfo,
                recoveryAvailabilityZone,
                recoveryAvailabilityType,
                agentAutoUpdateStatus,
                automationAccountArmId,
                automationAccountAuthenticationType);
        }

        /// <summary> Initializes a new instance of <see cref="Models.A2AZoneDetails"/>. </summary>
        /// <param name="source"> Source zone info. </param>
        /// <param name="target"> The target zone info. </param>
        /// <returns> A new <see cref="Models.A2AZoneDetails"/> instance for mocking. </returns>
        public static A2AZoneDetails A2AZoneDetails(string source = null, string target = null)
        {
            return new A2AZoneDetails(source, target, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SiteRecoveryAgentDetails"/>. </summary>
        /// <param name="agentId"> The Id of the agent running on the server. </param>
        /// <param name="machineId"> The Id of the machine to which the agent is registered. </param>
        /// <param name="biosId"> The machine BIOS Id. </param>
        /// <param name="fqdn"> The machine FQDN. </param>
        /// <param name="disks"> The disks. </param>
        /// <returns> A new <see cref="Models.SiteRecoveryAgentDetails"/> instance for mocking. </returns>
        public static SiteRecoveryAgentDetails SiteRecoveryAgentDetails(string agentId = null, string machineId = null, string biosId = null, string fqdn = null, IEnumerable<SiteRecoveryAgentDiskDetails> disks = null)
        {
            disks ??= new List<SiteRecoveryAgentDiskDetails>();

            return new SiteRecoveryAgentDetails(
                agentId,
                machineId,
                biosId,
                fqdn,
                disks?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SiteRecoveryAgentDiskDetails"/>. </summary>
        /// <param name="diskId"> The disk Id. </param>
        /// <param name="diskName"> The disk name. </param>
        /// <param name="isOSDisk"> A value indicating whether the disk is the OS disk. </param>
        /// <param name="capacityInBytes"> The disk capacity in bytes. </param>
        /// <param name="lunId"> The lun of disk. </param>
        /// <returns> A new <see cref="Models.SiteRecoveryAgentDiskDetails"/> instance for mocking. </returns>
        public static SiteRecoveryAgentDiskDetails SiteRecoveryAgentDiskDetails(string diskId = null, string diskName = null, string isOSDisk = null, long? capacityInBytes = null, int? lunId = null)
        {
            return new SiteRecoveryAgentDiskDetails(
                diskId,
                diskName,
                isOSDisk,
                capacityInBytes,
                lunId,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ApplianceMonitoringDetails"/>. </summary>
        /// <param name="cpuDetails"> The appliance CPU details. </param>
        /// <param name="ramDetails"> The appliance RAM details. </param>
        /// <param name="datastoreSnapshot"> The appliance datastore snapshot details. </param>
        /// <param name="disksReplicationDetails"> The disk replication details. </param>
        /// <param name="esxiNfcBuffer"> The ESXi NFC buffer details. </param>
        /// <param name="networkBandwidth"> The appliance network bandwidth details. </param>
        /// <returns> A new <see cref="Models.ApplianceMonitoringDetails"/> instance for mocking. </returns>
        public static ApplianceMonitoringDetails ApplianceMonitoringDetails(ApplianceResourceDetails cpuDetails = null, ApplianceResourceDetails ramDetails = null, IEnumerable<DataStoreUtilizationDetails> datastoreSnapshot = null, ApplianceResourceDetails disksReplicationDetails = null, ApplianceResourceDetails esxiNfcBuffer = null, ApplianceResourceDetails networkBandwidth = null)
        {
            datastoreSnapshot ??= new List<DataStoreUtilizationDetails>();

            return new ApplianceMonitoringDetails(
                cpuDetails,
                ramDetails,
                datastoreSnapshot?.ToList(),
                disksReplicationDetails,
                esxiNfcBuffer,
                networkBandwidth,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ApplianceResourceDetails"/>. </summary>
        /// <param name="capacity"> A value indicating the total capacity of appliance resource. </param>
        /// <param name="processUtilization"> A value indicating the utilization percentage by gateway agent on appliance. </param>
        /// <param name="totalUtilization"> A value indicating the total utilization percentage for all processes on the appliance. </param>
        /// <param name="status"> A value indicating the status of appliance resource. </param>
        /// <returns> A new <see cref="Models.ApplianceResourceDetails"/> instance for mocking. </returns>
        public static ApplianceResourceDetails ApplianceResourceDetails(long? capacity = null, double? processUtilization = null, double? totalUtilization = null, string status = null)
        {
            return new ApplianceResourceDetails(capacity, processUtilization, totalUtilization, status, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataStoreUtilizationDetails"/>. </summary>
        /// <param name="totalSnapshotsSupported"> The total count of snapshots supported by the datastore. </param>
        /// <param name="totalSnapshotsCreated"> The total snapshots created for server migration in the datastore. </param>
        /// <param name="dataStoreName"> The datastore name. </param>
        /// <returns> A new <see cref="Models.DataStoreUtilizationDetails"/> instance for mocking. </returns>
        public static DataStoreUtilizationDetails DataStoreUtilizationDetails(long? totalSnapshotsSupported = null, long? totalSnapshotsCreated = null, string dataStoreName = null)
        {
            return new DataStoreUtilizationDetails(totalSnapshotsSupported, totalSnapshotsCreated, dataStoreName, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AsrJobDetails"/>. </summary>
        /// <param name="affectedObjectDetails"> The affected object properties like source server, source cloud, target server, target cloud etc. based on the workflow object details. </param>
        /// <returns> A new <see cref="Models.AsrJobDetails"/> instance for mocking. </returns>
        public static AsrJobDetails AsrJobDetails(IReadOnlyDictionary<string, string> affectedObjectDetails = null)
        {
            affectedObjectDetails ??= new Dictionary<string, string>();

            return new AsrJobDetails("AsrJobDetails", affectedObjectDetails, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AutomationRunbookTaskDetails"/>. </summary>
        /// <param name="name"> The recovery plan task name. </param>
        /// <param name="cloudServiceName"> The cloud service of the automation runbook account. </param>
        /// <param name="subscriptionId"> The subscription Id of the automation runbook account. </param>
        /// <param name="accountName"> The automation account name of the runbook. </param>
        /// <param name="runbookId"> The runbook Id. </param>
        /// <param name="runbookName"> The runbook name. </param>
        /// <param name="jobId"> The job Id of the runbook execution. </param>
        /// <param name="jobOutput"> The execution output of the runbook. </param>
        /// <param name="isPrimarySideScript"> A value indicating whether it is a primary side script or not. </param>
        /// <returns> A new <see cref="Models.AutomationRunbookTaskDetails"/> instance for mocking. </returns>
        public static AutomationRunbookTaskDetails AutomationRunbookTaskDetails(string name = null, string cloudServiceName = null, string subscriptionId = null, string accountName = null, string runbookId = null, string runbookName = null, ResourceIdentifier jobId = null, string jobOutput = null, bool? isPrimarySideScript = null)
        {
            return new AutomationRunbookTaskDetails(
                "AutomationRunbookTaskDetails",
                serializedAdditionalRawData: null,
                name,
                cloudServiceName,
                subscriptionId,
                accountName,
                runbookId,
                runbookName,
                jobId,
                jobOutput,
                isPrimarySideScript);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SiteRecoveryFabricProviderSpecificDetails"/>. </summary>
        /// <param name="location"> The Location for the Azure fabric. </param>
        /// <param name="containerIds"> The container Ids for the Azure fabric. </param>
        /// <param name="zones"> The zones. </param>
        /// <param name="extendedLocations"> The ExtendedLocations. </param>
        /// <param name="locationDetails"> The location details. </param>
        /// <returns> A new <see cref="Models.SiteRecoveryFabricProviderSpecificDetails"/> instance for mocking. </returns>
        public static SiteRecoveryFabricProviderSpecificDetails SiteRecoveryFabricProviderSpecificDetails(AzureLocation? location = null, IEnumerable<ResourceIdentifier> containerIds = null, IEnumerable<A2AZoneDetails> zones = null, IEnumerable<A2AExtendedLocationDetails> extendedLocations = null, IEnumerable<A2AFabricSpecificLocationDetails> locationDetails = null)
        {
            containerIds ??= new List<ResourceIdentifier>();
            zones ??= new List<A2AZoneDetails>();
            extendedLocations ??= new List<A2AExtendedLocationDetails>();
            locationDetails ??= new List<A2AFabricSpecificLocationDetails>();

            return new SiteRecoveryFabricProviderSpecificDetails(
                "Azure",
                serializedAdditionalRawData: null,
                location,
                containerIds?.ToList(),
                zones?.ToList(),
                extendedLocations?.ToList(),
                locationDetails?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.A2ACreateNetworkMappingContent"/>. </summary>
        /// <param name="primaryNetworkId"> The primary azure vnet Id. </param>
        /// <returns> A new <see cref="Models.A2ACreateNetworkMappingContent"/> instance for mocking. </returns>
        public static A2ACreateNetworkMappingContent A2ACreateNetworkMappingContent(ResourceIdentifier primaryNetworkId = null)
        {
            return new A2ACreateNetworkMappingContent("AzureToAzure", serializedAdditionalRawData: null, primaryNetworkId);
        }

        /// <summary> Initializes a new instance of <see cref="Models.A2ANetworkMappingSettings"/>. </summary>
        /// <param name="primaryFabricLocation"> The primary fabric location. </param>
        /// <param name="recoveryFabricLocation"> The recovery fabric location. </param>
        /// <returns> A new <see cref="Models.A2ANetworkMappingSettings"/> instance for mocking. </returns>
        public static A2ANetworkMappingSettings A2ANetworkMappingSettings(AzureLocation? primaryFabricLocation = null, AzureLocation? recoveryFabricLocation = null)
        {
            return new A2ANetworkMappingSettings("AzureToAzure", serializedAdditionalRawData: null, primaryFabricLocation, recoveryFabricLocation);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SiteRecoveryVmDiskDetails"/>. </summary>
        /// <param name="vhdType"> VHD type. </param>
        /// <param name="vhdId"> The VHD id. </param>
        /// <param name="diskId"> The disk resource id. </param>
        /// <param name="vhdName"> VHD name. </param>
        /// <param name="maxSizeMB"> Max side in MB. </param>
        /// <param name="targetDiskLocation"> Blob uri of the Azure disk. </param>
        /// <param name="targetDiskName"> The target Azure disk name. </param>
        /// <param name="lunId"> Ordinal\LunId of the disk for the Azure VM. </param>
        /// <param name="diskEncryptionSetId"> The DiskEncryptionSet ARM ID. </param>
        /// <param name="customTargetDiskName"> The custom target Azure disk name. </param>
        /// <returns> A new <see cref="Models.SiteRecoveryVmDiskDetails"/> instance for mocking. </returns>
        public static SiteRecoveryVmDiskDetails SiteRecoveryVmDiskDetails(string vhdType = null, string vhdId = null, string diskId = null, string vhdName = null, string maxSizeMB = null, string targetDiskLocation = null, string targetDiskName = null, string lunId = null, ResourceIdentifier diskEncryptionSetId = null, string customTargetDiskName = null)
        {
            return new SiteRecoveryVmDiskDetails(
                vhdType,
                vhdId,
                diskId,
                vhdName,
                maxSizeMB,
                targetDiskLocation,
                targetDiskName,
                lunId,
                diskEncryptionSetId,
                customTargetDiskName,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConsistencyCheckTaskDetails"/>. </summary>
        /// <param name="vmDetails"> The list of inconsistent Vm details. </param>
        /// <returns> A new <see cref="Models.ConsistencyCheckTaskDetails"/> instance for mocking. </returns>
        public static ConsistencyCheckTaskDetails ConsistencyCheckTaskDetails(IEnumerable<InconsistentVmDetails> vmDetails = null)
        {
            vmDetails ??= new List<InconsistentVmDetails>();

            return new ConsistencyCheckTaskDetails("ConsistencyCheckTaskDetails", serializedAdditionalRawData: null, vmDetails?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.InconsistentVmDetails"/>. </summary>
        /// <param name="vmName"> The Vm name. </param>
        /// <param name="cloudName"> The Cloud name. </param>
        /// <param name="details"> The list of details regarding state of the Protected Entity in SRS and On prem. </param>
        /// <param name="errorIds"> The list of error ids. </param>
        /// <returns> A new <see cref="Models.InconsistentVmDetails"/> instance for mocking. </returns>
        public static InconsistentVmDetails InconsistentVmDetails(string vmName = null, string cloudName = null, IEnumerable<string> details = null, IEnumerable<string> errorIds = null)
        {
            details ??= new List<string>();
            errorIds ??= new List<string>();

            return new InconsistentVmDetails(vmName, cloudName, details?.ToList(), errorIds?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SiteRecoveryDataStore"/>. </summary>
        /// <param name="symbolicName"> The symbolic name of data store. </param>
        /// <param name="uuid"> The uuid of data store. </param>
        /// <param name="capacity"> The capacity of data store in GBs. </param>
        /// <param name="freeSpace"> The free space of data store in GBs. </param>
        /// <param name="dataStoreType"> The type of data store. </param>
        /// <returns> A new <see cref="Models.SiteRecoveryDataStore"/> instance for mocking. </returns>
        public static SiteRecoveryDataStore SiteRecoveryDataStore(string symbolicName = null, Guid? uuid = null, string capacity = null, string freeSpace = null, string dataStoreType = null)
        {
            return new SiteRecoveryDataStore(
                symbolicName,
                uuid,
                capacity,
                freeSpace,
                dataStoreType,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SiteRecoveryDiskDetails"/>. </summary>
        /// <param name="maxSizeMB"> The hard disk max size in MB. </param>
        /// <param name="vhdType"> The type of the volume. </param>
        /// <param name="vhdId"> The VHD Id. </param>
        /// <param name="vhdName"> The VHD name. </param>
        /// <returns> A new <see cref="Models.SiteRecoveryDiskDetails"/> instance for mocking. </returns>
        public static SiteRecoveryDiskDetails SiteRecoveryDiskDetails(long? maxSizeMB = null, string vhdType = null, string vhdId = null, string vhdName = null)
        {
            return new SiteRecoveryDiskDetails(maxSizeMB, vhdType, vhdId, vhdName, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SiteRecoveryDiskVolumeDetails"/>. </summary>
        /// <param name="label"> The volume label. </param>
        /// <param name="name"> The volume name. </param>
        /// <returns> A new <see cref="Models.SiteRecoveryDiskVolumeDetails"/> instance for mocking. </returns>
        public static SiteRecoveryDiskVolumeDetails SiteRecoveryDiskVolumeDetails(string label = null, string name = null)
        {
            return new SiteRecoveryDiskVolumeDetails(label, name, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SiteRecoveryDraDetails"/>. </summary>
        /// <param name="id"> The DRA Id. </param>
        /// <param name="name"> The DRA name. </param>
        /// <param name="biosId"> The DRA Bios Id. </param>
        /// <param name="version"> The version. </param>
        /// <param name="lastHeartbeatReceivedOn"> The last heartbeat received from the DRA. </param>
        /// <param name="health"> The health. </param>
        /// <param name="healthErrors"> The health errors. </param>
        /// <param name="forwardProtectedItemCount"> The count of protected items which are protected in forward direction. </param>
        /// <param name="reverseProtectedItemCount"> The count of protected items which are protected in reverse direction. </param>
        /// <returns> A new <see cref="Models.SiteRecoveryDraDetails"/> instance for mocking. </returns>
        public static SiteRecoveryDraDetails SiteRecoveryDraDetails(string id = null, string name = null, string biosId = null, string version = null, DateTimeOffset? lastHeartbeatReceivedOn = null, SiteRecoveryProtectionHealth? health = null, IEnumerable<SiteRecoveryHealthError> healthErrors = null, int? forwardProtectedItemCount = null, int? reverseProtectedItemCount = null)
        {
            healthErrors ??= new List<SiteRecoveryHealthError>();

            return new SiteRecoveryDraDetails(
                id,
                name,
                biosId,
                version,
                lastHeartbeatReceivedOn,
                health,
                healthErrors?.ToList(),
                forwardProtectedItemCount,
                reverseProtectedItemCount,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ExportJobDetails"/>. </summary>
        /// <param name="affectedObjectDetails"> The affected object properties like source server, source cloud, target server, target cloud etc. based on the workflow object details. </param>
        /// <param name="blobUri"> BlobUri of the exported jobs. </param>
        /// <param name="sasToken"> The sas token to access blob. </param>
        /// <returns> A new <see cref="Models.ExportJobDetails"/> instance for mocking. </returns>
        public static ExportJobDetails ExportJobDetails(IReadOnlyDictionary<string, string> affectedObjectDetails = null, Uri blobUri = null, string sasToken = null)
        {
            affectedObjectDetails ??= new Dictionary<string, string>();

            return new ExportJobDetails("ExportJobDetails", affectedObjectDetails, serializedAdditionalRawData: null, blobUri, sasToken);
        }

        /// <summary> Initializes a new instance of <see cref="Models.FabricReplicationGroupTaskDetails"/>. </summary>
        /// <param name="jobTask"> The job entity. </param>
        /// <param name="skippedReason"> The skipped reason. </param>
        /// <param name="skippedReasonString"> The skipped reason string. </param>
        /// <returns> A new <see cref="Models.FabricReplicationGroupTaskDetails"/> instance for mocking. </returns>
        public static FabricReplicationGroupTaskDetails FabricReplicationGroupTaskDetails(SiteRecoveryJobEntity jobTask = null, string skippedReason = null, string skippedReasonString = null)
        {
            return new FabricReplicationGroupTaskDetails("FabricReplicationGroupTaskDetails", serializedAdditionalRawData: null, jobTask, skippedReason, skippedReasonString);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SiteRecoveryJobTaskDetails"/>. </summary>
        /// <param name="jobTask"> The job entity. </param>
        /// <returns> A new <see cref="Models.SiteRecoveryJobTaskDetails"/> instance for mocking. </returns>
        public static SiteRecoveryJobTaskDetails SiteRecoveryJobTaskDetails(SiteRecoveryJobEntity jobTask = null)
        {
            return new SiteRecoveryJobTaskDetails("JobTaskDetails", serializedAdditionalRawData: null, jobTask);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SiteRecoveryJobEntity"/>. </summary>
        /// <param name="jobId"> The job id. </param>
        /// <param name="jobFriendlyName"> The job display name. </param>
        /// <param name="targetObjectId"> The object id. </param>
        /// <param name="targetObjectName"> The object name. </param>
        /// <param name="targetInstanceType"> The workflow affected object type. </param>
        /// <param name="jobScenarioName"> The job name. Enum type ScenarioName. </param>
        /// <returns> A new <see cref="Models.SiteRecoveryJobEntity"/> instance for mocking. </returns>
        public static SiteRecoveryJobEntity SiteRecoveryJobEntity(ResourceIdentifier jobId = null, string jobFriendlyName = null, string targetObjectId = null, string targetObjectName = null, string targetInstanceType = null, string jobScenarioName = null)
        {
            return new SiteRecoveryJobEntity(
                jobId,
                jobFriendlyName,
                targetObjectId,
                targetObjectName,
                targetInstanceType,
                jobScenarioName,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.FailoverJobDetails"/>. </summary>
        /// <param name="affectedObjectDetails"> The affected object properties like source server, source cloud, target server, target cloud etc. based on the workflow object details. </param>
        /// <param name="protectedItemDetails"> The test VM details. </param>
        /// <returns> A new <see cref="Models.FailoverJobDetails"/> instance for mocking. </returns>
        public static FailoverJobDetails FailoverJobDetails(IReadOnlyDictionary<string, string> affectedObjectDetails = null, IEnumerable<FailoverReplicationProtectedItemDetails> protectedItemDetails = null)
        {
            affectedObjectDetails ??= new Dictionary<string, string>();
            protectedItemDetails ??= new List<FailoverReplicationProtectedItemDetails>();

            return new FailoverJobDetails("FailoverJobDetails", affectedObjectDetails, serializedAdditionalRawData: null, protectedItemDetails?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.FailoverReplicationProtectedItemDetails"/>. </summary>
        /// <param name="name"> The name. </param>
        /// <param name="friendlyName"> The friendly name. </param>
        /// <param name="testVmName"> The test Vm name. </param>
        /// <param name="testVmFriendlyName"> The test Vm friendly name. </param>
        /// <param name="networkConnectionStatus"> The network connection status. </param>
        /// <param name="networkFriendlyName"> The network friendly name. </param>
        /// <param name="subnet"> The network subnet. </param>
        /// <param name="recoveryPointId"> The recovery point Id. </param>
        /// <param name="recoveryPointOn"> The recovery point time. </param>
        /// <returns> A new <see cref="Models.FailoverReplicationProtectedItemDetails"/> instance for mocking. </returns>
        public static FailoverReplicationProtectedItemDetails FailoverReplicationProtectedItemDetails(string name = null, string friendlyName = null, string testVmName = null, string testVmFriendlyName = null, string networkConnectionStatus = null, string networkFriendlyName = null, string subnet = null, ResourceIdentifier recoveryPointId = null, DateTimeOffset? recoveryPointOn = null)
        {
            return new FailoverReplicationProtectedItemDetails(
                name,
                friendlyName,
                testVmName,
                testVmFriendlyName,
                networkConnectionStatus,
                networkFriendlyName,
                subnet,
                recoveryPointId,
                recoveryPointOn,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.GatewayOperationDetails"/>. </summary>
        /// <param name="state"> A value indicating the state of gateway operation. </param>
        /// <param name="progressPercentage"> A value indicating the progress percentage of gateway operation. </param>
        /// <param name="timeElapsed"> A value indicating the time elapsed for the operation in milliseconds. </param>
        /// <param name="timeRemaining"> A value indicating the time remaining for the operation in milliseconds. </param>
        /// <param name="uploadSpeed"> A value indicating the upload speed in bytes per second. </param>
        /// <param name="hostName"> A value indicating the ESXi host name. </param>
        /// <param name="dataStores"> A value indicating the datastore collection. </param>
        /// <param name="vmwareReadThroughput"> A value indicating the VMware read throughput in bytes per second. </param>
        /// <returns> A new <see cref="Models.GatewayOperationDetails"/> instance for mocking. </returns>
        public static GatewayOperationDetails GatewayOperationDetails(string state = null, int? progressPercentage = null, long? timeElapsed = null, long? timeRemaining = null, long? uploadSpeed = null, string hostName = null, IEnumerable<string> dataStores = null, long? vmwareReadThroughput = null)
        {
            dataStores ??= new List<string>();

            return new GatewayOperationDetails(
                state,
                progressPercentage,
                timeElapsed,
                timeRemaining,
                uploadSpeed,
                hostName,
                dataStores?.ToList(),
                vmwareReadThroughput,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HyperVHostDetails"/>. </summary>
        /// <param name="id"> The Hyper-V host Id. </param>
        /// <param name="name"> The Hyper-V host name. </param>
        /// <param name="marsAgentVersion"> The Mars agent version. </param>
        /// <returns> A new <see cref="Models.HyperVHostDetails"/> instance for mocking. </returns>
        public static HyperVHostDetails HyperVHostDetails(string id = null, string name = null, string marsAgentVersion = null)
        {
            return new HyperVHostDetails(id, name, marsAgentVersion, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HyperVReplica2012EventDetails"/>. </summary>
        /// <param name="containerName"> The container friendly name. </param>
        /// <param name="fabricName"> The fabric friendly name. </param>
        /// <param name="remoteContainerName"> The remote container name. </param>
        /// <param name="remoteFabricName"> The remote fabric name. </param>
        /// <returns> A new <see cref="Models.HyperVReplica2012EventDetails"/> instance for mocking. </returns>
        public static HyperVReplica2012EventDetails HyperVReplica2012EventDetails(string containerName = null, string fabricName = null, string remoteContainerName = null, string remoteFabricName = null)
        {
            return new HyperVReplica2012EventDetails(
                "HyperVReplica2012",
                serializedAdditionalRawData: null,
                containerName,
                fabricName,
                remoteContainerName,
                remoteFabricName);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HyperVReplica2012R2EventDetails"/>. </summary>
        /// <param name="containerName"> The container friendly name. </param>
        /// <param name="fabricName"> The fabric friendly name. </param>
        /// <param name="remoteContainerName"> The remote container name. </param>
        /// <param name="remoteFabricName"> The remote fabric name. </param>
        /// <returns> A new <see cref="Models.HyperVReplica2012R2EventDetails"/> instance for mocking. </returns>
        public static HyperVReplica2012R2EventDetails HyperVReplica2012R2EventDetails(string containerName = null, string fabricName = null, string remoteContainerName = null, string remoteFabricName = null)
        {
            return new HyperVReplica2012R2EventDetails(
                "HyperVReplica2012R2",
                serializedAdditionalRawData: null,
                containerName,
                fabricName,
                remoteContainerName,
                remoteFabricName);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HyperVReplicaAzureEventDetails"/>. </summary>
        /// <param name="containerName"> The container friendly name. </param>
        /// <param name="fabricName"> The fabric friendly name. </param>
        /// <param name="remoteContainerName"> The remote container name. </param>
        /// <returns> A new <see cref="Models.HyperVReplicaAzureEventDetails"/> instance for mocking. </returns>
        public static HyperVReplicaAzureEventDetails HyperVReplicaAzureEventDetails(string containerName = null, string fabricName = null, string remoteContainerName = null)
        {
            return new HyperVReplicaAzureEventDetails("HyperVReplicaAzure", serializedAdditionalRawData: null, containerName, fabricName, remoteContainerName);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HyperVReplicaAzureManagedDiskDetails"/>. </summary>
        /// <param name="diskId"> The disk Id. </param>
        /// <param name="seedManagedDiskId"> Seed managed disk Id. </param>
        /// <param name="replicaDiskType"> The replica disk type. </param>
        /// <param name="diskEncryptionSetId"> The disk encryption set ARM Id. </param>
        /// <returns> A new <see cref="Models.HyperVReplicaAzureManagedDiskDetails"/> instance for mocking. </returns>
        public static HyperVReplicaAzureManagedDiskDetails HyperVReplicaAzureManagedDiskDetails(string diskId = null, string seedManagedDiskId = null, string replicaDiskType = null, ResourceIdentifier diskEncryptionSetId = null)
        {
            return new HyperVReplicaAzureManagedDiskDetails(diskId, seedManagedDiskId, replicaDiskType, diskEncryptionSetId, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HyperVReplicaAzurePolicyDetails"/>. </summary>
        /// <param name="recoveryPointHistoryDurationInHours"> The duration (in hours) to which point the recovery history needs to be maintained. </param>
        /// <param name="applicationConsistentSnapshotFrequencyInHours"> The interval (in hours) at which Hyper-V Replica should create an application consistent snapshot within the VM. </param>
        /// <param name="replicationInterval"> The replication interval. </param>
        /// <param name="onlineReplicationStartTime"> The scheduled start time for the initial replication. If this parameter is Null, the initial replication starts immediately. </param>
        /// <param name="encryption"> A value indicating whether encryption is enabled for virtual machines in this cloud. </param>
        /// <param name="activeStorageAccountId"> The active storage account Id. </param>
        /// <returns> A new <see cref="Models.HyperVReplicaAzurePolicyDetails"/> instance for mocking. </returns>
        public static HyperVReplicaAzurePolicyDetails HyperVReplicaAzurePolicyDetails(int? recoveryPointHistoryDurationInHours = null, int? applicationConsistentSnapshotFrequencyInHours = null, int? replicationInterval = null, string onlineReplicationStartTime = null, string encryption = null, ResourceIdentifier activeStorageAccountId = null)
        {
            return new HyperVReplicaAzurePolicyDetails(
                "HyperVReplicaAzure",
                serializedAdditionalRawData: null,
                recoveryPointHistoryDurationInHours,
                applicationConsistentSnapshotFrequencyInHours,
                replicationInterval,
                onlineReplicationStartTime,
                encryption,
                activeStorageAccountId);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HyperVReplicaAzureReplicationDetails"/>. </summary>
        /// <param name="azureVmDiskDetails"> Azure VM Disk details. </param>
        /// <param name="recoveryAzureVmName"> Recovery Azure given name. </param>
        /// <param name="recoveryAzureVmSize"> The Recovery Azure VM size. </param>
        /// <param name="recoveryAzureStorageAccount"> The recovery Azure storage account. </param>
        /// <param name="recoveryAzureLogStorageAccountId"> The ARM id of the log storage account used for replication. This will be set to null if no log storage account was provided during enable protection. </param>
        /// <param name="lastReplicatedOn"> The Last replication time. </param>
        /// <param name="rpoInSeconds"> Last RPO value. </param>
        /// <param name="lastRpoCalculatedOn"> The last RPO calculated time. </param>
        /// <param name="vmId"> The virtual machine Id. </param>
        /// <param name="vmProtectionState"> The protection state for the vm. </param>
        /// <param name="vmProtectionStateDescription"> The protection state description for the vm. </param>
        /// <param name="initialReplicationDetails"> Initial replication details. </param>
        /// <param name="vmNics"> The PE Network details. </param>
        /// <param name="selectedRecoveryAzureNetworkId"> The selected recovery azure network Id. </param>
        /// <param name="selectedSourceNicId"> The selected source nic Id which will be used as the primary nic during failover. </param>
        /// <param name="encryption"> The encryption info. </param>
        /// <param name="osDetails"> The operating system info. </param>
        /// <param name="sourceVmRamSizeInMB"> The RAM size of the VM on the primary side. </param>
        /// <param name="sourceVmCpuCount"> The CPU count of the VM on the primary side. </param>
        /// <param name="enableRdpOnTargetOption"> The selected option to enable RDP\SSH on target vm after failover. String value of SrsDataContract.EnableRDPOnTargetOption enum. </param>
        /// <param name="recoveryAzureResourceGroupId"> The target resource group Id. </param>
        /// <param name="recoveryAvailabilitySetId"> The recovery availability set Id. </param>
        /// <param name="targetAvailabilityZone"> The target availability zone. </param>
        /// <param name="targetProximityPlacementGroupId"> The target proximity placement group Id. </param>
        /// <param name="useManagedDisks"> A value indicating whether managed disks should be used during failover. </param>
        /// <param name="licenseType"> License Type of the VM to be used. </param>
        /// <param name="sqlServerLicenseType"> The SQL Server license type. </param>
        /// <param name="lastRecoveryPointReceived"> The last recovery point received time. </param>
        /// <param name="targetVmTags"> The target VM tags. </param>
        /// <param name="seedManagedDiskTags"> The tags for the seed managed disks. </param>
        /// <param name="targetManagedDiskTags"> The tags for the target managed disks. </param>
        /// <param name="targetNicTags"> The tags for the target NICs. </param>
        /// <param name="protectedManagedDisks"> The list of protected managed disks. </param>
        /// <param name="allAvailableOSUpgradeConfigurations"> A value indicating all available inplace OS Upgrade configurations. </param>
        /// <returns> A new <see cref="Models.HyperVReplicaAzureReplicationDetails"/> instance for mocking. </returns>
        public static HyperVReplicaAzureReplicationDetails HyperVReplicaAzureReplicationDetails(IEnumerable<SiteRecoveryVmDiskDetails> azureVmDiskDetails = null, string recoveryAzureVmName = null, string recoveryAzureVmSize = null, string recoveryAzureStorageAccount = null, ResourceIdentifier recoveryAzureLogStorageAccountId = null, DateTimeOffset? lastReplicatedOn = null, long? rpoInSeconds = null, DateTimeOffset? lastRpoCalculatedOn = null, string vmId = null, string vmProtectionState = null, string vmProtectionStateDescription = null, InitialReplicationDetails initialReplicationDetails = null, IEnumerable<VmNicDetails> vmNics = null, ResourceIdentifier selectedRecoveryAzureNetworkId = null, string selectedSourceNicId = null, string encryption = null, SiteRecoveryOSDetails osDetails = null, int? sourceVmRamSizeInMB = null, int? sourceVmCpuCount = null, string enableRdpOnTargetOption = null, ResourceIdentifier recoveryAzureResourceGroupId = null, ResourceIdentifier recoveryAvailabilitySetId = null, string targetAvailabilityZone = null, ResourceIdentifier targetProximityPlacementGroupId = null, string useManagedDisks = null, string licenseType = null, string sqlServerLicenseType = null, DateTimeOffset? lastRecoveryPointReceived = null, IReadOnlyDictionary<string, string> targetVmTags = null, IReadOnlyDictionary<string, string> seedManagedDiskTags = null, IReadOnlyDictionary<string, string> targetManagedDiskTags = null, IReadOnlyDictionary<string, string> targetNicTags = null, IEnumerable<HyperVReplicaAzureManagedDiskDetails> protectedManagedDisks = null, IEnumerable<OSUpgradeSupportedVersions> allAvailableOSUpgradeConfigurations = null)
        {
            azureVmDiskDetails ??= new List<SiteRecoveryVmDiskDetails>();
            vmNics ??= new List<VmNicDetails>();
            targetVmTags ??= new Dictionary<string, string>();
            seedManagedDiskTags ??= new Dictionary<string, string>();
            targetManagedDiskTags ??= new Dictionary<string, string>();
            targetNicTags ??= new Dictionary<string, string>();
            protectedManagedDisks ??= new List<HyperVReplicaAzureManagedDiskDetails>();
            allAvailableOSUpgradeConfigurations ??= new List<OSUpgradeSupportedVersions>();

            return new HyperVReplicaAzureReplicationDetails(
                "HyperVReplicaAzure",
                serializedAdditionalRawData: null,
                azureVmDiskDetails?.ToList(),
                recoveryAzureVmName,
                recoveryAzureVmSize,
                recoveryAzureStorageAccount,
                recoveryAzureLogStorageAccountId,
                lastReplicatedOn,
                rpoInSeconds,
                lastRpoCalculatedOn,
                vmId,
                vmProtectionState,
                vmProtectionStateDescription,
                initialReplicationDetails,
                vmNics?.ToList(),
                selectedRecoveryAzureNetworkId,
                selectedSourceNicId,
                encryption,
                osDetails,
                sourceVmRamSizeInMB,
                sourceVmCpuCount,
                enableRdpOnTargetOption,
                recoveryAzureResourceGroupId,
                recoveryAvailabilitySetId,
                targetAvailabilityZone,
                targetProximityPlacementGroupId,
                useManagedDisks,
                licenseType,
                sqlServerLicenseType,
                lastRecoveryPointReceived,
                targetVmTags,
                seedManagedDiskTags,
                targetManagedDiskTags,
                targetNicTags,
                protectedManagedDisks?.ToList(),
                allAvailableOSUpgradeConfigurations?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.InitialReplicationDetails"/>. </summary>
        /// <param name="initialReplicationType"> Initial replication type. </param>
        /// <param name="initialReplicationProgressPercentage"> The initial replication progress percentage. </param>
        /// <returns> A new <see cref="Models.InitialReplicationDetails"/> instance for mocking. </returns>
        public static InitialReplicationDetails InitialReplicationDetails(string initialReplicationType = null, string initialReplicationProgressPercentage = null)
        {
            return new InitialReplicationDetails(initialReplicationType, initialReplicationProgressPercentage, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SiteRecoveryOSDetails"/>. </summary>
        /// <param name="osType"> VM Disk details. </param>
        /// <param name="productType"> Product type. </param>
        /// <param name="osEdition"> The OSEdition. </param>
        /// <param name="osVersion"> The OS Version. </param>
        /// <param name="osMajorVersion"> The OS Major Version. </param>
        /// <param name="osMinorVersion"> The OS Minor Version. </param>
        /// <returns> A new <see cref="Models.SiteRecoveryOSDetails"/> instance for mocking. </returns>
        public static SiteRecoveryOSDetails SiteRecoveryOSDetails(string osType = null, string productType = null, string osEdition = null, string osVersion = null, string osMajorVersion = null, string osMinorVersion = null)
        {
            return new SiteRecoveryOSDetails(
                osType,
                productType,
                osEdition,
                osVersion,
                osMajorVersion,
                osMinorVersion,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.OSUpgradeSupportedVersions"/>. </summary>
        /// <param name="supportedSourceOSVersion"> The source OS version name. </param>
        /// <param name="supportedTargetOSVersions"> The target OS version names. </param>
        /// <returns> A new <see cref="Models.OSUpgradeSupportedVersions"/> instance for mocking. </returns>
        public static OSUpgradeSupportedVersions OSUpgradeSupportedVersions(string supportedSourceOSVersion = null, IEnumerable<string> supportedTargetOSVersions = null)
        {
            supportedTargetOSVersions ??= new List<string>();

            return new OSUpgradeSupportedVersions(supportedSourceOSVersion, supportedTargetOSVersions?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.UpdateDiskContent"/>. </summary>
        /// <param name="diskId"> The disk Id. </param>
        /// <param name="targetDiskName"> The target disk name. </param>
        /// <returns> A new <see cref="Models.UpdateDiskContent"/> instance for mocking. </returns>
        public static UpdateDiskContent UpdateDiskContent(string diskId = null, string targetDiskName = null)
        {
            return new UpdateDiskContent(diskId, targetDiskName, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HyperVReplicaBaseEventDetails"/>. </summary>
        /// <param name="containerName"> The container friendly name. </param>
        /// <param name="fabricName"> The fabric friendly name. </param>
        /// <param name="remoteContainerName"> The remote container name. </param>
        /// <param name="remoteFabricName"> The remote fabric name. </param>
        /// <returns> A new <see cref="Models.HyperVReplicaBaseEventDetails"/> instance for mocking. </returns>
        public static HyperVReplicaBaseEventDetails HyperVReplicaBaseEventDetails(string containerName = null, string fabricName = null, string remoteContainerName = null, string remoteFabricName = null)
        {
            return new HyperVReplicaBaseEventDetails(
                "HyperVReplicaBaseEventDetails",
                serializedAdditionalRawData: null,
                containerName,
                fabricName,
                remoteContainerName,
                remoteFabricName);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HyperVReplicaBasePolicyDetails"/>. </summary>
        /// <param name="recoveryPoints"> A value indicating the number of recovery points. </param>
        /// <param name="applicationConsistentSnapshotFrequencyInHours"> A value indicating the application consistent frequency. </param>
        /// <param name="compression"> A value indicating whether compression has to be enabled. </param>
        /// <param name="initialReplicationMethod"> A value indicating whether IR is online. </param>
        /// <param name="onlineReplicationStartTime"> A value indicating the online IR start time. </param>
        /// <param name="offlineReplicationImportPath"> A value indicating the offline IR import path. </param>
        /// <param name="offlineReplicationExportPath"> A value indicating the offline IR export path. </param>
        /// <param name="replicationPort"> A value indicating the recovery HTTPS port. </param>
        /// <param name="allowedAuthenticationType"> A value indicating the authentication type. </param>
        /// <param name="replicaDeletionOption"> A value indicating whether the VM has to be auto deleted. Supported Values: String.Empty, None, OnRecoveryCloud. </param>
        /// <returns> A new <see cref="Models.HyperVReplicaBasePolicyDetails"/> instance for mocking. </returns>
        public static HyperVReplicaBasePolicyDetails HyperVReplicaBasePolicyDetails(int? recoveryPoints = null, int? applicationConsistentSnapshotFrequencyInHours = null, string compression = null, string initialReplicationMethod = null, string onlineReplicationStartTime = null, string offlineReplicationImportPath = null, string offlineReplicationExportPath = null, int? replicationPort = null, int? allowedAuthenticationType = null, string replicaDeletionOption = null)
        {
            return new HyperVReplicaBasePolicyDetails(
                "HyperVReplicaBasePolicyDetails",
                serializedAdditionalRawData: null,
                recoveryPoints,
                applicationConsistentSnapshotFrequencyInHours,
                compression,
                initialReplicationMethod,
                onlineReplicationStartTime,
                offlineReplicationImportPath,
                offlineReplicationExportPath,
                replicationPort,
                allowedAuthenticationType,
                replicaDeletionOption);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HyperVReplicaBaseReplicationDetails"/>. </summary>
        /// <param name="lastReplicatedOn"> The Last replication time. </param>
        /// <param name="vmNics"> The PE Network details. </param>
        /// <param name="vmId"> The virtual machine Id. </param>
        /// <param name="vmProtectionState"> The protection state for the vm. </param>
        /// <param name="vmProtectionStateDescription"> The protection state description for the vm. </param>
        /// <param name="initialReplicationDetails"> Initial replication details. </param>
        /// <param name="vmDiskDetails"> VM disk details. </param>
        /// <returns> A new <see cref="Models.HyperVReplicaBaseReplicationDetails"/> instance for mocking. </returns>
        public static HyperVReplicaBaseReplicationDetails HyperVReplicaBaseReplicationDetails(DateTimeOffset? lastReplicatedOn = null, IEnumerable<VmNicDetails> vmNics = null, string vmId = null, string vmProtectionState = null, string vmProtectionStateDescription = null, InitialReplicationDetails initialReplicationDetails = null, IEnumerable<SiteRecoveryDiskDetails> vmDiskDetails = null)
        {
            vmNics ??= new List<VmNicDetails>();
            vmDiskDetails ??= new List<SiteRecoveryDiskDetails>();

            return new HyperVReplicaBaseReplicationDetails(
                "HyperVReplicaBaseReplicationDetails",
                serializedAdditionalRawData: null,
                lastReplicatedOn,
                vmNics?.ToList(),
                vmId,
                vmProtectionState,
                vmProtectionStateDescription,
                initialReplicationDetails,
                vmDiskDetails?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.HyperVReplicaBluePolicyDetails"/>. </summary>
        /// <param name="replicationFrequencyInSeconds"> A value indicating the replication interval. </param>
        /// <param name="recoveryPoints"> A value indicating the number of recovery points. </param>
        /// <param name="applicationConsistentSnapshotFrequencyInHours"> A value indicating the application consistent frequency. </param>
        /// <param name="compression"> A value indicating whether compression has to be enabled. </param>
        /// <param name="initialReplicationMethod"> A value indicating whether IR is online. </param>
        /// <param name="onlineReplicationStartTime"> A value indicating the online IR start time. </param>
        /// <param name="offlineReplicationImportPath"> A value indicating the offline IR import path. </param>
        /// <param name="offlineReplicationExportPath"> A value indicating the offline IR export path. </param>
        /// <param name="replicationPort"> A value indicating the recovery HTTPS port. </param>
        /// <param name="allowedAuthenticationType"> A value indicating the authentication type. </param>
        /// <param name="replicaDeletionOption"> A value indicating whether the VM has to be auto deleted. Supported Values: String.Empty, None, OnRecoveryCloud. </param>
        /// <returns> A new <see cref="Models.HyperVReplicaBluePolicyDetails"/> instance for mocking. </returns>
        public static HyperVReplicaBluePolicyDetails HyperVReplicaBluePolicyDetails(int? replicationFrequencyInSeconds = null, int? recoveryPoints = null, int? applicationConsistentSnapshotFrequencyInHours = null, string compression = null, string initialReplicationMethod = null, string onlineReplicationStartTime = null, string offlineReplicationImportPath = null, string offlineReplicationExportPath = null, int? replicationPort = null, int? allowedAuthenticationType = null, string replicaDeletionOption = null)
        {
            return new HyperVReplicaBluePolicyDetails(
                "HyperVReplica2012R2",
                serializedAdditionalRawData: null,
                replicationFrequencyInSeconds,
                recoveryPoints,
                applicationConsistentSnapshotFrequencyInHours,
                compression,
                initialReplicationMethod,
                onlineReplicationStartTime,
                offlineReplicationImportPath,
                offlineReplicationExportPath,
                replicationPort,
                allowedAuthenticationType,
                replicaDeletionOption);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HyperVReplicaBlueReplicationDetails"/>. </summary>
        /// <param name="lastReplicatedOn"> The Last replication time. </param>
        /// <param name="vmNics"> The PE Network details. </param>
        /// <param name="vmId"> The virtual machine Id. </param>
        /// <param name="vmProtectionState"> The protection state for the vm. </param>
        /// <param name="vmProtectionStateDescription"> The protection state description for the vm. </param>
        /// <param name="initialReplicationDetails"> Initial replication details. </param>
        /// <param name="vmDiskDetails"> VM disk details. </param>
        /// <returns> A new <see cref="Models.HyperVReplicaBlueReplicationDetails"/> instance for mocking. </returns>
        public static HyperVReplicaBlueReplicationDetails HyperVReplicaBlueReplicationDetails(DateTimeOffset? lastReplicatedOn = null, IEnumerable<VmNicDetails> vmNics = null, string vmId = null, string vmProtectionState = null, string vmProtectionStateDescription = null, InitialReplicationDetails initialReplicationDetails = null, IEnumerable<SiteRecoveryDiskDetails> vmDiskDetails = null)
        {
            vmNics ??= new List<VmNicDetails>();
            vmDiskDetails ??= new List<SiteRecoveryDiskDetails>();

            return new HyperVReplicaBlueReplicationDetails(
                "HyperVReplica2012R2",
                serializedAdditionalRawData: null,
                lastReplicatedOn,
                vmNics?.ToList(),
                vmId,
                vmProtectionState,
                vmProtectionStateDescription,
                initialReplicationDetails,
                vmDiskDetails?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.HyperVReplicaPolicyDetails"/>. </summary>
        /// <param name="recoveryPoints"> A value indicating the number of recovery points. </param>
        /// <param name="applicationConsistentSnapshotFrequencyInHours"> A value indicating the application consistent frequency. </param>
        /// <param name="compression"> A value indicating whether compression has to be enabled. </param>
        /// <param name="initialReplicationMethod"> A value indicating whether IR is online. </param>
        /// <param name="onlineReplicationStartTime"> A value indicating the online IR start time. </param>
        /// <param name="offlineReplicationImportPath"> A value indicating the offline IR import path. </param>
        /// <param name="offlineReplicationExportPath"> A value indicating the offline IR export path. </param>
        /// <param name="replicationPort"> A value indicating the recovery HTTPS port. </param>
        /// <param name="allowedAuthenticationType"> A value indicating the authentication type. </param>
        /// <param name="replicaDeletionOption"> A value indicating whether the VM has to be auto deleted. Supported Values: String.Empty, None, OnRecoveryCloud. </param>
        /// <returns> A new <see cref="Models.HyperVReplicaPolicyDetails"/> instance for mocking. </returns>
        public static HyperVReplicaPolicyDetails HyperVReplicaPolicyDetails(int? recoveryPoints = null, int? applicationConsistentSnapshotFrequencyInHours = null, string compression = null, string initialReplicationMethod = null, string onlineReplicationStartTime = null, string offlineReplicationImportPath = null, string offlineReplicationExportPath = null, int? replicationPort = null, int? allowedAuthenticationType = null, string replicaDeletionOption = null)
        {
            return new HyperVReplicaPolicyDetails(
                "HyperVReplica2012",
                serializedAdditionalRawData: null,
                recoveryPoints,
                applicationConsistentSnapshotFrequencyInHours,
                compression,
                initialReplicationMethod,
                onlineReplicationStartTime,
                offlineReplicationImportPath,
                offlineReplicationExportPath,
                replicationPort,
                allowedAuthenticationType,
                replicaDeletionOption);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HyperVReplicaReplicationDetails"/>. </summary>
        /// <param name="lastReplicatedOn"> The Last replication time. </param>
        /// <param name="vmNics"> The PE Network details. </param>
        /// <param name="vmId"> The virtual machine Id. </param>
        /// <param name="vmProtectionState"> The protection state for the vm. </param>
        /// <param name="vmProtectionStateDescription"> The protection state description for the vm. </param>
        /// <param name="initialReplicationDetails"> Initial replication details. </param>
        /// <param name="vmDiskDetails"> VM disk details. </param>
        /// <returns> A new <see cref="Models.HyperVReplicaReplicationDetails"/> instance for mocking. </returns>
        public static HyperVReplicaReplicationDetails HyperVReplicaReplicationDetails(DateTimeOffset? lastReplicatedOn = null, IEnumerable<VmNicDetails> vmNics = null, string vmId = null, string vmProtectionState = null, string vmProtectionStateDescription = null, InitialReplicationDetails initialReplicationDetails = null, IEnumerable<SiteRecoveryDiskDetails> vmDiskDetails = null)
        {
            vmNics ??= new List<VmNicDetails>();
            vmDiskDetails ??= new List<SiteRecoveryDiskDetails>();

            return new HyperVReplicaReplicationDetails(
                "HyperVReplica2012",
                serializedAdditionalRawData: null,
                lastReplicatedOn,
                vmNics?.ToList(),
                vmId,
                vmProtectionState,
                vmProtectionStateDescription,
                initialReplicationDetails,
                vmDiskDetails?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.HyperVSiteDetails"/>. </summary>
        /// <param name="hyperVHosts"> The list of Hyper-V hosts associated with the fabric. </param>
        /// <returns> A new <see cref="Models.HyperVSiteDetails"/> instance for mocking. </returns>
        public static HyperVSiteDetails HyperVSiteDetails(IEnumerable<HyperVHostDetails> hyperVHosts = null)
        {
            hyperVHosts ??= new List<HyperVHostDetails>();

            return new HyperVSiteDetails("HyperVSite", serializedAdditionalRawData: null, hyperVHosts?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.HyperVVmDetails"/>. </summary>
        /// <param name="sourceItemId"> The source id of the object. </param>
        /// <param name="generation"> The id of the object in fabric. </param>
        /// <param name="osDetails"> The Last replication time. </param>
        /// <param name="diskDetails"> The Last successful failover time. </param>
        /// <param name="hasPhysicalDisk"> A value indicating whether the VM has a physical disk attached. String value of SrsDataContract.PresenceStatus enum. </param>
        /// <param name="hasFibreChannelAdapter"> A value indicating whether the VM has a fibre channel adapter attached. String value of SrsDataContract.PresenceStatus enum. </param>
        /// <param name="hasSharedVhd"> A value indicating whether the VM has a shared VHD attached. String value of SrsDataContract.PresenceStatus enum. </param>
        /// <param name="hyperVHostId"> The Id of the hyper-v host in fabric. </param>
        /// <returns> A new <see cref="Models.HyperVVmDetails"/> instance for mocking. </returns>
        public static HyperVVmDetails HyperVVmDetails(string sourceItemId = null, string generation = null, SiteRecoveryOSDetails osDetails = null, IEnumerable<SiteRecoveryDiskDetails> diskDetails = null, HyperVVmDiskPresenceStatus? hasPhysicalDisk = null, HyperVVmDiskPresenceStatus? hasFibreChannelAdapter = null, HyperVVmDiskPresenceStatus? hasSharedVhd = null, string hyperVHostId = null)
        {
            diskDetails ??= new List<SiteRecoveryDiskDetails>();

            return new HyperVVmDetails(
                "HyperVVirtualMachine",
                serializedAdditionalRawData: null,
                sourceItemId,
                generation,
                osDetails,
                diskDetails?.ToList(),
                hasPhysicalDisk,
                hasFibreChannelAdapter,
                hasSharedVhd,
                hyperVHostId);
        }

        /// <summary> Initializes a new instance of <see cref="Models.InlineWorkflowTaskDetails"/>. </summary>
        /// <param name="childTasks"> The child tasks. </param>
        /// <param name="workflowIds"> The list of child workflow ids. </param>
        /// <returns> A new <see cref="Models.InlineWorkflowTaskDetails"/> instance for mocking. </returns>
        public static InlineWorkflowTaskDetails InlineWorkflowTaskDetails(IEnumerable<AsrTask> childTasks = null, IEnumerable<string> workflowIds = null)
        {
            childTasks ??= new List<AsrTask>();
            workflowIds ??= new List<string>();

            return new InlineWorkflowTaskDetails("InlineWorkflowTaskDetails", childTasks?.ToList(), serializedAdditionalRawData: null, workflowIds?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.InMageAgentDetails"/>. </summary>
        /// <param name="agentVersion"> The agent version. </param>
        /// <param name="agentUpdateStatus"> A value indicating whether installed agent needs to be updated. </param>
        /// <param name="postUpdateRebootStatus"> A value indicating whether reboot is required after update is applied. </param>
        /// <param name="agentExpireOn"> Agent expiry date. </param>
        /// <returns> A new <see cref="Models.InMageAgentDetails"/> instance for mocking. </returns>
        public static InMageAgentDetails InMageAgentDetails(string agentVersion = null, string agentUpdateStatus = null, string postUpdateRebootStatus = null, DateTimeOffset? agentExpireOn = null)
        {
            return new InMageAgentDetails(agentVersion, agentUpdateStatus, postUpdateRebootStatus, agentExpireOn, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.InMageAzureV2EventDetails"/>. </summary>
        /// <param name="eventType"> InMage Event type. Takes one of the values of InMageDataContract.InMageMonitoringEventType. </param>
        /// <param name="category"> InMage Event Category. </param>
        /// <param name="component"> InMage Event Component. </param>
        /// <param name="correctiveAction"> Corrective Action string for the event. </param>
        /// <param name="details"> InMage Event Details. </param>
        /// <param name="summary"> InMage Event Summary. </param>
        /// <param name="siteName"> VMware Site name. </param>
        /// <returns> A new <see cref="Models.InMageAzureV2EventDetails"/> instance for mocking. </returns>
        public static InMageAzureV2EventDetails InMageAzureV2EventDetails(string eventType = null, string category = null, string component = null, string correctiveAction = null, string details = null, string summary = null, string siteName = null)
        {
            return new InMageAzureV2EventDetails(
                "InMageAzureV2",
                serializedAdditionalRawData: null,
                eventType,
                category,
                component,
                correctiveAction,
                details,
                summary,
                siteName);
        }

        /// <summary> Initializes a new instance of <see cref="Models.InMageAzureV2ManagedDiskDetails"/>. </summary>
        /// <param name="diskId"> The disk id. </param>
        /// <param name="seedManagedDiskId"> Seed managed disk Id. </param>
        /// <param name="replicaDiskType"> The replica disk type. </param>
        /// <param name="diskEncryptionSetId"> The DiskEncryptionSet ARM ID. </param>
        /// <param name="targetDiskName"> The target disk name. </param>
        /// <returns> A new <see cref="Models.InMageAzureV2ManagedDiskDetails"/> instance for mocking. </returns>
        public static InMageAzureV2ManagedDiskDetails InMageAzureV2ManagedDiskDetails(string diskId = null, string seedManagedDiskId = null, string replicaDiskType = null, ResourceIdentifier diskEncryptionSetId = null, string targetDiskName = null)
        {
            return new InMageAzureV2ManagedDiskDetails(
                diskId,
                seedManagedDiskId,
                replicaDiskType,
                diskEncryptionSetId,
                targetDiskName,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.InMageAzureV2PolicyDetails"/>. </summary>
        /// <param name="crashConsistentFrequencyInMinutes"> The crash consistent snapshot frequency in minutes. </param>
        /// <param name="recoveryPointThresholdInMinutes"> The recovery point threshold in minutes. </param>
        /// <param name="recoveryPointHistory"> The duration in minutes until which the recovery points need to be stored. </param>
        /// <param name="appConsistentFrequencyInMinutes"> The app consistent snapshot frequency in minutes. </param>
        /// <param name="multiVmSyncStatus"> A value indicating whether multi-VM sync has to be enabled. </param>
        /// <returns> A new <see cref="Models.InMageAzureV2PolicyDetails"/> instance for mocking. </returns>
        public static InMageAzureV2PolicyDetails InMageAzureV2PolicyDetails(int? crashConsistentFrequencyInMinutes = null, int? recoveryPointThresholdInMinutes = null, int? recoveryPointHistory = null, int? appConsistentFrequencyInMinutes = null, string multiVmSyncStatus = null)
        {
            return new InMageAzureV2PolicyDetails(
                "InMageAzureV2",
                serializedAdditionalRawData: null,
                crashConsistentFrequencyInMinutes,
                recoveryPointThresholdInMinutes,
                recoveryPointHistory,
                appConsistentFrequencyInMinutes,
                multiVmSyncStatus);
        }

        /// <summary> Initializes a new instance of <see cref="Models.InMageAzureV2PolicyContent"/>. </summary>
        /// <param name="recoveryPointThresholdInMinutes"> The recovery point threshold in minutes. </param>
        /// <param name="recoveryPointHistory"> The duration in minutes until which the recovery points need to be stored. </param>
        /// <param name="crashConsistentFrequencyInMinutes"> The crash consistent snapshot frequency (in minutes). </param>
        /// <param name="appConsistentFrequencyInMinutes"> The app consistent snapshot frequency (in minutes). </param>
        /// <param name="multiVmSyncStatus"> A value indicating whether multi-VM sync has to be enabled. Value should be 'Enabled' or 'Disabled'. </param>
        /// <returns> A new <see cref="Models.InMageAzureV2PolicyContent"/> instance for mocking. </returns>
        public static InMageAzureV2PolicyContent InMageAzureV2PolicyContent(int? recoveryPointThresholdInMinutes = null, int? recoveryPointHistory = null, int? crashConsistentFrequencyInMinutes = null, int? appConsistentFrequencyInMinutes = null, SetMultiVmSyncStatus multiVmSyncStatus = default)
        {
            return new InMageAzureV2PolicyContent(
                "InMageAzureV2",
                serializedAdditionalRawData: null,
                recoveryPointThresholdInMinutes,
                recoveryPointHistory,
                crashConsistentFrequencyInMinutes,
                appConsistentFrequencyInMinutes,
                multiVmSyncStatus);
        }

        /// <summary> Initializes a new instance of <see cref="Models.InMageAzureV2ProtectedDiskDetails"/>. </summary>
        /// <param name="diskId"> The disk id. </param>
        /// <param name="diskName"> The disk name. </param>
        /// <param name="protectionStage"> The protection stage. </param>
        /// <param name="healthErrorCode"> The health error code for the disk. </param>
        /// <param name="rpoInSeconds"> The RPO in seconds. </param>
        /// <param name="resyncRequired"> A value indicating whether resync is required for this disk. </param>
        /// <param name="resyncProgressPercentage"> The resync progress percentage. </param>
        /// <param name="resyncDurationInSeconds"> The resync duration in seconds. </param>
        /// <param name="diskCapacityInBytes"> The disk capacity in bytes. </param>
        /// <param name="fileSystemCapacityInBytes"> The disk file system capacity in bytes. </param>
        /// <param name="sourceDataInMegaBytes"> The source data transit in MB. </param>
        /// <param name="psDataInMegaBytes"> The PS data transit in MB. </param>
        /// <param name="targetDataInMegaBytes"> The target data transit in MB. </param>
        /// <param name="diskResized"> A value indicating whether disk is resized. </param>
        /// <param name="lastRpoCalculatedOn"> The last RPO calculated time. </param>
        /// <param name="resyncProcessedBytes"> The resync processed bytes. </param>
        /// <param name="resyncTotalTransferredBytes"> The resync total transferred bytes. </param>
        /// <param name="resyncLast15MinutesTransferredBytes"> The resync last 15 minutes transferred bytes. </param>
        /// <param name="resyncLastDataTransferOn"> The last data transfer time in UTC. </param>
        /// <param name="resyncStartOn"> The resync start time. </param>
        /// <param name="progressHealth"> The Progress Health. </param>
        /// <param name="progressStatus"> The Progress Status. </param>
        /// <param name="secondsToTakeSwitchProvider"> The seconds to take for switch provider. </param>
        /// <returns> A new <see cref="Models.InMageAzureV2ProtectedDiskDetails"/> instance for mocking. </returns>
        public static InMageAzureV2ProtectedDiskDetails InMageAzureV2ProtectedDiskDetails(string diskId = null, string diskName = null, string protectionStage = null, string healthErrorCode = null, long? rpoInSeconds = null, string resyncRequired = null, int? resyncProgressPercentage = null, long? resyncDurationInSeconds = null, long? diskCapacityInBytes = null, long? fileSystemCapacityInBytes = null, double? sourceDataInMegaBytes = null, double? psDataInMegaBytes = null, double? targetDataInMegaBytes = null, string diskResized = null, DateTimeOffset? lastRpoCalculatedOn = null, long? resyncProcessedBytes = null, long? resyncTotalTransferredBytes = null, long? resyncLast15MinutesTransferredBytes = null, DateTimeOffset? resyncLastDataTransferOn = null, DateTimeOffset? resyncStartOn = null, string progressHealth = null, string progressStatus = null, long? secondsToTakeSwitchProvider = null)
        {
            return new InMageAzureV2ProtectedDiskDetails(
                diskId,
                diskName,
                protectionStage,
                healthErrorCode,
                rpoInSeconds,
                resyncRequired,
                resyncProgressPercentage,
                resyncDurationInSeconds,
                diskCapacityInBytes,
                fileSystemCapacityInBytes,
                sourceDataInMegaBytes,
                psDataInMegaBytes,
                targetDataInMegaBytes,
                diskResized,
                lastRpoCalculatedOn,
                resyncProcessedBytes,
                resyncTotalTransferredBytes,
                resyncLast15MinutesTransferredBytes,
                resyncLastDataTransferOn,
                resyncStartOn,
                progressHealth,
                progressStatus,
                secondsToTakeSwitchProvider,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.InMageAzureV2RecoveryPointDetails"/>. </summary>
        /// <param name="isMultiVmSyncPoint"> A value indicating whether the recovery point is multi VM consistent. </param>
        /// <returns> A new <see cref="Models.InMageAzureV2RecoveryPointDetails"/> instance for mocking. </returns>
        public static InMageAzureV2RecoveryPointDetails InMageAzureV2RecoveryPointDetails(string isMultiVmSyncPoint = null)
        {
            return new InMageAzureV2RecoveryPointDetails("InMageAzureV2", serializedAdditionalRawData: null, isMultiVmSyncPoint);
        }

        /// <summary> Initializes a new instance of <see cref="Models.InMageAzureV2ReplicationDetails"/>. </summary>
        /// <param name="infrastructureVmId"> The infrastructure VM Id. </param>
        /// <param name="vCenterInfrastructureId"> The vCenter infrastructure Id. </param>
        /// <param name="protectionStage"> The protection stage. </param>
        /// <param name="vmId"> The virtual machine Id. </param>
        /// <param name="vmProtectionState"> The protection state for the vm. </param>
        /// <param name="vmProtectionStateDescription"> The protection state description for the vm. </param>
        /// <param name="resyncProgressPercentage"> The resync progress percentage. </param>
        /// <param name="rpoInSeconds"> The RPO in seconds. </param>
        /// <param name="compressedDataRateInMB"> The compressed data change rate in MB. </param>
        /// <param name="uncompressedDataRateInMB"> The uncompressed data change rate in MB. </param>
        /// <param name="ipAddress"> The source IP address. </param>
        /// <param name="agentVersion"> The agent version. </param>
        /// <param name="agentExpireOn"> Agent expiry date. </param>
        /// <param name="isAgentUpdateRequired"> A value indicating whether installed agent needs to be updated. </param>
        /// <param name="isRebootAfterUpdateRequired"> A value indicating whether the source server requires a restart after update. </param>
        /// <param name="lastHeartbeat"> The last heartbeat received from the source server. </param>
        /// <param name="processServerId"> The process server Id. </param>
        /// <param name="processServerName"> The process server name. </param>
        /// <param name="multiVmGroupId"> The multi vm group Id. </param>
        /// <param name="multiVmGroupName"> The multi vm group name. </param>
        /// <param name="multiVmSyncStatus"> A value indicating whether multi vm sync is enabled or disabled. </param>
        /// <param name="protectedDisks"> The list of protected disks. </param>
        /// <param name="diskResized"> A value indicating whether any disk is resized for this VM. </param>
        /// <param name="masterTargetId"> The master target Id. </param>
        /// <param name="sourceVmCpuCount"> The CPU count of the VM on the primary side. </param>
        /// <param name="sourceVmRamSizeInMB"> The RAM size of the VM on the primary side. </param>
        /// <param name="osType"> The type of the OS on the VM. </param>
        /// <param name="vhdName"> The OS disk VHD name. </param>
        /// <param name="osDiskId"> The id of the disk containing the OS. </param>
        /// <param name="azureVmDiskDetails"> Azure VM Disk details. </param>
        /// <param name="recoveryAzureVmName"> Recovery Azure given name. </param>
        /// <param name="recoveryAzureVmSize"> The Recovery Azure VM size. </param>
        /// <param name="recoveryAzureStorageAccount"> The recovery Azure storage account. </param>
        /// <param name="recoveryAzureLogStorageAccountId"> The ARM id of the log storage account used for replication. This will be set to null if no log storage account was provided during enable protection. </param>
        /// <param name="vmNics"> The PE Network details. </param>
        /// <param name="selectedRecoveryAzureNetworkId"> The selected recovery azure network Id. </param>
        /// <param name="selectedTfoAzureNetworkId"> The test failover virtual network. </param>
        /// <param name="selectedSourceNicId"> The selected source nic Id which will be used as the primary nic during failover. </param>
        /// <param name="discoveryType"> A value indicating the discovery type of the machine. Value can be vCenter or physical. </param>
        /// <param name="enableRdpOnTargetOption"> The selected option to enable RDP\SSH on target vm after failover. String value of SrsDataContract.EnableRDPOnTargetOption enum. </param>
        /// <param name="datastores"> The datastores of the on-premise machine. Value can be list of strings that contain datastore names. </param>
        /// <param name="targetVmId"> The ARM Id of the target Azure VM. This value will be null until the VM is failed over. Only after failure it will be populated with the ARM Id of the Azure VM. </param>
        /// <param name="recoveryAzureResourceGroupId"> The target resource group Id. </param>
        /// <param name="recoveryAvailabilitySetId"> The recovery availability set Id. </param>
        /// <param name="targetAvailabilityZone"> The target availability zone. </param>
        /// <param name="targetProximityPlacementGroupId"> The target proximity placement group Id. </param>
        /// <param name="useManagedDisks"> A value indicating whether managed disks should be used during failover. </param>
        /// <param name="licenseType"> License Type of the VM to be used. </param>
        /// <param name="sqlServerLicenseType"> The SQL Server license type. </param>
        /// <param name="validationErrors"> The validation errors of the on-premise machine Value can be list of validation errors. </param>
        /// <param name="lastRpoCalculatedOn"> The last RPO calculated time. </param>
        /// <param name="lastUpdateReceivedOn"> The last update time received from on-prem components. </param>
        /// <param name="replicaId"> The replica id of the protected item. </param>
        /// <param name="osVersion"> The OS Version of the protected item. </param>
        /// <param name="protectedManagedDisks"> The list of protected managed disks. </param>
        /// <param name="lastRecoveryPointReceived"> The last recovery point received time. </param>
        /// <param name="firmwareType"> The firmware type of this protected item. </param>
        /// <param name="azureVmGeneration"> The target generation for this protected item. </param>
        /// <param name="isAdditionalStatsAvailable"> A value indicating whether additional IR stats are available or not. </param>
        /// <param name="totalDataTransferred"> The total transferred data in bytes. </param>
        /// <param name="totalProgressHealth"> The progress health. </param>
        /// <param name="targetVmTags"> The target VM tags. </param>
        /// <param name="seedManagedDiskTags"> The tags for the seed managed disks. </param>
        /// <param name="targetManagedDiskTags"> The tags for the target managed disks. </param>
        /// <param name="targetNicTags"> The tags for the target NICs. </param>
        /// <param name="switchProviderBlockingErrorDetails"> The switch provider blocking error information. </param>
        /// <param name="switchProviderDetails"> The switch provider blocking error information. </param>
        /// <param name="supportedOSVersions"> A value indicating the inplace OS Upgrade version. </param>
        /// <param name="allAvailableOSUpgradeConfigurations"> A value indicating all available inplace OS Upgrade configurations. </param>
        /// <param name="osName"> The name of the OS on the VM. </param>
        /// <returns> A new <see cref="Models.InMageAzureV2ReplicationDetails"/> instance for mocking. </returns>
        public static InMageAzureV2ReplicationDetails InMageAzureV2ReplicationDetails(string infrastructureVmId = null, string vCenterInfrastructureId = null, string protectionStage = null, string vmId = null, string vmProtectionState = null, string vmProtectionStateDescription = null, int? resyncProgressPercentage = null, long? rpoInSeconds = null, double? compressedDataRateInMB = null, double? uncompressedDataRateInMB = null, IPAddress ipAddress = null, string agentVersion = null, DateTimeOffset? agentExpireOn = null, string isAgentUpdateRequired = null, string isRebootAfterUpdateRequired = null, DateTimeOffset? lastHeartbeat = null, Guid? processServerId = null, string processServerName = null, string multiVmGroupId = null, string multiVmGroupName = null, string multiVmSyncStatus = null, IEnumerable<InMageAzureV2ProtectedDiskDetails> protectedDisks = null, string diskResized = null, string masterTargetId = null, int? sourceVmCpuCount = null, int? sourceVmRamSizeInMB = null, string osType = null, string vhdName = null, string osDiskId = null, IEnumerable<SiteRecoveryVmDiskDetails> azureVmDiskDetails = null, string recoveryAzureVmName = null, string recoveryAzureVmSize = null, string recoveryAzureStorageAccount = null, ResourceIdentifier recoveryAzureLogStorageAccountId = null, IEnumerable<VmNicDetails> vmNics = null, ResourceIdentifier selectedRecoveryAzureNetworkId = null, ResourceIdentifier selectedTfoAzureNetworkId = null, string selectedSourceNicId = null, string discoveryType = null, string enableRdpOnTargetOption = null, IEnumerable<string> datastores = null, string targetVmId = null, ResourceIdentifier recoveryAzureResourceGroupId = null, ResourceIdentifier recoveryAvailabilitySetId = null, string targetAvailabilityZone = null, ResourceIdentifier targetProximityPlacementGroupId = null, string useManagedDisks = null, string licenseType = null, string sqlServerLicenseType = null, IEnumerable<SiteRecoveryHealthError> validationErrors = null, DateTimeOffset? lastRpoCalculatedOn = null, DateTimeOffset? lastUpdateReceivedOn = null, string replicaId = null, string osVersion = null, IEnumerable<InMageAzureV2ManagedDiskDetails> protectedManagedDisks = null, DateTimeOffset? lastRecoveryPointReceived = null, string firmwareType = null, string azureVmGeneration = null, bool? isAdditionalStatsAvailable = null, long? totalDataTransferred = null, string totalProgressHealth = null, IReadOnlyDictionary<string, string> targetVmTags = null, IReadOnlyDictionary<string, string> seedManagedDiskTags = null, IReadOnlyDictionary<string, string> targetManagedDiskTags = null, IReadOnlyDictionary<string, string> targetNicTags = null, IEnumerable<InMageAzureV2SwitchProviderBlockingErrorDetails> switchProviderBlockingErrorDetails = null, InMageAzureV2SwitchProviderDetails switchProviderDetails = null, IEnumerable<string> supportedOSVersions = null, IEnumerable<OSUpgradeSupportedVersions> allAvailableOSUpgradeConfigurations = null, string osName = null)
        {
            protectedDisks ??= new List<InMageAzureV2ProtectedDiskDetails>();
            azureVmDiskDetails ??= new List<SiteRecoveryVmDiskDetails>();
            vmNics ??= new List<VmNicDetails>();
            datastores ??= new List<string>();
            validationErrors ??= new List<SiteRecoveryHealthError>();
            protectedManagedDisks ??= new List<InMageAzureV2ManagedDiskDetails>();
            targetVmTags ??= new Dictionary<string, string>();
            seedManagedDiskTags ??= new Dictionary<string, string>();
            targetManagedDiskTags ??= new Dictionary<string, string>();
            targetNicTags ??= new Dictionary<string, string>();
            switchProviderBlockingErrorDetails ??= new List<InMageAzureV2SwitchProviderBlockingErrorDetails>();
            supportedOSVersions ??= new List<string>();
            allAvailableOSUpgradeConfigurations ??= new List<OSUpgradeSupportedVersions>();

            return new InMageAzureV2ReplicationDetails(
                "InMageAzureV2",
                serializedAdditionalRawData: null,
                infrastructureVmId,
                vCenterInfrastructureId,
                protectionStage,
                vmId,
                vmProtectionState,
                vmProtectionStateDescription,
                resyncProgressPercentage,
                rpoInSeconds,
                compressedDataRateInMB,
                uncompressedDataRateInMB,
                ipAddress,
                agentVersion,
                agentExpireOn,
                isAgentUpdateRequired,
                isRebootAfterUpdateRequired,
                lastHeartbeat,
                processServerId,
                processServerName,
                multiVmGroupId,
                multiVmGroupName,
                multiVmSyncStatus,
                protectedDisks?.ToList(),
                diskResized,
                masterTargetId,
                sourceVmCpuCount,
                sourceVmRamSizeInMB,
                osType,
                vhdName,
                osDiskId,
                azureVmDiskDetails?.ToList(),
                recoveryAzureVmName,
                recoveryAzureVmSize,
                recoveryAzureStorageAccount,
                recoveryAzureLogStorageAccountId,
                vmNics?.ToList(),
                selectedRecoveryAzureNetworkId,
                selectedTfoAzureNetworkId,
                selectedSourceNicId,
                discoveryType,
                enableRdpOnTargetOption,
                datastores?.ToList(),
                targetVmId,
                recoveryAzureResourceGroupId,
                recoveryAvailabilitySetId,
                targetAvailabilityZone,
                targetProximityPlacementGroupId,
                useManagedDisks,
                licenseType,
                sqlServerLicenseType,
                validationErrors?.ToList(),
                lastRpoCalculatedOn,
                lastUpdateReceivedOn,
                replicaId,
                osVersion,
                protectedManagedDisks?.ToList(),
                lastRecoveryPointReceived,
                firmwareType,
                azureVmGeneration,
                isAdditionalStatsAvailable,
                totalDataTransferred,
                totalProgressHealth,
                targetVmTags,
                seedManagedDiskTags,
                targetManagedDiskTags,
                targetNicTags,
                switchProviderBlockingErrorDetails?.ToList(),
                switchProviderDetails,
                supportedOSVersions?.ToList(),
                allAvailableOSUpgradeConfigurations?.ToList(),
                osName);
        }

        /// <summary> Initializes a new instance of <see cref="Models.InMageAzureV2SwitchProviderBlockingErrorDetails"/>. </summary>
        /// <param name="errorCode"> The error code. </param>
        /// <param name="errorMessage"> The error message. </param>
        /// <param name="possibleCauses"> The possible causes. </param>
        /// <param name="recommendedAction"> The recommended action. </param>
        /// <param name="errorMessageParameters"> The error message parameters. </param>
        /// <param name="errorTags"> The error tags. </param>
        /// <returns> A new <see cref="Models.InMageAzureV2SwitchProviderBlockingErrorDetails"/> instance for mocking. </returns>
        public static InMageAzureV2SwitchProviderBlockingErrorDetails InMageAzureV2SwitchProviderBlockingErrorDetails(string errorCode = null, string errorMessage = null, string possibleCauses = null, string recommendedAction = null, IReadOnlyDictionary<string, string> errorMessageParameters = null, IReadOnlyDictionary<string, string> errorTags = null)
        {
            errorMessageParameters ??= new Dictionary<string, string>();
            errorTags ??= new Dictionary<string, string>();

            return new InMageAzureV2SwitchProviderBlockingErrorDetails(
                errorCode,
                errorMessage,
                possibleCauses,
                recommendedAction,
                errorMessageParameters,
                errorTags,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.InMageAzureV2SwitchProviderDetails"/>. </summary>
        /// <param name="targetVaultId"> The target vault Id. </param>
        /// <param name="targetResourceId"> The target resource Id. </param>
        /// <param name="targetFabricId"> The target fabric Id. </param>
        /// <param name="targetApplianceId"> The target appliance Id. </param>
        /// <returns> A new <see cref="Models.InMageAzureV2SwitchProviderDetails"/> instance for mocking. </returns>
        public static InMageAzureV2SwitchProviderDetails InMageAzureV2SwitchProviderDetails(ResourceIdentifier targetVaultId = null, ResourceIdentifier targetResourceId = null, ResourceIdentifier targetFabricId = null, string targetApplianceId = null)
        {
            return new InMageAzureV2SwitchProviderDetails(targetVaultId, targetResourceId, targetFabricId, targetApplianceId, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.InMageAzureV2SwitchProviderContent"/>. </summary>
        /// <param name="targetVaultId"> The target vault Id. </param>
        /// <param name="targetFabricId"> The target fabric Id. </param>
        /// <param name="targetApplianceId"> The target appliance Id. </param>
        /// <returns> A new <see cref="Models.InMageAzureV2SwitchProviderContent"/> instance for mocking. </returns>
        public static InMageAzureV2SwitchProviderContent InMageAzureV2SwitchProviderContent(ResourceIdentifier targetVaultId = null, ResourceIdentifier targetFabricId = null, string targetApplianceId = null)
        {
            return new InMageAzureV2SwitchProviderContent("InMageAzureV2", serializedAdditionalRawData: null, targetVaultId, targetFabricId, targetApplianceId);
        }

        /// <summary> Initializes a new instance of <see cref="Models.InMageBasePolicyDetails"/>. </summary>
        /// <param name="recoveryPointThresholdInMinutes"> The recovery point threshold in minutes. </param>
        /// <param name="recoveryPointHistory"> The duration in minutes until which the recovery points need to be stored. </param>
        /// <param name="appConsistentFrequencyInMinutes"> The app consistent snapshot frequency in minutes. </param>
        /// <param name="multiVmSyncStatus"> A value indicating whether multi-VM sync has to be enabled. </param>
        /// <returns> A new <see cref="Models.InMageBasePolicyDetails"/> instance for mocking. </returns>
        public static InMageBasePolicyDetails InMageBasePolicyDetails(int? recoveryPointThresholdInMinutes = null, int? recoveryPointHistory = null, int? appConsistentFrequencyInMinutes = null, string multiVmSyncStatus = null)
        {
            return new InMageBasePolicyDetails(
                "InMageBasePolicyDetails",
                serializedAdditionalRawData: null,
                recoveryPointThresholdInMinutes,
                recoveryPointHistory,
                appConsistentFrequencyInMinutes,
                multiVmSyncStatus);
        }

        /// <summary> Initializes a new instance of <see cref="Models.InMageDiskDetails"/>. </summary>
        /// <param name="diskId"> The disk Id. </param>
        /// <param name="diskName"> The disk name. </param>
        /// <param name="diskSizeInMB"> The disk size in MB. </param>
        /// <param name="diskType"> Whether disk is system disk or data disk. </param>
        /// <param name="diskConfiguration"> Whether disk is dynamic disk or basic disk. </param>
        /// <param name="volumeList"> Volumes of the disk. </param>
        /// <returns> A new <see cref="Models.InMageDiskDetails"/> instance for mocking. </returns>
        public static InMageDiskDetails InMageDiskDetails(string diskId = null, string diskName = null, string diskSizeInMB = null, string diskType = null, string diskConfiguration = null, IEnumerable<SiteRecoveryDiskVolumeDetails> volumeList = null)
        {
            volumeList ??= new List<SiteRecoveryDiskVolumeDetails>();

            return new InMageDiskDetails(
                diskId,
                diskName,
                diskSizeInMB,
                diskType,
                diskConfiguration,
                volumeList?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.InMageEnableProtectionContent"/>. </summary>
        /// <param name="vmFriendlyName"> The VM Name. </param>
        /// <param name="masterTargetId"> The Master Target Id. </param>
        /// <param name="processServerId"> The Process Server Id. </param>
        /// <param name="retentionDrive"> The retention drive to use on the MT. </param>
        /// <param name="runAsAccountId"> The CS account Id. </param>
        /// <param name="multiVmGroupId"> The multi VM group Id. </param>
        /// <param name="multiVmGroupName"> The multi VM group name. </param>
        /// <param name="datastoreName"> The target datastore name. </param>
        /// <param name="diskExclusionContent"> The enable disk exclusion input. </param>
        /// <param name="disksToInclude"> The disks to include list. </param>
        /// <returns> A new <see cref="Models.InMageEnableProtectionContent"/> instance for mocking. </returns>
        public static InMageEnableProtectionContent InMageEnableProtectionContent(string vmFriendlyName = null, string masterTargetId = null, Guid processServerId = default, string retentionDrive = null, string runAsAccountId = null, string multiVmGroupId = null, string multiVmGroupName = null, string datastoreName = null, InMageDiskExclusionContent diskExclusionContent = null, IEnumerable<string> disksToInclude = null)
        {
            disksToInclude ??= new List<string>();

            return new InMageEnableProtectionContent(
                "InMage",
                serializedAdditionalRawData: null,
                vmFriendlyName,
                masterTargetId,
                processServerId,
                retentionDrive,
                runAsAccountId,
                multiVmGroupId,
                multiVmGroupName,
                datastoreName,
                diskExclusionContent,
                disksToInclude?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.InMageFabricSwitchProviderBlockingErrorDetails"/>. </summary>
        /// <param name="errorCode"> The error code. </param>
        /// <param name="errorMessage"> The error message. </param>
        /// <param name="possibleCauses"> The possible causes. </param>
        /// <param name="recommendedAction"> The recommended action. </param>
        /// <param name="errorMessageParameters"> The error message parameters. </param>
        /// <param name="errorTags"> The error tags. </param>
        /// <returns> A new <see cref="Models.InMageFabricSwitchProviderBlockingErrorDetails"/> instance for mocking. </returns>
        public static InMageFabricSwitchProviderBlockingErrorDetails InMageFabricSwitchProviderBlockingErrorDetails(string errorCode = null, string errorMessage = null, string possibleCauses = null, string recommendedAction = null, IReadOnlyDictionary<string, string> errorMessageParameters = null, IReadOnlyDictionary<string, string> errorTags = null)
        {
            errorMessageParameters ??= new Dictionary<string, string>();
            errorTags ??= new Dictionary<string, string>();

            return new InMageFabricSwitchProviderBlockingErrorDetails(
                errorCode,
                errorMessage,
                possibleCauses,
                recommendedAction,
                errorMessageParameters,
                errorTags,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.InMagePolicyDetails"/>. </summary>
        /// <param name="recoveryPointThresholdInMinutes"> The recovery point threshold in minutes. </param>
        /// <param name="recoveryPointHistory"> The duration in minutes until which the recovery points need to be stored. </param>
        /// <param name="appConsistentFrequencyInMinutes"> The app consistent snapshot frequency in minutes. </param>
        /// <param name="multiVmSyncStatus"> A value indicating whether multi-VM sync has to be enabled. </param>
        /// <returns> A new <see cref="Models.InMagePolicyDetails"/> instance for mocking. </returns>
        public static InMagePolicyDetails InMagePolicyDetails(int? recoveryPointThresholdInMinutes = null, int? recoveryPointHistory = null, int? appConsistentFrequencyInMinutes = null, string multiVmSyncStatus = null)
        {
            return new InMagePolicyDetails(
                "InMage",
                serializedAdditionalRawData: null,
                recoveryPointThresholdInMinutes,
                recoveryPointHistory,
                appConsistentFrequencyInMinutes,
                multiVmSyncStatus);
        }

        /// <summary> Initializes a new instance of <see cref="Models.InMagePolicyContent"/>. </summary>
        /// <param name="recoveryPointThresholdInMinutes"> The recovery point threshold in minutes. </param>
        /// <param name="recoveryPointHistory"> The duration in minutes until which the recovery points need to be stored. </param>
        /// <param name="appConsistentFrequencyInMinutes"> The app consistent snapshot frequency (in minutes). </param>
        /// <param name="multiVmSyncStatus"> A value indicating whether multi-VM sync has to be enabled. Value should be 'Enabled' or 'Disabled'. </param>
        /// <returns> A new <see cref="Models.InMagePolicyContent"/> instance for mocking. </returns>
        public static InMagePolicyContent InMagePolicyContent(int? recoveryPointThresholdInMinutes = null, int? recoveryPointHistory = null, int? appConsistentFrequencyInMinutes = null, SetMultiVmSyncStatus multiVmSyncStatus = default)
        {
            return new InMagePolicyContent(
                "InMage",
                serializedAdditionalRawData: null,
                recoveryPointThresholdInMinutes,
                recoveryPointHistory,
                appConsistentFrequencyInMinutes,
                multiVmSyncStatus);
        }

        /// <summary> Initializes a new instance of <see cref="Models.InMageProtectedDiskDetails"/>. </summary>
        /// <param name="diskId"> The disk id. </param>
        /// <param name="diskName"> The disk name. </param>
        /// <param name="protectionStage"> The protection stage. </param>
        /// <param name="healthErrorCode"> The health error code for the disk. </param>
        /// <param name="rpoInSeconds"> The RPO in seconds. </param>
        /// <param name="resyncRequired"> A value indicating whether resync is required for this disk. </param>
        /// <param name="resyncProgressPercentage"> The resync progress percentage. </param>
        /// <param name="resyncDurationInSeconds"> The resync duration in seconds. </param>
        /// <param name="diskCapacityInBytes"> The disk capacity in bytes. </param>
        /// <param name="fileSystemCapacityInBytes"> The file system capacity in bytes. </param>
        /// <param name="sourceDataInMB"> The source data transit in MB. </param>
        /// <param name="psDataInMB"> The PS data transit in MB. </param>
        /// <param name="targetDataInMB"> The target data transit in MB. </param>
        /// <param name="diskResized"> A value indicating whether disk is resized. </param>
        /// <param name="lastRpoCalculatedOn"> The last RPO calculated time. </param>
        /// <param name="resyncProcessedBytes"> The resync processed bytes. </param>
        /// <param name="resyncTotalTransferredBytes"> The resync total transferred bytes. </param>
        /// <param name="resyncLast15MinutesTransferredBytes"> The resync last 15 minutes transferred bytes. </param>
        /// <param name="resyncLastDataTransferTimeUTC"> The last data transfer time in UTC. </param>
        /// <param name="resyncStartOn"> The resync start time. </param>
        /// <param name="progressHealth"> The Progress Health. </param>
        /// <param name="progressStatus"> The Progress Status. </param>
        /// <returns> A new <see cref="Models.InMageProtectedDiskDetails"/> instance for mocking. </returns>
        public static InMageProtectedDiskDetails InMageProtectedDiskDetails(string diskId = null, string diskName = null, string protectionStage = null, string healthErrorCode = null, long? rpoInSeconds = null, string resyncRequired = null, int? resyncProgressPercentage = null, long? resyncDurationInSeconds = null, long? diskCapacityInBytes = null, long? fileSystemCapacityInBytes = null, double? sourceDataInMB = null, double? psDataInMB = null, double? targetDataInMB = null, string diskResized = null, DateTimeOffset? lastRpoCalculatedOn = null, long? resyncProcessedBytes = null, long? resyncTotalTransferredBytes = null, long? resyncLast15MinutesTransferredBytes = null, DateTimeOffset? resyncLastDataTransferTimeUTC = null, DateTimeOffset? resyncStartOn = null, string progressHealth = null, string progressStatus = null)
        {
            return new InMageProtectedDiskDetails(
                diskId,
                diskName,
                protectionStage,
                healthErrorCode,
                rpoInSeconds,
                resyncRequired,
                resyncProgressPercentage,
                resyncDurationInSeconds,
                diskCapacityInBytes,
                fileSystemCapacityInBytes,
                sourceDataInMB,
                psDataInMB,
                targetDataInMB,
                diskResized,
                lastRpoCalculatedOn,
                resyncProcessedBytes,
                resyncTotalTransferredBytes,
                resyncLast15MinutesTransferredBytes,
                resyncLastDataTransferTimeUTC,
                resyncStartOn,
                progressHealth,
                progressStatus,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.InMageRcmAgentUpgradeBlockingErrorDetails"/>. </summary>
        /// <param name="errorCode"> The error code. </param>
        /// <param name="errorMessage"> The error message. </param>
        /// <param name="possibleCauses"> The possible causes. </param>
        /// <param name="recommendedAction"> The recommended action. </param>
        /// <param name="errorMessageParameters"> The error message parameters. </param>
        /// <param name="errorTags"> The error tags. </param>
        /// <returns> A new <see cref="Models.InMageRcmAgentUpgradeBlockingErrorDetails"/> instance for mocking. </returns>
        public static InMageRcmAgentUpgradeBlockingErrorDetails InMageRcmAgentUpgradeBlockingErrorDetails(string errorCode = null, string errorMessage = null, string possibleCauses = null, string recommendedAction = null, IReadOnlyDictionary<string, string> errorMessageParameters = null, IReadOnlyDictionary<string, string> errorTags = null)
        {
            errorMessageParameters ??= new Dictionary<string, string>();
            errorTags ??= new Dictionary<string, string>();

            return new InMageRcmAgentUpgradeBlockingErrorDetails(
                errorCode,
                errorMessage,
                possibleCauses,
                recommendedAction,
                errorMessageParameters,
                errorTags,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.InMageRcmApplianceDetails"/>. </summary>
        /// <param name="id"> The appliance Id. </param>
        /// <param name="name"> The appliance name. </param>
        /// <param name="fabricArmId"> The fabric ARM Id. </param>
        /// <param name="processServer"> The process server. </param>
        /// <param name="rcmProxy"> The of RCM proxy. </param>
        /// <param name="pushInstaller"> The push installer. </param>
        /// <param name="replicationAgent"> The replication agent. </param>
        /// <param name="reprotectAgent"> The reprotect agent. </param>
        /// <param name="marsAgent"> The Mars agent. </param>
        /// <param name="dra"> The DRA. </param>
        /// <param name="switchProviderBlockingErrorDetails"> The switch provider blocking error information. </param>
        /// <returns> A new <see cref="Models.InMageRcmApplianceDetails"/> instance for mocking. </returns>
        public static InMageRcmApplianceDetails InMageRcmApplianceDetails(string id = null, string name = null, ResourceIdentifier fabricArmId = null, SiteRecoveryProcessServerDetails processServer = null, RcmProxyDetails rcmProxy = null, PushInstallerDetails pushInstaller = null, ReplicationAgentDetails replicationAgent = null, ReprotectAgentDetails reprotectAgent = null, MarsAgentDetails marsAgent = null, SiteRecoveryDraDetails dra = null, IEnumerable<InMageRcmFabricSwitchProviderBlockingErrorDetails> switchProviderBlockingErrorDetails = null)
        {
            switchProviderBlockingErrorDetails ??= new List<InMageRcmFabricSwitchProviderBlockingErrorDetails>();

            return new InMageRcmApplianceDetails(
                id,
                name,
                fabricArmId,
                processServer,
                rcmProxy,
                pushInstaller,
                replicationAgent,
                reprotectAgent,
                marsAgent,
                dra,
                switchProviderBlockingErrorDetails?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SiteRecoveryProcessServerDetails"/>. </summary>
        /// <param name="id"> The process server Id. </param>
        /// <param name="name"> The process server name. </param>
        /// <param name="biosId"> The process server Bios Id. </param>
        /// <param name="fabricObjectId"> The fabric object Id. </param>
        /// <param name="fqdn"> The process server Fqdn. </param>
        /// <param name="ipAddresses"> The list of IP addresses for communicating with the RCM component. </param>
        /// <param name="version"> The version. </param>
        /// <param name="lastHeartbeatReceivedOn"> The last heartbeat received from the process server. </param>
        /// <param name="totalMemoryInBytes"> The total memory. </param>
        /// <param name="availableMemoryInBytes"> The available memory. </param>
        /// <param name="usedMemoryInBytes"> The used memory. </param>
        /// <param name="memoryUsagePercentage"> The memory usage percentage. </param>
        /// <param name="totalSpaceInBytes"> The total disk space. </param>
        /// <param name="availableSpaceInBytes"> The available disk space. </param>
        /// <param name="usedSpaceInBytes"> The used disk space. </param>
        /// <param name="freeSpacePercentage"> The free disk space percentage. </param>
        /// <param name="throughputUploadPendingDataInBytes"> The uploading pending data in bytes. </param>
        /// <param name="throughputInBytes"> The throughput in bytes. </param>
        /// <param name="processorUsagePercentage"> The processor usage percentage. </param>
        /// <param name="throughputStatus"> The throughput status. </param>
        /// <param name="systemLoad"> The system load. </param>
        /// <param name="systemLoadStatus"> The system load status. </param>
        /// <param name="diskUsageStatus"> The disk usage status. </param>
        /// <param name="memoryUsageStatus"> The memory usage status. </param>
        /// <param name="processorUsageStatus"> The processor usage status. </param>
        /// <param name="health"> The health of the process server. </param>
        /// <param name="healthErrors"> The health errors. </param>
        /// <param name="protectedItemCount"> The protected item count. </param>
        /// <param name="historicHealth"> The historic health of the process server based on the health in last 24 hours. </param>
        /// <returns> A new <see cref="Models.SiteRecoveryProcessServerDetails"/> instance for mocking. </returns>
        public static SiteRecoveryProcessServerDetails SiteRecoveryProcessServerDetails(string id = null, string name = null, string biosId = null, ResourceIdentifier fabricObjectId = null, string fqdn = null, IEnumerable<IPAddress> ipAddresses = null, string version = null, DateTimeOffset? lastHeartbeatReceivedOn = null, long? totalMemoryInBytes = null, long? availableMemoryInBytes = null, long? usedMemoryInBytes = null, double? memoryUsagePercentage = null, long? totalSpaceInBytes = null, long? availableSpaceInBytes = null, long? usedSpaceInBytes = null, double? freeSpacePercentage = null, long? throughputUploadPendingDataInBytes = null, long? throughputInBytes = null, double? processorUsagePercentage = null, RcmComponentStatus? throughputStatus = null, long? systemLoad = null, RcmComponentStatus? systemLoadStatus = null, RcmComponentStatus? diskUsageStatus = null, RcmComponentStatus? memoryUsageStatus = null, RcmComponentStatus? processorUsageStatus = null, SiteRecoveryProtectionHealth? health = null, IEnumerable<SiteRecoveryHealthError> healthErrors = null, int? protectedItemCount = null, SiteRecoveryProtectionHealth? historicHealth = null)
        {
            ipAddresses ??= new List<IPAddress>();
            healthErrors ??= new List<SiteRecoveryHealthError>();

            return new SiteRecoveryProcessServerDetails(
                id,
                name,
                biosId,
                fabricObjectId,
                fqdn,
                ipAddresses?.ToList(),
                version,
                lastHeartbeatReceivedOn,
                totalMemoryInBytes,
                availableMemoryInBytes,
                usedMemoryInBytes,
                memoryUsagePercentage,
                totalSpaceInBytes,
                availableSpaceInBytes,
                usedSpaceInBytes,
                freeSpacePercentage,
                throughputUploadPendingDataInBytes,
                throughputInBytes,
                processorUsagePercentage,
                throughputStatus,
                systemLoad,
                systemLoadStatus,
                diskUsageStatus,
                memoryUsageStatus,
                processorUsageStatus,
                health,
                healthErrors?.ToList(),
                protectedItemCount,
                historicHealth,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RcmProxyDetails"/>. </summary>
        /// <param name="id"> The RCM proxy Id. </param>
        /// <param name="name"> The RCM proxy name. </param>
        /// <param name="biosId"> The RCM proxy Bios Id. </param>
        /// <param name="fabricObjectId"> The fabric object Id. </param>
        /// <param name="fqdn"> The RCM proxy Fqdn. </param>
        /// <param name="clientAuthenticationType"> The client authentication type. </param>
        /// <param name="version"> The version. </param>
        /// <param name="lastHeartbeatReceivedOn"> The last heartbeat received from the RCM proxy. </param>
        /// <param name="health"> The health of the RCM proxy. </param>
        /// <param name="healthErrors"> The health errors. </param>
        /// <returns> A new <see cref="Models.RcmProxyDetails"/> instance for mocking. </returns>
        public static RcmProxyDetails RcmProxyDetails(string id = null, string name = null, string biosId = null, ResourceIdentifier fabricObjectId = null, string fqdn = null, string clientAuthenticationType = null, string version = null, DateTimeOffset? lastHeartbeatReceivedOn = null, SiteRecoveryProtectionHealth? health = null, IEnumerable<SiteRecoveryHealthError> healthErrors = null)
        {
            healthErrors ??= new List<SiteRecoveryHealthError>();

            return new RcmProxyDetails(
                id,
                name,
                biosId,
                fabricObjectId,
                fqdn,
                clientAuthenticationType,
                version,
                lastHeartbeatReceivedOn,
                health,
                healthErrors?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PushInstallerDetails"/>. </summary>
        /// <param name="id"> The push installer Id. </param>
        /// <param name="name"> The push installer name. </param>
        /// <param name="biosId"> The push installer Bios Id. </param>
        /// <param name="fabricObjectId"> The fabric object Id. </param>
        /// <param name="fqdn"> The push installer Fqdn. </param>
        /// <param name="version"> The version. </param>
        /// <param name="lastHeartbeatReceivedOn"> The last heartbeat received from the push installer. </param>
        /// <param name="health"> The health of the push installer. </param>
        /// <param name="healthErrors"> The health errors. </param>
        /// <returns> A new <see cref="Models.PushInstallerDetails"/> instance for mocking. </returns>
        public static PushInstallerDetails PushInstallerDetails(string id = null, string name = null, string biosId = null, ResourceIdentifier fabricObjectId = null, string fqdn = null, string version = null, DateTimeOffset? lastHeartbeatReceivedOn = null, SiteRecoveryProtectionHealth? health = null, IEnumerable<SiteRecoveryHealthError> healthErrors = null)
        {
            healthErrors ??= new List<SiteRecoveryHealthError>();

            return new PushInstallerDetails(
                id,
                name,
                biosId,
                fabricObjectId,
                fqdn,
                version,
                lastHeartbeatReceivedOn,
                health,
                healthErrors?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ReplicationAgentDetails"/>. </summary>
        /// <param name="id"> The replication agent Id. </param>
        /// <param name="name"> The replication agent name. </param>
        /// <param name="biosId"> The replication agent Bios Id. </param>
        /// <param name="fabricObjectId"> The fabric object Id. </param>
        /// <param name="fqdn"> The replication agent Fqdn. </param>
        /// <param name="version"> The version. </param>
        /// <param name="lastHeartbeatUtc"> The last heartbeat received from the replication agent. </param>
        /// <param name="health"> The health of the replication agent. </param>
        /// <param name="healthErrors"> The health errors. </param>
        /// <returns> A new <see cref="Models.ReplicationAgentDetails"/> instance for mocking. </returns>
        public static ReplicationAgentDetails ReplicationAgentDetails(string id = null, string name = null, string biosId = null, ResourceIdentifier fabricObjectId = null, string fqdn = null, string version = null, DateTimeOffset? lastHeartbeatUtc = null, SiteRecoveryProtectionHealth? health = null, IEnumerable<SiteRecoveryHealthError> healthErrors = null)
        {
            healthErrors ??= new List<SiteRecoveryHealthError>();

            return new ReplicationAgentDetails(
                id,
                name,
                biosId,
                fabricObjectId,
                fqdn,
                version,
                lastHeartbeatUtc,
                health,
                healthErrors?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ReprotectAgentDetails"/>. </summary>
        /// <param name="id"> The reprotect agent Id. </param>
        /// <param name="name"> The reprotect agent name. </param>
        /// <param name="biosId"> The reprotect agent Bios Id. </param>
        /// <param name="fabricObjectId"> The fabric object Id. </param>
        /// <param name="fqdn"> The reprotect agent Fqdn. </param>
        /// <param name="version"> The version. </param>
        /// <param name="lastHeartbeatReceivedOn"> The last heartbeat received from the reprotect agent. </param>
        /// <param name="health"> The health of the reprotect agent. </param>
        /// <param name="healthErrors"> The health errors. </param>
        /// <param name="protectedItemCount"> The protected item count. </param>
        /// <param name="accessibleDatastores"> The list of accessible datastores fetched from discovery. </param>
        /// <param name="vCenterId"> The Vcenter Id. </param>
        /// <param name="last"> The last time when SDS information discovered in SRS. </param>
        /// <returns> A new <see cref="Models.ReprotectAgentDetails"/> instance for mocking. </returns>
        public static ReprotectAgentDetails ReprotectAgentDetails(string id = null, string name = null, string biosId = null, ResourceIdentifier fabricObjectId = null, string fqdn = null, string version = null, DateTimeOffset? lastHeartbeatReceivedOn = null, SiteRecoveryProtectionHealth? health = null, IEnumerable<SiteRecoveryHealthError> healthErrors = null, int? protectedItemCount = null, IEnumerable<string> accessibleDatastores = null, string vCenterId = null, DateTimeOffset? last = null)
        {
            healthErrors ??= new List<SiteRecoveryHealthError>();
            accessibleDatastores ??= new List<string>();

            return new ReprotectAgentDetails(
                id,
                name,
                biosId,
                fabricObjectId,
                fqdn,
                version,
                lastHeartbeatReceivedOn,
                health,
                healthErrors?.ToList(),
                protectedItemCount,
                accessibleDatastores?.ToList(),
                vCenterId,
                last,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MarsAgentDetails"/>. </summary>
        /// <param name="id"> The Mars agent Id. </param>
        /// <param name="name"> The Mars agent name. </param>
        /// <param name="biosId"> The Mars agent Bios Id. </param>
        /// <param name="fabricObjectId"> The fabric object Id. </param>
        /// <param name="fqdn"> The Mars agent Fqdn. </param>
        /// <param name="version"> The version. </param>
        /// <param name="lastHeartbeatReceivedOn"> The last heartbeat received from the Mars agent. </param>
        /// <param name="health"> The health of the Mars agent. </param>
        /// <param name="healthErrors"> The health errors. </param>
        /// <returns> A new <see cref="Models.MarsAgentDetails"/> instance for mocking. </returns>
        public static MarsAgentDetails MarsAgentDetails(string id = null, string name = null, string biosId = null, ResourceIdentifier fabricObjectId = null, string fqdn = null, string version = null, DateTimeOffset? lastHeartbeatReceivedOn = null, SiteRecoveryProtectionHealth? health = null, IEnumerable<SiteRecoveryHealthError> healthErrors = null)
        {
            healthErrors ??= new List<SiteRecoveryHealthError>();

            return new MarsAgentDetails(
                id,
                name,
                biosId,
                fabricObjectId,
                fqdn,
                version,
                lastHeartbeatReceivedOn,
                health,
                healthErrors?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.InMageRcmFabricSwitchProviderBlockingErrorDetails"/>. </summary>
        /// <param name="errorCode"> The error code. </param>
        /// <param name="errorMessage"> The error message. </param>
        /// <param name="possibleCauses"> The possible causes. </param>
        /// <param name="recommendedAction"> The recommended action. </param>
        /// <param name="errorMessageParameters"> The error message parameters. </param>
        /// <param name="errorTags"> The error tags. </param>
        /// <returns> A new <see cref="Models.InMageRcmFabricSwitchProviderBlockingErrorDetails"/> instance for mocking. </returns>
        public static InMageRcmFabricSwitchProviderBlockingErrorDetails InMageRcmFabricSwitchProviderBlockingErrorDetails(string errorCode = null, string errorMessage = null, string possibleCauses = null, string recommendedAction = null, IReadOnlyDictionary<string, string> errorMessageParameters = null, IReadOnlyDictionary<string, string> errorTags = null)
        {
            errorMessageParameters ??= new Dictionary<string, string>();
            errorTags ??= new Dictionary<string, string>();

            return new InMageRcmFabricSwitchProviderBlockingErrorDetails(
                errorCode,
                errorMessage,
                possibleCauses,
                recommendedAction,
                errorMessageParameters,
                errorTags,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.InMageRcmApplianceSpecificDetails"/>. </summary>
        /// <param name="appliances"> The list of appliances. </param>
        /// <returns> A new <see cref="Models.InMageRcmApplianceSpecificDetails"/> instance for mocking. </returns>
        public static InMageRcmApplianceSpecificDetails InMageRcmApplianceSpecificDetails(IEnumerable<InMageRcmApplianceDetails> appliances = null)
        {
            appliances ??= new List<InMageRcmApplianceDetails>();

            return new InMageRcmApplianceSpecificDetails("InMageRcm", serializedAdditionalRawData: null, appliances?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.InMageRcmApplyRecoveryPointContent"/>. </summary>
        /// <param name="recoveryPointId"> The recovery point Id. </param>
        /// <returns> A new <see cref="Models.InMageRcmApplyRecoveryPointContent"/> instance for mocking. </returns>
        public static InMageRcmApplyRecoveryPointContent InMageRcmApplyRecoveryPointContent(ResourceIdentifier recoveryPointId = null)
        {
            return new InMageRcmApplyRecoveryPointContent("InMageRcm", serializedAdditionalRawData: null, recoveryPointId);
        }

        /// <summary> Initializes a new instance of <see cref="Models.InMageRcmDiscoveredProtectedVmDetails"/>. </summary>
        /// <param name="vCenterId"> The VCenter Id. </param>
        /// <param name="vCenterFqdn"> The VCenter fqdn. </param>
        /// <param name="datastores"> The list of datastores. </param>
        /// <param name="ipAddresses"> The list of IP addresses. </param>
        /// <param name="vmwareToolsStatus"> The VMware tools status. </param>
        /// <param name="powerStatus"> The VM power status. </param>
        /// <param name="vmFqdn"> The VM fqdn. </param>
        /// <param name="osName"> The VM's OS name. </param>
        /// <param name="createdOn"> The SDS created timestamp. </param>
        /// <param name="updatedOn"> The SDS updated timestamp. </param>
        /// <param name="isDeleted"> A value indicating whether the VM is deleted. </param>
        /// <param name="lastDiscoveryTimeInUtc"> The last time when SDS information discovered in SRS. </param>
        /// <returns> A new <see cref="Models.InMageRcmDiscoveredProtectedVmDetails"/> instance for mocking. </returns>
        public static InMageRcmDiscoveredProtectedVmDetails InMageRcmDiscoveredProtectedVmDetails(string vCenterId = null, string vCenterFqdn = null, IEnumerable<string> datastores = null, IEnumerable<IPAddress> ipAddresses = null, string vmwareToolsStatus = null, string powerStatus = null, string vmFqdn = null, string osName = null, DateTimeOffset? createdOn = null, DateTimeOffset? updatedOn = null, bool? isDeleted = null, DateTimeOffset? lastDiscoveryTimeInUtc = null)
        {
            datastores ??= new List<string>();
            ipAddresses ??= new List<IPAddress>();

            return new InMageRcmDiscoveredProtectedVmDetails(
                vCenterId,
                vCenterFqdn,
                datastores?.ToList(),
                ipAddresses?.ToList(),
                vmwareToolsStatus,
                powerStatus,
                vmFqdn,
                osName,
                createdOn,
                updatedOn,
                isDeleted,
                lastDiscoveryTimeInUtc,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.InMageRcmDiskContent"/>. </summary>
        /// <param name="diskId"> The disk Id. </param>
        /// <param name="logStorageAccountId"> The log storage account ARM Id. </param>
        /// <param name="diskType"> The disk type. </param>
        /// <param name="diskEncryptionSetId"> The DiskEncryptionSet ARM Id. </param>
        /// <returns> A new <see cref="Models.InMageRcmDiskContent"/> instance for mocking. </returns>
        public static InMageRcmDiskContent InMageRcmDiskContent(string diskId = null, ResourceIdentifier logStorageAccountId = null, SiteRecoveryDiskAccountType diskType = default, ResourceIdentifier diskEncryptionSetId = null)
        {
            return new InMageRcmDiskContent(diskId, logStorageAccountId, diskType, diskEncryptionSetId, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.InMageRcmDisksDefaultContent"/>. </summary>
        /// <param name="logStorageAccountId"> The log storage account ARM Id. </param>
        /// <param name="diskType"> The disk type. </param>
        /// <param name="diskEncryptionSetId"> The DiskEncryptionSet ARM Id. </param>
        /// <returns> A new <see cref="Models.InMageRcmDisksDefaultContent"/> instance for mocking. </returns>
        public static InMageRcmDisksDefaultContent InMageRcmDisksDefaultContent(ResourceIdentifier logStorageAccountId = null, SiteRecoveryDiskAccountType diskType = default, ResourceIdentifier diskEncryptionSetId = null)
        {
            return new InMageRcmDisksDefaultContent(logStorageAccountId, diskType, diskEncryptionSetId, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.InMageRcmEnableProtectionContent"/>. </summary>
        /// <param name="fabricDiscoveryMachineId"> The ARM Id of discovered machine. </param>
        /// <param name="disksToInclude"> The disks to include list. </param>
        /// <param name="disksDefault"> The default disk input. </param>
        /// <param name="targetResourceGroupId"> The target resource group ARM Id. </param>
        /// <param name="targetNetworkId"> The selected target network ARM Id. </param>
        /// <param name="testNetworkId"> The selected test network ARM Id. </param>
        /// <param name="targetSubnetName"> The selected target subnet name. </param>
        /// <param name="testSubnetName"> The selected test subnet name. </param>
        /// <param name="targetVmName"> The target VM name. </param>
        /// <param name="targetVmSize"> The target VM size. </param>
        /// <param name="licenseType"> The license type. </param>
        /// <param name="targetAvailabilitySetId"> The target availability set ARM Id. </param>
        /// <param name="targetAvailabilityZone"> The target availability zone. </param>
        /// <param name="targetProximityPlacementGroupId"> The target proximity placement group Id. </param>
        /// <param name="targetBootDiagnosticsStorageAccountId"> The target boot diagnostics storage account ARM Id. </param>
        /// <param name="runAsAccountId"> The run-as account Id. </param>
        /// <param name="processServerId"> The process server Id. </param>
        /// <param name="multiVmGroupName"> The multi VM group name. </param>
        /// <returns> A new <see cref="Models.InMageRcmEnableProtectionContent"/> instance for mocking. </returns>
        public static InMageRcmEnableProtectionContent InMageRcmEnableProtectionContent(string fabricDiscoveryMachineId = null, IEnumerable<InMageRcmDiskContent> disksToInclude = null, InMageRcmDisksDefaultContent disksDefault = null, ResourceIdentifier targetResourceGroupId = null, ResourceIdentifier targetNetworkId = null, ResourceIdentifier testNetworkId = null, string targetSubnetName = null, string testSubnetName = null, string targetVmName = null, string targetVmSize = null, SiteRecoveryLicenseType? licenseType = null, ResourceIdentifier targetAvailabilitySetId = null, string targetAvailabilityZone = null, ResourceIdentifier targetProximityPlacementGroupId = null, ResourceIdentifier targetBootDiagnosticsStorageAccountId = null, string runAsAccountId = null, Guid processServerId = default, string multiVmGroupName = null)
        {
            disksToInclude ??= new List<InMageRcmDiskContent>();

            return new InMageRcmEnableProtectionContent(
                "InMageRcm",
                serializedAdditionalRawData: null,
                fabricDiscoveryMachineId,
                disksToInclude?.ToList(),
                disksDefault,
                targetResourceGroupId,
                targetNetworkId,
                testNetworkId,
                targetSubnetName,
                testSubnetName,
                targetVmName,
                targetVmSize,
                licenseType,
                targetAvailabilitySetId,
                targetAvailabilityZone,
                targetProximityPlacementGroupId,
                targetBootDiagnosticsStorageAccountId,
                runAsAccountId,
                processServerId,
                multiVmGroupName);
        }

        /// <summary> Initializes a new instance of <see cref="Models.InMageRcmEventDetails"/>. </summary>
        /// <param name="protectedItemName"> The protected item name. </param>
        /// <param name="vmName"> The protected item name. </param>
        /// <param name="latestAgentVersion"> The latest agent version. </param>
        /// <param name="jobId"> The job Id. </param>
        /// <param name="fabricName"> The fabric name. </param>
        /// <param name="applianceName"> The appliance name. </param>
        /// <param name="serverType"> The server type. </param>
        /// <param name="componentDisplayName"> The component display name. </param>
        /// <returns> A new <see cref="Models.InMageRcmEventDetails"/> instance for mocking. </returns>
        public static InMageRcmEventDetails InMageRcmEventDetails(string protectedItemName = null, string vmName = null, string latestAgentVersion = null, ResourceIdentifier jobId = null, string fabricName = null, string applianceName = null, string serverType = null, string componentDisplayName = null)
        {
            return new InMageRcmEventDetails(
                "InMageRcm",
                serializedAdditionalRawData: null,
                protectedItemName,
                vmName,
                latestAgentVersion,
                jobId,
                fabricName,
                applianceName,
                serverType,
                componentDisplayName);
        }

        /// <summary> Initializes a new instance of <see cref="Models.InMageRcmFabricCreationContent"/>. </summary>
        /// <param name="vmwareSiteId"> The ARM Id of the VMware site. </param>
        /// <param name="physicalSiteId"> The ARM Id of the physical site. </param>
        /// <param name="sourceAgentIdentity"> The identity provider input for source agent authentication. </param>
        /// <returns> A new <see cref="Models.InMageRcmFabricCreationContent"/> instance for mocking. </returns>
        public static InMageRcmFabricCreationContent InMageRcmFabricCreationContent(ResourceIdentifier vmwareSiteId = null, ResourceIdentifier physicalSiteId = null, IdentityProviderContent sourceAgentIdentity = null)
        {
            return new InMageRcmFabricCreationContent("InMageRcm", serializedAdditionalRawData: null, vmwareSiteId, physicalSiteId, sourceAgentIdentity);
        }

        /// <summary> Initializes a new instance of <see cref="Models.InMageRcmFabricSpecificDetails"/>. </summary>
        /// <param name="vmwareSiteId"> The ARM Id of the VMware site. </param>
        /// <param name="physicalSiteId"> The ARM Id of the physical site. </param>
        /// <param name="serviceEndpoint"> The service endpoint. </param>
        /// <param name="serviceResourceId"> The service resource Id. </param>
        /// <param name="serviceContainerId"> The service container Id. </param>
        /// <param name="dataPlaneUri"> The data plane Uri. </param>
        /// <param name="controlPlaneUri"> The control plane Uri. </param>
        /// <param name="sourceAgentIdentityDetails"> The source agent identity details. </param>
        /// <param name="processServers"> The list of process servers. </param>
        /// <param name="rcmProxies"> The list of RCM proxies. </param>
        /// <param name="pushInstallers"> The list of push installers. </param>
        /// <param name="replicationAgents"> The list of replication agents. </param>
        /// <param name="reprotectAgents"> The list of reprotect agents. </param>
        /// <param name="marsAgents"> The list of Mars agents. </param>
        /// <param name="dras"> The list of DRAs. </param>
        /// <param name="agentDetails"> The list of agent details. </param>
        /// <returns> A new <see cref="Models.InMageRcmFabricSpecificDetails"/> instance for mocking. </returns>
        public static InMageRcmFabricSpecificDetails InMageRcmFabricSpecificDetails(ResourceIdentifier vmwareSiteId = null, ResourceIdentifier physicalSiteId = null, string serviceEndpoint = null, ResourceIdentifier serviceResourceId = null, string serviceContainerId = null, Uri dataPlaneUri = null, Uri controlPlaneUri = null, IdentityProviderDetails sourceAgentIdentityDetails = null, IEnumerable<SiteRecoveryProcessServerDetails> processServers = null, IEnumerable<RcmProxyDetails> rcmProxies = null, IEnumerable<PushInstallerDetails> pushInstallers = null, IEnumerable<ReplicationAgentDetails> replicationAgents = null, IEnumerable<ReprotectAgentDetails> reprotectAgents = null, IEnumerable<MarsAgentDetails> marsAgents = null, IEnumerable<SiteRecoveryDraDetails> dras = null, IEnumerable<SiteRecoveryAgentDetails> agentDetails = null)
        {
            processServers ??= new List<SiteRecoveryProcessServerDetails>();
            rcmProxies ??= new List<RcmProxyDetails>();
            pushInstallers ??= new List<PushInstallerDetails>();
            replicationAgents ??= new List<ReplicationAgentDetails>();
            reprotectAgents ??= new List<ReprotectAgentDetails>();
            marsAgents ??= new List<MarsAgentDetails>();
            dras ??= new List<SiteRecoveryDraDetails>();
            agentDetails ??= new List<SiteRecoveryAgentDetails>();

            return new InMageRcmFabricSpecificDetails(
                "InMageRcm",
                serializedAdditionalRawData: null,
                vmwareSiteId,
                physicalSiteId,
                serviceEndpoint,
                serviceResourceId,
                serviceContainerId,
                dataPlaneUri,
                controlPlaneUri,
                sourceAgentIdentityDetails,
                processServers?.ToList(),
                rcmProxies?.ToList(),
                pushInstallers?.ToList(),
                replicationAgents?.ToList(),
                reprotectAgents?.ToList(),
                marsAgents?.ToList(),
                dras?.ToList(),
                agentDetails?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.InMageRcmFailbackDiscoveredProtectedVmDetails"/>. </summary>
        /// <param name="vCenterId"> The VCenter Id. </param>
        /// <param name="vCenterFqdn"> The VCenter fqdn. </param>
        /// <param name="datastores"> The list of datastores. </param>
        /// <param name="ipAddresses"> The list of IP addresses. </param>
        /// <param name="vmwareToolsStatus"> The VMware tools status. </param>
        /// <param name="powerStatus"> The VM power status. </param>
        /// <param name="vmFqdn"> The VM fqdn. </param>
        /// <param name="osName"> The VM's OS name. </param>
        /// <param name="createdOn"> The SDS created timestamp. </param>
        /// <param name="updatedOn"> The SDS updated timestamp. </param>
        /// <param name="isDeleted"> A value indicating whether the VM is deleted. </param>
        /// <param name="lastDiscoveredOn"> The last time when SDS information discovered in SRS. </param>
        /// <returns> A new <see cref="Models.InMageRcmFailbackDiscoveredProtectedVmDetails"/> instance for mocking. </returns>
        public static InMageRcmFailbackDiscoveredProtectedVmDetails InMageRcmFailbackDiscoveredProtectedVmDetails(string vCenterId = null, string vCenterFqdn = null, IEnumerable<string> datastores = null, IEnumerable<IPAddress> ipAddresses = null, string vmwareToolsStatus = null, string powerStatus = null, string vmFqdn = null, string osName = null, DateTimeOffset? createdOn = null, DateTimeOffset? updatedOn = null, bool? isDeleted = null, DateTimeOffset? lastDiscoveredOn = null)
        {
            datastores ??= new List<string>();
            ipAddresses ??= new List<IPAddress>();

            return new InMageRcmFailbackDiscoveredProtectedVmDetails(
                vCenterId,
                vCenterFqdn,
                datastores?.ToList(),
                ipAddresses?.ToList(),
                vmwareToolsStatus,
                powerStatus,
                vmFqdn,
                osName,
                createdOn,
                updatedOn,
                isDeleted,
                lastDiscoveredOn,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.InMageRcmFailbackEventDetails"/>. </summary>
        /// <param name="protectedItemName"> The protected item name. </param>
        /// <param name="vmName"> The protected item name. </param>
        /// <param name="applianceName"> The appliance name. </param>
        /// <param name="serverType"> The server type. </param>
        /// <param name="componentDisplayName"> The component display name. </param>
        /// <returns> A new <see cref="Models.InMageRcmFailbackEventDetails"/> instance for mocking. </returns>
        public static InMageRcmFailbackEventDetails InMageRcmFailbackEventDetails(string protectedItemName = null, string vmName = null, string applianceName = null, string serverType = null, string componentDisplayName = null)
        {
            return new InMageRcmFailbackEventDetails(
                "InMageRcmFailback",
                serializedAdditionalRawData: null,
                protectedItemName,
                vmName,
                applianceName,
                serverType,
                componentDisplayName);
        }

        /// <summary> Initializes a new instance of <see cref="Models.InMageRcmFailbackMobilityAgentDetails"/>. </summary>
        /// <param name="version"> The agent version. </param>
        /// <param name="latestVersion"> The latest agent version available. </param>
        /// <param name="driverVersion"> The driver version. </param>
        /// <param name="latestUpgradableVersionWithoutReboot"> The latest upgradeable version available without reboot. </param>
        /// <param name="agentVersionExpireOn"> The agent version expiry date. </param>
        /// <param name="driverVersionExpireOn"> The driver version expiry date. </param>
        /// <param name="lastHeartbeatReceivedOn"> The time of the last heartbeat received from the agent. </param>
        /// <param name="reasonsBlockingUpgrade"> The whether update is possible or not. </param>
        /// <param name="isUpgradeable"> A value indicating whether agent is upgradeable or not. </param>
        /// <returns> A new <see cref="Models.InMageRcmFailbackMobilityAgentDetails"/> instance for mocking. </returns>
        public static InMageRcmFailbackMobilityAgentDetails InMageRcmFailbackMobilityAgentDetails(string version = null, string latestVersion = null, string driverVersion = null, string latestUpgradableVersionWithoutReboot = null, DateTimeOffset? agentVersionExpireOn = null, DateTimeOffset? driverVersionExpireOn = null, DateTimeOffset? lastHeartbeatReceivedOn = null, IEnumerable<AgentUpgradeBlockedReason> reasonsBlockingUpgrade = null, string isUpgradeable = null)
        {
            reasonsBlockingUpgrade ??= new List<AgentUpgradeBlockedReason>();

            return new InMageRcmFailbackMobilityAgentDetails(
                version,
                latestVersion,
                driverVersion,
                latestUpgradableVersionWithoutReboot,
                agentVersionExpireOn,
                driverVersionExpireOn,
                lastHeartbeatReceivedOn,
                reasonsBlockingUpgrade?.ToList(),
                isUpgradeable,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.InMageRcmFailbackNicDetails"/>. </summary>
        /// <param name="macAddress"> The mac address. </param>
        /// <param name="networkName"> The network name. </param>
        /// <param name="adapterType"> The adapter type. </param>
        /// <param name="sourceIPAddress"> The IP address. </param>
        /// <returns> A new <see cref="Models.InMageRcmFailbackNicDetails"/> instance for mocking. </returns>
        public static InMageRcmFailbackNicDetails InMageRcmFailbackNicDetails(string macAddress = null, string networkName = null, string adapterType = null, IPAddress sourceIPAddress = null)
        {
            return new InMageRcmFailbackNicDetails(macAddress, networkName, adapterType, sourceIPAddress, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.InMageRcmFailbackPlannedFailoverProviderContent"/>. </summary>
        /// <param name="recoveryPointType"> The recovery point type. </param>
        /// <returns> A new <see cref="Models.InMageRcmFailbackPlannedFailoverProviderContent"/> instance for mocking. </returns>
        public static InMageRcmFailbackPlannedFailoverProviderContent InMageRcmFailbackPlannedFailoverProviderContent(InMageRcmFailbackRecoveryPointType recoveryPointType = default)
        {
            return new InMageRcmFailbackPlannedFailoverProviderContent("InMageRcmFailback", serializedAdditionalRawData: null, recoveryPointType);
        }

        /// <summary> Initializes a new instance of <see cref="Models.InMageRcmFailbackPolicyDetails"/>. </summary>
        /// <param name="appConsistentFrequencyInMinutes"> The app consistent snapshot frequency in minutes. </param>
        /// <param name="crashConsistentFrequencyInMinutes"> The crash consistent snapshot frequency in minutes. </param>
        /// <returns> A new <see cref="Models.InMageRcmFailbackPolicyDetails"/> instance for mocking. </returns>
        public static InMageRcmFailbackPolicyDetails InMageRcmFailbackPolicyDetails(int? appConsistentFrequencyInMinutes = null, int? crashConsistentFrequencyInMinutes = null)
        {
            return new InMageRcmFailbackPolicyDetails("InMageRcmFailback", serializedAdditionalRawData: null, appConsistentFrequencyInMinutes, crashConsistentFrequencyInMinutes);
        }

        /// <summary> Initializes a new instance of <see cref="Models.InMageRcmFailbackProtectedDiskDetails"/>. </summary>
        /// <param name="diskId"> The disk Id (reported by source agent). </param>
        /// <param name="diskName"> The disk name. </param>
        /// <param name="isOSDisk"> A value indicating whether the disk is the OS disk. </param>
        /// <param name="capacityInBytes"> The disk capacity in bytes. </param>
        /// <param name="diskUuid"> The disk Uuid (reported by vCenter). </param>
        /// <param name="dataPendingInLogDataStoreInMB"> The data pending in log data store in MB. </param>
        /// <param name="dataPendingAtSourceAgentInMB"> The data pending at source agent in MB. </param>
        /// <param name="isInitialReplicationComplete"> A value indicating whether initial replication is complete or not. </param>
        /// <param name="irDetails"> The initial replication details. </param>
        /// <param name="resyncDetails"> The resync details. </param>
        /// <param name="lastSyncedOn"> The last sync time. </param>
        /// <returns> A new <see cref="Models.InMageRcmFailbackProtectedDiskDetails"/> instance for mocking. </returns>
        public static InMageRcmFailbackProtectedDiskDetails InMageRcmFailbackProtectedDiskDetails(string diskId = null, string diskName = null, string isOSDisk = null, long? capacityInBytes = null, string diskUuid = null, double? dataPendingInLogDataStoreInMB = null, double? dataPendingAtSourceAgentInMB = null, string isInitialReplicationComplete = null, InMageRcmFailbackSyncDetails irDetails = null, InMageRcmFailbackSyncDetails resyncDetails = null, DateTimeOffset? lastSyncedOn = null)
        {
            return new InMageRcmFailbackProtectedDiskDetails(
                diskId,
                diskName,
                isOSDisk,
                capacityInBytes,
                diskUuid,
                dataPendingInLogDataStoreInMB,
                dataPendingAtSourceAgentInMB,
                isInitialReplicationComplete,
                irDetails,
                resyncDetails,
                lastSyncedOn,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.InMageRcmFailbackSyncDetails"/>. </summary>
        /// <param name="progressHealth"> The progress health. </param>
        /// <param name="transferredBytes"> The transferred bytes from source VM to azure for the disk. </param>
        /// <param name="last15MinutesTransferredBytes"> The bytes transferred in last 15 minutes from source VM to target. </param>
        /// <param name="lastDataTransferOn"> The time of the last data transfer from source VM to target. </param>
        /// <param name="processedBytes"> The total processed bytes. This includes bytes that are transferred from source VM to target and matched bytes. </param>
        /// <param name="startOn"> The start time. </param>
        /// <param name="lastRefreshedOn"> The last refresh time. </param>
        /// <param name="progressPercentage"> Progress in percentage. Progress percentage is calculated based on processed bytes. </param>
        /// <returns> A new <see cref="Models.InMageRcmFailbackSyncDetails"/> instance for mocking. </returns>
        public static InMageRcmFailbackSyncDetails InMageRcmFailbackSyncDetails(SiteRecoveryDiskReplicationProgressHealth? progressHealth = null, long? transferredBytes = null, long? last15MinutesTransferredBytes = null, DateTimeOffset? lastDataTransferOn = null, long? processedBytes = null, DateTimeOffset? startOn = null, DateTimeOffset? lastRefreshedOn = null, int? progressPercentage = null)
        {
            return new InMageRcmFailbackSyncDetails(
                progressHealth,
                transferredBytes,
                last15MinutesTransferredBytes,
                lastDataTransferOn,
                processedBytes,
                startOn,
                lastRefreshedOn,
                progressPercentage,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.InMageRcmFailbackReplicationDetails"/>. </summary>
        /// <param name="internalIdentifier"> The virtual machine internal identifier. </param>
        /// <param name="azureVirtualMachineId"> The ARM Id of the azure VM. </param>
        /// <param name="multiVmGroupName"> The multi VM group name. </param>
        /// <param name="reprotectAgentId"> The reprotect agent Id. </param>
        /// <param name="reprotectAgentName"> The reprotect agent name. </param>
        /// <param name="osType"> The type of the OS on the VM. </param>
        /// <param name="logStorageAccountId"> The log storage account ARM Id. </param>
        /// <param name="targetVCenterId"> The target vCenter Id. </param>
        /// <param name="targetDataStoreName"> The target datastore name. </param>
        /// <param name="targetVmName"> The target VM name. </param>
        /// <param name="initialReplicationProgressPercentage"> The initial replication progress percentage. </param>
        /// <param name="initialReplicationProcessedBytes"> The initial replication processed bytes. This includes sum of total bytes transferred and matched bytes on all selected disks in source VM. </param>
        /// <param name="initialReplicationTransferredBytes"> The initial replication transferred bytes from source VM to target for all selected disks on source VM. </param>
        /// <param name="initialReplicationProgressHealth"> The initial replication progress health. </param>
        /// <param name="resyncProgressPercentage"> The resync progress percentage. </param>
        /// <param name="resyncProcessedBytes"> The resync processed bytes. This includes sum of total bytes transferred and matched bytes on all selected disks in source VM. </param>
        /// <param name="resyncTransferredBytes"> The resync transferred bytes from source VM to target for all selected disks on source VM. </param>
        /// <param name="resyncProgressHealth"> The resync progress health. </param>
        /// <param name="resyncRequired"> A value indicating whether resync is required. </param>
        /// <param name="resyncState"> The resync state. </param>
        /// <param name="protectedDisks"> The list of protected disks. </param>
        /// <param name="mobilityAgentDetails"> The mobility agent information. </param>
        /// <param name="vmNics"> The network details. </param>
        /// <param name="lastPlannedFailoverStartOn"> The last planned failover start time. </param>
        /// <param name="lastPlannedFailoverStatus"> The last planned failover status. </param>
        /// <param name="discoveredVmDetails"> The discovered VM information. </param>
        /// <param name="lastUsedPolicyId"> The policy Id used by the forward replication. </param>
        /// <param name="lastUsedPolicyFriendlyName"> The policy friendly name used by the forward replication. </param>
        /// <param name="isAgentRegistrationSuccessfulAfterFailover"> A value indicating whether agent registration was successful after failover. </param>
        /// <returns> A new <see cref="Models.InMageRcmFailbackReplicationDetails"/> instance for mocking. </returns>
        public static InMageRcmFailbackReplicationDetails InMageRcmFailbackReplicationDetails(string internalIdentifier = null, ResourceIdentifier azureVirtualMachineId = null, string multiVmGroupName = null, string reprotectAgentId = null, string reprotectAgentName = null, string osType = null, ResourceIdentifier logStorageAccountId = null, string targetVCenterId = null, string targetDataStoreName = null, string targetVmName = null, int? initialReplicationProgressPercentage = null, long? initialReplicationProcessedBytes = null, long? initialReplicationTransferredBytes = null, VmReplicationProgressHealth? initialReplicationProgressHealth = null, int? resyncProgressPercentage = null, long? resyncProcessedBytes = null, long? resyncTransferredBytes = null, VmReplicationProgressHealth? resyncProgressHealth = null, string resyncRequired = null, SiteRecoveryResyncState? resyncState = null, IEnumerable<InMageRcmFailbackProtectedDiskDetails> protectedDisks = null, InMageRcmFailbackMobilityAgentDetails mobilityAgentDetails = null, IEnumerable<InMageRcmFailbackNicDetails> vmNics = null, DateTimeOffset? lastPlannedFailoverStartOn = null, PlannedFailoverStatus? lastPlannedFailoverStatus = null, InMageRcmFailbackDiscoveredProtectedVmDetails discoveredVmDetails = null, ResourceIdentifier lastUsedPolicyId = null, string lastUsedPolicyFriendlyName = null, bool? isAgentRegistrationSuccessfulAfterFailover = null)
        {
            protectedDisks ??= new List<InMageRcmFailbackProtectedDiskDetails>();
            vmNics ??= new List<InMageRcmFailbackNicDetails>();

            return new InMageRcmFailbackReplicationDetails(
                "InMageRcmFailback",
                serializedAdditionalRawData: null,
                internalIdentifier,
                azureVirtualMachineId,
                multiVmGroupName,
                reprotectAgentId,
                reprotectAgentName,
                osType,
                logStorageAccountId,
                targetVCenterId,
                targetDataStoreName,
                targetVmName,
                initialReplicationProgressPercentage,
                initialReplicationProcessedBytes,
                initialReplicationTransferredBytes,
                initialReplicationProgressHealth,
                resyncProgressPercentage,
                resyncProcessedBytes,
                resyncTransferredBytes,
                resyncProgressHealth,
                resyncRequired,
                resyncState,
                protectedDisks?.ToList(),
                mobilityAgentDetails,
                vmNics?.ToList(),
                lastPlannedFailoverStartOn,
                lastPlannedFailoverStatus,
                discoveredVmDetails,
                lastUsedPolicyId,
                lastUsedPolicyFriendlyName,
                isAgentRegistrationSuccessfulAfterFailover);
        }

        /// <summary> Initializes a new instance of <see cref="Models.InMageRcmFailbackReprotectContent"/>. </summary>
        /// <param name="processServerId"> The process server Id. </param>
        /// <param name="runAsAccountId"> The run as account Id. </param>
        /// <param name="policyId"> The Policy Id. </param>
        /// <returns> A new <see cref="Models.InMageRcmFailbackReprotectContent"/> instance for mocking. </returns>
        public static InMageRcmFailbackReprotectContent InMageRcmFailbackReprotectContent(Guid processServerId = default, string runAsAccountId = null, ResourceIdentifier policyId = null)
        {
            return new InMageRcmFailbackReprotectContent("InMageRcmFailback", serializedAdditionalRawData: null, processServerId, runAsAccountId, policyId);
        }

        /// <summary> Initializes a new instance of <see cref="Models.InMageRcmLastAgentUpgradeErrorDetails"/>. </summary>
        /// <param name="errorCode"> The error code. </param>
        /// <param name="errorMessage"> The error message. </param>
        /// <param name="possibleCauses"> The possible causes. </param>
        /// <param name="recommendedAction"> The recommended action. </param>
        /// <param name="errorMessageParameters"> The error message parameters. </param>
        /// <param name="errorTags"> The error tags. </param>
        /// <returns> A new <see cref="Models.InMageRcmLastAgentUpgradeErrorDetails"/> instance for mocking. </returns>
        public static InMageRcmLastAgentUpgradeErrorDetails InMageRcmLastAgentUpgradeErrorDetails(string errorCode = null, string errorMessage = null, string possibleCauses = null, string recommendedAction = null, IReadOnlyDictionary<string, string> errorMessageParameters = null, IReadOnlyDictionary<string, string> errorTags = null)
        {
            errorMessageParameters ??= new Dictionary<string, string>();
            errorTags ??= new Dictionary<string, string>();

            return new InMageRcmLastAgentUpgradeErrorDetails(
                errorCode,
                errorMessage,
                possibleCauses,
                recommendedAction,
                errorMessageParameters,
                errorTags,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.InMageRcmMobilityAgentDetails"/>. </summary>
        /// <param name="version"> The agent version. </param>
        /// <param name="latestVersion"> The latest agent version available. </param>
        /// <param name="latestAgentReleaseDate"> The latest agent version release date. </param>
        /// <param name="driverVersion"> The driver version. </param>
        /// <param name="latestUpgradableVersionWithoutReboot"> The latest upgradeable version available without reboot. </param>
        /// <param name="agentVersionExpireOn"> The agent version expiry date. </param>
        /// <param name="driverVersionExpireOn"> The driver version expiry date. </param>
        /// <param name="lastHeartbeatReceivedOn"> The time of the last heartbeat received from the agent. </param>
        /// <param name="reasonsBlockingUpgrade"> The whether update is possible or not. </param>
        /// <param name="isUpgradeable"> A value indicating whether agent is upgradeable or not. </param>
        /// <returns> A new <see cref="Models.InMageRcmMobilityAgentDetails"/> instance for mocking. </returns>
        public static InMageRcmMobilityAgentDetails InMageRcmMobilityAgentDetails(string version = null, string latestVersion = null, string latestAgentReleaseDate = null, string driverVersion = null, string latestUpgradableVersionWithoutReboot = null, DateTimeOffset? agentVersionExpireOn = null, DateTimeOffset? driverVersionExpireOn = null, DateTimeOffset? lastHeartbeatReceivedOn = null, IEnumerable<AgentUpgradeBlockedReason> reasonsBlockingUpgrade = null, string isUpgradeable = null)
        {
            reasonsBlockingUpgrade ??= new List<AgentUpgradeBlockedReason>();

            return new InMageRcmMobilityAgentDetails(
                version,
                latestVersion,
                latestAgentReleaseDate,
                driverVersion,
                latestUpgradableVersionWithoutReboot,
                agentVersionExpireOn,
                driverVersionExpireOn,
                lastHeartbeatReceivedOn,
                reasonsBlockingUpgrade?.ToList(),
                isUpgradeable,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.InMageRcmNicDetails"/>. </summary>
        /// <param name="nicId"> The NIC Id. </param>
        /// <param name="isPrimaryNic"> A value indicating whether this is the primary NIC. </param>
        /// <param name="isSelectedForFailover"> A value indicating whether this NIC is selected for failover. </param>
        /// <param name="sourceIPAddress"> The source IP address. </param>
        /// <param name="sourceIPAddressType"> The source IP address type. </param>
        /// <param name="sourceNetworkId"> Source network Id. </param>
        /// <param name="sourceSubnetName"> Source subnet name. </param>
        /// <param name="targetIPAddress"> The target IP address. </param>
        /// <param name="targetIPAddressType"> The target IP address type. </param>
        /// <param name="targetSubnetName"> Target subnet name. </param>
        /// <param name="testSubnetName"> Test subnet name. </param>
        /// <param name="testIPAddress"> The test IP address. </param>
        /// <param name="testIPAddressType"> The test IP address type. </param>
        /// <returns> A new <see cref="Models.InMageRcmNicDetails"/> instance for mocking. </returns>
        public static InMageRcmNicDetails InMageRcmNicDetails(string nicId = null, string isPrimaryNic = null, string isSelectedForFailover = null, IPAddress sourceIPAddress = null, SiteRecoveryEthernetAddressType? sourceIPAddressType = null, ResourceIdentifier sourceNetworkId = null, string sourceSubnetName = null, IPAddress targetIPAddress = null, SiteRecoveryEthernetAddressType? targetIPAddressType = null, string targetSubnetName = null, string testSubnetName = null, IPAddress testIPAddress = null, SiteRecoveryEthernetAddressType? testIPAddressType = null)
        {
            return new InMageRcmNicDetails(
                nicId,
                isPrimaryNic,
                isSelectedForFailover,
                sourceIPAddress,
                sourceIPAddressType,
                sourceNetworkId,
                sourceSubnetName,
                targetIPAddress,
                targetIPAddressType,
                targetSubnetName,
                testSubnetName,
                testIPAddress,
                testIPAddressType,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.InMageRcmNicContent"/>. </summary>
        /// <param name="nicId"> The NIC Id. </param>
        /// <param name="isPrimaryNic"> A value indicating whether this is the primary NIC. </param>
        /// <param name="isSelectedForFailover"> A value indicating whether this NIC is selected for failover. </param>
        /// <param name="targetSubnetName"> Target subnet name. </param>
        /// <param name="targetStaticIPAddress"> The target static IP address. </param>
        /// <param name="testSubnetName"> The test subnet name. </param>
        /// <param name="testStaticIPAddress"> The test static IP address. </param>
        /// <returns> A new <see cref="Models.InMageRcmNicContent"/> instance for mocking. </returns>
        public static InMageRcmNicContent InMageRcmNicContent(string nicId = null, string isPrimaryNic = null, string isSelectedForFailover = null, string targetSubnetName = null, IPAddress targetStaticIPAddress = null, string testSubnetName = null, IPAddress testStaticIPAddress = null)
        {
            return new InMageRcmNicContent(
                nicId,
                isPrimaryNic,
                isSelectedForFailover,
                targetSubnetName,
                targetStaticIPAddress,
                testSubnetName,
                testStaticIPAddress,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.InMageRcmPolicyDetails"/>. </summary>
        /// <param name="recoveryPointHistoryInMinutes"> The duration in minutes until which the recovery points need to be stored. </param>
        /// <param name="appConsistentFrequencyInMinutes"> The app consistent snapshot frequency in minutes. </param>
        /// <param name="crashConsistentFrequencyInMinutes"> The crash consistent snapshot frequency in minutes. </param>
        /// <param name="enableMultiVmSync"> A value indicating whether multi-VM sync has to be enabled. </param>
        /// <returns> A new <see cref="Models.InMageRcmPolicyDetails"/> instance for mocking. </returns>
        public static InMageRcmPolicyDetails InMageRcmPolicyDetails(int? recoveryPointHistoryInMinutes = null, int? appConsistentFrequencyInMinutes = null, int? crashConsistentFrequencyInMinutes = null, string enableMultiVmSync = null)
        {
            return new InMageRcmPolicyDetails(
                "InMageRcm",
                serializedAdditionalRawData: null,
                recoveryPointHistoryInMinutes,
                appConsistentFrequencyInMinutes,
                crashConsistentFrequencyInMinutes,
                enableMultiVmSync);
        }

        /// <summary> Initializes a new instance of <see cref="Models.InMageRcmProtectedDiskDetails"/>. </summary>
        /// <param name="diskId"> The disk Id. </param>
        /// <param name="diskName"> The disk name. </param>
        /// <param name="isOSDisk"> A value indicating whether the disk is the OS disk. </param>
        /// <param name="capacityInBytes"> The disk capacity in bytes. </param>
        /// <param name="logStorageAccountId"> The log storage account ARM Id. </param>
        /// <param name="diskEncryptionSetId"> The DiskEncryptionSet ARM Id. </param>
        /// <param name="seedManagedDiskId"> The ARM Id of the seed managed disk. </param>
        /// <param name="seedBlobUri"> The uri of the seed blob. </param>
        /// <param name="targetManagedDiskId"> The ARM Id of the target managed disk. </param>
        /// <param name="diskType"> The disk type. </param>
        /// <param name="dataPendingInLogDataStoreInMB"> The data pending in log data store in MB. </param>
        /// <param name="dataPendingAtSourceAgentInMB"> The data pending at source agent in MB. </param>
        /// <param name="isInitialReplicationComplete"> A value indicating whether initial replication is complete or not. </param>
        /// <param name="irDetails"> The initial replication details. </param>
        /// <param name="resyncDetails"> The resync details. </param>
        /// <returns> A new <see cref="Models.InMageRcmProtectedDiskDetails"/> instance for mocking. </returns>
        public static InMageRcmProtectedDiskDetails InMageRcmProtectedDiskDetails(string diskId = null, string diskName = null, string isOSDisk = null, long? capacityInBytes = null, ResourceIdentifier logStorageAccountId = null, ResourceIdentifier diskEncryptionSetId = null, string seedManagedDiskId = null, Uri seedBlobUri = null, string targetManagedDiskId = null, SiteRecoveryDiskAccountType? diskType = null, double? dataPendingInLogDataStoreInMB = null, double? dataPendingAtSourceAgentInMB = null, string isInitialReplicationComplete = null, InMageRcmSyncDetails irDetails = null, InMageRcmSyncDetails resyncDetails = null)
        {
            return new InMageRcmProtectedDiskDetails(
                diskId,
                diskName,
                isOSDisk,
                capacityInBytes,
                logStorageAccountId,
                diskEncryptionSetId,
                seedManagedDiskId,
                seedBlobUri,
                targetManagedDiskId,
                diskType,
                dataPendingInLogDataStoreInMB,
                dataPendingAtSourceAgentInMB,
                isInitialReplicationComplete,
                irDetails,
                resyncDetails,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.InMageRcmSyncDetails"/>. </summary>
        /// <param name="progressHealth"> The progress health. </param>
        /// <param name="transferredBytes"> The transferred bytes from source VM to azure for the disk. </param>
        /// <param name="last15MinutesTransferredBytes"> The bytes transferred in last 15 minutes from source VM to azure. </param>
        /// <param name="lastDataTransferTimeUtc"> The time of the last data transfer from source VM to azure. </param>
        /// <param name="processedBytes"> The total processed bytes. This includes bytes that are transferred from source VM to azure and matched bytes. </param>
        /// <param name="staStartOn"> The start time. </param>
        /// <param name="lastRefreshedOn"> The last refresh time. </param>
        /// <param name="progressPercentage"> Progress in percentage. Progress percentage is calculated based on processed bytes. </param>
        /// <returns> A new <see cref="Models.InMageRcmSyncDetails"/> instance for mocking. </returns>
        public static InMageRcmSyncDetails InMageRcmSyncDetails(SiteRecoveryDiskReplicationProgressHealth? progressHealth = null, long? transferredBytes = null, long? last15MinutesTransferredBytes = null, string lastDataTransferTimeUtc = null, long? processedBytes = null, DateTimeOffset? staStartOn = null, DateTimeOffset? lastRefreshedOn = null, int? progressPercentage = null)
        {
            return new InMageRcmSyncDetails(
                progressHealth,
                transferredBytes,
                last15MinutesTransferredBytes,
                lastDataTransferTimeUtc,
                processedBytes,
                staStartOn,
                lastRefreshedOn,
                progressPercentage,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.InMageRcmProtectionContainerMappingDetails"/>. </summary>
        /// <param name="enableAgentAutoUpgrade"> A value indicating whether the flag for enable agent auto upgrade. </param>
        /// <returns> A new <see cref="Models.InMageRcmProtectionContainerMappingDetails"/> instance for mocking. </returns>
        public static InMageRcmProtectionContainerMappingDetails InMageRcmProtectionContainerMappingDetails(string enableAgentAutoUpgrade = null)
        {
            return new InMageRcmProtectionContainerMappingDetails("InMageRcm", serializedAdditionalRawData: null, enableAgentAutoUpgrade);
        }

        /// <summary> Initializes a new instance of <see cref="Models.InMageRcmRecoveryPointDetails"/>. </summary>
        /// <param name="isMultiVmSyncPoint"> A value indicating whether the recovery point is multi VM consistent. </param>
        /// <returns> A new <see cref="Models.InMageRcmRecoveryPointDetails"/> instance for mocking. </returns>
        public static InMageRcmRecoveryPointDetails InMageRcmRecoveryPointDetails(string isMultiVmSyncPoint = null)
        {
            return new InMageRcmRecoveryPointDetails("InMageRcm", serializedAdditionalRawData: null, isMultiVmSyncPoint);
        }

        /// <summary> Initializes a new instance of <see cref="Models.InMageRcmReplicationDetails"/>. </summary>
        /// <param name="internalIdentifier"> The virtual machine internal identifier. </param>
        /// <param name="fabricDiscoveryMachineId"> The ARM Id of the discovered VM. </param>
        /// <param name="multiVmGroupName"> The multi VM group name. </param>
        /// <param name="discoveryType"> The type of the discovered VM. </param>
        /// <param name="processServerId"> The process server Id. </param>
        /// <param name="processorCoreCount"> The processor core count. </param>
        /// <param name="allocatedMemoryInMB"> The allocated memory in MB. </param>
        /// <param name="processServerName"> The process server name. </param>
        /// <param name="runAsAccountId"> The run-as account Id. </param>
        /// <param name="osType"> The type of the OS on the VM. </param>
        /// <param name="firmwareType"> The firmware type. </param>
        /// <param name="primaryNicIPAddress"> The IP address of the primary network interface. </param>
        /// <param name="targetGeneration"> The target generation. </param>
        /// <param name="licenseType"> License Type of the VM to be used. </param>
        /// <param name="storageAccountId"> The replication storage account ARM Id. This is applicable only for the blob based replication test hook. </param>
        /// <param name="targetVmName"> Target VM name. </param>
        /// <param name="targetVmSize"> The target VM size. </param>
        /// <param name="targetResourceGroupId"> The target resource group Id. </param>
        /// <param name="targetLocation"> The target location. </param>
        /// <param name="targetAvailabilitySetId"> The target availability set Id. </param>
        /// <param name="targetAvailabilityZone"> The target availability zone. </param>
        /// <param name="targetProximityPlacementGroupId"> The target proximity placement group Id. </param>
        /// <param name="targetBootDiagnosticsStorageAccountId"> The target boot diagnostics storage account ARM Id. </param>
        /// <param name="targetNetworkId"> The target network Id. </param>
        /// <param name="testNetworkId"> The test network Id. </param>
        /// <param name="failoverRecoveryPointId"> The recovery point Id to which the VM was failed over. </param>
        /// <param name="lastRecoveryPointReceived"> The last recovery point received time. </param>
        /// <param name="lastRpoInSeconds"> The last recovery point objective value. </param>
        /// <param name="lastRpoCalculatedOn"> The last recovery point objective calculated time. </param>
        /// <param name="lastRecoveryPointId"> The last recovery point Id. </param>
        /// <param name="initialReplicationProgressPercentage"> The initial replication progress percentage. This is calculated based on total bytes processed for all disks in the source VM. </param>
        /// <param name="initialReplicationProcessedBytes"> The initial replication processed bytes. This includes sum of total bytes transferred and matched bytes on all selected disks in source VM. </param>
        /// <param name="initialReplicationTransferredBytes"> The initial replication transferred bytes from source VM to azure for all selected disks on source VM. </param>
        /// <param name="initialReplicationProgressHealth"> The initial replication progress health. </param>
        /// <param name="resyncProgressPercentage"> The resync progress percentage. This is calculated based on total bytes processed for all disks in the source VM. </param>
        /// <param name="resyncProcessedBytes"> The resync processed bytes. This includes sum of total bytes transferred and matched bytes on all selected disks in source VM. </param>
        /// <param name="resyncTransferredBytes"> The resync transferred bytes from source VM to azure for all selected disks on source VM. </param>
        /// <param name="resyncProgressHealth"> The resync progress health. </param>
        /// <param name="resyncRequired"> A value indicating whether resync is required. </param>
        /// <param name="resyncState"> The resync state. </param>
        /// <param name="agentUpgradeState"> The agent auto upgrade state. </param>
        /// <param name="lastAgentUpgradeType"> The last agent upgrade type. </param>
        /// <param name="agentUpgradeJobId"> The agent upgrade job Id. </param>
        /// <param name="agentUpgradeAttemptToVersion"> The agent version to which last agent upgrade was attempted. </param>
        /// <param name="protectedDisks"> The list of protected disks. </param>
        /// <param name="isLastUpgradeSuccessful"> A value indicating whether last agent upgrade was successful or not. </param>
        /// <param name="isAgentRegistrationSuccessfulAfterFailover"> A value indicating whether agent registration was successful after failover. </param>
        /// <param name="mobilityAgentDetails"> The mobility agent information. </param>
        /// <param name="lastAgentUpgradeErrorDetails"> The last agent upgrade error information. </param>
        /// <param name="agentUpgradeBlockingErrorDetails"> The agent upgrade blocking error information. </param>
        /// <param name="vmNics"> The network details. </param>
        /// <param name="discoveredVmDetails"> The discovered VM details. </param>
        /// <returns> A new <see cref="Models.InMageRcmReplicationDetails"/> instance for mocking. </returns>
        public static InMageRcmReplicationDetails InMageRcmReplicationDetails(string internalIdentifier = null, string fabricDiscoveryMachineId = null, string multiVmGroupName = null, string discoveryType = null, Guid? processServerId = null, int? processorCoreCount = null, double? allocatedMemoryInMB = null, string processServerName = null, string runAsAccountId = null, string osType = null, string firmwareType = null, IPAddress primaryNicIPAddress = null, string targetGeneration = null, string licenseType = null, ResourceIdentifier storageAccountId = null, string targetVmName = null, string targetVmSize = null, ResourceIdentifier targetResourceGroupId = null, string targetLocation = null, ResourceIdentifier targetAvailabilitySetId = null, string targetAvailabilityZone = null, ResourceIdentifier targetProximityPlacementGroupId = null, ResourceIdentifier targetBootDiagnosticsStorageAccountId = null, ResourceIdentifier targetNetworkId = null, ResourceIdentifier testNetworkId = null, ResourceIdentifier failoverRecoveryPointId = null, DateTimeOffset? lastRecoveryPointReceived = null, long? lastRpoInSeconds = null, DateTimeOffset? lastRpoCalculatedOn = null, ResourceIdentifier lastRecoveryPointId = null, int? initialReplicationProgressPercentage = null, long? initialReplicationProcessedBytes = null, long? initialReplicationTransferredBytes = null, VmReplicationProgressHealth? initialReplicationProgressHealth = null, int? resyncProgressPercentage = null, long? resyncProcessedBytes = null, long? resyncTransferredBytes = null, VmReplicationProgressHealth? resyncProgressHealth = null, string resyncRequired = null, SiteRecoveryResyncState? resyncState = null, MobilityAgentUpgradeState? agentUpgradeState = null, string lastAgentUpgradeType = null, string agentUpgradeJobId = null, string agentUpgradeAttemptToVersion = null, IEnumerable<InMageRcmProtectedDiskDetails> protectedDisks = null, string isLastUpgradeSuccessful = null, bool? isAgentRegistrationSuccessfulAfterFailover = null, InMageRcmMobilityAgentDetails mobilityAgentDetails = null, IEnumerable<InMageRcmLastAgentUpgradeErrorDetails> lastAgentUpgradeErrorDetails = null, IEnumerable<InMageRcmAgentUpgradeBlockingErrorDetails> agentUpgradeBlockingErrorDetails = null, IEnumerable<InMageRcmNicDetails> vmNics = null, InMageRcmDiscoveredProtectedVmDetails discoveredVmDetails = null)
        {
            protectedDisks ??= new List<InMageRcmProtectedDiskDetails>();
            lastAgentUpgradeErrorDetails ??= new List<InMageRcmLastAgentUpgradeErrorDetails>();
            agentUpgradeBlockingErrorDetails ??= new List<InMageRcmAgentUpgradeBlockingErrorDetails>();
            vmNics ??= new List<InMageRcmNicDetails>();

            return new InMageRcmReplicationDetails(
                "InMageRcm",
                serializedAdditionalRawData: null,
                internalIdentifier,
                fabricDiscoveryMachineId,
                multiVmGroupName,
                discoveryType,
                processServerId,
                processorCoreCount,
                allocatedMemoryInMB,
                processServerName,
                runAsAccountId,
                osType,
                firmwareType,
                primaryNicIPAddress,
                targetGeneration,
                licenseType,
                storageAccountId,
                targetVmName,
                targetVmSize,
                targetResourceGroupId,
                targetLocation,
                targetAvailabilitySetId,
                targetAvailabilityZone,
                targetProximityPlacementGroupId,
                targetBootDiagnosticsStorageAccountId,
                targetNetworkId,
                testNetworkId,
                failoverRecoveryPointId,
                lastRecoveryPointReceived,
                lastRpoInSeconds,
                lastRpoCalculatedOn,
                lastRecoveryPointId,
                initialReplicationProgressPercentage,
                initialReplicationProcessedBytes,
                initialReplicationTransferredBytes,
                initialReplicationProgressHealth,
                resyncProgressPercentage,
                resyncProcessedBytes,
                resyncTransferredBytes,
                resyncProgressHealth,
                resyncRequired,
                resyncState,
                agentUpgradeState,
                lastAgentUpgradeType,
                agentUpgradeJobId,
                agentUpgradeAttemptToVersion,
                protectedDisks?.ToList(),
                isLastUpgradeSuccessful,
                isAgentRegistrationSuccessfulAfterFailover,
                mobilityAgentDetails,
                lastAgentUpgradeErrorDetails?.ToList(),
                agentUpgradeBlockingErrorDetails?.ToList(),
                vmNics?.ToList(),
                discoveredVmDetails);
        }

        /// <summary> Initializes a new instance of <see cref="Models.InMageRcmReprotectContent"/>. </summary>
        /// <param name="reprotectAgentId"> The reprotect agent Id. </param>
        /// <param name="datastoreName"> The target datastore name. </param>
        /// <param name="logStorageAccountId"> The log storage account ARM Id. </param>
        /// <param name="policyId"> The Policy Id. </param>
        /// <returns> A new <see cref="Models.InMageRcmReprotectContent"/> instance for mocking. </returns>
        public static InMageRcmReprotectContent InMageRcmReprotectContent(string reprotectAgentId = null, string datastoreName = null, ResourceIdentifier logStorageAccountId = null, ResourceIdentifier policyId = null)
        {
            return new InMageRcmReprotectContent(
                "InMageRcm",
                serializedAdditionalRawData: null,
                reprotectAgentId,
                datastoreName,
                logStorageAccountId,
                policyId);
        }

        /// <summary> Initializes a new instance of <see cref="Models.InMageRcmUnplannedFailoverContent"/>. </summary>
        /// <param name="performShutdown"> A value indicating whether VM is to be shutdown. </param>
        /// <param name="recoveryPointId"> The recovery point id to be passed to failover to a particular recovery point. In case of latest recovery point, null should be passed. </param>
        /// <returns> A new <see cref="Models.InMageRcmUnplannedFailoverContent"/> instance for mocking. </returns>
        public static InMageRcmUnplannedFailoverContent InMageRcmUnplannedFailoverContent(string performShutdown = null, ResourceIdentifier recoveryPointId = null)
        {
            return new InMageRcmUnplannedFailoverContent("InMageRcm", serializedAdditionalRawData: null, performShutdown, recoveryPointId);
        }

        /// <summary> Initializes a new instance of <see cref="Models.InMageRcmUpdateContainerMappingContent"/>. </summary>
        /// <param name="enableAgentAutoUpgrade"> A value indicating whether agent auto upgrade has to be enabled. </param>
        /// <returns> A new <see cref="Models.InMageRcmUpdateContainerMappingContent"/> instance for mocking. </returns>
        public static InMageRcmUpdateContainerMappingContent InMageRcmUpdateContainerMappingContent(string enableAgentAutoUpgrade = null)
        {
            return new InMageRcmUpdateContainerMappingContent("InMageRcm", serializedAdditionalRawData: null, enableAgentAutoUpgrade);
        }

        /// <summary> Initializes a new instance of <see cref="Models.InMageReplicationDetails"/>. </summary>
        /// <param name="activeSiteType"> The active location of the VM. If the VM is being protected from Azure, this field will take values from { Azure, OnPrem }. If the VM is being protected between two data-centers, this field will be OnPrem always. </param>
        /// <param name="sourceVmCpuCount"> The CPU count of the VM on the primary side. </param>
        /// <param name="sourceVmRamSizeInMB"> The RAM size of the VM on the primary side. </param>
        /// <param name="osDetails"> The OS details. </param>
        /// <param name="protectionStage"> The protection stage. </param>
        /// <param name="vmId"> The virtual machine Id. </param>
        /// <param name="vmProtectionState"> The protection state for the vm. </param>
        /// <param name="vmProtectionStateDescription"> The protection state description for the vm. </param>
        /// <param name="resyncDetails"> The resync details of the machine. </param>
        /// <param name="retentionWindowStartOn"> The retention window start time. </param>
        /// <param name="retentionWindowEndOn"> The retention window end time. </param>
        /// <param name="compressedDataRateInMB"> The compressed data change rate in MB. </param>
        /// <param name="uncompressedDataRateInMB"> The uncompressed data change rate in MB. </param>
        /// <param name="rpoInSeconds"> The RPO in seconds. </param>
        /// <param name="protectedDisks"> The list of protected disks. </param>
        /// <param name="ipAddress"> The source IP address. </param>
        /// <param name="lastHeartbeatReceivedOn"> The last heartbeat received from the source server. </param>
        /// <param name="processServerId"> The process server Id. </param>
        /// <param name="masterTargetId"> The master target Id. </param>
        /// <param name="consistencyPoints"> The collection of Consistency points. </param>
        /// <param name="diskResized"> A value indicating whether any disk is resized for this VM. </param>
        /// <param name="rebootAfterUpdateStatus"> A value indicating whether the source server requires a restart after update. </param>
        /// <param name="multiVmGroupId"> The multi vm group Id, if any. </param>
        /// <param name="multiVmGroupName"> The multi vm group name, if any. </param>
        /// <param name="multiVmSyncStatus"> A value indicating whether the multi vm sync is enabled or disabled. </param>
        /// <param name="agentDetails"> The agent details. </param>
        /// <param name="vCenterInfrastructureId"> The vCenter infrastructure Id. </param>
        /// <param name="infrastructureVmId"> The infrastructure VM Id. </param>
        /// <param name="vmNics"> The PE Network details. </param>
        /// <param name="discoveryType"> A value indicating the discovery type of the machine. </param>
        /// <param name="azureStorageAccountId"> A value indicating the underlying Azure storage account. If the VM is not running in Azure, this value shall be set to null. </param>
        /// <param name="datastores"> The datastores of the on-premise machine Value can be list of strings that contain datastore names. </param>
        /// <param name="validationErrors"> The validation errors of the on-premise machine Value can be list of validation errors. </param>
        /// <param name="lastRpoCalculatedOn"> The last RPO calculated time. </param>
        /// <param name="lastUpdateReceivedOn"> The last update time received from on-prem components. </param>
        /// <param name="replicaId"> The replica id of the protected item. </param>
        /// <param name="osVersion"> The OS Version of the protected item. </param>
        /// <param name="isAdditionalStatsAvailable"> A value indicating whether additional IR stats are available or not. </param>
        /// <param name="totalDataTransferred"> The total transferred data in bytes. </param>
        /// <param name="totalProgressHealth"> The progress health. </param>
        /// <returns> A new <see cref="Models.InMageReplicationDetails"/> instance for mocking. </returns>
        public static InMageReplicationDetails InMageReplicationDetails(string activeSiteType = null, int? sourceVmCpuCount = null, int? sourceVmRamSizeInMB = null, SiteRecoveryOSDiskDetails osDetails = null, string protectionStage = null, string vmId = null, string vmProtectionState = null, string vmProtectionStateDescription = null, InitialReplicationDetails resyncDetails = null, DateTimeOffset? retentionWindowStartOn = null, DateTimeOffset? retentionWindowEndOn = null, double? compressedDataRateInMB = null, double? uncompressedDataRateInMB = null, long? rpoInSeconds = null, IEnumerable<InMageProtectedDiskDetails> protectedDisks = null, IPAddress ipAddress = null, DateTimeOffset? lastHeartbeatReceivedOn = null, Guid? processServerId = null, string masterTargetId = null, IReadOnlyDictionary<string, DateTimeOffset> consistencyPoints = null, string diskResized = null, string rebootAfterUpdateStatus = null, string multiVmGroupId = null, string multiVmGroupName = null, string multiVmSyncStatus = null, InMageAgentDetails agentDetails = null, string vCenterInfrastructureId = null, string infrastructureVmId = null, IEnumerable<VmNicDetails> vmNics = null, string discoveryType = null, ResourceIdentifier azureStorageAccountId = null, IEnumerable<string> datastores = null, IEnumerable<SiteRecoveryHealthError> validationErrors = null, DateTimeOffset? lastRpoCalculatedOn = null, DateTimeOffset? lastUpdateReceivedOn = null, string replicaId = null, string osVersion = null, bool? isAdditionalStatsAvailable = null, long? totalDataTransferred = null, string totalProgressHealth = null)
        {
            protectedDisks ??= new List<InMageProtectedDiskDetails>();
            consistencyPoints ??= new Dictionary<string, DateTimeOffset>();
            vmNics ??= new List<VmNicDetails>();
            datastores ??= new List<string>();
            validationErrors ??= new List<SiteRecoveryHealthError>();

            return new InMageReplicationDetails(
                "InMage",
                serializedAdditionalRawData: null,
                activeSiteType,
                sourceVmCpuCount,
                sourceVmRamSizeInMB,
                osDetails,
                protectionStage,
                vmId,
                vmProtectionState,
                vmProtectionStateDescription,
                resyncDetails,
                retentionWindowStartOn,
                retentionWindowEndOn,
                compressedDataRateInMB,
                uncompressedDataRateInMB,
                rpoInSeconds,
                protectedDisks?.ToList(),
                ipAddress,
                lastHeartbeatReceivedOn,
                processServerId,
                masterTargetId,
                consistencyPoints,
                diskResized,
                rebootAfterUpdateStatus,
                multiVmGroupId,
                multiVmGroupName,
                multiVmSyncStatus,
                agentDetails,
                vCenterInfrastructureId,
                infrastructureVmId,
                vmNics?.ToList(),
                discoveryType,
                azureStorageAccountId,
                datastores?.ToList(),
                validationErrors?.ToList(),
                lastRpoCalculatedOn,
                lastUpdateReceivedOn,
                replicaId,
                osVersion,
                isAdditionalStatsAvailable,
                totalDataTransferred,
                totalProgressHealth);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SiteRecoveryOSDiskDetails"/>. </summary>
        /// <param name="osVhdId"> The id of the disk containing the OS. </param>
        /// <param name="osType"> The type of the OS on the VM. </param>
        /// <param name="vhdName"> The OS disk VHD name. </param>
        /// <returns> A new <see cref="Models.SiteRecoveryOSDiskDetails"/> instance for mocking. </returns>
        public static SiteRecoveryOSDiskDetails SiteRecoveryOSDiskDetails(string osVhdId = null, string osType = null, string vhdName = null)
        {
            return new SiteRecoveryOSDiskDetails(osVhdId, osType, vhdName, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.InMageReprotectContent"/>. </summary>
        /// <param name="masterTargetId"> The Master Target Id. </param>
        /// <param name="processServerId"> The Process Server Id. </param>
        /// <param name="retentionDrive"> The retention drive to use on the MT. </param>
        /// <param name="runAsAccountId"> The CS account Id. </param>
        /// <param name="datastoreName"> The target datastore name. </param>
        /// <param name="diskExclusionContent"> The enable disk exclusion input. </param>
        /// <param name="profileId"> The Policy Id. </param>
        /// <param name="disksToInclude"> The disks to include list. </param>
        /// <returns> A new <see cref="Models.InMageReprotectContent"/> instance for mocking. </returns>
        public static InMageReprotectContent InMageReprotectContent(string masterTargetId = null, Guid processServerId = default, string retentionDrive = null, string runAsAccountId = null, string datastoreName = null, InMageDiskExclusionContent diskExclusionContent = null, string profileId = null, IEnumerable<string> disksToInclude = null)
        {
            disksToInclude ??= new List<string>();

            return new InMageReprotectContent(
                "InMage",
                serializedAdditionalRawData: null,
                masterTargetId,
                processServerId,
                retentionDrive,
                runAsAccountId,
                datastoreName,
                diskExclusionContent,
                profileId,
                disksToInclude?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.SiteRecoveryJobStatusEventDetails"/>. </summary>
        /// <param name="jobId"> Job arm id for the event. </param>
        /// <param name="jobFriendlyName"> JobName for the Event. </param>
        /// <param name="jobStatus"> JobStatus for the Event. </param>
        /// <param name="affectedObjectType"> AffectedObjectType for the event. </param>
        /// <returns> A new <see cref="Models.SiteRecoveryJobStatusEventDetails"/> instance for mocking. </returns>
        public static SiteRecoveryJobStatusEventDetails SiteRecoveryJobStatusEventDetails(ResourceIdentifier jobId = null, string jobFriendlyName = null, string jobStatus = null, string affectedObjectType = null)
        {
            return new SiteRecoveryJobStatusEventDetails(
                "JobStatus",
                serializedAdditionalRawData: null,
                jobId,
                jobFriendlyName,
                jobStatus,
                affectedObjectType);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ManualActionTaskDetails"/>. </summary>
        /// <param name="name"> The name. </param>
        /// <param name="instructions"> The instructions. </param>
        /// <param name="observation"> The observation. </param>
        /// <returns> A new <see cref="Models.ManualActionTaskDetails"/> instance for mocking. </returns>
        public static ManualActionTaskDetails ManualActionTaskDetails(string name = null, string instructions = null, string observation = null)
        {
            return new ManualActionTaskDetails("ManualActionTaskDetails", serializedAdditionalRawData: null, name, instructions, observation);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MasterTargetServer"/>. </summary>
        /// <param name="id"> The server Id. </param>
        /// <param name="ipAddress"> The IP address of the server. </param>
        /// <param name="name"> The server name. </param>
        /// <param name="osType"> The OS type of the server. </param>
        /// <param name="agentVersion"> The version of the scout component on the server. </param>
        /// <param name="lastHeartbeatReceivedOn"> The last heartbeat received from the server. </param>
        /// <param name="versionStatus"> Version status. </param>
        /// <param name="retentionVolumes"> The retention volumes of Master target Server. </param>
        /// <param name="dataStores"> The list of data stores in the fabric. </param>
        /// <param name="validationErrors"> Validation errors. </param>
        /// <param name="healthErrors"> Health errors. </param>
        /// <param name="diskCount"> Disk count of the master target. </param>
        /// <param name="osVersion"> OS Version of the master target. </param>
        /// <param name="agentExpireOn"> Agent expiry date. </param>
        /// <param name="marsAgentVersion"> MARS agent version. </param>
        /// <param name="marsAgentExpireOn"> MARS agent expiry date. </param>
        /// <param name="agentVersionDetails"> Agent version details. </param>
        /// <param name="marsAgentVersionDetails"> Mars agent version details. </param>
        /// <returns> A new <see cref="Models.MasterTargetServer"/> instance for mocking. </returns>
        public static MasterTargetServer MasterTargetServer(string id = null, IPAddress ipAddress = null, string name = null, string osType = null, string agentVersion = null, DateTimeOffset? lastHeartbeatReceivedOn = null, string versionStatus = null, IEnumerable<SiteRecoveryRetentionVolume> retentionVolumes = null, IEnumerable<SiteRecoveryDataStore> dataStores = null, IEnumerable<SiteRecoveryHealthError> validationErrors = null, IEnumerable<SiteRecoveryHealthError> healthErrors = null, int? diskCount = null, string osVersion = null, DateTimeOffset? agentExpireOn = null, string marsAgentVersion = null, DateTimeOffset? marsAgentExpireOn = null, SiteRecoveryVersionDetails agentVersionDetails = null, SiteRecoveryVersionDetails marsAgentVersionDetails = null)
        {
            retentionVolumes ??= new List<SiteRecoveryRetentionVolume>();
            dataStores ??= new List<SiteRecoveryDataStore>();
            validationErrors ??= new List<SiteRecoveryHealthError>();
            healthErrors ??= new List<SiteRecoveryHealthError>();

            return new MasterTargetServer(
                id,
                ipAddress,
                name,
                osType,
                agentVersion,
                lastHeartbeatReceivedOn,
                versionStatus,
                retentionVolumes?.ToList(),
                dataStores?.ToList(),
                validationErrors?.ToList(),
                healthErrors?.ToList(),
                diskCount,
                osVersion,
                agentExpireOn,
                marsAgentVersion,
                marsAgentExpireOn,
                agentVersionDetails,
                marsAgentVersionDetails,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SiteRecoveryRetentionVolume"/>. </summary>
        /// <param name="volumeName"> The volume name. </param>
        /// <param name="capacityInBytes"> The volume capacity. </param>
        /// <param name="freeSpaceInBytes"> The free space available in this volume. </param>
        /// <param name="thresholdPercentage"> The threshold percentage. </param>
        /// <returns> A new <see cref="Models.SiteRecoveryRetentionVolume"/> instance for mocking. </returns>
        public static SiteRecoveryRetentionVolume SiteRecoveryRetentionVolume(string volumeName = null, long? capacityInBytes = null, long? freeSpaceInBytes = null, int? thresholdPercentage = null)
        {
            return new SiteRecoveryRetentionVolume(volumeName, capacityInBytes, freeSpaceInBytes, thresholdPercentage, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MobilityServiceUpdate"/>. </summary>
        /// <param name="version"> The version of the latest update. </param>
        /// <param name="rebootStatus"> The reboot status of the update - whether it is required or not. </param>
        /// <param name="osType"> The OS type. </param>
        /// <returns> A new <see cref="Models.MobilityServiceUpdate"/> instance for mocking. </returns>
        public static MobilityServiceUpdate MobilityServiceUpdate(string version = null, string rebootStatus = null, string osType = null)
        {
            return new MobilityServiceUpdate(version, rebootStatus, osType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SiteRecoveryProcessServer"/>. </summary>
        /// <param name="friendlyName"> The Process Server's friendly name. </param>
        /// <param name="id"> The Process Server Id. </param>
        /// <param name="ipAddress"> The IP address of the server. </param>
        /// <param name="osType"> The OS type of the server. </param>
        /// <param name="agentVersion"> The version of the scout component on the server. </param>
        /// <param name="lastHeartbeatReceivedOn"> The last heartbeat received from the server. </param>
        /// <param name="versionStatus"> Version status. </param>
        /// <param name="mobilityServiceUpdates"> The list of the mobility service updates available on the Process Server. </param>
        /// <param name="hostId"> The agent generated Id. </param>
        /// <param name="machineCount"> The servers configured with this PS. </param>
        /// <param name="replicationPairCount"> The number of replication pairs configured in this PS. </param>
        /// <param name="systemLoad"> The percentage of the system load. </param>
        /// <param name="systemLoadStatus"> The system load status. </param>
        /// <param name="cpuLoad"> The percentage of the CPU load. </param>
        /// <param name="cpuLoadStatus"> The CPU load status. </param>
        /// <param name="totalMemoryInBytes"> The total memory. </param>
        /// <param name="availableMemoryInBytes"> The available memory. </param>
        /// <param name="memoryUsageStatus"> The memory usage status. </param>
        /// <param name="totalSpaceInBytes"> The total space. </param>
        /// <param name="availableSpaceInBytes"> The available space. </param>
        /// <param name="spaceUsageStatus"> The space usage status. </param>
        /// <param name="psServiceStatus"> The PS service status. </param>
        /// <param name="sslCertExpireOn"> The PS SSL cert expiry date. </param>
        /// <param name="sslCertExpiryRemainingDays"> CS SSL cert expiry date. </param>
        /// <param name="osVersion"> OS Version of the process server. Note: This will get populated if user has CS version greater than 9.12.0.0. </param>
        /// <param name="healthErrors"> Health errors. </param>
        /// <param name="agentExpireOn"> Agent expiry date. </param>
        /// <param name="agentVersionDetails"> The agent version details. </param>
        /// <param name="health"> The health of Process Server. </param>
        /// <param name="psStatsRefreshOn"> The process server stats refresh time. </param>
        /// <param name="throughputUploadPendingDataInBytes"> The uploading pending data in bytes. </param>
        /// <param name="throughputInMBps"> The throughput in MBps. </param>
        /// <param name="throughputInBytes"> The throughput in bytes. </param>
        /// <param name="throughputStatus"> The throughput status. </param>
        /// <param name="marsCommunicationStatus"> The MARS communication status. </param>
        /// <param name="marsRegistrationStatus"> The MARS registration status. </param>
        /// <returns> A new <see cref="Models.SiteRecoveryProcessServer"/> instance for mocking. </returns>
        public static SiteRecoveryProcessServer SiteRecoveryProcessServer(string friendlyName = null, string id = null, IPAddress ipAddress = null, string osType = null, string agentVersion = null, DateTimeOffset? lastHeartbeatReceivedOn = null, string versionStatus = null, IEnumerable<MobilityServiceUpdate> mobilityServiceUpdates = null, string hostId = null, string machineCount = null, string replicationPairCount = null, string systemLoad = null, string systemLoadStatus = null, string cpuLoad = null, string cpuLoadStatus = null, long? totalMemoryInBytes = null, long? availableMemoryInBytes = null, string memoryUsageStatus = null, long? totalSpaceInBytes = null, long? availableSpaceInBytes = null, string spaceUsageStatus = null, string psServiceStatus = null, DateTimeOffset? sslCertExpireOn = null, int? sslCertExpiryRemainingDays = null, string osVersion = null, IEnumerable<SiteRecoveryHealthError> healthErrors = null, DateTimeOffset? agentExpireOn = null, SiteRecoveryVersionDetails agentVersionDetails = null, SiteRecoveryProtectionHealth? health = null, DateTimeOffset? psStatsRefreshOn = null, long? throughputUploadPendingDataInBytes = null, long? throughputInMBps = null, long? throughputInBytes = null, string throughputStatus = null, string marsCommunicationStatus = null, string marsRegistrationStatus = null)
        {
            mobilityServiceUpdates ??= new List<MobilityServiceUpdate>();
            healthErrors ??= new List<SiteRecoveryHealthError>();

            return new SiteRecoveryProcessServer(
                friendlyName,
                id,
                ipAddress,
                osType,
                agentVersion,
                lastHeartbeatReceivedOn,
                versionStatus,
                mobilityServiceUpdates?.ToList(),
                hostId,
                machineCount,
                replicationPairCount,
                systemLoad,
                systemLoadStatus,
                cpuLoad,
                cpuLoadStatus,
                totalMemoryInBytes,
                availableMemoryInBytes,
                memoryUsageStatus,
                totalSpaceInBytes,
                availableSpaceInBytes,
                spaceUsageStatus,
                psServiceStatus,
                sslCertExpireOn,
                sslCertExpiryRemainingDays,
                osVersion,
                healthErrors?.ToList(),
                agentExpireOn,
                agentVersionDetails,
                health,
                psStatsRefreshOn,
                throughputUploadPendingDataInBytes,
                throughputInMBps,
                throughputInBytes,
                throughputStatus,
                marsCommunicationStatus,
                marsRegistrationStatus,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RecoveryPlanA2ADetails"/>. </summary>
        /// <param name="primaryZone"> The primary zone. </param>
        /// <param name="recoveryZone"> The recovery zone. </param>
        /// <param name="primaryExtendedLocation"> The primary extended location. </param>
        /// <param name="recoveryExtendedLocation"> The recovery extended location. </param>
        /// <returns> A new <see cref="Models.RecoveryPlanA2ADetails"/> instance for mocking. </returns>
        public static RecoveryPlanA2ADetails RecoveryPlanA2ADetails(string primaryZone = null, string recoveryZone = null, SiteRecoveryExtendedLocation primaryExtendedLocation = null, SiteRecoveryExtendedLocation recoveryExtendedLocation = null)
        {
            return new RecoveryPlanA2ADetails(
                "A2A",
                serializedAdditionalRawData: null,
                primaryZone,
                recoveryZone,
                primaryExtendedLocation,
                recoveryExtendedLocation);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RecoveryPlanA2AFailoverContent"/>. </summary>
        /// <param name="recoveryPointType"> The recovery point type. </param>
        /// <param name="cloudServiceCreationOption"> A value indicating whether to use recovery cloud service for TFO or not. </param>
        /// <param name="multiVmSyncPointOption"> A value indicating whether multi VM sync enabled VMs should use multi VM sync points for failover. </param>
        /// <returns> A new <see cref="Models.RecoveryPlanA2AFailoverContent"/> instance for mocking. </returns>
        public static RecoveryPlanA2AFailoverContent RecoveryPlanA2AFailoverContent(A2ARpRecoveryPointType recoveryPointType = default, string cloudServiceCreationOption = null, MultiVmSyncPointOption? multiVmSyncPointOption = null)
        {
            return new RecoveryPlanA2AFailoverContent("A2A", serializedAdditionalRawData: null, recoveryPointType, cloudServiceCreationOption, multiVmSyncPointOption);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RecoveryPlanGroupTaskDetails"/>. </summary>
        /// <param name="childTasks"> The child tasks. </param>
        /// <param name="name"> The name. </param>
        /// <param name="groupId"> The group identifier. </param>
        /// <param name="rpGroupType"> The group type. </param>
        /// <returns> A new <see cref="Models.RecoveryPlanGroupTaskDetails"/> instance for mocking. </returns>
        public static RecoveryPlanGroupTaskDetails RecoveryPlanGroupTaskDetails(IEnumerable<AsrTask> childTasks = null, string name = null, string groupId = null, string rpGroupType = null)
        {
            childTasks ??= new List<AsrTask>();

            return new RecoveryPlanGroupTaskDetails(
                "RecoveryPlanGroupTaskDetails",
                childTasks?.ToList(),
                serializedAdditionalRawData: null,
                name,
                groupId,
                rpGroupType);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RecoveryPlanHyperVReplicaAzureFailbackContent"/>. </summary>
        /// <param name="dataSyncOption"> The data sync option. </param>
        /// <param name="recoveryVmCreationOption"> The ALR option. </param>
        /// <returns> A new <see cref="Models.RecoveryPlanHyperVReplicaAzureFailbackContent"/> instance for mocking. </returns>
        public static RecoveryPlanHyperVReplicaAzureFailbackContent RecoveryPlanHyperVReplicaAzureFailbackContent(SiteRecoveryDataSyncStatus dataSyncOption = default, AlternateLocationRecoveryOption recoveryVmCreationOption = default)
        {
            return new RecoveryPlanHyperVReplicaAzureFailbackContent("HyperVReplicaAzureFailback", serializedAdditionalRawData: null, dataSyncOption, recoveryVmCreationOption);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RecoveryPlanInMageAzureV2FailoverContent"/>. </summary>
        /// <param name="recoveryPointType"> The recovery point type. </param>
        /// <param name="useMultiVmSyncPoint"> A value indicating whether multi VM sync enabled VMs should use multi VM sync points for failover. </param>
        /// <returns> A new <see cref="Models.RecoveryPlanInMageAzureV2FailoverContent"/> instance for mocking. </returns>
        public static RecoveryPlanInMageAzureV2FailoverContent RecoveryPlanInMageAzureV2FailoverContent(InMageV2RpRecoveryPointType recoveryPointType = default, string useMultiVmSyncPoint = null)
        {
            return new RecoveryPlanInMageAzureV2FailoverContent("InMageAzureV2", serializedAdditionalRawData: null, recoveryPointType, useMultiVmSyncPoint);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RecoveryPlanInMageFailoverContent"/>. </summary>
        /// <param name="recoveryPointType"> The recovery point type. </param>
        /// <returns> A new <see cref="Models.RecoveryPlanInMageFailoverContent"/> instance for mocking. </returns>
        public static RecoveryPlanInMageFailoverContent RecoveryPlanInMageFailoverContent(RpInMageRecoveryPointType recoveryPointType = default)
        {
            return new RecoveryPlanInMageFailoverContent("InMage", serializedAdditionalRawData: null, recoveryPointType);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RecoveryPlanInMageRcmFailbackFailoverContent"/>. </summary>
        /// <param name="recoveryPointType"> The recovery point type. </param>
        /// <param name="useMultiVmSyncPoint"> A value indicating whether multi VM sync enabled VMs should use multi VM sync points for failover. </param>
        /// <returns> A new <see cref="Models.RecoveryPlanInMageRcmFailbackFailoverContent"/> instance for mocking. </returns>
        public static RecoveryPlanInMageRcmFailbackFailoverContent RecoveryPlanInMageRcmFailbackFailoverContent(InMageRcmFailbackRecoveryPointType recoveryPointType = default, string useMultiVmSyncPoint = null)
        {
            return new RecoveryPlanInMageRcmFailbackFailoverContent("InMageRcmFailback", serializedAdditionalRawData: null, recoveryPointType, useMultiVmSyncPoint);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RecoveryPlanInMageRcmFailoverContent"/>. </summary>
        /// <param name="recoveryPointType"> The recovery point type. </param>
        /// <param name="useMultiVmSyncPoint"> A value indicating whether multi VM sync enabled VMs should use multi VM sync points for failover. </param>
        /// <returns> A new <see cref="Models.RecoveryPlanInMageRcmFailoverContent"/> instance for mocking. </returns>
        public static RecoveryPlanInMageRcmFailoverContent RecoveryPlanInMageRcmFailoverContent(RecoveryPlanPointType recoveryPointType = default, string useMultiVmSyncPoint = null)
        {
            return new RecoveryPlanInMageRcmFailoverContent("InMageRcm", serializedAdditionalRawData: null, recoveryPointType, useMultiVmSyncPoint);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RecoveryPlanShutdownGroupTaskDetails"/>. </summary>
        /// <param name="childTasks"> The child tasks. </param>
        /// <param name="name"> The name. </param>
        /// <param name="groupId"> The group identifier. </param>
        /// <param name="rpGroupType"> The group type. </param>
        /// <returns> A new <see cref="Models.RecoveryPlanShutdownGroupTaskDetails"/> instance for mocking. </returns>
        public static RecoveryPlanShutdownGroupTaskDetails RecoveryPlanShutdownGroupTaskDetails(IEnumerable<AsrTask> childTasks = null, string name = null, string groupId = null, string rpGroupType = null)
        {
            childTasks ??= new List<AsrTask>();

            return new RecoveryPlanShutdownGroupTaskDetails(
                "RecoveryPlanShutdownGroupTaskDetails",
                childTasks?.ToList(),
                serializedAdditionalRawData: null,
                name,
                groupId,
                rpGroupType);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SiteRecoveryRunAsAccount"/>. </summary>
        /// <param name="accountId"> The CS RunAs account Id. </param>
        /// <param name="accountName"> The CS RunAs account name. </param>
        /// <returns> A new <see cref="Models.SiteRecoveryRunAsAccount"/> instance for mocking. </returns>
        public static SiteRecoveryRunAsAccount SiteRecoveryRunAsAccount(string accountId = null, string accountName = null)
        {
            return new SiteRecoveryRunAsAccount(accountId, accountName, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ScriptActionTaskDetails"/>. </summary>
        /// <param name="name"> The name. </param>
        /// <param name="path"> The path. </param>
        /// <param name="output"> The output. </param>
        /// <param name="isPrimarySideScript"> A value indicating whether it is a primary side script or not. </param>
        /// <returns> A new <see cref="Models.ScriptActionTaskDetails"/> instance for mocking. </returns>
        public static ScriptActionTaskDetails ScriptActionTaskDetails(string name = null, string path = null, string output = null, bool? isPrimarySideScript = null)
        {
            return new ScriptActionTaskDetails(
                "ScriptActionTaskDetails",
                serializedAdditionalRawData: null,
                name,
                path,
                output,
                isPrimarySideScript);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SwitchProtectionJobDetails"/>. </summary>
        /// <param name="affectedObjectDetails"> The affected object properties like source server, source cloud, target server, target cloud etc. based on the workflow object details. </param>
        /// <param name="newReplicationProtectedItemId"> ARM Id of the new replication protected item. </param>
        /// <returns> A new <see cref="Models.SwitchProtectionJobDetails"/> instance for mocking. </returns>
        public static SwitchProtectionJobDetails SwitchProtectionJobDetails(IReadOnlyDictionary<string, string> affectedObjectDetails = null, ResourceIdentifier newReplicationProtectedItemId = null)
        {
            affectedObjectDetails ??= new Dictionary<string, string>();

            return new SwitchProtectionJobDetails("SwitchProtectionJobDetails", affectedObjectDetails, serializedAdditionalRawData: null, newReplicationProtectedItemId);
        }

        /// <summary> Initializes a new instance of <see cref="Models.TestFailoverJobDetails"/>. </summary>
        /// <param name="affectedObjectDetails"> The affected object properties like source server, source cloud, target server, target cloud etc. based on the workflow object details. </param>
        /// <param name="testFailoverStatus"> The test failover status. </param>
        /// <param name="comments"> The test failover comments. </param>
        /// <param name="networkName"> The test network name. </param>
        /// <param name="networkFriendlyName"> The test network friendly name. </param>
        /// <param name="networkType"> The test network type (see TestFailoverInput enum for possible values). </param>
        /// <param name="protectedItemDetails"> The test VM details. </param>
        /// <returns> A new <see cref="Models.TestFailoverJobDetails"/> instance for mocking. </returns>
        public static TestFailoverJobDetails TestFailoverJobDetails(IReadOnlyDictionary<string, string> affectedObjectDetails = null, string testFailoverStatus = null, string comments = null, string networkName = null, string networkFriendlyName = null, string networkType = null, IEnumerable<FailoverReplicationProtectedItemDetails> protectedItemDetails = null)
        {
            affectedObjectDetails ??= new Dictionary<string, string>();
            protectedItemDetails ??= new List<FailoverReplicationProtectedItemDetails>();

            return new TestFailoverJobDetails(
                "TestFailoverJobDetails",
                affectedObjectDetails,
                serializedAdditionalRawData: null,
                testFailoverStatus,
                comments,
                networkName,
                networkFriendlyName,
                networkType,
                protectedItemDetails?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.SiteRecoveryVmTaskDetails"/>. </summary>
        /// <param name="jobTask"> The job entity. </param>
        /// <param name="skippedReason"> The skipped reason. </param>
        /// <param name="skippedReasonString"> The skipped reason string. </param>
        /// <returns> A new <see cref="Models.SiteRecoveryVmTaskDetails"/> instance for mocking. </returns>
        public static SiteRecoveryVmTaskDetails SiteRecoveryVmTaskDetails(SiteRecoveryJobEntity jobTask = null, string skippedReason = null, string skippedReasonString = null)
        {
            return new SiteRecoveryVmTaskDetails("VirtualMachineTaskDetails", serializedAdditionalRawData: null, jobTask, skippedReason, skippedReasonString);
        }

        /// <summary> Initializes a new instance of <see cref="Models.VmmVmDetails"/>. </summary>
        /// <param name="sourceItemId"> The source id of the object. </param>
        /// <param name="generation"> The id of the object in fabric. </param>
        /// <param name="osDetails"> The Last replication time. </param>
        /// <param name="diskDetails"> The Last successful failover time. </param>
        /// <param name="hasPhysicalDisk"> A value indicating whether the VM has a physical disk attached. String value of SrsDataContract.PresenceStatus enum. </param>
        /// <param name="hasFibreChannelAdapter"> A value indicating whether the VM has a fibre channel adapter attached. String value of SrsDataContract.PresenceStatus enum. </param>
        /// <param name="hasSharedVhd"> A value indicating whether the VM has a shared VHD attached. String value of SrsDataContract.PresenceStatus enum. </param>
        /// <param name="hyperVHostId"> The Id of the hyper-v host in fabric. </param>
        /// <returns> A new <see cref="Models.VmmVmDetails"/> instance for mocking. </returns>
        public static VmmVmDetails VmmVmDetails(string sourceItemId = null, string generation = null, SiteRecoveryOSDetails osDetails = null, IEnumerable<SiteRecoveryDiskDetails> diskDetails = null, HyperVVmDiskPresenceStatus? hasPhysicalDisk = null, HyperVVmDiskPresenceStatus? hasFibreChannelAdapter = null, HyperVVmDiskPresenceStatus? hasSharedVhd = null, string hyperVHostId = null)
        {
            diskDetails ??= new List<SiteRecoveryDiskDetails>();

            return new VmmVmDetails(
                "VmmVirtualMachine",
                serializedAdditionalRawData: null,
                sourceItemId,
                generation,
                osDetails,
                diskDetails?.ToList(),
                hasPhysicalDisk,
                hasFibreChannelAdapter,
                hasSharedVhd,
                hyperVHostId);
        }

        /// <summary> Initializes a new instance of <see cref="Models.VmNicUpdatesTaskDetails"/>. </summary>
        /// <param name="vmId"> Virtual machine Id. </param>
        /// <param name="nicId"> Nic Id. </param>
        /// <param name="name"> Name of the Nic. </param>
        /// <returns> A new <see cref="Models.VmNicUpdatesTaskDetails"/> instance for mocking. </returns>
        public static VmNicUpdatesTaskDetails VmNicUpdatesTaskDetails(string vmId = null, string nicId = null, string name = null)
        {
            return new VmNicUpdatesTaskDetails("VmNicUpdatesTaskDetails", serializedAdditionalRawData: null, vmId, nicId, name);
        }

        /// <summary> Initializes a new instance of <see cref="Models.VMwareCbtContainerMappingContent"/>. </summary>
        /// <param name="keyVaultId"> The target key vault ARM Id. </param>
        /// <param name="keyVaultUri"> The target key vault URL. </param>
        /// <param name="storageAccountId"> The storage account ARM Id. </param>
        /// <param name="storageAccountSasSecretName"> The secret name of the storage account. </param>
        /// <param name="serviceBusConnectionStringSecretName"> The secret name of the service bus connection string. </param>
        /// <param name="targetLocation"> The target location. </param>
        /// <returns> A new <see cref="Models.VMwareCbtContainerMappingContent"/> instance for mocking. </returns>
        public static VMwareCbtContainerMappingContent VMwareCbtContainerMappingContent(ResourceIdentifier keyVaultId = null, Uri keyVaultUri = null, ResourceIdentifier storageAccountId = null, string storageAccountSasSecretName = null, string serviceBusConnectionStringSecretName = null, string targetLocation = null)
        {
            return new VMwareCbtContainerMappingContent(
                "VMwareCbt",
                serializedAdditionalRawData: null,
                keyVaultId,
                keyVaultUri,
                storageAccountId,
                storageAccountSasSecretName,
                serviceBusConnectionStringSecretName,
                targetLocation);
        }

        /// <summary> Initializes a new instance of <see cref="Models.VMwareCbtDiskContent"/>. </summary>
        /// <param name="diskId"> The disk Id. </param>
        /// <param name="diskType"> The disk type. </param>
        /// <param name="isOSDisk"> A value indicating whether the disk is the OS disk. </param>
        /// <param name="logStorageAccountId"> The log storage account ARM Id. </param>
        /// <param name="logStorageAccountSasSecretName"> The key vault secret name of the log storage account. </param>
        /// <param name="diskEncryptionSetId"> The DiskEncryptionSet ARM Id. </param>
        /// <returns> A new <see cref="Models.VMwareCbtDiskContent"/> instance for mocking. </returns>
        public static VMwareCbtDiskContent VMwareCbtDiskContent(string diskId = null, SiteRecoveryDiskAccountType? diskType = null, string isOSDisk = null, ResourceIdentifier logStorageAccountId = null, string logStorageAccountSasSecretName = null, ResourceIdentifier diskEncryptionSetId = null)
        {
            return new VMwareCbtDiskContent(
                diskId,
                diskType,
                isOSDisk,
                logStorageAccountId,
                logStorageAccountSasSecretName,
                diskEncryptionSetId,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.VMwareCbtEnableMigrationContent"/>. </summary>
        /// <param name="vmwareMachineId"> The ARM Id of the VM discovered in VMware. </param>
        /// <param name="disksToInclude"> The disks to include list. </param>
        /// <param name="licenseType"> License type. </param>
        /// <param name="sqlServerLicenseType"> The SQL Server license type. </param>
        /// <param name="performSqlBulkRegistration"> A value indicating whether bulk SQL RP registration to be done. </param>
        /// <param name="dataMoverRunAsAccountId"> The data mover run as account Id. </param>
        /// <param name="snapshotRunAsAccountId"> The snapshot run as account Id. </param>
        /// <param name="targetVmName"> The target VM name. </param>
        /// <param name="targetVmSize"> The target VM size. </param>
        /// <param name="targetResourceGroupId"> The target resource group ARM Id. </param>
        /// <param name="targetNetworkId"> The target network ARM Id. </param>
        /// <param name="testNetworkId"> The selected test network ARM Id. </param>
        /// <param name="targetSubnetName"> The target subnet name. </param>
        /// <param name="testSubnetName"> The selected test subnet name. </param>
        /// <param name="targetAvailabilitySetId"> The target availability set ARM Id. </param>
        /// <param name="targetAvailabilityZone"> The target availability zone. </param>
        /// <param name="targetProximityPlacementGroupId"> The target proximity placement group ARM Id. </param>
        /// <param name="confidentialVmKeyVaultId"> The confidential VM key vault Id for ADE installation. </param>
        /// <param name="targetVmSecurityProfile"> The target VM security profile. </param>
        /// <param name="targetBootDiagnosticsStorageAccountId"> The target boot diagnostics storage account ARM Id. </param>
        /// <param name="performAutoResync"> A value indicating whether auto resync is to be done. </param>
        /// <param name="targetVmTags"> The target VM tags. </param>
        /// <param name="seedDiskTags"> The tags for the seed disks. </param>
        /// <param name="targetDiskTags"> The tags for the target disks. </param>
        /// <param name="targetNicTags"> The tags for the target NICs. </param>
        /// <returns> A new <see cref="Models.VMwareCbtEnableMigrationContent"/> instance for mocking. </returns>
        public static VMwareCbtEnableMigrationContent VMwareCbtEnableMigrationContent(ResourceIdentifier vmwareMachineId = null, IEnumerable<VMwareCbtDiskContent> disksToInclude = null, SiteRecoveryLicenseType? licenseType = null, SiteRecoverySqlServerLicenseType? sqlServerLicenseType = null, string performSqlBulkRegistration = null, ResourceIdentifier dataMoverRunAsAccountId = null, ResourceIdentifier snapshotRunAsAccountId = null, string targetVmName = null, string targetVmSize = null, ResourceIdentifier targetResourceGroupId = null, ResourceIdentifier targetNetworkId = null, ResourceIdentifier testNetworkId = null, string targetSubnetName = null, string testSubnetName = null, ResourceIdentifier targetAvailabilitySetId = null, string targetAvailabilityZone = null, ResourceIdentifier targetProximityPlacementGroupId = null, ResourceIdentifier confidentialVmKeyVaultId = null, VMwareCbtSecurityProfileProperties targetVmSecurityProfile = null, ResourceIdentifier targetBootDiagnosticsStorageAccountId = null, string performAutoResync = null, IDictionary<string, string> targetVmTags = null, IDictionary<string, string> seedDiskTags = null, IDictionary<string, string> targetDiskTags = null, IDictionary<string, string> targetNicTags = null)
        {
            disksToInclude ??= new List<VMwareCbtDiskContent>();
            targetVmTags ??= new Dictionary<string, string>();
            seedDiskTags ??= new Dictionary<string, string>();
            targetDiskTags ??= new Dictionary<string, string>();
            targetNicTags ??= new Dictionary<string, string>();

            return new VMwareCbtEnableMigrationContent(
                "VMwareCbt",
                serializedAdditionalRawData: null,
                vmwareMachineId,
                disksToInclude?.ToList(),
                licenseType,
                sqlServerLicenseType,
                performSqlBulkRegistration,
                dataMoverRunAsAccountId,
                snapshotRunAsAccountId,
                targetVmName,
                targetVmSize,
                targetResourceGroupId,
                targetNetworkId,
                testNetworkId,
                targetSubnetName,
                testSubnetName,
                targetAvailabilitySetId,
                targetAvailabilityZone,
                targetProximityPlacementGroupId,
                confidentialVmKeyVaultId,
                targetVmSecurityProfile,
                targetBootDiagnosticsStorageAccountId,
                performAutoResync,
                targetVmTags,
                seedDiskTags,
                targetDiskTags,
                targetNicTags);
        }

        /// <summary> Initializes a new instance of <see cref="Models.VMwareCbtEventDetails"/>. </summary>
        /// <param name="migrationItemName"> The migration item name. </param>
        /// <returns> A new <see cref="Models.VMwareCbtEventDetails"/> instance for mocking. </returns>
        public static VMwareCbtEventDetails VMwareCbtEventDetails(string migrationItemName = null)
        {
            return new VMwareCbtEventDetails("VMwareCbt", serializedAdditionalRawData: null, migrationItemName);
        }

        /// <summary> Initializes a new instance of <see cref="Models.VMwareCbtMigrateContent"/>. </summary>
        /// <param name="performShutdown"> A value indicating whether VM is to be shutdown. </param>
        /// <param name="osUpgradeVersion"> A value indicating the inplace OS Upgrade version. </param>
        /// <returns> A new <see cref="Models.VMwareCbtMigrateContent"/> instance for mocking. </returns>
        public static VMwareCbtMigrateContent VMwareCbtMigrateContent(string performShutdown = null, string osUpgradeVersion = null)
        {
            return new VMwareCbtMigrateContent("VMwareCbt", serializedAdditionalRawData: null, performShutdown, osUpgradeVersion);
        }

        /// <summary> Initializes a new instance of <see cref="Models.VMwareCbtMigrationDetails"/>. </summary>
        /// <param name="vmwareMachineId"> The ARM Id of the VM discovered in VMware. </param>
        /// <param name="osType"> The type of the OS on the VM. </param>
        /// <param name="osName"> The name of the OS on the VM. </param>
        /// <param name="firmwareType"> The firmware type. </param>
        /// <param name="targetGeneration"> The target generation. </param>
        /// <param name="licenseType"> License Type of the VM to be used. </param>
        /// <param name="sqlServerLicenseType"> The SQL Server license type. </param>
        /// <param name="dataMoverRunAsAccountId"> The data mover run as account Id. </param>
        /// <param name="snapshotRunAsAccountId"> The snapshot run as account Id. </param>
        /// <param name="storageAccountId"> The replication storage account ARM Id. This is applicable only for the blob based replication test hook. </param>
        /// <param name="targetVmName"> Target VM name. </param>
        /// <param name="targetVmSize"> The target VM size. </param>
        /// <param name="targetLocation"> The target location. </param>
        /// <param name="targetResourceGroupId"> The target resource group Id. </param>
        /// <param name="targetAvailabilitySetId"> The target availability set Id. </param>
        /// <param name="targetAvailabilityZone"> The target availability zone. </param>
        /// <param name="targetProximityPlacementGroupId"> The target proximity placement group Id. </param>
        /// <param name="confidentialVmKeyVaultId"> The confidential VM key vault Id for ADE installation. </param>
        /// <param name="targetVmSecurityProfile"> The target VM security profile. </param>
        /// <param name="targetBootDiagnosticsStorageAccountId"> The target boot diagnostics storage account ARM Id. </param>
        /// <param name="targetVmTags"> The target VM tags. </param>
        /// <param name="protectedDisks"> The list of protected disks. </param>
        /// <param name="targetNetworkId"> The target network Id. </param>
        /// <param name="testNetworkId"> The test network Id. </param>
        /// <param name="vmNics"> The network details. </param>
        /// <param name="targetNicTags"> The tags for the target NICs. </param>
        /// <param name="migrationRecoveryPointId"> The recovery point Id to which the VM was migrated. </param>
        /// <param name="lastRecoveryPointReceived"> The last recovery point received time. </param>
        /// <param name="lastRecoveryPointId"> The last recovery point Id. </param>
        /// <param name="initialSeedingProgressPercentage"> The initial seeding progress percentage. </param>
        /// <param name="migrationProgressPercentage"> The migration progress percentage. </param>
        /// <param name="resyncProgressPercentage"> The resync progress percentage. </param>
        /// <param name="resumeProgressPercentage"> The resume progress percentage. </param>
        /// <param name="deltaSyncProgressPercentage"> The delta sync progress percentage. </param>
        /// <param name="isCheckSumResyncCycle"> A value indicating whether checksum resync cycle is in progress. </param>
        /// <param name="initialSeedingRetryCount"> The initial seeding retry count. </param>
        /// <param name="resyncRetryCount"> The resync retry count. </param>
        /// <param name="resumeRetryCount"> The resume retry count. </param>
        /// <param name="deltaSyncRetryCount"> The delta sync retry count. </param>
        /// <param name="resyncRequired"> A value indicating whether resync is required. </param>
        /// <param name="resyncState"> The resync state. </param>
        /// <param name="performAutoResync"> A value indicating whether auto resync is to be done. </param>
        /// <param name="seedDiskTags"> The tags for the seed disks. </param>
        /// <param name="targetDiskTags"> The tags for the target disks. </param>
        /// <param name="supportedOSVersions"> A value indicating the inplace OS Upgrade version. </param>
        /// <param name="applianceMonitoringDetails"> A value indicating the appliance monitoring details. </param>
        /// <param name="gatewayOperationDetails"> A value indicating the gateway operation details. </param>
        /// <param name="operationName"> A value indicating the SRS operation name. </param>
        /// <returns> A new <see cref="Models.VMwareCbtMigrationDetails"/> instance for mocking. </returns>
        public static VMwareCbtMigrationDetails VMwareCbtMigrationDetails(ResourceIdentifier vmwareMachineId = null, string osType = null, string osName = null, string firmwareType = null, string targetGeneration = null, string licenseType = null, string sqlServerLicenseType = null, ResourceIdentifier dataMoverRunAsAccountId = null, ResourceIdentifier snapshotRunAsAccountId = null, ResourceIdentifier storageAccountId = null, string targetVmName = null, string targetVmSize = null, string targetLocation = null, ResourceIdentifier targetResourceGroupId = null, ResourceIdentifier targetAvailabilitySetId = null, string targetAvailabilityZone = null, ResourceIdentifier targetProximityPlacementGroupId = null, ResourceIdentifier confidentialVmKeyVaultId = null, VMwareCbtSecurityProfileProperties targetVmSecurityProfile = null, ResourceIdentifier targetBootDiagnosticsStorageAccountId = null, IReadOnlyDictionary<string, string> targetVmTags = null, IEnumerable<VMwareCbtProtectedDiskDetails> protectedDisks = null, ResourceIdentifier targetNetworkId = null, ResourceIdentifier testNetworkId = null, IEnumerable<VMwareCbtNicDetails> vmNics = null, IReadOnlyDictionary<string, string> targetNicTags = null, ResourceIdentifier migrationRecoveryPointId = null, DateTimeOffset? lastRecoveryPointReceived = null, ResourceIdentifier lastRecoveryPointId = null, int? initialSeedingProgressPercentage = null, int? migrationProgressPercentage = null, int? resyncProgressPercentage = null, int? resumeProgressPercentage = null, int? deltaSyncProgressPercentage = null, string isCheckSumResyncCycle = null, long? initialSeedingRetryCount = null, long? resyncRetryCount = null, long? resumeRetryCount = null, long? deltaSyncRetryCount = null, string resyncRequired = null, SiteRecoveryResyncState? resyncState = null, string performAutoResync = null, IReadOnlyDictionary<string, string> seedDiskTags = null, IReadOnlyDictionary<string, string> targetDiskTags = null, IEnumerable<string> supportedOSVersions = null, ApplianceMonitoringDetails applianceMonitoringDetails = null, GatewayOperationDetails gatewayOperationDetails = null, string operationName = null)
        {
            targetVmTags ??= new Dictionary<string, string>();
            protectedDisks ??= new List<VMwareCbtProtectedDiskDetails>();
            vmNics ??= new List<VMwareCbtNicDetails>();
            targetNicTags ??= new Dictionary<string, string>();
            seedDiskTags ??= new Dictionary<string, string>();
            targetDiskTags ??= new Dictionary<string, string>();
            supportedOSVersions ??= new List<string>();

            return new VMwareCbtMigrationDetails(
                "VMwareCbt",
                serializedAdditionalRawData: null,
                vmwareMachineId,
                osType,
                osName,
                firmwareType,
                targetGeneration,
                licenseType,
                sqlServerLicenseType,
                dataMoverRunAsAccountId,
                snapshotRunAsAccountId,
                storageAccountId,
                targetVmName,
                targetVmSize,
                targetLocation,
                targetResourceGroupId,
                targetAvailabilitySetId,
                targetAvailabilityZone,
                targetProximityPlacementGroupId,
                confidentialVmKeyVaultId,
                targetVmSecurityProfile,
                targetBootDiagnosticsStorageAccountId,
                targetVmTags,
                protectedDisks?.ToList(),
                targetNetworkId,
                testNetworkId,
                vmNics?.ToList(),
                targetNicTags,
                migrationRecoveryPointId,
                lastRecoveryPointReceived,
                lastRecoveryPointId,
                initialSeedingProgressPercentage,
                migrationProgressPercentage,
                resyncProgressPercentage,
                resumeProgressPercentage,
                deltaSyncProgressPercentage,
                isCheckSumResyncCycle,
                initialSeedingRetryCount,
                resyncRetryCount,
                resumeRetryCount,
                deltaSyncRetryCount,
                resyncRequired,
                resyncState,
                performAutoResync,
                seedDiskTags,
                targetDiskTags,
                supportedOSVersions?.ToList(),
                applianceMonitoringDetails,
                gatewayOperationDetails,
                operationName);
        }

        /// <summary> Initializes a new instance of <see cref="Models.VMwareCbtProtectedDiskDetails"/>. </summary>
        /// <param name="diskId"> The disk id. </param>
        /// <param name="diskName"> The disk name. </param>
        /// <param name="diskType"> The disk type. </param>
        /// <param name="diskPath"> The disk path. </param>
        /// <param name="isOSDisk"> A value indicating whether the disk is the OS disk. </param>
        /// <param name="capacityInBytes"> The disk capacity in bytes. </param>
        /// <param name="logStorageAccountId"> The log storage account ARM Id. </param>
        /// <param name="logStorageAccountSasSecretName"> The key vault secret name of the log storage account. </param>
        /// <param name="diskEncryptionSetId"> The DiskEncryptionSet ARM Id. </param>
        /// <param name="seedManagedDiskId"> The ARM Id of the seed managed disk. </param>
        /// <param name="seedBlobUri"> The uri of the seed blob. </param>
        /// <param name="targetManagedDiskId"> The ARM Id of the target managed disk. </param>
        /// <param name="targetBlobUri"> The uri of the target blob. </param>
        /// <param name="targetDiskName"> The name for the target managed disk. </param>
        /// <param name="gatewayOperationDetails"> A value indicating the gateway operation details. </param>
        /// <returns> A new <see cref="Models.VMwareCbtProtectedDiskDetails"/> instance for mocking. </returns>
        public static VMwareCbtProtectedDiskDetails VMwareCbtProtectedDiskDetails(string diskId = null, string diskName = null, SiteRecoveryDiskAccountType? diskType = null, string diskPath = null, string isOSDisk = null, long? capacityInBytes = null, ResourceIdentifier logStorageAccountId = null, string logStorageAccountSasSecretName = null, ResourceIdentifier diskEncryptionSetId = null, string seedManagedDiskId = null, Uri seedBlobUri = null, string targetManagedDiskId = null, Uri targetBlobUri = null, string targetDiskName = null, GatewayOperationDetails gatewayOperationDetails = null)
        {
            return new VMwareCbtProtectedDiskDetails(
                diskId,
                diskName,
                diskType,
                diskPath,
                isOSDisk,
                capacityInBytes,
                logStorageAccountId,
                logStorageAccountSasSecretName,
                diskEncryptionSetId,
                seedManagedDiskId,
                seedBlobUri,
                targetManagedDiskId,
                targetBlobUri,
                targetDiskName,
                gatewayOperationDetails,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.VMwareCbtNicDetails"/>. </summary>
        /// <param name="nicId"> The NIC Id. </param>
        /// <param name="isPrimaryNic"> A value indicating whether this is the primary NIC. </param>
        /// <param name="sourceIPAddress"> The source IP address. </param>
        /// <param name="sourceIPAddressType"> The source IP address type. </param>
        /// <param name="sourceNetworkId"> Source network Id. </param>
        /// <param name="targetIPAddress"> The target IP address. </param>
        /// <param name="targetIPAddressType"> The target IP address type. </param>
        /// <param name="targetSubnetName"> Target subnet name. </param>
        /// <param name="testNetworkId"> Source network Id. </param>
        /// <param name="testSubnetName"> Test subnet name. </param>
        /// <param name="testIPAddress"> The test IP address. </param>
        /// <param name="testIPAddressType"> The test IP address type. </param>
        /// <param name="targetNicName"> Target NIC name. </param>
        /// <param name="isSelectedForMigration"> A value indicating whether this NIC is selected for migration. </param>
        /// <returns> A new <see cref="Models.VMwareCbtNicDetails"/> instance for mocking. </returns>
        public static VMwareCbtNicDetails VMwareCbtNicDetails(string nicId = null, string isPrimaryNic = null, IPAddress sourceIPAddress = null, SiteRecoveryEthernetAddressType? sourceIPAddressType = null, ResourceIdentifier sourceNetworkId = null, IPAddress targetIPAddress = null, SiteRecoveryEthernetAddressType? targetIPAddressType = null, string targetSubnetName = null, ResourceIdentifier testNetworkId = null, string testSubnetName = null, IPAddress testIPAddress = null, SiteRecoveryEthernetAddressType? testIPAddressType = null, string targetNicName = null, string isSelectedForMigration = null)
        {
            return new VMwareCbtNicDetails(
                nicId,
                isPrimaryNic,
                sourceIPAddress,
                sourceIPAddressType,
                sourceNetworkId,
                targetIPAddress,
                targetIPAddressType,
                targetSubnetName,
                testNetworkId,
                testSubnetName,
                testIPAddress,
                testIPAddressType,
                targetNicName,
                isSelectedForMigration,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.VMwareCbtNicContent"/>. </summary>
        /// <param name="nicId"> The NIC Id. </param>
        /// <param name="isPrimaryNic"> A value indicating whether this is the primary NIC. </param>
        /// <param name="targetSubnetName"> Target subnet name. </param>
        /// <param name="targetStaticIPAddress"> The static IP address. </param>
        /// <param name="isSelectedForMigration"> A value indicating whether this NIC is selected for migration. </param>
        /// <param name="targetNicName"> Target NIC name. </param>
        /// <param name="testSubnetName"> The test subnet name. </param>
        /// <param name="testStaticIPAddress"> The test static IP address. </param>
        /// <returns> A new <see cref="Models.VMwareCbtNicContent"/> instance for mocking. </returns>
        public static VMwareCbtNicContent VMwareCbtNicContent(string nicId = null, string isPrimaryNic = null, string targetSubnetName = null, IPAddress targetStaticIPAddress = null, string isSelectedForMigration = null, string targetNicName = null, string testSubnetName = null, IPAddress testStaticIPAddress = null)
        {
            return new VMwareCbtNicContent(
                nicId,
                isPrimaryNic,
                targetSubnetName,
                targetStaticIPAddress,
                isSelectedForMigration,
                targetNicName,
                testSubnetName,
                testStaticIPAddress,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.VMwareCbtPolicyDetails"/>. </summary>
        /// <param name="recoveryPointHistoryInMinutes"> The duration in minutes until which the recovery points need to be stored. </param>
        /// <param name="appConsistentFrequencyInMinutes"> The app consistent snapshot frequency in minutes. </param>
        /// <param name="crashConsistentFrequencyInMinutes"> The crash consistent snapshot frequency in minutes. </param>
        /// <returns> A new <see cref="Models.VMwareCbtPolicyDetails"/> instance for mocking. </returns>
        public static VMwareCbtPolicyDetails VMwareCbtPolicyDetails(int? recoveryPointHistoryInMinutes = null, int? appConsistentFrequencyInMinutes = null, int? crashConsistentFrequencyInMinutes = null)
        {
            return new VMwareCbtPolicyDetails("VMwareCbt", serializedAdditionalRawData: null, recoveryPointHistoryInMinutes, appConsistentFrequencyInMinutes, crashConsistentFrequencyInMinutes);
        }

        /// <summary> Initializes a new instance of <see cref="Models.VMwareCbtProtectionContainerMappingDetails"/>. </summary>
        /// <param name="keyVaultId"> The target key vault ARM Id. </param>
        /// <param name="keyVaultUri"> The target key vault URI. </param>
        /// <param name="storageAccountId"> The storage account ARM Id. </param>
        /// <param name="storageAccountSasSecretName"> The secret name of the storage account. </param>
        /// <param name="serviceBusConnectionStringSecretName"> The secret name of the service bus connection string. </param>
        /// <param name="targetLocation"> The target location. </param>
        /// <param name="roleSizeToNicCountMap"> The role size to NIC count map. </param>
        /// <param name="excludedSkus"> The SKUs to be excluded. </param>
        /// <returns> A new <see cref="Models.VMwareCbtProtectionContainerMappingDetails"/> instance for mocking. </returns>
        public static VMwareCbtProtectionContainerMappingDetails VMwareCbtProtectionContainerMappingDetails(ResourceIdentifier keyVaultId = null, Uri keyVaultUri = null, ResourceIdentifier storageAccountId = null, string storageAccountSasSecretName = null, string serviceBusConnectionStringSecretName = null, string targetLocation = null, IReadOnlyDictionary<string, int> roleSizeToNicCountMap = null, IEnumerable<string> excludedSkus = null)
        {
            roleSizeToNicCountMap ??= new Dictionary<string, int>();
            excludedSkus ??= new List<string>();

            return new VMwareCbtProtectionContainerMappingDetails(
                "VMwareCbt",
                serializedAdditionalRawData: null,
                keyVaultId,
                keyVaultUri,
                storageAccountId,
                storageAccountSasSecretName,
                serviceBusConnectionStringSecretName,
                targetLocation,
                roleSizeToNicCountMap,
                excludedSkus?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.VMwareCbtResyncContent"/>. </summary>
        /// <param name="skipCbtReset"> A value indicating whether CBT is to be reset. </param>
        /// <returns> A new <see cref="Models.VMwareCbtResyncContent"/> instance for mocking. </returns>
        public static VMwareCbtResyncContent VMwareCbtResyncContent(string skipCbtReset = null)
        {
            return new VMwareCbtResyncContent("VMwareCbt", serializedAdditionalRawData: null, skipCbtReset);
        }

        /// <summary> Initializes a new instance of <see cref="Models.VMwareCbtTestMigrateContent"/>. </summary>
        /// <param name="recoveryPointId"> The recovery point Id. </param>
        /// <param name="networkId"> The test network Id. </param>
        /// <param name="vmNics"> The list of NIC details. </param>
        /// <param name="osUpgradeVersion"> A value indicating the inplace OS Upgrade version. </param>
        /// <returns> A new <see cref="Models.VMwareCbtTestMigrateContent"/> instance for mocking. </returns>
        public static VMwareCbtTestMigrateContent VMwareCbtTestMigrateContent(ResourceIdentifier recoveryPointId = null, ResourceIdentifier networkId = null, IEnumerable<VMwareCbtNicContent> vmNics = null, string osUpgradeVersion = null)
        {
            vmNics ??= new List<VMwareCbtNicContent>();

            return new VMwareCbtTestMigrateContent(
                "VMwareCbt",
                serializedAdditionalRawData: null,
                recoveryPointId,
                networkId,
                vmNics?.ToList(),
                osUpgradeVersion);
        }

        /// <summary> Initializes a new instance of <see cref="Models.VMwareCbtUpdateDiskContent"/>. </summary>
        /// <param name="diskId"> The disk Id. </param>
        /// <param name="targetDiskName"> The target disk name. </param>
        /// <param name="isOSDisk"> A value indicating whether the disk is the OS disk. </param>
        /// <returns> A new <see cref="Models.VMwareCbtUpdateDiskContent"/> instance for mocking. </returns>
        public static VMwareCbtUpdateDiskContent VMwareCbtUpdateDiskContent(string diskId = null, string targetDiskName = null, string isOSDisk = null)
        {
            return new VMwareCbtUpdateDiskContent(diskId, targetDiskName, isOSDisk, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.VMwareDetails"/>. </summary>
        /// <param name="processServers"> The list of Process Servers associated with the fabric. </param>
        /// <param name="masterTargetServers"> The list of Master Target servers associated with the fabric. </param>
        /// <param name="runAsAccounts"> The list of run as accounts created on the server. </param>
        /// <param name="replicationPairCount"> The number of replication pairs configured in this CS. </param>
        /// <param name="processServerCount"> The number of process servers. </param>
        /// <param name="agentCount"> The number of source and target servers configured to talk to this CS. </param>
        /// <param name="protectedServers"> The number of protected servers. </param>
        /// <param name="systemLoad"> The percentage of the system load. </param>
        /// <param name="systemLoadStatus"> The system load status. </param>
        /// <param name="cpuLoad"> The percentage of the CPU load. </param>
        /// <param name="cpuLoadStatus"> The CPU load status. </param>
        /// <param name="totalMemoryInBytes"> The total memory. </param>
        /// <param name="availableMemoryInBytes"> The available memory. </param>
        /// <param name="memoryUsageStatus"> The memory usage status. </param>
        /// <param name="totalSpaceInBytes"> The total space. </param>
        /// <param name="availableSpaceInBytes"> The available space. </param>
        /// <param name="spaceUsageStatus"> The space usage status. </param>
        /// <param name="webLoad"> The web load. </param>
        /// <param name="webLoadStatus"> The web load status. </param>
        /// <param name="databaseServerLoad"> The database server load. </param>
        /// <param name="databaseServerLoadStatus"> The database server load status. </param>
        /// <param name="csServiceStatus"> The CS service status. </param>
        /// <param name="ipAddress"> The IP address. </param>
        /// <param name="agentVersion"> The agent Version. </param>
        /// <param name="hostName"> The host name. </param>
        /// <param name="lastHeartbeat"> The last heartbeat received from CS server. </param>
        /// <param name="versionStatus"> Version status. </param>
        /// <param name="sslCertExpireOn"> CS SSL cert expiry date. </param>
        /// <param name="sslCertExpiryRemainingDays"> CS SSL cert expiry date. </param>
        /// <param name="psTemplateVersion"> PS template version. </param>
        /// <param name="agentExpireOn"> Agent expiry date. </param>
        /// <param name="agentVersionDetails"> The agent version details. </param>
        /// <param name="switchProviderBlockingErrorDetails"> The switch provider blocking error information. </param>
        /// <returns> A new <see cref="Models.VMwareDetails"/> instance for mocking. </returns>
        public static VMwareDetails VMwareDetails(IEnumerable<SiteRecoveryProcessServer> processServers = null, IEnumerable<MasterTargetServer> masterTargetServers = null, IEnumerable<SiteRecoveryRunAsAccount> runAsAccounts = null, string replicationPairCount = null, string processServerCount = null, string agentCount = null, string protectedServers = null, string systemLoad = null, string systemLoadStatus = null, string cpuLoad = null, string cpuLoadStatus = null, long? totalMemoryInBytes = null, long? availableMemoryInBytes = null, string memoryUsageStatus = null, long? totalSpaceInBytes = null, long? availableSpaceInBytes = null, string spaceUsageStatus = null, string webLoad = null, string webLoadStatus = null, string databaseServerLoad = null, string databaseServerLoadStatus = null, string csServiceStatus = null, IPAddress ipAddress = null, string agentVersion = null, string hostName = null, DateTimeOffset? lastHeartbeat = null, string versionStatus = null, DateTimeOffset? sslCertExpireOn = null, int? sslCertExpiryRemainingDays = null, string psTemplateVersion = null, DateTimeOffset? agentExpireOn = null, SiteRecoveryVersionDetails agentVersionDetails = null, IEnumerable<InMageFabricSwitchProviderBlockingErrorDetails> switchProviderBlockingErrorDetails = null)
        {
            processServers ??= new List<SiteRecoveryProcessServer>();
            masterTargetServers ??= new List<MasterTargetServer>();
            runAsAccounts ??= new List<SiteRecoveryRunAsAccount>();
            switchProviderBlockingErrorDetails ??= new List<InMageFabricSwitchProviderBlockingErrorDetails>();

            return new VMwareDetails(
                "VMware",
                serializedAdditionalRawData: null,
                processServers?.ToList(),
                masterTargetServers?.ToList(),
                runAsAccounts?.ToList(),
                replicationPairCount,
                processServerCount,
                agentCount,
                protectedServers,
                systemLoad,
                systemLoadStatus,
                cpuLoad,
                cpuLoadStatus,
                totalMemoryInBytes,
                availableMemoryInBytes,
                memoryUsageStatus,
                totalSpaceInBytes,
                availableSpaceInBytes,
                spaceUsageStatus,
                webLoad,
                webLoadStatus,
                databaseServerLoad,
                databaseServerLoadStatus,
                csServiceStatus,
                ipAddress,
                agentVersion,
                hostName,
                lastHeartbeat,
                versionStatus,
                sslCertExpireOn,
                sslCertExpiryRemainingDays,
                psTemplateVersion,
                agentExpireOn,
                agentVersionDetails,
                switchProviderBlockingErrorDetails?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.VMwareV2FabricCreationContent"/>. </summary>
        /// <param name="vmwareSiteId"> The ARM Id of the VMware site. </param>
        /// <param name="physicalSiteId"> The ARM Id of the physical site. </param>
        /// <param name="migrationSolutionId"> The ARM Id of the migration solution. </param>
        /// <returns> A new <see cref="Models.VMwareV2FabricCreationContent"/> instance for mocking. </returns>
        public static VMwareV2FabricCreationContent VMwareV2FabricCreationContent(ResourceIdentifier vmwareSiteId = null, ResourceIdentifier physicalSiteId = null, ResourceIdentifier migrationSolutionId = null)
        {
            return new VMwareV2FabricCreationContent("VMwareV2", serializedAdditionalRawData: null, vmwareSiteId, physicalSiteId, migrationSolutionId);
        }

        /// <summary> Initializes a new instance of <see cref="Models.VMwareV2FabricSpecificDetails"/>. </summary>
        /// <param name="vmwareSiteId"> The ARM Id of the VMware site. </param>
        /// <param name="physicalSiteId"> The ARM Id of the physical site. </param>
        /// <param name="migrationSolutionId"> The Migration solution ARM Id. </param>
        /// <param name="serviceEndpoint"> The service endpoint. </param>
        /// <param name="serviceResourceId"> The service resource Id. </param>
        /// <param name="serviceContainerId"> The service container Id. </param>
        /// <param name="processServers"> The list of process servers. </param>
        /// <returns> A new <see cref="Models.VMwareV2FabricSpecificDetails"/> instance for mocking. </returns>
        public static VMwareV2FabricSpecificDetails VMwareV2FabricSpecificDetails(ResourceIdentifier vmwareSiteId = null, ResourceIdentifier physicalSiteId = null, ResourceIdentifier migrationSolutionId = null, string serviceEndpoint = null, ResourceIdentifier serviceResourceId = null, string serviceContainerId = null, IEnumerable<SiteRecoveryProcessServerDetails> processServers = null)
        {
            processServers ??= new List<SiteRecoveryProcessServerDetails>();

            return new VMwareV2FabricSpecificDetails(
                "VMwareV2",
                serializedAdditionalRawData: null,
                vmwareSiteId,
                physicalSiteId,
                migrationSolutionId,
                serviceEndpoint,
                serviceResourceId,
                serviceContainerId,
                processServers?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.VMwareVmDetails"/>. </summary>
        /// <param name="agentGeneratedId"> The ID generated by the InMage agent after it gets installed on guest. This is the ID to be used during InMage CreateProtection. </param>
        /// <param name="agentInstalled"> The value indicating if InMage scout agent is installed on guest. </param>
        /// <param name="osType"> The OsType installed on VM. </param>
        /// <param name="agentVersion"> The agent version. </param>
        /// <param name="ipAddress"> The IP address. </param>
        /// <param name="poweredOn"> The value indicating whether VM is powered on. </param>
        /// <param name="vCenterInfrastructureId"> The VCenter infrastructure Id. </param>
        /// <param name="discoveryType"> A value indicating the discovery type of the machine. Value can be vCenter or physical. </param>
        /// <param name="diskDetails"> The disk details. </param>
        /// <param name="validationErrors"> The validation errors. </param>
        /// <returns> A new <see cref="Models.VMwareVmDetails"/> instance for mocking. </returns>
        public static VMwareVmDetails VMwareVmDetails(string agentGeneratedId = null, string agentInstalled = null, string osType = null, string agentVersion = null, IPAddress ipAddress = null, string poweredOn = null, string vCenterInfrastructureId = null, string discoveryType = null, IEnumerable<InMageDiskDetails> diskDetails = null, IEnumerable<SiteRecoveryHealthError> validationErrors = null)
        {
            diskDetails ??= new List<InMageDiskDetails>();
            validationErrors ??= new List<SiteRecoveryHealthError>();

            return new VMwareVmDetails(
                "VMwareVirtualMachine",
                serializedAdditionalRawData: null,
                agentGeneratedId,
                agentInstalled,
                osType,
                agentVersion,
                ipAddress,
                poweredOn,
                vCenterInfrastructureId,
                discoveryType,
                diskDetails?.ToList(),
                validationErrors?.ToList());
        }
    }
}
