// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.RecoveryServicesSiteRecovery.Models;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Samples
{
    public partial class Sample_SiteRecoveryPolicyResource
    {
        // Gets the requested policy.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetsTheRequestedPolicy()
        {
            // Generated from example definition: specification/recoveryservicessiterecovery/resource-manager/Microsoft.RecoveryServices/stable/2023-08-01/examples/ReplicationPolicies_Get.json
            // this example is just showing the usage of "ReplicationPolicies_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SiteRecoveryPolicyResource created on azure
            // for more information of creating SiteRecoveryPolicyResource, please refer to the document of SiteRecoveryPolicyResource
            string subscriptionId = "c183865e-6077-46f2-a3b1-deb0f4f4650a";
            string resourceGroupName = "resourceGroupPS1";
            string resourceName = "vault1";
            string policyName = "protectionprofile1";
            ResourceIdentifier siteRecoveryPolicyResourceId = SiteRecoveryPolicyResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, policyName);
            SiteRecoveryPolicyResource siteRecoveryPolicy = client.GetSiteRecoveryPolicyResource(siteRecoveryPolicyResourceId);

            // invoke the operation
            SiteRecoveryPolicyResource result = await siteRecoveryPolicy.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SiteRecoveryPolicyData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Delete the policy.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteThePolicy()
        {
            // Generated from example definition: specification/recoveryservicessiterecovery/resource-manager/Microsoft.RecoveryServices/stable/2023-08-01/examples/ReplicationPolicies_Delete.json
            // this example is just showing the usage of "ReplicationPolicies_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SiteRecoveryPolicyResource created on azure
            // for more information of creating SiteRecoveryPolicyResource, please refer to the document of SiteRecoveryPolicyResource
            string subscriptionId = "c183865e-6077-46f2-a3b1-deb0f4f4650a";
            string resourceGroupName = "resourceGroupPS1";
            string resourceName = "vault1";
            string policyName = "protectionprofile1";
            ResourceIdentifier siteRecoveryPolicyResourceId = SiteRecoveryPolicyResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, policyName);
            SiteRecoveryPolicyResource siteRecoveryPolicy = client.GetSiteRecoveryPolicyResource(siteRecoveryPolicyResourceId);

            // invoke the operation
            await siteRecoveryPolicy.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // Updates the policy.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdatesThePolicy()
        {
            // Generated from example definition: specification/recoveryservicessiterecovery/resource-manager/Microsoft.RecoveryServices/stable/2023-08-01/examples/ReplicationPolicies_Update.json
            // this example is just showing the usage of "ReplicationPolicies_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SiteRecoveryPolicyResource created on azure
            // for more information of creating SiteRecoveryPolicyResource, please refer to the document of SiteRecoveryPolicyResource
            string subscriptionId = "c183865e-6077-46f2-a3b1-deb0f4f4650a";
            string resourceGroupName = "resourceGroupPS1";
            string resourceName = "vault1";
            string policyName = "protectionprofile1";
            ResourceIdentifier siteRecoveryPolicyResourceId = SiteRecoveryPolicyResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, policyName);
            SiteRecoveryPolicyResource siteRecoveryPolicy = client.GetSiteRecoveryPolicyResource(siteRecoveryPolicyResourceId);

            // invoke the operation
            SiteRecoveryPolicyPatch patch = new SiteRecoveryPolicyPatch()
            {
                UpdatePolicyContentReplicationProviderSettings = new HyperVReplicaAzurePolicyContent(),
            };
            ArmOperation<SiteRecoveryPolicyResource> lro = await siteRecoveryPolicy.UpdateAsync(WaitUntil.Completed, patch);
            SiteRecoveryPolicyResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SiteRecoveryPolicyData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
