// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.RecoveryServicesSiteRecovery.Models;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Samples
{
    public partial class Sample_SiteRecoveryNetworkMappingResource
    {
        // Gets network mapping by name.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetsNetworkMappingByName()
        {
            // Generated from example definition: specification/recoveryservicessiterecovery/resource-manager/Microsoft.RecoveryServices/stable/2023-08-01/examples/ReplicationNetworkMappings_Get.json
            // this example is just showing the usage of "ReplicationNetworkMappings_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SiteRecoveryNetworkMappingResource created on azure
            // for more information of creating SiteRecoveryNetworkMappingResource, please refer to the document of SiteRecoveryNetworkMappingResource
            string subscriptionId = "9112a37f-0f3e-46ec-9c00-060c6edca071";
            string resourceGroupName = "srcBvte2a14C27";
            string resourceName = "srce2avaultbvtaC27";
            string fabricName = "b0cef6e9a4437b81803d0b55ada4f700ab66caae59c35d62723a1589c0cd13ac";
            string networkName = "e2267b5c-2650-49bd-ab3f-d66aae694c06";
            string networkMappingName = "corpe2amap";
            ResourceIdentifier siteRecoveryNetworkMappingResourceId = SiteRecoveryNetworkMappingResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, fabricName, networkName, networkMappingName);
            SiteRecoveryNetworkMappingResource siteRecoveryNetworkMapping = client.GetSiteRecoveryNetworkMappingResource(siteRecoveryNetworkMappingResourceId);

            // invoke the operation
            SiteRecoveryNetworkMappingResource result = await siteRecoveryNetworkMapping.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SiteRecoveryNetworkMappingData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Delete network mapping.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteNetworkMapping()
        {
            // Generated from example definition: specification/recoveryservicessiterecovery/resource-manager/Microsoft.RecoveryServices/stable/2023-08-01/examples/ReplicationNetworkMappings_Delete.json
            // this example is just showing the usage of "ReplicationNetworkMappings_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SiteRecoveryNetworkMappingResource created on azure
            // for more information of creating SiteRecoveryNetworkMappingResource, please refer to the document of SiteRecoveryNetworkMappingResource
            string subscriptionId = "9112a37f-0f3e-46ec-9c00-060c6edca071";
            string resourceGroupName = "srcBvte2a14C27";
            string resourceName = "srce2avaultbvtaC27";
            string fabricName = "b0cef6e9a4437b81803d0b55ada4f700ab66caae59c35d62723a1589c0cd13ac";
            string networkName = "e2267b5c-2650-49bd-ab3f-d66aae694c06";
            string networkMappingName = "corpe2amap";
            ResourceIdentifier siteRecoveryNetworkMappingResourceId = SiteRecoveryNetworkMappingResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, fabricName, networkName, networkMappingName);
            SiteRecoveryNetworkMappingResource siteRecoveryNetworkMapping = client.GetSiteRecoveryNetworkMappingResource(siteRecoveryNetworkMappingResourceId);

            // invoke the operation
            await siteRecoveryNetworkMapping.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // Updates network mapping.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdatesNetworkMapping()
        {
            // Generated from example definition: specification/recoveryservicessiterecovery/resource-manager/Microsoft.RecoveryServices/stable/2023-08-01/examples/ReplicationNetworkMappings_Update.json
            // this example is just showing the usage of "ReplicationNetworkMappings_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SiteRecoveryNetworkMappingResource created on azure
            // for more information of creating SiteRecoveryNetworkMappingResource, please refer to the document of SiteRecoveryNetworkMappingResource
            string subscriptionId = "9112a37f-0f3e-46ec-9c00-060c6edca071";
            string resourceGroupName = "srcBvte2a14C27";
            string resourceName = "srce2avaultbvtaC27";
            string fabricName = "b0cef6e9a4437b81803d0b55ada4f700ab66caae59c35d62723a1589c0cd13ac";
            string networkName = "e2267b5c-2650-49bd-ab3f-d66aae694c06";
            string networkMappingName = "corpe2amap";
            ResourceIdentifier siteRecoveryNetworkMappingResourceId = SiteRecoveryNetworkMappingResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, fabricName, networkName, networkMappingName);
            SiteRecoveryNetworkMappingResource siteRecoveryNetworkMapping = client.GetSiteRecoveryNetworkMappingResource(siteRecoveryNetworkMappingResourceId);

            // invoke the operation
            SiteRecoveryNetworkMappingPatch patch = new SiteRecoveryNetworkMappingPatch()
            {
                Properties = new UpdateNetworkMappingProperties()
                {
                    RecoveryFabricName = "Microsoft Azure",
                    RecoveryNetworkId = new ResourceIdentifier("/subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/siterecoveryProd1/providers/Microsoft.Network/virtualNetworks/vnetavrai2"),
                    FabricSpecificDetails = new VmmToAzureUpdateNetworkMappingContent(),
                },
            };
            ArmOperation<SiteRecoveryNetworkMappingResource> lro = await siteRecoveryNetworkMapping.UpdateAsync(WaitUntil.Completed, patch);
            SiteRecoveryNetworkMappingResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SiteRecoveryNetworkMappingData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Gets all the network mappings under a vault.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetSiteRecoveryNetworkMappings_GetsAllTheNetworkMappingsUnderAVault()
        {
            // Generated from example definition: specification/recoveryservicessiterecovery/resource-manager/Microsoft.RecoveryServices/stable/2023-08-01/examples/ReplicationNetworkMappings_List.json
            // this example is just showing the usage of "ReplicationNetworkMappings_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "9112a37f-0f3e-46ec-9c00-060c6edca071";
            string resourceGroupName = "srcBvte2a14C27";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // invoke the operation and iterate over the result
            string resourceName = "srce2avaultbvtaC27";
            await foreach (SiteRecoveryNetworkMappingResource item in resourceGroupResource.GetSiteRecoveryNetworkMappingsAsync(resourceName))
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                SiteRecoveryNetworkMappingData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
