// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Samples
{
    public partial class Sample_SiteRecoveryEventResource
    {
        // Get the details of an Azure Site recovery event.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetTheDetailsOfAnAzureSiteRecoveryEvent()
        {
            // Generated from example definition: specification/recoveryservicessiterecovery/resource-manager/Microsoft.RecoveryServices/stable/2023-08-01/examples/ReplicationEvents_Get.json
            // this example is just showing the usage of "ReplicationEvents_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SiteRecoveryEventResource created on azure
            // for more information of creating SiteRecoveryEventResource, please refer to the document of SiteRecoveryEventResource
            string subscriptionId = "c183865e-6077-46f2-a3b1-deb0f4f4650a";
            string resourceGroupName = "resourceGroupPS1";
            string resourceName = "vault1";
            string eventName = "654b71d0-b2ce-4e6e-a861-98528d4bd375";
            ResourceIdentifier siteRecoveryEventResourceId = SiteRecoveryEventResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, eventName);
            SiteRecoveryEventResource siteRecoveryEvent = client.GetSiteRecoveryEventResource(siteRecoveryEventResourceId);

            // invoke the operation
            SiteRecoveryEventResource result = await siteRecoveryEvent.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SiteRecoveryEventData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
