// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Net;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.RecoveryServicesSiteRecovery.Models;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Samples
{
    public partial class Sample_ReplicationProtectedItemResource
    {
        // Gets the details of a Replication protected item.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetsTheDetailsOfAReplicationProtectedItem()
        {
            // Generated from example definition: specification/recoveryservicessiterecovery/resource-manager/Microsoft.RecoveryServices/stable/2023-08-01/examples/ReplicationProtectedItems_Get.json
            // this example is just showing the usage of "ReplicationProtectedItems_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ReplicationProtectedItemResource created on azure
            // for more information of creating ReplicationProtectedItemResource, please refer to the document of ReplicationProtectedItemResource
            string subscriptionId = "c183865e-6077-46f2-a3b1-deb0f4f4650a";
            string resourceGroupName = "resourceGroupPS1";
            string resourceName = "vault1";
            string fabricName = "cloud1";
            string protectionContainerName = "cloud_6d224fc6-f326-5d35-96de-fbf51efb3179";
            string replicatedProtectedItemName = "f8491e4f-817a-40dd-a90c-af773978c75b";
            ResourceIdentifier replicationProtectedItemResourceId = ReplicationProtectedItemResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, fabricName, protectionContainerName, replicatedProtectedItemName);
            ReplicationProtectedItemResource replicationProtectedItem = client.GetReplicationProtectedItemResource(replicationProtectedItemResourceId);

            // invoke the operation
            ReplicationProtectedItemResource result = await replicationProtectedItem.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ReplicationProtectedItemData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Purges protection.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_PurgesProtection()
        {
            // Generated from example definition: specification/recoveryservicessiterecovery/resource-manager/Microsoft.RecoveryServices/stable/2023-08-01/examples/ReplicationProtectedItems_Purge.json
            // this example is just showing the usage of "ReplicationProtectedItems_Purge" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ReplicationProtectedItemResource created on azure
            // for more information of creating ReplicationProtectedItemResource, please refer to the document of ReplicationProtectedItemResource
            string subscriptionId = "c183865e-6077-46f2-a3b1-deb0f4f4650a";
            string resourceGroupName = "resourceGroupPS1";
            string resourceName = "vault1";
            string fabricName = "cloud1";
            string protectionContainerName = "cloud_6d224fc6-f326-5d35-96de-fbf51efb3179";
            string replicatedProtectedItemName = "c0c14913-3d7a-48ea-9531-cc99e0e686e6";
            ResourceIdentifier replicationProtectedItemResourceId = ReplicationProtectedItemResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, fabricName, protectionContainerName, replicatedProtectedItemName);
            ReplicationProtectedItemResource replicationProtectedItem = client.GetReplicationProtectedItemResource(replicationProtectedItemResourceId);

            // invoke the operation
            await replicationProtectedItem.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // Updates the replication protected Item settings.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdatesTheReplicationProtectedItemSettings()
        {
            // Generated from example definition: specification/recoveryservicessiterecovery/resource-manager/Microsoft.RecoveryServices/stable/2023-08-01/examples/ReplicationProtectedItems_Update.json
            // this example is just showing the usage of "ReplicationProtectedItems_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ReplicationProtectedItemResource created on azure
            // for more information of creating ReplicationProtectedItemResource, please refer to the document of ReplicationProtectedItemResource
            string subscriptionId = "c183865e-6077-46f2-a3b1-deb0f4f4650a";
            string resourceGroupName = "resourceGroupPS1";
            string resourceName = "vault1";
            string fabricName = "cloud1";
            string protectionContainerName = "cloud_6d224fc6-f326-5d35-96de-fbf51efb3179";
            string replicatedProtectedItemName = "f8491e4f-817a-40dd-a90c-af773978c75b";
            ResourceIdentifier replicationProtectedItemResourceId = ReplicationProtectedItemResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, fabricName, protectionContainerName, replicatedProtectedItemName);
            ReplicationProtectedItemResource replicationProtectedItem = client.GetReplicationProtectedItemResource(replicationProtectedItemResourceId);

            // invoke the operation
            ReplicationProtectedItemPatch patch = new ReplicationProtectedItemPatch()
            {
                Properties = new UpdateReplicationProtectedItemProperties()
                {
                    RecoveryAzureVmName = "vm1",
                    RecoveryAzureVmSize = "Basic_A0",
                    SelectedRecoveryAzureNetworkId = new ResourceIdentifier("/subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/siterecoveryProd1/providers/Microsoft.Network/virtualNetworks/vnetavrai"),
                    VmNics =
{
new VmNicContentDetails()
{
NicId = "TWljcm9zb2Z0OkY4NDkxRTRGLTgxN0EtNDBERC1BOTBDLUFGNzczOTc4Qzc1Qlw3NjAwMzMxRS03NDk4LTQ0QTQtQjdDNy0xQjY1NkJDREQ1MkQ=",
IPConfigs =
{
new HyperVFailoverIPConfigDetails()
{
IPConfigName = "ipconfig1",
IsPrimary = true,
RecoverySubnetName = "subnet1",
RecoveryStaticIPAddress = IPAddress.Parse("10.0.2.46"),
}
},
SelectionType = "SelectedByUser",
}
},
                    LicenseType = SiteRecoveryLicenseType.WindowsServer,
                    ProviderSpecificDetails = new HyperVReplicaAzureUpdateReplicationProtectedItemContent(),
                },
            };
            ArmOperation<ReplicationProtectedItemResource> lro = await replicationProtectedItem.UpdateAsync(WaitUntil.Completed, patch);
            ReplicationProtectedItemResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ReplicationProtectedItemData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Add disk(s) for protection.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task AddDisks_AddDiskSForProtection()
        {
            // Generated from example definition: specification/recoveryservicessiterecovery/resource-manager/Microsoft.RecoveryServices/stable/2023-08-01/examples/ReplicationProtectedItems_AddDisks.json
            // this example is just showing the usage of "ReplicationProtectedItems_AddDisks" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ReplicationProtectedItemResource created on azure
            // for more information of creating ReplicationProtectedItemResource, please refer to the document of ReplicationProtectedItemResource
            string subscriptionId = "c183865e-6077-46f2-a3b1-deb0f4f4650a";
            string resourceGroupName = "resourceGroupPS1";
            string resourceName = "vault1";
            string fabricName = "cloud1";
            string protectionContainerName = "cloud_6d224fc6-f326-5d35-96de-fbf51efb3179";
            string replicatedProtectedItemName = "f8491e4f-817a-40dd-a90c-af773978c75b";
            ResourceIdentifier replicationProtectedItemResourceId = ReplicationProtectedItemResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, fabricName, protectionContainerName, replicatedProtectedItemName);
            ReplicationProtectedItemResource replicationProtectedItem = client.GetReplicationProtectedItemResource(replicationProtectedItemResourceId);

            // invoke the operation
            SiteRecoveryAddDisksContent content = new SiteRecoveryAddDisksContent()
            {
                SiteRecoveryAddDisksProviderSpecificDetails = new A2AAddDisksContent()
                {
                    VmDisks =
{
new A2AVmDiskDetails(new Uri("https://vmstorage.blob.core.windows.net/vhds/datadisk1.vhd"),new ResourceIdentifier("/subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourcegroups/recoveryResource/providers/Microsoft.Storage/storageAccounts/recoverystorage"),new ResourceIdentifier("/subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourcegroups/primaryResource/providers/Microsoft.Storage/storageAccounts/vmcachestorage"))
},
                },
            };
            ArmOperation<ReplicationProtectedItemResource> lro = await replicationProtectedItem.AddDisksAsync(WaitUntil.Completed, content);
            ReplicationProtectedItemResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ReplicationProtectedItemData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Change or apply recovery point.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task ApplyRecoveryPoint_ChangeOrApplyRecoveryPoint()
        {
            // Generated from example definition: specification/recoveryservicessiterecovery/resource-manager/Microsoft.RecoveryServices/stable/2023-08-01/examples/ReplicationProtectedItems_ApplyRecoveryPoint.json
            // this example is just showing the usage of "ReplicationProtectedItems_ApplyRecoveryPoint" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ReplicationProtectedItemResource created on azure
            // for more information of creating ReplicationProtectedItemResource, please refer to the document of ReplicationProtectedItemResource
            string subscriptionId = "c183865e-6077-46f2-a3b1-deb0f4f4650a";
            string resourceGroupName = "resourceGroupPS1";
            string resourceName = "vault1";
            string fabricName = "cloud1";
            string protectionContainerName = "cloud_6d224fc6-f326-5d35-96de-fbf51efb3179";
            string replicatedProtectedItemName = "f8491e4f-817a-40dd-a90c-af773978c75b";
            ResourceIdentifier replicationProtectedItemResourceId = ReplicationProtectedItemResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, fabricName, protectionContainerName, replicatedProtectedItemName);
            ReplicationProtectedItemResource replicationProtectedItem = client.GetReplicationProtectedItemResource(replicationProtectedItemResourceId);

            // invoke the operation
            SiteRecoveryApplyRecoveryPointContent content = new SiteRecoveryApplyRecoveryPointContent(new SiteRecoveryApplyRecoveryPointProperties(new HyperVReplicaAzureApplyRecoveryPointContent())
            {
                RecoveryPointId = new ResourceIdentifier("/Subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/resourceGroupPS1/providers/Microsoft.RecoveryServices/vaults/vault1/replicationFabrics/cloud1/replicationProtectionContainers/cloud_6d224fc6-f326-5d35-96de-fbf51efb3179/replicationProtectedItems/f8491e4f-817a-40dd-a90c-af773978c75b/recoveryPoints/e4d05fe9-5dfd-47be-b50b-aad306b2802d"),
            });
            ArmOperation<ReplicationProtectedItemResource> lro = await replicationProtectedItem.ApplyRecoveryPointAsync(WaitUntil.Completed, content);
            ReplicationProtectedItemResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ReplicationProtectedItemData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Execute cancel failover.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task FailoverCancel_ExecuteCancelFailover()
        {
            // Generated from example definition: specification/recoveryservicessiterecovery/resource-manager/Microsoft.RecoveryServices/stable/2023-08-01/examples/ReplicationProtectedItems_FailoverCancel.json
            // this example is just showing the usage of "ReplicationProtectedItems_FailoverCancel" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ReplicationProtectedItemResource created on azure
            // for more information of creating ReplicationProtectedItemResource, please refer to the document of ReplicationProtectedItemResource
            string subscriptionId = "c183865e-6077-46f2-a3b1-deb0f4f4650a";
            string resourceGroupName = "resourceGroupPS1";
            string resourceName = "vault1";
            string fabricName = "cloud1";
            string protectionContainerName = "cloud_6d224fc6-f326-5d35-96de-fbf51efb3179";
            string replicatedProtectedItemName = "f8491e4f-817a-40dd-a90c-af773978c75b";
            ResourceIdentifier replicationProtectedItemResourceId = ReplicationProtectedItemResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, fabricName, protectionContainerName, replicatedProtectedItemName);
            ReplicationProtectedItemResource replicationProtectedItem = client.GetReplicationProtectedItemResource(replicationProtectedItemResourceId);

            // invoke the operation
            ArmOperation<ReplicationProtectedItemResource> lro = await replicationProtectedItem.FailoverCancelAsync(WaitUntil.Completed);
            ReplicationProtectedItemResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ReplicationProtectedItemData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Execute commit failover.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task FailoverCommit_ExecuteCommitFailover()
        {
            // Generated from example definition: specification/recoveryservicessiterecovery/resource-manager/Microsoft.RecoveryServices/stable/2023-08-01/examples/ReplicationProtectedItems_FailoverCommit.json
            // this example is just showing the usage of "ReplicationProtectedItems_FailoverCommit" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ReplicationProtectedItemResource created on azure
            // for more information of creating ReplicationProtectedItemResource, please refer to the document of ReplicationProtectedItemResource
            string subscriptionId = "c183865e-6077-46f2-a3b1-deb0f4f4650a";
            string resourceGroupName = "resourceGroupPS1";
            string resourceName = "vault1";
            string fabricName = "cloud1";
            string protectionContainerName = "cloud_6d224fc6-f326-5d35-96de-fbf51efb3179";
            string replicatedProtectedItemName = "f8491e4f-817a-40dd-a90c-af773978c75b";
            ResourceIdentifier replicationProtectedItemResourceId = ReplicationProtectedItemResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, fabricName, protectionContainerName, replicatedProtectedItemName);
            ReplicationProtectedItemResource replicationProtectedItem = client.GetReplicationProtectedItemResource(replicationProtectedItemResourceId);

            // invoke the operation
            ArmOperation<ReplicationProtectedItemResource> lro = await replicationProtectedItem.FailoverCommitAsync(WaitUntil.Completed);
            ReplicationProtectedItemResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ReplicationProtectedItemData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Execute planned failover.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task PlannedFailover_ExecutePlannedFailover()
        {
            // Generated from example definition: specification/recoveryservicessiterecovery/resource-manager/Microsoft.RecoveryServices/stable/2023-08-01/examples/ReplicationProtectedItems_PlannedFailover.json
            // this example is just showing the usage of "ReplicationProtectedItems_PlannedFailover" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ReplicationProtectedItemResource created on azure
            // for more information of creating ReplicationProtectedItemResource, please refer to the document of ReplicationProtectedItemResource
            string subscriptionId = "c183865e-6077-46f2-a3b1-deb0f4f4650a";
            string resourceGroupName = "resourceGroupPS1";
            string resourceName = "vault1";
            string fabricName = "cloud1";
            string protectionContainerName = "cloud_6d224fc6-f326-5d35-96de-fbf51efb3179";
            string replicatedProtectedItemName = "f8491e4f-817a-40dd-a90c-af773978c75b";
            ResourceIdentifier replicationProtectedItemResourceId = ReplicationProtectedItemResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, fabricName, protectionContainerName, replicatedProtectedItemName);
            ReplicationProtectedItemResource replicationProtectedItem = client.GetReplicationProtectedItemResource(replicationProtectedItemResourceId);

            // invoke the operation
            PlannedFailoverContent content = new PlannedFailoverContent()
            {
                Properties = new PlannedFailoverProperties()
                {
                    FailoverDirection = "PrimaryToRecovery",
                    ProviderSpecificDetails = new HyperVReplicaAzurePlannedFailoverProviderContent(),
                },
            };
            ArmOperation<ReplicationProtectedItemResource> lro = await replicationProtectedItem.PlannedFailoverAsync(WaitUntil.Completed, content);
            ReplicationProtectedItemResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ReplicationProtectedItemData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Removes disk(s).
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task RemoveDisks_RemovesDiskS()
        {
            // Generated from example definition: specification/recoveryservicessiterecovery/resource-manager/Microsoft.RecoveryServices/stable/2023-08-01/examples/ReplicationProtectedItems_RemoveDisks.json
            // this example is just showing the usage of "ReplicationProtectedItems_RemoveDisks" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ReplicationProtectedItemResource created on azure
            // for more information of creating ReplicationProtectedItemResource, please refer to the document of ReplicationProtectedItemResource
            string subscriptionId = "c183865e-6077-46f2-a3b1-deb0f4f4650a";
            string resourceGroupName = "resourceGroupPS1";
            string resourceName = "vault1";
            string fabricName = "cloud1";
            string protectionContainerName = "cloud_6d224fc6-f326-5d35-96de-fbf51efb3179";
            string replicatedProtectedItemName = "f8491e4f-817a-40dd-a90c-af773978c75b";
            ResourceIdentifier replicationProtectedItemResourceId = ReplicationProtectedItemResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, fabricName, protectionContainerName, replicatedProtectedItemName);
            ReplicationProtectedItemResource replicationProtectedItem = client.GetReplicationProtectedItemResource(replicationProtectedItemResourceId);

            // invoke the operation
            RemoveDisksContent content = new RemoveDisksContent()
            {
                RemoveDisksContentProviderSpecificDetails = new A2ARemoveDisksContent()
                {
                    VmDisksUris =
{
new Uri("https://vmstorage.blob.core.windows.net/vhds/datadisk1.vhd")
},
                },
            };
            ArmOperation<ReplicationProtectedItemResource> lro = await replicationProtectedItem.RemoveDisksAsync(WaitUntil.Completed, content);
            ReplicationProtectedItemResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ReplicationProtectedItemData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Resynchronize or repair replication.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task RepairReplication_ResynchronizeOrRepairReplication()
        {
            // Generated from example definition: specification/recoveryservicessiterecovery/resource-manager/Microsoft.RecoveryServices/stable/2023-08-01/examples/ReplicationProtectedItems_RepairReplication.json
            // this example is just showing the usage of "ReplicationProtectedItems_RepairReplication" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ReplicationProtectedItemResource created on azure
            // for more information of creating ReplicationProtectedItemResource, please refer to the document of ReplicationProtectedItemResource
            string subscriptionId = "c183865e-6077-46f2-a3b1-deb0f4f4650a";
            string resourceGroupName = "resourceGroupPS1";
            string resourceName = "vault1";
            string fabricName = "cloud1";
            string protectionContainerName = "cloud_6d224fc6-f326-5d35-96de-fbf51efb3179";
            string replicatedProtectedItemName = "f8491e4f-817a-40dd-a90c-af773978c75b";
            ResourceIdentifier replicationProtectedItemResourceId = ReplicationProtectedItemResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, fabricName, protectionContainerName, replicatedProtectedItemName);
            ReplicationProtectedItemResource replicationProtectedItem = client.GetReplicationProtectedItemResource(replicationProtectedItemResourceId);

            // invoke the operation
            ArmOperation<ReplicationProtectedItemResource> lro = await replicationProtectedItem.RepairReplicationAsync(WaitUntil.Completed);
            ReplicationProtectedItemResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ReplicationProtectedItemData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Execute Reverse Replication\Reprotect.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Reprotect_ExecuteReverseReplicationReprotect()
        {
            // Generated from example definition: specification/recoveryservicessiterecovery/resource-manager/Microsoft.RecoveryServices/stable/2023-08-01/examples/ReplicationProtectedItems_Reprotect.json
            // this example is just showing the usage of "ReplicationProtectedItems_Reprotect" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ReplicationProtectedItemResource created on azure
            // for more information of creating ReplicationProtectedItemResource, please refer to the document of ReplicationProtectedItemResource
            string subscriptionId = "c183865e-6077-46f2-a3b1-deb0f4f4650a";
            string resourceGroupName = "resourceGroupPS1";
            string resourceName = "vault1";
            string fabricName = "cloud1";
            string protectionContainerName = "cloud_6d224fc6-f326-5d35-96de-fbf51efb3179";
            string replicatedProtectedItemName = "f8491e4f-817a-40dd-a90c-af773978c75b";
            ResourceIdentifier replicationProtectedItemResourceId = ReplicationProtectedItemResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, fabricName, protectionContainerName, replicatedProtectedItemName);
            ReplicationProtectedItemResource replicationProtectedItem = client.GetReplicationProtectedItemResource(replicationProtectedItemResourceId);

            // invoke the operation
            ReverseReplicationContent content = new ReverseReplicationContent()
            {
                Properties = new ReverseReplicationProperties()
                {
                    FailoverDirection = "PrimaryToRecovery",
                    ProviderSpecificDetails = new HyperVReplicaAzureReprotectContent(),
                },
            };
            ArmOperation<ReplicationProtectedItemResource> lro = await replicationProtectedItem.ReprotectAsync(WaitUntil.Completed, content);
            ReplicationProtectedItemResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ReplicationProtectedItemData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Resolve health errors.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task ResolveHealthErrors_ResolveHealthErrors()
        {
            // Generated from example definition: specification/recoveryservicessiterecovery/resource-manager/Microsoft.RecoveryServices/stable/2023-08-01/examples/ReplicationProtectedItems_ResolveHealthErrors.json
            // this example is just showing the usage of "ReplicationProtectedItems_ResolveHealthErrors" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ReplicationProtectedItemResource created on azure
            // for more information of creating ReplicationProtectedItemResource, please refer to the document of ReplicationProtectedItemResource
            string subscriptionId = "c183865e-6077-46f2-a3b1-deb0f4f4650a";
            string resourceGroupName = "resourceGroupPS1";
            string resourceName = "vault1";
            string fabricName = "cloud1";
            string protectionContainerName = "cloud_6d224fc6-f326-5d35-96de-fbf51efb3179";
            string replicatedProtectedItemName = "f8491e4f-817a-40dd-a90c-af773978c75b";
            ResourceIdentifier replicationProtectedItemResourceId = ReplicationProtectedItemResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, fabricName, protectionContainerName, replicatedProtectedItemName);
            ReplicationProtectedItemResource replicationProtectedItem = client.GetReplicationProtectedItemResource(replicationProtectedItemResourceId);

            // invoke the operation
            ResolveHealthContent content = new ResolveHealthContent()
            {
                ResolveHealthErrors =
{
new ResolveHealthError()
{
HealthErrorId = "3:8020",
}
},
            };
            ArmOperation<ReplicationProtectedItemResource> lro = await replicationProtectedItem.ResolveHealthErrorsAsync(WaitUntil.Completed, content);
            ReplicationProtectedItemResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ReplicationProtectedItemData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Execute switch provider.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task SwitchProvider_ExecuteSwitchProvider()
        {
            // Generated from example definition: specification/recoveryservicessiterecovery/resource-manager/Microsoft.RecoveryServices/stable/2023-08-01/examples/ReplicationProtectedItems_SwitchProvider.json
            // this example is just showing the usage of "ReplicationProtectedItems_SwitchProvider" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ReplicationProtectedItemResource created on azure
            // for more information of creating ReplicationProtectedItemResource, please refer to the document of ReplicationProtectedItemResource
            string subscriptionId = "c183865e-6077-46f2-a3b1-deb0f4f4650a";
            string resourceGroupName = "resourceGroupPS1";
            string resourceName = "vault1";
            string fabricName = "cloud1";
            string protectionContainerName = "cloud_6d224fc6-f326-5d35-96de-fbf51efb3179";
            string replicatedProtectedItemName = "f8491e4f-817a-40dd-a90c-af773978c75b";
            ResourceIdentifier replicationProtectedItemResourceId = ReplicationProtectedItemResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, fabricName, protectionContainerName, replicatedProtectedItemName);
            ReplicationProtectedItemResource replicationProtectedItem = client.GetReplicationProtectedItemResource(replicationProtectedItemResourceId);

            // invoke the operation
            SwitchProviderContent content = new SwitchProviderContent()
            {
                Properties = new SwitchProviderProperties()
                {
                    TargetInstanceType = "InMageRcm",
                    ProviderSpecificDetails = new InMageAzureV2SwitchProviderContent(new ResourceIdentifier("/Subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/resourceGroupPS1/providers/Microsoft.RecoveryServices/vaults/vault2"), new ResourceIdentifier("/Subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/resourceGroupPS1/providers/Microsoft.RecoveryServices/vaults/vault1/replicationFabrics/cloud2"), "5efaa202-e958-435e-8171-706bf735fcc4"),
                },
            };
            ArmOperation<ReplicationProtectedItemResource> lro = await replicationProtectedItem.SwitchProviderAsync(WaitUntil.Completed, content);
            ReplicationProtectedItemResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ReplicationProtectedItemData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Execute test failover.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task TestFailover_ExecuteTestFailover()
        {
            // Generated from example definition: specification/recoveryservicessiterecovery/resource-manager/Microsoft.RecoveryServices/stable/2023-08-01/examples/ReplicationProtectedItems_TestFailover.json
            // this example is just showing the usage of "ReplicationProtectedItems_TestFailover" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ReplicationProtectedItemResource created on azure
            // for more information of creating ReplicationProtectedItemResource, please refer to the document of ReplicationProtectedItemResource
            string subscriptionId = "c183865e-6077-46f2-a3b1-deb0f4f4650a";
            string resourceGroupName = "resourceGroupPS1";
            string resourceName = "vault1";
            string fabricName = "cloud1";
            string protectionContainerName = "cloud_6d224fc6-f326-5d35-96de-fbf51efb3179";
            string replicatedProtectedItemName = "f8491e4f-817a-40dd-a90c-af773978c75b";
            ResourceIdentifier replicationProtectedItemResourceId = ReplicationProtectedItemResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, fabricName, protectionContainerName, replicatedProtectedItemName);
            ReplicationProtectedItemResource replicationProtectedItem = client.GetReplicationProtectedItemResource(replicationProtectedItemResourceId);

            // invoke the operation
            TestFailoverContent content = new TestFailoverContent(new TestFailoverProperties()
            {
                FailoverDirection = "PrimaryToRecovery",
                NetworkType = "VmNetworkAsInput",
                NetworkId = new ResourceIdentifier("/subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/siterecoveryProd1/providers/Microsoft.Network/virtualNetworks/vnetavrai"),
                ProviderSpecificDetails = new HyperVReplicaAzureTestFailoverContent(),
            });
            ArmOperation<ReplicationProtectedItemResource> lro = await replicationProtectedItem.TestFailoverAsync(WaitUntil.Completed, content);
            ReplicationProtectedItemResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ReplicationProtectedItemData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Execute test failover cleanup.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task TestFailoverCleanup_ExecuteTestFailoverCleanup()
        {
            // Generated from example definition: specification/recoveryservicessiterecovery/resource-manager/Microsoft.RecoveryServices/stable/2023-08-01/examples/ReplicationProtectedItems_TestFailoverCleanup.json
            // this example is just showing the usage of "ReplicationProtectedItems_TestFailoverCleanup" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ReplicationProtectedItemResource created on azure
            // for more information of creating ReplicationProtectedItemResource, please refer to the document of ReplicationProtectedItemResource
            string subscriptionId = "c183865e-6077-46f2-a3b1-deb0f4f4650a";
            string resourceGroupName = "resourceGroupPS1";
            string resourceName = "vault1";
            string fabricName = "cloud1";
            string protectionContainerName = "cloud_6d224fc6-f326-5d35-96de-fbf51efb3179";
            string replicatedProtectedItemName = "f8491e4f-817a-40dd-a90c-af773978c75b";
            ResourceIdentifier replicationProtectedItemResourceId = ReplicationProtectedItemResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, fabricName, protectionContainerName, replicatedProtectedItemName);
            ReplicationProtectedItemResource replicationProtectedItem = client.GetReplicationProtectedItemResource(replicationProtectedItemResourceId);

            // invoke the operation
            TestFailoverCleanupContent content = new TestFailoverCleanupContent(new TestFailoverCleanupProperties()
            {
                Comments = "Test Failover Cleanup",
            });
            ArmOperation<ReplicationProtectedItemResource> lro = await replicationProtectedItem.TestFailoverCleanupAsync(WaitUntil.Completed, content);
            ReplicationProtectedItemResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ReplicationProtectedItemData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Execute unplanned failover.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task UnplannedFailover_ExecuteUnplannedFailover()
        {
            // Generated from example definition: specification/recoveryservicessiterecovery/resource-manager/Microsoft.RecoveryServices/stable/2023-08-01/examples/ReplicationProtectedItems_UnplannedFailover.json
            // this example is just showing the usage of "ReplicationProtectedItems_UnplannedFailover" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ReplicationProtectedItemResource created on azure
            // for more information of creating ReplicationProtectedItemResource, please refer to the document of ReplicationProtectedItemResource
            string subscriptionId = "c183865e-6077-46f2-a3b1-deb0f4f4650a";
            string resourceGroupName = "resourceGroupPS1";
            string resourceName = "vault1";
            string fabricName = "cloud1";
            string protectionContainerName = "cloud_6d224fc6-f326-5d35-96de-fbf51efb3179";
            string replicatedProtectedItemName = "f8491e4f-817a-40dd-a90c-af773978c75b";
            ResourceIdentifier replicationProtectedItemResourceId = ReplicationProtectedItemResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, fabricName, protectionContainerName, replicatedProtectedItemName);
            ReplicationProtectedItemResource replicationProtectedItem = client.GetReplicationProtectedItemResource(replicationProtectedItemResourceId);

            // invoke the operation
            UnplannedFailoverContent content = new UnplannedFailoverContent(new UnplannedFailoverProperties()
            {
                FailoverDirection = "PrimaryToRecovery",
                SourceSiteOperations = "NotRequired",
                ProviderSpecificDetails = new HyperVReplicaAzureUnplannedFailoverContent(),
            });
            ArmOperation<ReplicationProtectedItemResource> lro = await replicationProtectedItem.UnplannedFailoverAsync(WaitUntil.Completed, content);
            ReplicationProtectedItemResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ReplicationProtectedItemData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Updates appliance for replication protected Item.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task UpdateAppliance_UpdatesApplianceForReplicationProtectedItem()
        {
            // Generated from example definition: specification/recoveryservicessiterecovery/resource-manager/Microsoft.RecoveryServices/stable/2023-08-01/examples/ReplicationProtectedItems_UpdateAppliance.json
            // this example is just showing the usage of "ReplicationProtectedItems_UpdateAppliance" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ReplicationProtectedItemResource created on azure
            // for more information of creating ReplicationProtectedItemResource, please refer to the document of ReplicationProtectedItemResource
            string subscriptionId = "7c943c1b-5122-4097-90c8-861411bdd574";
            string resourceGroupName = "Ayan-0106-SA-RG";
            string resourceName = "Ayan-0106-SA-Vault";
            string fabricName = "Ayan-0106-SA-Vaultreplicationfabric";
            string protectionContainerName = "Ayan-0106-SA-Vaultreplicationcontainer";
            string replicatedProtectedItemName = "idclab-vcen67_50158124-8857-3e08-0893-2ddf8ebb8c1f";
            ResourceIdentifier replicationProtectedItemResourceId = ReplicationProtectedItemResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, fabricName, protectionContainerName, replicatedProtectedItemName);
            ReplicationProtectedItemResource replicationProtectedItem = client.GetReplicationProtectedItemResource(replicationProtectedItemResourceId);

            // invoke the operation
            UpdateApplianceForReplicationProtectedItemContent content = new UpdateApplianceForReplicationProtectedItemContent(new UpdateApplianceForReplicationProtectedItemProperties("", new InMageRcmUpdateApplianceForReplicationProtectedItemContent()
            {
                RunAsAccountId = "",
            }));
            ArmOperation<ReplicationProtectedItemResource> lro = await replicationProtectedItem.UpdateApplianceAsync(WaitUntil.Completed, content);
            ReplicationProtectedItemResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ReplicationProtectedItemData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Update the mobility service on a protected item.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task UpdateMobilityService_UpdateTheMobilityServiceOnAProtectedItem()
        {
            // Generated from example definition: specification/recoveryservicessiterecovery/resource-manager/Microsoft.RecoveryServices/stable/2023-08-01/examples/ReplicationProtectedItems_UpdateMobilityService.json
            // this example is just showing the usage of "ReplicationProtectedItems_UpdateMobilityService" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ReplicationProtectedItemResource created on azure
            // for more information of creating ReplicationProtectedItemResource, please refer to the document of ReplicationProtectedItemResource
            string subscriptionId = "b364ed8d-4279-4bf8-8fd1-56f8fa0ae05c";
            string resourceGroupName = "wcusValidations";
            string resourceName = "WCUSVault";
            string fabricName = "WIN-JKKJ31QI8U2";
            string protectionContainerName = "cloud_c6780228-83bd-4f3e-a70e-cb46b7da33a0";
            string replicatedProtectedItemName = "79dd20ab-2b40-11e7-9791-0050568f387e";
            ResourceIdentifier replicationProtectedItemResourceId = ReplicationProtectedItemResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, fabricName, protectionContainerName, replicatedProtectedItemName);
            ReplicationProtectedItemResource replicationProtectedItem = client.GetReplicationProtectedItemResource(replicationProtectedItemResourceId);

            // invoke the operation
            UpdateMobilityServiceContent content = new UpdateMobilityServiceContent()
            {
                UpdateMobilityServiceRequestRunAsAccountId = "2",
            };
            ArmOperation<ReplicationProtectedItemResource> lro = await replicationProtectedItem.UpdateMobilityServiceAsync(WaitUntil.Completed, content);
            ReplicationProtectedItemResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ReplicationProtectedItemData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Gets the list of replication protected items.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetReplicationProtectedItems_GetsTheListOfReplicationProtectedItems()
        {
            // Generated from example definition: specification/recoveryservicessiterecovery/resource-manager/Microsoft.RecoveryServices/stable/2023-08-01/examples/ReplicationProtectedItems_List.json
            // this example is just showing the usage of "ReplicationProtectedItems_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "c183865e-6077-46f2-a3b1-deb0f4f4650a";
            string resourceGroupName = "resourceGroupPS1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // invoke the operation and iterate over the result
            string resourceName = "vault1";
            await foreach (ReplicationProtectedItemResource item in resourceGroupResource.GetReplicationProtectedItemsAsync(resourceName))
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                ReplicationProtectedItemData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Gets the list of target compute sizes for the replication protected item.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetTargetComputeSizesByReplicationProtectedItems_GetsTheListOfTargetComputeSizesForTheReplicationProtectedItem()
        {
            // Generated from example definition: specification/recoveryservicessiterecovery/resource-manager/Microsoft.RecoveryServices/stable/2023-08-01/examples/TargetComputeSizes_ListByReplicationProtectedItems.json
            // this example is just showing the usage of "TargetComputeSizes_ListByReplicationProtectedItems" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ReplicationProtectedItemResource created on azure
            // for more information of creating ReplicationProtectedItemResource, please refer to the document of ReplicationProtectedItemResource
            string subscriptionId = "6808dbbc-98c7-431f-a1b1-9580902423b7";
            string resourceGroupName = "avraiMgDiskVaultRG";
            string resourceName = "avraiMgDiskVault";
            string fabricName = "asr-a2a-default-centraluseuap";
            string protectionContainerName = "asr-a2a-default-centraluseuap-container";
            string replicatedProtectedItemName = "468c912d-b1ab-4ea2-97eb-4b5095155db2";
            ResourceIdentifier replicationProtectedItemResourceId = ReplicationProtectedItemResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, fabricName, protectionContainerName, replicatedProtectedItemName);
            ReplicationProtectedItemResource replicationProtectedItem = client.GetReplicationProtectedItemResource(replicationProtectedItemResourceId);

            // invoke the operation and iterate over the result
            await foreach (TargetComputeSize item in replicationProtectedItem.GetTargetComputeSizesByReplicationProtectedItemsAsync())
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
