// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Samples
{
    public partial class Sample_ReplicationEligibilityResultResource
    {
        // Gets the validation errors in case the VM is unsuitable for protection.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetsTheValidationErrorsInCaseTheVMIsUnsuitableForProtection()
        {
            // Generated from example definition: specification/recoveryservicessiterecovery/resource-manager/Microsoft.RecoveryServices/stable/2023-08-01/examples/ReplicationEligibilityResults_Get.json
            // this example is just showing the usage of "ReplicationEligibilityResults_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ReplicationEligibilityResultResource created on azure
            // for more information of creating ReplicationEligibilityResultResource, please refer to the document of ReplicationEligibilityResultResource
            string subscriptionId = "d90d145a-4cdd-45a3-b2c4-971d69775278";
            string resourceGroupName = "testRg1";
            string virtualMachineName = "testVm1";
            ResourceIdentifier replicationEligibilityResultResourceId = ReplicationEligibilityResultResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, virtualMachineName);
            ReplicationEligibilityResultResource replicationEligibilityResult = client.GetReplicationEligibilityResultResource(replicationEligibilityResultResourceId);

            // invoke the operation
            ReplicationEligibilityResultResource result = await replicationEligibilityResult.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ReplicationEligibilityResultData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
