// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.RecoveryServicesSiteRecovery.Samples
{
    public partial class Sample_MigrationRecoveryPointResource
    {
        // Gets a recovery point for a migration item.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetsARecoveryPointForAMigrationItem()
        {
            // Generated from example definition: specification/recoveryservicessiterecovery/resource-manager/Microsoft.RecoveryServices/stable/2023-08-01/examples/MigrationRecoveryPoints_Get.json
            // this example is just showing the usage of "MigrationRecoveryPoints_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MigrationRecoveryPointResource created on azure
            // for more information of creating MigrationRecoveryPointResource, please refer to the document of MigrationRecoveryPointResource
            string subscriptionId = "cb53d0c3-bd59-4721-89bc-06916a9147ef";
            string resourceGroupName = "resourcegroup1";
            string resourceName = "migrationvault";
            string fabricName = "vmwarefabric1";
            string protectionContainerName = "vmwareContainer1";
            string migrationItemName = "virtualmachine1";
            string migrationRecoveryPointName = "b22134ea-620c-474b-9fa5-3c1cb47708e3";
            ResourceIdentifier migrationRecoveryPointResourceId = MigrationRecoveryPointResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, fabricName, protectionContainerName, migrationItemName, migrationRecoveryPointName);
            MigrationRecoveryPointResource migrationRecoveryPoint = client.GetMigrationRecoveryPointResource(migrationRecoveryPointResourceId);

            // invoke the operation
            MigrationRecoveryPointResource result = await migrationRecoveryPoint.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            MigrationRecoveryPointData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
