// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesDataReplication.Models
{
    /// <summary> Gets or sets the object type. </summary>
    public readonly partial struct WorkflowObjectType : IEquatable<WorkflowObjectType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="WorkflowObjectType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public WorkflowObjectType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AvsDiskPoolValue = "AvsDiskPool";
        private const string DraValue = "Dra";
        private const string FabricValue = "Fabric";
        private const string PolicyValue = "Policy";
        private const string ProtectedItemValue = "ProtectedItem";
        private const string RecoveryPlanValue = "RecoveryPlan";
        private const string ReplicationExtensionValue = "ReplicationExtension";
        private const string VaultValue = "Vault";

        /// <summary> AvsDiskPool. </summary>
        public static WorkflowObjectType AvsDiskPool { get; } = new WorkflowObjectType(AvsDiskPoolValue);
        /// <summary> Dra. </summary>
        public static WorkflowObjectType Dra { get; } = new WorkflowObjectType(DraValue);
        /// <summary> Fabric. </summary>
        public static WorkflowObjectType Fabric { get; } = new WorkflowObjectType(FabricValue);
        /// <summary> Policy. </summary>
        public static WorkflowObjectType Policy { get; } = new WorkflowObjectType(PolicyValue);
        /// <summary> ProtectedItem. </summary>
        public static WorkflowObjectType ProtectedItem { get; } = new WorkflowObjectType(ProtectedItemValue);
        /// <summary> RecoveryPlan. </summary>
        public static WorkflowObjectType RecoveryPlan { get; } = new WorkflowObjectType(RecoveryPlanValue);
        /// <summary> ReplicationExtension. </summary>
        public static WorkflowObjectType ReplicationExtension { get; } = new WorkflowObjectType(ReplicationExtensionValue);
        /// <summary> Vault. </summary>
        public static WorkflowObjectType Vault { get; } = new WorkflowObjectType(VaultValue);
        /// <summary> Determines if two <see cref="WorkflowObjectType"/> values are the same. </summary>
        public static bool operator ==(WorkflowObjectType left, WorkflowObjectType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="WorkflowObjectType"/> values are not the same. </summary>
        public static bool operator !=(WorkflowObjectType left, WorkflowObjectType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="WorkflowObjectType"/>. </summary>
        public static implicit operator WorkflowObjectType(string value) => new WorkflowObjectType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is WorkflowObjectType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(WorkflowObjectType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
