// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesDataReplication.Models
{
    public partial class VMwareToAzStackHciReplicationExtensionModelCustomProperties : IUtf8JsonSerializable, IJsonModel<VMwareToAzStackHciReplicationExtensionModelCustomProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<VMwareToAzStackHciReplicationExtensionModelCustomProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<VMwareToAzStackHciReplicationExtensionModelCustomProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<VMwareToAzStackHciReplicationExtensionModelCustomProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(VMwareToAzStackHciReplicationExtensionModelCustomProperties)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("vmwareFabricArmId"u8);
            writer.WriteStringValue(VmwareFabricArmId);
            if (options.Format != "W" && Optional.IsDefined(VmwareSiteId))
            {
                writer.WritePropertyName("vmwareSiteId"u8);
                writer.WriteStringValue(VmwareSiteId);
            }
            writer.WritePropertyName("azStackHciFabricArmId"u8);
            writer.WriteStringValue(AzStackHciFabricArmId);
            if (options.Format != "W" && Optional.IsDefined(AzStackHciSiteId))
            {
                writer.WritePropertyName("azStackHciSiteId"u8);
                writer.WriteStringValue(AzStackHciSiteId);
            }
            if (Optional.IsDefined(StorageAccountId))
            {
                writer.WritePropertyName("storageAccountId"u8);
                writer.WriteStringValue(StorageAccountId);
            }
            if (Optional.IsDefined(StorageAccountSasSecretName))
            {
                writer.WritePropertyName("storageAccountSasSecretName"u8);
                writer.WriteStringValue(StorageAccountSasSecretName);
            }
            if (options.Format != "W" && Optional.IsDefined(AsrServiceUri))
            {
                writer.WritePropertyName("asrServiceUri"u8);
                writer.WriteStringValue(AsrServiceUri.AbsoluteUri);
            }
            if (options.Format != "W" && Optional.IsDefined(RcmServiceUri))
            {
                writer.WritePropertyName("rcmServiceUri"u8);
                writer.WriteStringValue(RcmServiceUri.AbsoluteUri);
            }
            if (options.Format != "W" && Optional.IsDefined(GatewayServiceUri))
            {
                writer.WritePropertyName("gatewayServiceUri"u8);
                writer.WriteStringValue(GatewayServiceUri.AbsoluteUri);
            }
            if (options.Format != "W" && Optional.IsDefined(SourceGatewayServiceId))
            {
                writer.WritePropertyName("sourceGatewayServiceId"u8);
                writer.WriteStringValue(SourceGatewayServiceId);
            }
            if (options.Format != "W" && Optional.IsDefined(TargetGatewayServiceId))
            {
                writer.WritePropertyName("targetGatewayServiceId"u8);
                writer.WriteStringValue(TargetGatewayServiceId);
            }
            if (options.Format != "W" && Optional.IsDefined(SourceStorageContainerName))
            {
                writer.WritePropertyName("sourceStorageContainerName"u8);
                writer.WriteStringValue(SourceStorageContainerName);
            }
            if (options.Format != "W" && Optional.IsDefined(TargetStorageContainerName))
            {
                writer.WritePropertyName("targetStorageContainerName"u8);
                writer.WriteStringValue(TargetStorageContainerName);
            }
            if (options.Format != "W" && Optional.IsDefined(ResourceLocation))
            {
                writer.WritePropertyName("resourceLocation"u8);
                writer.WriteStringValue(ResourceLocation);
            }
            if (options.Format != "W" && Optional.IsDefined(SubscriptionId))
            {
                writer.WritePropertyName("subscriptionId"u8);
                writer.WriteStringValue(SubscriptionId);
            }
            if (options.Format != "W" && Optional.IsDefined(ResourceGroup))
            {
                writer.WritePropertyName("resourceGroup"u8);
                writer.WriteStringValue(ResourceGroup);
            }
        }

        VMwareToAzStackHciReplicationExtensionModelCustomProperties IJsonModel<VMwareToAzStackHciReplicationExtensionModelCustomProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<VMwareToAzStackHciReplicationExtensionModelCustomProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(VMwareToAzStackHciReplicationExtensionModelCustomProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeVMwareToAzStackHciReplicationExtensionModelCustomProperties(document.RootElement, options);
        }

        internal static VMwareToAzStackHciReplicationExtensionModelCustomProperties DeserializeVMwareToAzStackHciReplicationExtensionModelCustomProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResourceIdentifier vmwareFabricArmId = default;
            ResourceIdentifier vmwareSiteId = default;
            ResourceIdentifier azStackHciFabricArmId = default;
            ResourceIdentifier azStackHciSiteId = default;
            ResourceIdentifier storageAccountId = default;
            string storageAccountSasSecretName = default;
            Uri asrServiceUri = default;
            Uri rcmServiceUri = default;
            Uri gatewayServiceUri = default;
            string sourceGatewayServiceId = default;
            string targetGatewayServiceId = default;
            string sourceStorageContainerName = default;
            string targetStorageContainerName = default;
            string resourceLocation = default;
            string subscriptionId = default;
            string resourceGroup = default;
            string instanceType = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("vmwareFabricArmId"u8))
                {
                    vmwareFabricArmId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("vmwareSiteId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    vmwareSiteId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("azStackHciFabricArmId"u8))
                {
                    azStackHciFabricArmId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("azStackHciSiteId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    azStackHciSiteId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("storageAccountId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    storageAccountId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("storageAccountSasSecretName"u8))
                {
                    storageAccountSasSecretName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("asrServiceUri"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    asrServiceUri = new Uri(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("rcmServiceUri"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    rcmServiceUri = new Uri(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("gatewayServiceUri"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    gatewayServiceUri = new Uri(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("sourceGatewayServiceId"u8))
                {
                    sourceGatewayServiceId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("targetGatewayServiceId"u8))
                {
                    targetGatewayServiceId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("sourceStorageContainerName"u8))
                {
                    sourceStorageContainerName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("targetStorageContainerName"u8))
                {
                    targetStorageContainerName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("resourceLocation"u8))
                {
                    resourceLocation = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("subscriptionId"u8))
                {
                    subscriptionId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("resourceGroup"u8))
                {
                    resourceGroup = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("instanceType"u8))
                {
                    instanceType = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new VMwareToAzStackHciReplicationExtensionModelCustomProperties(
                instanceType,
                serializedAdditionalRawData,
                vmwareFabricArmId,
                vmwareSiteId,
                azStackHciFabricArmId,
                azStackHciSiteId,
                storageAccountId,
                storageAccountSasSecretName,
                asrServiceUri,
                rcmServiceUri,
                gatewayServiceUri,
                sourceGatewayServiceId,
                targetGatewayServiceId,
                sourceStorageContainerName,
                targetStorageContainerName,
                resourceLocation,
                subscriptionId,
                resourceGroup);
        }

        BinaryData IPersistableModel<VMwareToAzStackHciReplicationExtensionModelCustomProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<VMwareToAzStackHciReplicationExtensionModelCustomProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(VMwareToAzStackHciReplicationExtensionModelCustomProperties)} does not support writing '{options.Format}' format.");
            }
        }

        VMwareToAzStackHciReplicationExtensionModelCustomProperties IPersistableModel<VMwareToAzStackHciReplicationExtensionModelCustomProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<VMwareToAzStackHciReplicationExtensionModelCustomProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeVMwareToAzStackHciReplicationExtensionModelCustomProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(VMwareToAzStackHciReplicationExtensionModelCustomProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<VMwareToAzStackHciReplicationExtensionModelCustomProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
