// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesDataReplication.Models
{
    /// <summary> VMware to AzStackHCI planned failover model custom properties. </summary>
    public partial class VMwareToAzStackHciPlannedFailoverModelCustomProperties : PlannedFailoverModelCustomProperties
    {
        /// <summary> Initializes a new instance of <see cref="VMwareToAzStackHciPlannedFailoverModelCustomProperties"/>. </summary>
        /// <param name="shutdownSourceVm"> Gets or sets a value indicating whether VM needs to be shut down. </param>
        public VMwareToAzStackHciPlannedFailoverModelCustomProperties(bool shutdownSourceVm)
        {
            ShutdownSourceVm = shutdownSourceVm;
            InstanceType = "VMwareToAzStackHCI";
        }

        /// <summary> Initializes a new instance of <see cref="VMwareToAzStackHciPlannedFailoverModelCustomProperties"/>. </summary>
        /// <param name="instanceType"> Gets or sets the instance type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="shutdownSourceVm"> Gets or sets a value indicating whether VM needs to be shut down. </param>
        internal VMwareToAzStackHciPlannedFailoverModelCustomProperties(string instanceType, IDictionary<string, BinaryData> serializedAdditionalRawData, bool shutdownSourceVm) : base(instanceType, serializedAdditionalRawData)
        {
            ShutdownSourceVm = shutdownSourceVm;
            InstanceType = instanceType ?? "VMwareToAzStackHCI";
        }

        /// <summary> Initializes a new instance of <see cref="VMwareToAzStackHciPlannedFailoverModelCustomProperties"/> for deserialization. </summary>
        internal VMwareToAzStackHciPlannedFailoverModelCustomProperties()
        {
        }

        /// <summary> Gets or sets a value indicating whether VM needs to be shut down. </summary>
        public bool ShutdownSourceVm { get; set; }
    }
}
