// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesDataReplication.Models
{
    /// <summary> VMwareToAzStack disk input. </summary>
    public partial class VMwareToAzStackHciDiskInput
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="VMwareToAzStackHciDiskInput"/>. </summary>
        /// <param name="diskId"> Gets or sets the disk Id. </param>
        /// <param name="diskSizeGB"> Gets or sets the disk size in GB. </param>
        /// <param name="diskFileFormat"> Gets or sets the type of the virtual hard disk, vhd or vhdx. </param>
        /// <param name="isOSDisk"> Gets or sets a value indicating whether disk is os disk. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="diskId"/> or <paramref name="diskFileFormat"/> is null. </exception>
        public VMwareToAzStackHciDiskInput(string diskId, long diskSizeGB, string diskFileFormat, bool isOSDisk)
        {
            Argument.AssertNotNull(diskId, nameof(diskId));
            Argument.AssertNotNull(diskFileFormat, nameof(diskFileFormat));

            DiskId = diskId;
            DiskSizeGB = diskSizeGB;
            DiskFileFormat = diskFileFormat;
            IsOSDisk = isOSDisk;
        }

        /// <summary> Initializes a new instance of <see cref="VMwareToAzStackHciDiskInput"/>. </summary>
        /// <param name="diskId"> Gets or sets the disk Id. </param>
        /// <param name="storageContainerId"> Gets or sets the target storage account ARM Id. </param>
        /// <param name="isDynamic">
        /// Gets or sets a value indicating whether dynamic sizing is enabled on the virtual hard
        /// disk.
        /// </param>
        /// <param name="diskSizeGB"> Gets or sets the disk size in GB. </param>
        /// <param name="diskFileFormat"> Gets or sets the type of the virtual hard disk, vhd or vhdx. </param>
        /// <param name="isOSDisk"> Gets or sets a value indicating whether disk is os disk. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal VMwareToAzStackHciDiskInput(string diskId, string storageContainerId, bool? isDynamic, long diskSizeGB, string diskFileFormat, bool isOSDisk, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DiskId = diskId;
            StorageContainerId = storageContainerId;
            IsDynamic = isDynamic;
            DiskSizeGB = diskSizeGB;
            DiskFileFormat = diskFileFormat;
            IsOSDisk = isOSDisk;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="VMwareToAzStackHciDiskInput"/> for deserialization. </summary>
        internal VMwareToAzStackHciDiskInput()
        {
        }

        /// <summary> Gets or sets the disk Id. </summary>
        public string DiskId { get; set; }
        /// <summary> Gets or sets the target storage account ARM Id. </summary>
        public string StorageContainerId { get; set; }
        /// <summary>
        /// Gets or sets a value indicating whether dynamic sizing is enabled on the virtual hard
        /// disk.
        /// </summary>
        public bool? IsDynamic { get; set; }
        /// <summary> Gets or sets the disk size in GB. </summary>
        public long DiskSizeGB { get; set; }
        /// <summary> Gets or sets the type of the virtual hard disk, vhd or vhdx. </summary>
        public string DiskFileFormat { get; set; }
        /// <summary> Gets or sets a value indicating whether disk is os disk. </summary>
        public bool IsOSDisk { get; set; }
    }
}
