// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesDataReplication.Models
{
    /// <summary> VMware migrate fabric model custom properties. </summary>
    public partial class VMwareMigrateFabricModelCustomProperties : FabricModelCustomProperties
    {
        /// <summary> Initializes a new instance of <see cref="VMwareMigrateFabricModelCustomProperties"/>. </summary>
        /// <param name="vMwareSiteId"> Gets or sets the ARM Id of the VMware site. </param>
        /// <param name="migrationSolutionId"> Gets or sets the ARM Id of the migration solution. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="vMwareSiteId"/> or <paramref name="migrationSolutionId"/> is null. </exception>
        public VMwareMigrateFabricModelCustomProperties(ResourceIdentifier vMwareSiteId, ResourceIdentifier migrationSolutionId)
        {
            Argument.AssertNotNull(vMwareSiteId, nameof(vMwareSiteId));
            Argument.AssertNotNull(migrationSolutionId, nameof(migrationSolutionId));

            VMwareSiteId = vMwareSiteId;
            MigrationSolutionId = migrationSolutionId;
            InstanceType = "VMwareMigrate";
        }

        /// <summary> Initializes a new instance of <see cref="VMwareMigrateFabricModelCustomProperties"/>. </summary>
        /// <param name="instanceType"> Gets or sets the instance type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="vMwareSiteId"> Gets or sets the ARM Id of the VMware site. </param>
        /// <param name="migrationSolutionId"> Gets or sets the ARM Id of the migration solution. </param>
        internal VMwareMigrateFabricModelCustomProperties(string instanceType, IDictionary<string, BinaryData> serializedAdditionalRawData, ResourceIdentifier vMwareSiteId, ResourceIdentifier migrationSolutionId) : base(instanceType, serializedAdditionalRawData)
        {
            VMwareSiteId = vMwareSiteId;
            MigrationSolutionId = migrationSolutionId;
            InstanceType = instanceType ?? "VMwareMigrate";
        }

        /// <summary> Initializes a new instance of <see cref="VMwareMigrateFabricModelCustomProperties"/> for deserialization. </summary>
        internal VMwareMigrateFabricModelCustomProperties()
        {
        }

        /// <summary> Gets or sets the ARM Id of the VMware site. </summary>
        public ResourceIdentifier VMwareSiteId { get; set; }
        /// <summary> Gets or sets the ARM Id of the migration solution. </summary>
        public ResourceIdentifier MigrationSolutionId { get; set; }
    }
}
