// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesDataReplication.Models
{
    /// <summary> Test failover cleanup workflow model custom properties. </summary>
    public partial class TestFailoverCleanupWorkflowModelCustomProperties : WorkflowModelCustomProperties
    {
        /// <summary> Initializes a new instance of <see cref="TestFailoverCleanupWorkflowModelCustomProperties"/>. </summary>
        internal TestFailoverCleanupWorkflowModelCustomProperties()
        {
            InstanceType = "TestFailoverCleanupWorkflowDetails";
        }

        /// <summary> Initializes a new instance of <see cref="TestFailoverCleanupWorkflowModelCustomProperties"/>. </summary>
        /// <param name="instanceType"> Gets or sets the instance type. </param>
        /// <param name="affectedObjectDetails"> Gets or sets any custom properties of the affected object. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="comments"> Gets or sets the test failover cleanup comments. </param>
        internal TestFailoverCleanupWorkflowModelCustomProperties(string instanceType, IReadOnlyDictionary<string, string> affectedObjectDetails, IDictionary<string, BinaryData> serializedAdditionalRawData, string comments) : base(instanceType, affectedObjectDetails, serializedAdditionalRawData)
        {
            Comments = comments;
            InstanceType = instanceType ?? "TestFailoverCleanupWorkflowDetails";
        }

        /// <summary> Gets or sets the test failover cleanup comments. </summary>
        public string Comments { get; }
    }
}
