// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesDataReplication.Models
{
    /// <summary> Protected item job properties. </summary>
    public partial class ProtectedItemJobProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ProtectedItemJobProperties"/>. </summary>
        internal ProtectedItemJobProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ProtectedItemJobProperties"/>. </summary>
        /// <param name="scenarioName"> Gets or sets protection scenario name. </param>
        /// <param name="id"> Gets or sets workflow Id. </param>
        /// <param name="name"> Gets or sets workflow name. </param>
        /// <param name="displayName"> Gets or sets the workflow friendly display name. </param>
        /// <param name="state"> Gets or sets workflow state. </param>
        /// <param name="startOn"> Gets or sets start time of the workflow. </param>
        /// <param name="endOn"> Gets or sets end time of the workflow. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ProtectedItemJobProperties(string scenarioName, string id, string name, string displayName, string state, DateTimeOffset? startOn, DateTimeOffset? endOn, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ScenarioName = scenarioName;
            Id = id;
            Name = name;
            DisplayName = displayName;
            State = state;
            StartOn = startOn;
            EndOn = endOn;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets or sets protection scenario name. </summary>
        public string ScenarioName { get; }
        /// <summary> Gets or sets workflow Id. </summary>
        public string Id { get; }
        /// <summary> Gets or sets workflow name. </summary>
        public string Name { get; }
        /// <summary> Gets or sets the workflow friendly display name. </summary>
        public string DisplayName { get; }
        /// <summary> Gets or sets workflow state. </summary>
        public string State { get; }
        /// <summary> Gets or sets start time of the workflow. </summary>
        public DateTimeOffset? StartOn { get; }
        /// <summary> Gets or sets end time of the workflow. </summary>
        public DateTimeOffset? EndOn { get; }
    }
}
