// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesDataReplication.Models
{
    /// <summary> Protected item dynamic memory config. </summary>
    public partial class ProtectedItemDynamicMemoryConfig
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ProtectedItemDynamicMemoryConfig"/>. </summary>
        /// <param name="maximumMemoryInMegaBytes"> Gets or sets maximum memory in MB. </param>
        /// <param name="minimumMemoryInMegaBytes"> Gets or sets minimum memory in MB. </param>
        /// <param name="targetMemoryBufferPercentage"> Gets or sets target memory buffer in %. </param>
        public ProtectedItemDynamicMemoryConfig(long maximumMemoryInMegaBytes, long minimumMemoryInMegaBytes, int targetMemoryBufferPercentage)
        {
            MaximumMemoryInMegaBytes = maximumMemoryInMegaBytes;
            MinimumMemoryInMegaBytes = minimumMemoryInMegaBytes;
            TargetMemoryBufferPercentage = targetMemoryBufferPercentage;
        }

        /// <summary> Initializes a new instance of <see cref="ProtectedItemDynamicMemoryConfig"/>. </summary>
        /// <param name="maximumMemoryInMegaBytes"> Gets or sets maximum memory in MB. </param>
        /// <param name="minimumMemoryInMegaBytes"> Gets or sets minimum memory in MB. </param>
        /// <param name="targetMemoryBufferPercentage"> Gets or sets target memory buffer in %. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ProtectedItemDynamicMemoryConfig(long maximumMemoryInMegaBytes, long minimumMemoryInMegaBytes, int targetMemoryBufferPercentage, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            MaximumMemoryInMegaBytes = maximumMemoryInMegaBytes;
            MinimumMemoryInMegaBytes = minimumMemoryInMegaBytes;
            TargetMemoryBufferPercentage = targetMemoryBufferPercentage;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ProtectedItemDynamicMemoryConfig"/> for deserialization. </summary>
        internal ProtectedItemDynamicMemoryConfig()
        {
        }

        /// <summary> Gets or sets maximum memory in MB. </summary>
        public long MaximumMemoryInMegaBytes { get; set; }
        /// <summary> Gets or sets minimum memory in MB. </summary>
        public long MinimumMemoryInMegaBytes { get; set; }
        /// <summary> Gets or sets target memory buffer in %. </summary>
        public int TargetMemoryBufferPercentage { get; set; }
    }
}
