// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesDataReplication.Models
{
    /// <summary> HyperV to AzStackHCI recovery point model custom properties. </summary>
    public partial class HyperVToAzStackHciRecoveryPointModelCustomProperties : RecoveryPointModelCustomProperties
    {
        /// <summary> Initializes a new instance of <see cref="HyperVToAzStackHciRecoveryPointModelCustomProperties"/>. </summary>
        internal HyperVToAzStackHciRecoveryPointModelCustomProperties()
        {
            DiskIds = new ChangeTrackingList<string>();
            InstanceType = "HyperVToAzStackHCI";
        }

        /// <summary> Initializes a new instance of <see cref="HyperVToAzStackHciRecoveryPointModelCustomProperties"/>. </summary>
        /// <param name="instanceType"> Gets or sets the instance type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="diskIds"> Gets or sets the list of the disk Ids. </param>
        internal HyperVToAzStackHciRecoveryPointModelCustomProperties(string instanceType, IDictionary<string, BinaryData> serializedAdditionalRawData, IReadOnlyList<string> diskIds) : base(instanceType, serializedAdditionalRawData)
        {
            DiskIds = diskIds;
            InstanceType = instanceType ?? "HyperVToAzStackHCI";
        }

        /// <summary> Gets or sets the list of the disk Ids. </summary>
        public IReadOnlyList<string> DiskIds { get; }
    }
}
