// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesDataReplication.Models
{
    public partial class HyperVToAzStackHciProtectedItemModelCustomProperties : IUtf8JsonSerializable, IJsonModel<HyperVToAzStackHciProtectedItemModelCustomProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<HyperVToAzStackHciProtectedItemModelCustomProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<HyperVToAzStackHciProtectedItemModelCustomProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HyperVToAzStackHciProtectedItemModelCustomProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(HyperVToAzStackHciProtectedItemModelCustomProperties)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (options.Format != "W" && Optional.IsDefined(ActiveLocation))
            {
                writer.WritePropertyName("activeLocation"u8);
                writer.WriteStringValue(ActiveLocation.Value.ToString());
            }
            writer.WritePropertyName("targetHciClusterId"u8);
            writer.WriteStringValue(TargetHciClusterId);
            writer.WritePropertyName("targetArcClusterCustomLocationId"u8);
            writer.WriteStringValue(TargetArcClusterCustomLocationId);
            if (options.Format != "W" && Optional.IsDefined(TargetAzStackHciClusterName))
            {
                writer.WritePropertyName("targetAzStackHciClusterName"u8);
                writer.WriteStringValue(TargetAzStackHciClusterName);
            }
            writer.WritePropertyName("fabricDiscoveryMachineId"u8);
            writer.WriteStringValue(FabricDiscoveryMachineId);
            writer.WritePropertyName("disksToInclude"u8);
            writer.WriteStartArray();
            foreach (var item in DisksToInclude)
            {
                writer.WriteObjectValue(item, options);
            }
            writer.WriteEndArray();
            writer.WritePropertyName("nicsToInclude"u8);
            writer.WriteStartArray();
            foreach (var item in NicsToInclude)
            {
                writer.WriteObjectValue(item, options);
            }
            writer.WriteEndArray();
            if (options.Format != "W" && Optional.IsDefined(SourceVmName))
            {
                writer.WritePropertyName("sourceVmName"u8);
                writer.WriteStringValue(SourceVmName);
            }
            if (options.Format != "W" && Optional.IsDefined(SourceCpuCores))
            {
                writer.WritePropertyName("sourceCpuCores"u8);
                writer.WriteNumberValue(SourceCpuCores.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(SourceMemoryInMegaBytes))
            {
                writer.WritePropertyName("sourceMemoryInMegaBytes"u8);
                writer.WriteNumberValue(SourceMemoryInMegaBytes.Value);
            }
            if (Optional.IsDefined(TargetVmName))
            {
                writer.WritePropertyName("targetVmName"u8);
                writer.WriteStringValue(TargetVmName);
            }
            writer.WritePropertyName("targetResourceGroupId"u8);
            writer.WriteStringValue(TargetResourceGroupId);
            writer.WritePropertyName("storageContainerId"u8);
            writer.WriteStringValue(StorageContainerId);
            writer.WritePropertyName("hyperVGeneration"u8);
            writer.WriteStringValue(HyperVGeneration);
            if (Optional.IsDefined(TargetNetworkId))
            {
                writer.WritePropertyName("targetNetworkId"u8);
                writer.WriteStringValue(TargetNetworkId);
            }
            if (Optional.IsDefined(TestNetworkId))
            {
                writer.WritePropertyName("testNetworkId"u8);
                writer.WriteStringValue(TestNetworkId);
            }
            if (Optional.IsDefined(TargetCpuCores))
            {
                writer.WritePropertyName("targetCpuCores"u8);
                writer.WriteNumberValue(TargetCpuCores.Value);
            }
            if (Optional.IsDefined(IsDynamicRam))
            {
                writer.WritePropertyName("isDynamicRam"u8);
                writer.WriteBooleanValue(IsDynamicRam.Value);
            }
            if (Optional.IsDefined(DynamicMemoryConfig))
            {
                writer.WritePropertyName("dynamicMemoryConfig"u8);
                writer.WriteObjectValue(DynamicMemoryConfig, options);
            }
            if (Optional.IsDefined(TargetMemoryInMegaBytes))
            {
                writer.WritePropertyName("targetMemoryInMegaBytes"u8);
                writer.WriteNumberValue(TargetMemoryInMegaBytes.Value);
            }
            writer.WritePropertyName("runAsAccountId"u8);
            writer.WriteStringValue(RunAsAccountId);
            writer.WritePropertyName("sourceDraName"u8);
            writer.WriteStringValue(SourceDraName);
            writer.WritePropertyName("targetDraName"u8);
            writer.WriteStringValue(TargetDraName);
            if (options.Format != "W" && Optional.IsDefined(SourceApplianceName))
            {
                writer.WritePropertyName("sourceApplianceName"u8);
                writer.WriteStringValue(SourceApplianceName);
            }
            if (options.Format != "W" && Optional.IsDefined(TargetApplianceName))
            {
                writer.WritePropertyName("targetApplianceName"u8);
                writer.WriteStringValue(TargetApplianceName);
            }
            if (options.Format != "W" && Optional.IsDefined(OSType))
            {
                writer.WritePropertyName("osType"u8);
                writer.WriteStringValue(OSType);
            }
            if (options.Format != "W" && Optional.IsDefined(OSName))
            {
                writer.WritePropertyName("osName"u8);
                writer.WriteStringValue(OSName);
            }
            if (options.Format != "W" && Optional.IsDefined(FirmwareType))
            {
                writer.WritePropertyName("firmwareType"u8);
                writer.WriteStringValue(FirmwareType);
            }
            if (options.Format != "W" && Optional.IsDefined(TargetLocation))
            {
                writer.WritePropertyName("targetLocation"u8);
                writer.WriteStringValue(TargetLocation);
            }
            writer.WritePropertyName("customLocationRegion"u8);
            writer.WriteStringValue(CustomLocationRegion);
            if (options.Format != "W" && Optional.IsDefined(FailoverRecoveryPointId))
            {
                writer.WritePropertyName("failoverRecoveryPointId"u8);
                writer.WriteStringValue(FailoverRecoveryPointId);
            }
            if (options.Format != "W" && Optional.IsDefined(LastRecoveryPointReceived))
            {
                writer.WritePropertyName("lastRecoveryPointReceived"u8);
                writer.WriteStringValue(LastRecoveryPointReceived.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(LastRecoveryPointId))
            {
                writer.WritePropertyName("lastRecoveryPointId"u8);
                writer.WriteStringValue(LastRecoveryPointId);
            }
            if (options.Format != "W" && Optional.IsDefined(InitialReplicationProgressPercentage))
            {
                writer.WritePropertyName("initialReplicationProgressPercentage"u8);
                writer.WriteNumberValue(InitialReplicationProgressPercentage.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(ResyncProgressPercentage))
            {
                writer.WritePropertyName("resyncProgressPercentage"u8);
                writer.WriteNumberValue(ResyncProgressPercentage.Value);
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(ProtectedDisks))
            {
                writer.WritePropertyName("protectedDisks"u8);
                writer.WriteStartArray();
                foreach (var item in ProtectedDisks)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(ProtectedNics))
            {
                writer.WritePropertyName("protectedNics"u8);
                writer.WriteStartArray();
                foreach (var item in ProtectedNics)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(TargetVmBiosId))
            {
                writer.WritePropertyName("targetVmBiosId"u8);
                writer.WriteStringValue(TargetVmBiosId);
            }
            if (options.Format != "W" && Optional.IsDefined(LastReplicationUpdateOn))
            {
                writer.WritePropertyName("lastReplicationUpdateTime"u8);
                writer.WriteStringValue(LastReplicationUpdateOn.Value, "O");
            }
        }

        HyperVToAzStackHciProtectedItemModelCustomProperties IJsonModel<HyperVToAzStackHciProtectedItemModelCustomProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HyperVToAzStackHciProtectedItemModelCustomProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(HyperVToAzStackHciProtectedItemModelCustomProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeHyperVToAzStackHciProtectedItemModelCustomProperties(document.RootElement, options);
        }

        internal static HyperVToAzStackHciProtectedItemModelCustomProperties DeserializeHyperVToAzStackHciProtectedItemModelCustomProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ProtectedItemActiveLocation? activeLocation = default;
            ResourceIdentifier targetHciClusterId = default;
            ResourceIdentifier targetArcClusterCustomLocationId = default;
            string targetAzStackHciClusterName = default;
            ResourceIdentifier fabricDiscoveryMachineId = default;
            IList<HyperVToAzStackHciDiskInput> disksToInclude = default;
            IList<HyperVToAzStackHciNicInput> nicsToInclude = default;
            string sourceVmName = default;
            int? sourceCpuCores = default;
            double? sourceMemoryInMegaBytes = default;
            string targetVmName = default;
            ResourceIdentifier targetResourceGroupId = default;
            ResourceIdentifier storageContainerId = default;
            string hyperVGeneration = default;
            string targetNetworkId = default;
            string testNetworkId = default;
            int? targetCpuCores = default;
            bool? isDynamicRam = default;
            ProtectedItemDynamicMemoryConfig dynamicMemoryConfig = default;
            int? targetMemoryInMegaBytes = default;
            string runAsAccountId = default;
            string sourceDraName = default;
            string targetDraName = default;
            string sourceApplianceName = default;
            string targetApplianceName = default;
            string osType = default;
            string osName = default;
            string firmwareType = default;
            string targetLocation = default;
            string customLocationRegion = default;
            string failoverRecoveryPointId = default;
            DateTimeOffset? lastRecoveryPointReceived = default;
            string lastRecoveryPointId = default;
            int? initialReplicationProgressPercentage = default;
            int? resyncProgressPercentage = default;
            IReadOnlyList<HyperVToAzStackHciProtectedDiskProperties> protectedDisks = default;
            IReadOnlyList<HyperVToAzStackHciProtectedNicProperties> protectedNics = default;
            string targetVmBiosId = default;
            DateTimeOffset? lastReplicationUpdateTime = default;
            string instanceType = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("activeLocation"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    activeLocation = new ProtectedItemActiveLocation(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("targetHciClusterId"u8))
                {
                    targetHciClusterId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("targetArcClusterCustomLocationId"u8))
                {
                    targetArcClusterCustomLocationId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("targetAzStackHciClusterName"u8))
                {
                    targetAzStackHciClusterName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("fabricDiscoveryMachineId"u8))
                {
                    fabricDiscoveryMachineId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("disksToInclude"u8))
                {
                    List<HyperVToAzStackHciDiskInput> array = new List<HyperVToAzStackHciDiskInput>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(HyperVToAzStackHciDiskInput.DeserializeHyperVToAzStackHciDiskInput(item, options));
                    }
                    disksToInclude = array;
                    continue;
                }
                if (property.NameEquals("nicsToInclude"u8))
                {
                    List<HyperVToAzStackHciNicInput> array = new List<HyperVToAzStackHciNicInput>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(HyperVToAzStackHciNicInput.DeserializeHyperVToAzStackHciNicInput(item, options));
                    }
                    nicsToInclude = array;
                    continue;
                }
                if (property.NameEquals("sourceVmName"u8))
                {
                    sourceVmName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("sourceCpuCores"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    sourceCpuCores = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("sourceMemoryInMegaBytes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    sourceMemoryInMegaBytes = property.Value.GetDouble();
                    continue;
                }
                if (property.NameEquals("targetVmName"u8))
                {
                    targetVmName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("targetResourceGroupId"u8))
                {
                    targetResourceGroupId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("storageContainerId"u8))
                {
                    storageContainerId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("hyperVGeneration"u8))
                {
                    hyperVGeneration = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("targetNetworkId"u8))
                {
                    targetNetworkId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("testNetworkId"u8))
                {
                    testNetworkId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("targetCpuCores"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    targetCpuCores = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("isDynamicRam"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isDynamicRam = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("dynamicMemoryConfig"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    dynamicMemoryConfig = ProtectedItemDynamicMemoryConfig.DeserializeProtectedItemDynamicMemoryConfig(property.Value, options);
                    continue;
                }
                if (property.NameEquals("targetMemoryInMegaBytes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    targetMemoryInMegaBytes = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("runAsAccountId"u8))
                {
                    runAsAccountId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("sourceDraName"u8))
                {
                    sourceDraName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("targetDraName"u8))
                {
                    targetDraName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("sourceApplianceName"u8))
                {
                    sourceApplianceName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("targetApplianceName"u8))
                {
                    targetApplianceName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("osType"u8))
                {
                    osType = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("osName"u8))
                {
                    osName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("firmwareType"u8))
                {
                    firmwareType = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("targetLocation"u8))
                {
                    targetLocation = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("customLocationRegion"u8))
                {
                    customLocationRegion = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("failoverRecoveryPointId"u8))
                {
                    failoverRecoveryPointId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("lastRecoveryPointReceived"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    lastRecoveryPointReceived = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("lastRecoveryPointId"u8))
                {
                    lastRecoveryPointId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("initialReplicationProgressPercentage"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    initialReplicationProgressPercentage = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("resyncProgressPercentage"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    resyncProgressPercentage = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("protectedDisks"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<HyperVToAzStackHciProtectedDiskProperties> array = new List<HyperVToAzStackHciProtectedDiskProperties>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(HyperVToAzStackHciProtectedDiskProperties.DeserializeHyperVToAzStackHciProtectedDiskProperties(item, options));
                    }
                    protectedDisks = array;
                    continue;
                }
                if (property.NameEquals("protectedNics"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<HyperVToAzStackHciProtectedNicProperties> array = new List<HyperVToAzStackHciProtectedNicProperties>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(HyperVToAzStackHciProtectedNicProperties.DeserializeHyperVToAzStackHciProtectedNicProperties(item, options));
                    }
                    protectedNics = array;
                    continue;
                }
                if (property.NameEquals("targetVmBiosId"u8))
                {
                    targetVmBiosId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("lastReplicationUpdateTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    lastReplicationUpdateTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("instanceType"u8))
                {
                    instanceType = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new HyperVToAzStackHciProtectedItemModelCustomProperties(
                instanceType,
                serializedAdditionalRawData,
                activeLocation,
                targetHciClusterId,
                targetArcClusterCustomLocationId,
                targetAzStackHciClusterName,
                fabricDiscoveryMachineId,
                disksToInclude,
                nicsToInclude,
                sourceVmName,
                sourceCpuCores,
                sourceMemoryInMegaBytes,
                targetVmName,
                targetResourceGroupId,
                storageContainerId,
                hyperVGeneration,
                targetNetworkId,
                testNetworkId,
                targetCpuCores,
                isDynamicRam,
                dynamicMemoryConfig,
                targetMemoryInMegaBytes,
                runAsAccountId,
                sourceDraName,
                targetDraName,
                sourceApplianceName,
                targetApplianceName,
                osType,
                osName,
                firmwareType,
                targetLocation,
                customLocationRegion,
                failoverRecoveryPointId,
                lastRecoveryPointReceived,
                lastRecoveryPointId,
                initialReplicationProgressPercentage,
                resyncProgressPercentage,
                protectedDisks ?? new ChangeTrackingList<HyperVToAzStackHciProtectedDiskProperties>(),
                protectedNics ?? new ChangeTrackingList<HyperVToAzStackHciProtectedNicProperties>(),
                targetVmBiosId,
                lastReplicationUpdateTime);
        }

        BinaryData IPersistableModel<HyperVToAzStackHciProtectedItemModelCustomProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HyperVToAzStackHciProtectedItemModelCustomProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(HyperVToAzStackHciProtectedItemModelCustomProperties)} does not support writing '{options.Format}' format.");
            }
        }

        HyperVToAzStackHciProtectedItemModelCustomProperties IPersistableModel<HyperVToAzStackHciProtectedItemModelCustomProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HyperVToAzStackHciProtectedItemModelCustomProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeHyperVToAzStackHciProtectedItemModelCustomProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(HyperVToAzStackHciProtectedItemModelCustomProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<HyperVToAzStackHciProtectedItemModelCustomProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
