// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesDataReplication.Models
{
    /// <summary> HyperV To AzStackHCI Policy model custom properties. </summary>
    public partial class HyperVToAzStackHciPolicyModelCustomProperties : PolicyModelCustomProperties
    {
        /// <summary> Initializes a new instance of <see cref="HyperVToAzStackHciPolicyModelCustomProperties"/>. </summary>
        /// <param name="recoveryPointHistoryInMinutes">
        /// Gets or sets the duration in minutes until which the recovery points need to be
        /// stored.
        /// </param>
        /// <param name="crashConsistentFrequencyInMinutes"> Gets or sets the crash consistent snapshot frequency (in minutes). </param>
        /// <param name="appConsistentFrequencyInMinutes"> Gets or sets the app consistent snapshot frequency (in minutes). </param>
        public HyperVToAzStackHciPolicyModelCustomProperties(int recoveryPointHistoryInMinutes, int crashConsistentFrequencyInMinutes, int appConsistentFrequencyInMinutes)
        {
            RecoveryPointHistoryInMinutes = recoveryPointHistoryInMinutes;
            CrashConsistentFrequencyInMinutes = crashConsistentFrequencyInMinutes;
            AppConsistentFrequencyInMinutes = appConsistentFrequencyInMinutes;
            InstanceType = "HyperVToAzStackHCI";
        }

        /// <summary> Initializes a new instance of <see cref="HyperVToAzStackHciPolicyModelCustomProperties"/>. </summary>
        /// <param name="instanceType"> Gets or sets the instance type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="recoveryPointHistoryInMinutes">
        /// Gets or sets the duration in minutes until which the recovery points need to be
        /// stored.
        /// </param>
        /// <param name="crashConsistentFrequencyInMinutes"> Gets or sets the crash consistent snapshot frequency (in minutes). </param>
        /// <param name="appConsistentFrequencyInMinutes"> Gets or sets the app consistent snapshot frequency (in minutes). </param>
        internal HyperVToAzStackHciPolicyModelCustomProperties(string instanceType, IDictionary<string, BinaryData> serializedAdditionalRawData, int recoveryPointHistoryInMinutes, int crashConsistentFrequencyInMinutes, int appConsistentFrequencyInMinutes) : base(instanceType, serializedAdditionalRawData)
        {
            RecoveryPointHistoryInMinutes = recoveryPointHistoryInMinutes;
            CrashConsistentFrequencyInMinutes = crashConsistentFrequencyInMinutes;
            AppConsistentFrequencyInMinutes = appConsistentFrequencyInMinutes;
            InstanceType = instanceType ?? "HyperVToAzStackHCI";
        }

        /// <summary> Initializes a new instance of <see cref="HyperVToAzStackHciPolicyModelCustomProperties"/> for deserialization. </summary>
        internal HyperVToAzStackHciPolicyModelCustomProperties()
        {
        }

        /// <summary>
        /// Gets or sets the duration in minutes until which the recovery points need to be
        /// stored.
        /// </summary>
        public int RecoveryPointHistoryInMinutes { get; set; }
        /// <summary> Gets or sets the crash consistent snapshot frequency (in minutes). </summary>
        public int CrashConsistentFrequencyInMinutes { get; set; }
        /// <summary> Gets or sets the app consistent snapshot frequency (in minutes). </summary>
        public int AppConsistentFrequencyInMinutes { get; set; }
    }
}
