// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesDataReplication.Models
{
    /// <summary> HyperV to AzStackHCI planned failover model custom properties. </summary>
    public partial class HyperVToAzStackHciPlannedFailoverModelCustomProperties : PlannedFailoverModelCustomProperties
    {
        /// <summary> Initializes a new instance of <see cref="HyperVToAzStackHciPlannedFailoverModelCustomProperties"/>. </summary>
        /// <param name="shutdownSourceVm"> Gets or sets a value indicating whether VM needs to be shut down. </param>
        public HyperVToAzStackHciPlannedFailoverModelCustomProperties(bool shutdownSourceVm)
        {
            ShutdownSourceVm = shutdownSourceVm;
            InstanceType = "HyperVToAzStackHCI";
        }

        /// <summary> Initializes a new instance of <see cref="HyperVToAzStackHciPlannedFailoverModelCustomProperties"/>. </summary>
        /// <param name="instanceType"> Gets or sets the instance type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="shutdownSourceVm"> Gets or sets a value indicating whether VM needs to be shut down. </param>
        internal HyperVToAzStackHciPlannedFailoverModelCustomProperties(string instanceType, IDictionary<string, BinaryData> serializedAdditionalRawData, bool shutdownSourceVm) : base(instanceType, serializedAdditionalRawData)
        {
            ShutdownSourceVm = shutdownSourceVm;
            InstanceType = instanceType ?? "HyperVToAzStackHCI";
        }

        /// <summary> Initializes a new instance of <see cref="HyperVToAzStackHciPlannedFailoverModelCustomProperties"/> for deserialization. </summary>
        internal HyperVToAzStackHciPlannedFailoverModelCustomProperties()
        {
        }

        /// <summary> Gets or sets a value indicating whether VM needs to be shut down. </summary>
        public bool ShutdownSourceVm { get; set; }
    }
}
