// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesDataReplication.Models
{
    /// <summary>
    /// HyperV to  AzStackHCI event model custom properties. This class provides provider specific
    /// details for events of type DataContract.HealthEvents.HealthEventType.ProtectedItemHealth and
    /// DataContract.HealthEvents.HealthEventType.AgentHealth.
    /// </summary>
    public partial class HyperVToAzStackHciEventModelCustomProperties : EventModelCustomProperties
    {
        /// <summary> Initializes a new instance of <see cref="HyperVToAzStackHciEventModelCustomProperties"/>. </summary>
        internal HyperVToAzStackHciEventModelCustomProperties()
        {
            InstanceType = "HyperVToAzStackHCI";
        }

        /// <summary> Initializes a new instance of <see cref="HyperVToAzStackHciEventModelCustomProperties"/>. </summary>
        /// <param name="instanceType"> Gets or sets the instance type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="eventSourceFriendlyName"> Gets or sets the friendly name of the source which has raised this health event. </param>
        /// <param name="protectedItemFriendlyName"> Gets or sets the protected item friendly name. </param>
        /// <param name="sourceApplianceName"> Gets or sets the source appliance name. </param>
        /// <param name="targetApplianceName"> Gets or sets the source target name. </param>
        /// <param name="serverType"> Gets or sets the server type. </param>
        internal HyperVToAzStackHciEventModelCustomProperties(string instanceType, IDictionary<string, BinaryData> serializedAdditionalRawData, string eventSourceFriendlyName, string protectedItemFriendlyName, string sourceApplianceName, string targetApplianceName, string serverType) : base(instanceType, serializedAdditionalRawData)
        {
            EventSourceFriendlyName = eventSourceFriendlyName;
            ProtectedItemFriendlyName = protectedItemFriendlyName;
            SourceApplianceName = sourceApplianceName;
            TargetApplianceName = targetApplianceName;
            ServerType = serverType;
            InstanceType = instanceType ?? "HyperVToAzStackHCI";
        }

        /// <summary> Gets or sets the friendly name of the source which has raised this health event. </summary>
        public string EventSourceFriendlyName { get; }
        /// <summary> Gets or sets the protected item friendly name. </summary>
        public string ProtectedItemFriendlyName { get; }
        /// <summary> Gets or sets the source appliance name. </summary>
        public string SourceApplianceName { get; }
        /// <summary> Gets or sets the source target name. </summary>
        public string TargetApplianceName { get; }
        /// <summary> Gets or sets the server type. </summary>
        public string ServerType { get; }
    }
}
