// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesDataReplication.Models
{
    public partial class HyperVToAzStackHciEventModelCustomProperties : IUtf8JsonSerializable, IJsonModel<HyperVToAzStackHciEventModelCustomProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<HyperVToAzStackHciEventModelCustomProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<HyperVToAzStackHciEventModelCustomProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HyperVToAzStackHciEventModelCustomProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(HyperVToAzStackHciEventModelCustomProperties)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (options.Format != "W" && Optional.IsDefined(EventSourceFriendlyName))
            {
                writer.WritePropertyName("eventSourceFriendlyName"u8);
                writer.WriteStringValue(EventSourceFriendlyName);
            }
            if (options.Format != "W" && Optional.IsDefined(ProtectedItemFriendlyName))
            {
                writer.WritePropertyName("protectedItemFriendlyName"u8);
                writer.WriteStringValue(ProtectedItemFriendlyName);
            }
            if (options.Format != "W" && Optional.IsDefined(SourceApplianceName))
            {
                writer.WritePropertyName("sourceApplianceName"u8);
                writer.WriteStringValue(SourceApplianceName);
            }
            if (options.Format != "W" && Optional.IsDefined(TargetApplianceName))
            {
                writer.WritePropertyName("targetApplianceName"u8);
                writer.WriteStringValue(TargetApplianceName);
            }
            if (options.Format != "W" && Optional.IsDefined(ServerType))
            {
                writer.WritePropertyName("serverType"u8);
                writer.WriteStringValue(ServerType);
            }
        }

        HyperVToAzStackHciEventModelCustomProperties IJsonModel<HyperVToAzStackHciEventModelCustomProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HyperVToAzStackHciEventModelCustomProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(HyperVToAzStackHciEventModelCustomProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeHyperVToAzStackHciEventModelCustomProperties(document.RootElement, options);
        }

        internal static HyperVToAzStackHciEventModelCustomProperties DeserializeHyperVToAzStackHciEventModelCustomProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string eventSourceFriendlyName = default;
            string protectedItemFriendlyName = default;
            string sourceApplianceName = default;
            string targetApplianceName = default;
            string serverType = default;
            string instanceType = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("eventSourceFriendlyName"u8))
                {
                    eventSourceFriendlyName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("protectedItemFriendlyName"u8))
                {
                    protectedItemFriendlyName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("sourceApplianceName"u8))
                {
                    sourceApplianceName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("targetApplianceName"u8))
                {
                    targetApplianceName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("serverType"u8))
                {
                    serverType = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("instanceType"u8))
                {
                    instanceType = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new HyperVToAzStackHciEventModelCustomProperties(
                instanceType,
                serializedAdditionalRawData,
                eventSourceFriendlyName,
                protectedItemFriendlyName,
                sourceApplianceName,
                targetApplianceName,
                serverType);
        }

        BinaryData IPersistableModel<HyperVToAzStackHciEventModelCustomProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HyperVToAzStackHciEventModelCustomProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(HyperVToAzStackHciEventModelCustomProperties)} does not support writing '{options.Format}' format.");
            }
        }

        HyperVToAzStackHciEventModelCustomProperties IPersistableModel<HyperVToAzStackHciEventModelCustomProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HyperVToAzStackHciEventModelCustomProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeHyperVToAzStackHciEventModelCustomProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(HyperVToAzStackHciEventModelCustomProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<HyperVToAzStackHciEventModelCustomProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
