// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.RecoveryServicesDataReplication.Models
{
    /// <summary> Failover properties of the protected item. </summary>
    public partial class FailoverProtectedItemProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="FailoverProtectedItemProperties"/>. </summary>
        internal FailoverProtectedItemProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="FailoverProtectedItemProperties"/>. </summary>
        /// <param name="protectedItemName"> Gets or sets the protected item name. </param>
        /// <param name="vmName"> Gets or sets the VM name. </param>
        /// <param name="testVmName"> Gets or sets the test VM name. </param>
        /// <param name="recoveryPointId"> Gets or sets the recovery point Id. </param>
        /// <param name="recoveryPointOn"> Gets or sets the recovery point time. </param>
        /// <param name="networkName"> Gets or sets the network name. </param>
        /// <param name="subnet"> Gets or sets the network subnet. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal FailoverProtectedItemProperties(string protectedItemName, string vmName, string testVmName, string recoveryPointId, DateTimeOffset? recoveryPointOn, string networkName, string subnet, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ProtectedItemName = protectedItemName;
            VmName = vmName;
            TestVmName = testVmName;
            RecoveryPointId = recoveryPointId;
            RecoveryPointOn = recoveryPointOn;
            NetworkName = networkName;
            Subnet = subnet;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets or sets the protected item name. </summary>
        public string ProtectedItemName { get; }
        /// <summary> Gets or sets the VM name. </summary>
        public string VmName { get; }
        /// <summary> Gets or sets the test VM name. </summary>
        public string TestVmName { get; }
        /// <summary> Gets or sets the recovery point Id. </summary>
        public string RecoveryPointId { get; }
        /// <summary> Gets or sets the recovery point time. </summary>
        public DateTimeOffset? RecoveryPointOn { get; }
        /// <summary> Gets or sets the network name. </summary>
        public string NetworkName { get; }
        /// <summary> Gets or sets the network subnet. </summary>
        public string Subnet { get; }
    }
}
