// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesDataReplication.Models
{
    /// <summary> Deployment preflight resource. </summary>
    public partial class DeploymentPreflightResourceInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DeploymentPreflightResourceInfo"/>. </summary>
        public DeploymentPreflightResourceInfo()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DeploymentPreflightResourceInfo"/>. </summary>
        /// <param name="name"> Gets or sets the resource name. </param>
        /// <param name="deploymentPreflightResourceType"> Gets or sets the resource type. </param>
        /// <param name="location"> Gets or sets the location of the resource. </param>
        /// <param name="apiVersion"> Gets or sets the Api version. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DeploymentPreflightResourceInfo(string name, ResourceType? deploymentPreflightResourceType, AzureLocation? location, string apiVersion, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            DeploymentPreflightResourceType = deploymentPreflightResourceType;
            Location = location;
            ApiVersion = apiVersion;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets or sets the resource name. </summary>
        public string Name { get; set; }
        /// <summary> Gets or sets the resource type. </summary>
        public ResourceType? DeploymentPreflightResourceType { get; set; }
        /// <summary> Gets or sets the location of the resource. </summary>
        public AzureLocation? Location { get; set; }
        /// <summary> Gets or sets the Api version. </summary>
        public string ApiVersion { get; set; }
    }
}
