// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.RecoveryServicesDataReplication.Models
{
    public partial class DataReplicationWorkflowProperties : IUtf8JsonSerializable, IJsonModel<DataReplicationWorkflowProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<DataReplicationWorkflowProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<DataReplicationWorkflowProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DataReplicationWorkflowProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DataReplicationWorkflowProperties)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(DisplayName))
            {
                writer.WritePropertyName("displayName"u8);
                writer.WriteStringValue(DisplayName);
            }
            if (options.Format != "W" && Optional.IsDefined(State))
            {
                writer.WritePropertyName("state"u8);
                writer.WriteStringValue(State.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(StartOn))
            {
                writer.WritePropertyName("startTime"u8);
                writer.WriteStringValue(StartOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(EndOn))
            {
                writer.WritePropertyName("endTime"u8);
                writer.WriteStringValue(EndOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(ObjectId))
            {
                writer.WritePropertyName("objectId"u8);
                writer.WriteStringValue(ObjectId);
            }
            if (options.Format != "W" && Optional.IsDefined(ObjectName))
            {
                writer.WritePropertyName("objectName"u8);
                writer.WriteStringValue(ObjectName);
            }
            if (options.Format != "W" && Optional.IsDefined(ObjectInternalId))
            {
                writer.WritePropertyName("objectInternalId"u8);
                writer.WriteStringValue(ObjectInternalId);
            }
            if (options.Format != "W" && Optional.IsDefined(ObjectInternalName))
            {
                writer.WritePropertyName("objectInternalName"u8);
                writer.WriteStringValue(ObjectInternalName);
            }
            if (options.Format != "W" && Optional.IsDefined(ObjectType))
            {
                writer.WritePropertyName("objectType"u8);
                writer.WriteStringValue(ObjectType.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(ReplicationProviderId))
            {
                writer.WritePropertyName("replicationProviderId"u8);
                writer.WriteStringValue(ReplicationProviderId);
            }
            if (options.Format != "W" && Optional.IsDefined(SourceFabricProviderId))
            {
                writer.WritePropertyName("sourceFabricProviderId"u8);
                writer.WriteStringValue(SourceFabricProviderId);
            }
            if (options.Format != "W" && Optional.IsDefined(TargetFabricProviderId))
            {
                writer.WritePropertyName("targetFabricProviderId"u8);
                writer.WriteStringValue(TargetFabricProviderId);
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(AllowedActions))
            {
                writer.WritePropertyName("allowedActions"u8);
                writer.WriteStartArray();
                foreach (var item in AllowedActions)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(ActivityId))
            {
                writer.WritePropertyName("activityId"u8);
                writer.WriteStringValue(ActivityId);
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(Tasks))
            {
                writer.WritePropertyName("tasks"u8);
                writer.WriteStartArray();
                foreach (var item in Tasks)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(Errors))
            {
                writer.WritePropertyName("errors"u8);
                writer.WriteStartArray();
                foreach (var item in Errors)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            writer.WritePropertyName("customProperties"u8);
            writer.WriteObjectValue(CustomProperties, options);
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        DataReplicationWorkflowProperties IJsonModel<DataReplicationWorkflowProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DataReplicationWorkflowProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DataReplicationWorkflowProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeDataReplicationWorkflowProperties(document.RootElement, options);
        }

        internal static DataReplicationWorkflowProperties DeserializeDataReplicationWorkflowProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string displayName = default;
            DataReplicationWorkflowState? state = default;
            DateTimeOffset? startTime = default;
            DateTimeOffset? endTime = default;
            string objectId = default;
            string objectName = default;
            string objectInternalId = default;
            string objectInternalName = default;
            WorkflowObjectType? objectType = default;
            string replicationProviderId = default;
            string sourceFabricProviderId = default;
            string targetFabricProviderId = default;
            IReadOnlyList<string> allowedActions = default;
            string activityId = default;
            IReadOnlyList<DataReplicationTask> tasks = default;
            IReadOnlyList<DataReplicationErrorInfo> errors = default;
            WorkflowModelCustomProperties customProperties = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("displayName"u8))
                {
                    displayName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("state"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    state = new DataReplicationWorkflowState(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("startTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    startTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("endTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    endTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("objectId"u8))
                {
                    objectId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("objectName"u8))
                {
                    objectName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("objectInternalId"u8))
                {
                    objectInternalId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("objectInternalName"u8))
                {
                    objectInternalName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("objectType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    objectType = new WorkflowObjectType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("replicationProviderId"u8))
                {
                    replicationProviderId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("sourceFabricProviderId"u8))
                {
                    sourceFabricProviderId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("targetFabricProviderId"u8))
                {
                    targetFabricProviderId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("allowedActions"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    allowedActions = array;
                    continue;
                }
                if (property.NameEquals("activityId"u8))
                {
                    activityId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("tasks"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<DataReplicationTask> array = new List<DataReplicationTask>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(DataReplicationTask.DeserializeDataReplicationTask(item, options));
                    }
                    tasks = array;
                    continue;
                }
                if (property.NameEquals("errors"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<DataReplicationErrorInfo> array = new List<DataReplicationErrorInfo>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(DataReplicationErrorInfo.DeserializeDataReplicationErrorInfo(item, options));
                    }
                    errors = array;
                    continue;
                }
                if (property.NameEquals("customProperties"u8))
                {
                    customProperties = WorkflowModelCustomProperties.DeserializeWorkflowModelCustomProperties(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new DataReplicationWorkflowProperties(
                displayName,
                state,
                startTime,
                endTime,
                objectId,
                objectName,
                objectInternalId,
                objectInternalName,
                objectType,
                replicationProviderId,
                sourceFabricProviderId,
                targetFabricProviderId,
                allowedActions ?? new ChangeTrackingList<string>(),
                activityId,
                tasks ?? new ChangeTrackingList<DataReplicationTask>(),
                errors ?? new ChangeTrackingList<DataReplicationErrorInfo>(),
                customProperties,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<DataReplicationWorkflowProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DataReplicationWorkflowProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(DataReplicationWorkflowProperties)} does not support writing '{options.Format}' format.");
            }
        }

        DataReplicationWorkflowProperties IPersistableModel<DataReplicationWorkflowProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DataReplicationWorkflowProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeDataReplicationWorkflowProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(DataReplicationWorkflowProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<DataReplicationWorkflowProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
