// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesDataReplication.Models
{
    /// <summary> Gets or sets the test failover state. </summary>
    public readonly partial struct DataReplicationTestFailoverState : IEquatable<DataReplicationTestFailoverState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataReplicationTestFailoverState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataReplicationTestFailoverState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string TestFailoverInitiatedValue = "TestFailoverInitiated";
        private const string TestFailoverCompletingValue = "TestFailoverCompleting";
        private const string TestFailoverCompletedValue = "TestFailoverCompleted";
        private const string TestFailoverFailedValue = "TestFailoverFailed";
        private const string TestFailoverCompletionFailedValue = "TestFailoverCompletionFailed";
        private const string TestFailoverCleanupInitiatedValue = "TestFailoverCleanupInitiated";
        private const string TestFailoverCleanupCompletingValue = "TestFailoverCleanupCompleting";
        private const string MarkedForDeletionValue = "MarkedForDeletion";

        /// <summary> None. </summary>
        public static DataReplicationTestFailoverState None { get; } = new DataReplicationTestFailoverState(NoneValue);
        /// <summary> TestFailoverInitiated. </summary>
        public static DataReplicationTestFailoverState TestFailoverInitiated { get; } = new DataReplicationTestFailoverState(TestFailoverInitiatedValue);
        /// <summary> TestFailoverCompleting. </summary>
        public static DataReplicationTestFailoverState TestFailoverCompleting { get; } = new DataReplicationTestFailoverState(TestFailoverCompletingValue);
        /// <summary> TestFailoverCompleted. </summary>
        public static DataReplicationTestFailoverState TestFailoverCompleted { get; } = new DataReplicationTestFailoverState(TestFailoverCompletedValue);
        /// <summary> TestFailoverFailed. </summary>
        public static DataReplicationTestFailoverState TestFailoverFailed { get; } = new DataReplicationTestFailoverState(TestFailoverFailedValue);
        /// <summary> TestFailoverCompletionFailed. </summary>
        public static DataReplicationTestFailoverState TestFailoverCompletionFailed { get; } = new DataReplicationTestFailoverState(TestFailoverCompletionFailedValue);
        /// <summary> TestFailoverCleanupInitiated. </summary>
        public static DataReplicationTestFailoverState TestFailoverCleanupInitiated { get; } = new DataReplicationTestFailoverState(TestFailoverCleanupInitiatedValue);
        /// <summary> TestFailoverCleanupCompleting. </summary>
        public static DataReplicationTestFailoverState TestFailoverCleanupCompleting { get; } = new DataReplicationTestFailoverState(TestFailoverCleanupCompletingValue);
        /// <summary> MarkedForDeletion. </summary>
        public static DataReplicationTestFailoverState MarkedForDeletion { get; } = new DataReplicationTestFailoverState(MarkedForDeletionValue);
        /// <summary> Determines if two <see cref="DataReplicationTestFailoverState"/> values are the same. </summary>
        public static bool operator ==(DataReplicationTestFailoverState left, DataReplicationTestFailoverState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataReplicationTestFailoverState"/> values are not the same. </summary>
        public static bool operator !=(DataReplicationTestFailoverState left, DataReplicationTestFailoverState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataReplicationTestFailoverState"/>. </summary>
        public static implicit operator DataReplicationTestFailoverState(string value) => new DataReplicationTestFailoverState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataReplicationTestFailoverState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataReplicationTestFailoverState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
