// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesDataReplication.Models
{
    /// <summary> Gets or sets the resynchronization state. </summary>
    public readonly partial struct DataReplicationResynchronizationState : IEquatable<DataReplicationResynchronizationState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataReplicationResynchronizationState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataReplicationResynchronizationState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string ResynchronizationInitiatedValue = "ResynchronizationInitiated";
        private const string ResynchronizationCompletedValue = "ResynchronizationCompleted";
        private const string ResynchronizationFailedValue = "ResynchronizationFailed";

        /// <summary> None. </summary>
        public static DataReplicationResynchronizationState None { get; } = new DataReplicationResynchronizationState(NoneValue);
        /// <summary> ResynchronizationInitiated. </summary>
        public static DataReplicationResynchronizationState ResynchronizationInitiated { get; } = new DataReplicationResynchronizationState(ResynchronizationInitiatedValue);
        /// <summary> ResynchronizationCompleted. </summary>
        public static DataReplicationResynchronizationState ResynchronizationCompleted { get; } = new DataReplicationResynchronizationState(ResynchronizationCompletedValue);
        /// <summary> ResynchronizationFailed. </summary>
        public static DataReplicationResynchronizationState ResynchronizationFailed { get; } = new DataReplicationResynchronizationState(ResynchronizationFailedValue);
        /// <summary> Determines if two <see cref="DataReplicationResynchronizationState"/> values are the same. </summary>
        public static bool operator ==(DataReplicationResynchronizationState left, DataReplicationResynchronizationState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataReplicationResynchronizationState"/> values are not the same. </summary>
        public static bool operator !=(DataReplicationResynchronizationState left, DataReplicationResynchronizationState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataReplicationResynchronizationState"/>. </summary>
        public static implicit operator DataReplicationResynchronizationState(string value) => new DataReplicationResynchronizationState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataReplicationResynchronizationState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataReplicationResynchronizationState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
