// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesDataReplication.Models
{
    /// <summary> Gets or sets the type of vault. </summary>
    public readonly partial struct DataReplicationReplicationVaultType : IEquatable<DataReplicationReplicationVaultType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataReplicationReplicationVaultType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataReplicationReplicationVaultType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DisasterRecoveryValue = "DisasterRecovery";
        private const string MigrateValue = "Migrate";

        /// <summary> DisasterRecovery. </summary>
        public static DataReplicationReplicationVaultType DisasterRecovery { get; } = new DataReplicationReplicationVaultType(DisasterRecoveryValue);
        /// <summary> Migrate. </summary>
        public static DataReplicationReplicationVaultType Migrate { get; } = new DataReplicationReplicationVaultType(MigrateValue);
        /// <summary> Determines if two <see cref="DataReplicationReplicationVaultType"/> values are the same. </summary>
        public static bool operator ==(DataReplicationReplicationVaultType left, DataReplicationReplicationVaultType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataReplicationReplicationVaultType"/> values are not the same. </summary>
        public static bool operator !=(DataReplicationReplicationVaultType left, DataReplicationReplicationVaultType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataReplicationReplicationVaultType"/>. </summary>
        public static implicit operator DataReplicationReplicationVaultType(string value) => new DataReplicationReplicationVaultType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataReplicationReplicationVaultType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataReplicationReplicationVaultType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
