// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesDataReplication.Models
{
    /// <summary> Gets or sets the recovery point type. </summary>
    public readonly partial struct DataReplicationRecoveryPointType : IEquatable<DataReplicationRecoveryPointType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataReplicationRecoveryPointType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataReplicationRecoveryPointType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ApplicationConsistentValue = "ApplicationConsistent";
        private const string CrashConsistentValue = "CrashConsistent";

        /// <summary> ApplicationConsistent. </summary>
        public static DataReplicationRecoveryPointType ApplicationConsistent { get; } = new DataReplicationRecoveryPointType(ApplicationConsistentValue);
        /// <summary> CrashConsistent. </summary>
        public static DataReplicationRecoveryPointType CrashConsistent { get; } = new DataReplicationRecoveryPointType(CrashConsistentValue);
        /// <summary> Determines if two <see cref="DataReplicationRecoveryPointType"/> values are the same. </summary>
        public static bool operator ==(DataReplicationRecoveryPointType left, DataReplicationRecoveryPointType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataReplicationRecoveryPointType"/> values are not the same. </summary>
        public static bool operator !=(DataReplicationRecoveryPointType left, DataReplicationRecoveryPointType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataReplicationRecoveryPointType"/>. </summary>
        public static implicit operator DataReplicationRecoveryPointType(string value) => new DataReplicationRecoveryPointType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataReplicationRecoveryPointType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataReplicationRecoveryPointType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
