// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesDataReplication.Models
{
    /// <summary> Gets or sets the provisioning state of the Dra. </summary>
    public readonly partial struct DataReplicationProvisioningState : IEquatable<DataReplicationProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataReplicationProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataReplicationProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CanceledValue = "Canceled";
        private const string CreatingValue = "Creating";
        private const string DeletingValue = "Deleting";
        private const string DeletedValue = "Deleted";
        private const string FailedValue = "Failed";
        private const string SucceededValue = "Succeeded";
        private const string UpdatingValue = "Updating";

        /// <summary> Canceled. </summary>
        public static DataReplicationProvisioningState Canceled { get; } = new DataReplicationProvisioningState(CanceledValue);
        /// <summary> Creating. </summary>
        public static DataReplicationProvisioningState Creating { get; } = new DataReplicationProvisioningState(CreatingValue);
        /// <summary> Deleting. </summary>
        public static DataReplicationProvisioningState Deleting { get; } = new DataReplicationProvisioningState(DeletingValue);
        /// <summary> Deleted. </summary>
        public static DataReplicationProvisioningState Deleted { get; } = new DataReplicationProvisioningState(DeletedValue);
        /// <summary> Failed. </summary>
        public static DataReplicationProvisioningState Failed { get; } = new DataReplicationProvisioningState(FailedValue);
        /// <summary> Succeeded. </summary>
        public static DataReplicationProvisioningState Succeeded { get; } = new DataReplicationProvisioningState(SucceededValue);
        /// <summary> Updating. </summary>
        public static DataReplicationProvisioningState Updating { get; } = new DataReplicationProvisioningState(UpdatingValue);
        /// <summary> Determines if two <see cref="DataReplicationProvisioningState"/> values are the same. </summary>
        public static bool operator ==(DataReplicationProvisioningState left, DataReplicationProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataReplicationProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(DataReplicationProvisioningState left, DataReplicationProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataReplicationProvisioningState"/>. </summary>
        public static implicit operator DataReplicationProvisioningState(string value) => new DataReplicationProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataReplicationProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataReplicationProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
