// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RecoveryServicesDataReplication.Models
{
    /// <summary> Gets or sets the protection state. </summary>
    public readonly partial struct DataReplicationProtectionState : IEquatable<DataReplicationProtectionState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataReplicationProtectionState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataReplicationProtectionState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnprotectedStatesBeginValue = "UnprotectedStatesBegin";
        private const string EnablingProtectionValue = "EnablingProtection";
        private const string EnablingFailedValue = "EnablingFailed";
        private const string DisablingProtectionValue = "DisablingProtection";
        private const string MarkedForDeletionValue = "MarkedForDeletion";
        private const string DisablingFailedValue = "DisablingFailed";
        private const string UnprotectedStatesEndValue = "UnprotectedStatesEnd";
        private const string InitialReplicationStatesBeginValue = "InitialReplicationStatesBegin";
        private const string InitialReplicationInProgressValue = "InitialReplicationInProgress";
        private const string InitialReplicationCompletedOnPrimaryValue = "InitialReplicationCompletedOnPrimary";
        private const string InitialReplicationCompletedOnRecoveryValue = "InitialReplicationCompletedOnRecovery";
        private const string InitialReplicationFailedValue = "InitialReplicationFailed";
        private const string InitialReplicationStatesEndValue = "InitialReplicationStatesEnd";
        private const string ProtectedStatesBeginValue = "ProtectedStatesBegin";
        private const string ProtectedValue = "Protected";
        private const string ProtectedStatesEndValue = "ProtectedStatesEnd";
        private const string PlannedFailoverTransitionStatesBeginValue = "PlannedFailoverTransitionStatesBegin";
        private const string PlannedFailoverInitiatedValue = "PlannedFailoverInitiated";
        private const string PlannedFailoverCompletingValue = "PlannedFailoverCompleting";
        private const string PlannedFailoverCompletedValue = "PlannedFailoverCompleted";
        private const string PlannedFailoverFailedValue = "PlannedFailoverFailed";
        private const string PlannedFailoverCompletionFailedValue = "PlannedFailoverCompletionFailed";
        private const string PlannedFailoverTransitionStatesEndValue = "PlannedFailoverTransitionStatesEnd";
        private const string UnplannedFailoverTransitionStatesBeginValue = "UnplannedFailoverTransitionStatesBegin";
        private const string UnplannedFailoverInitiatedValue = "UnplannedFailoverInitiated";
        private const string UnplannedFailoverCompletingValue = "UnplannedFailoverCompleting";
        private const string UnplannedFailoverCompletedValue = "UnplannedFailoverCompleted";
        private const string UnplannedFailoverFailedValue = "UnplannedFailoverFailed";
        private const string UnplannedFailoverCompletionFailedValue = "UnplannedFailoverCompletionFailed";
        private const string UnplannedFailoverTransitionStatesEndValue = "UnplannedFailoverTransitionStatesEnd";
        private const string CommitFailoverStatesBeginValue = "CommitFailoverStatesBegin";
        private const string CommitFailoverInProgressOnPrimaryValue = "CommitFailoverInProgressOnPrimary";
        private const string CommitFailoverInProgressOnRecoveryValue = "CommitFailoverInProgressOnRecovery";
        private const string CommitFailoverCompletedValue = "CommitFailoverCompleted";
        private const string CommitFailoverFailedOnPrimaryValue = "CommitFailoverFailedOnPrimary";
        private const string CommitFailoverFailedOnRecoveryValue = "CommitFailoverFailedOnRecovery";
        private const string CommitFailoverStatesEndValue = "CommitFailoverStatesEnd";
        private const string CancelFailoverStatesBeginValue = "CancelFailoverStatesBegin";
        private const string CancelFailoverInProgressOnPrimaryValue = "CancelFailoverInProgressOnPrimary";
        private const string CancelFailoverInProgressOnRecoveryValue = "CancelFailoverInProgressOnRecovery";
        private const string CancelFailoverFailedOnPrimaryValue = "CancelFailoverFailedOnPrimary";
        private const string CancelFailoverFailedOnRecoveryValue = "CancelFailoverFailedOnRecovery";
        private const string CancelFailoverStatesEndValue = "CancelFailoverStatesEnd";
        private const string ChangeRecoveryPointStatesBeginValue = "ChangeRecoveryPointStatesBegin";
        private const string ChangeRecoveryPointInitiatedValue = "ChangeRecoveryPointInitiated";
        private const string ChangeRecoveryPointCompletedValue = "ChangeRecoveryPointCompleted";
        private const string ChangeRecoveryPointFailedValue = "ChangeRecoveryPointFailed";
        private const string ChangeRecoveryPointStatesEndValue = "ChangeRecoveryPointStatesEnd";
        private const string ReprotectStatesBeginValue = "ReprotectStatesBegin";
        private const string ReprotectInitiatedValue = "ReprotectInitiated";
        private const string ReprotectFailedValue = "ReprotectFailed";
        private const string ReprotectStatesEndValue = "ReprotectStatesEnd";

        /// <summary> UnprotectedStatesBegin. </summary>
        public static DataReplicationProtectionState UnprotectedStatesBegin { get; } = new DataReplicationProtectionState(UnprotectedStatesBeginValue);
        /// <summary> EnablingProtection. </summary>
        public static DataReplicationProtectionState EnablingProtection { get; } = new DataReplicationProtectionState(EnablingProtectionValue);
        /// <summary> EnablingFailed. </summary>
        public static DataReplicationProtectionState EnablingFailed { get; } = new DataReplicationProtectionState(EnablingFailedValue);
        /// <summary> DisablingProtection. </summary>
        public static DataReplicationProtectionState DisablingProtection { get; } = new DataReplicationProtectionState(DisablingProtectionValue);
        /// <summary> MarkedForDeletion. </summary>
        public static DataReplicationProtectionState MarkedForDeletion { get; } = new DataReplicationProtectionState(MarkedForDeletionValue);
        /// <summary> DisablingFailed. </summary>
        public static DataReplicationProtectionState DisablingFailed { get; } = new DataReplicationProtectionState(DisablingFailedValue);
        /// <summary> UnprotectedStatesEnd. </summary>
        public static DataReplicationProtectionState UnprotectedStatesEnd { get; } = new DataReplicationProtectionState(UnprotectedStatesEndValue);
        /// <summary> InitialReplicationStatesBegin. </summary>
        public static DataReplicationProtectionState InitialReplicationStatesBegin { get; } = new DataReplicationProtectionState(InitialReplicationStatesBeginValue);
        /// <summary> InitialReplicationInProgress. </summary>
        public static DataReplicationProtectionState InitialReplicationInProgress { get; } = new DataReplicationProtectionState(InitialReplicationInProgressValue);
        /// <summary> InitialReplicationCompletedOnPrimary. </summary>
        public static DataReplicationProtectionState InitialReplicationCompletedOnPrimary { get; } = new DataReplicationProtectionState(InitialReplicationCompletedOnPrimaryValue);
        /// <summary> InitialReplicationCompletedOnRecovery. </summary>
        public static DataReplicationProtectionState InitialReplicationCompletedOnRecovery { get; } = new DataReplicationProtectionState(InitialReplicationCompletedOnRecoveryValue);
        /// <summary> InitialReplicationFailed. </summary>
        public static DataReplicationProtectionState InitialReplicationFailed { get; } = new DataReplicationProtectionState(InitialReplicationFailedValue);
        /// <summary> InitialReplicationStatesEnd. </summary>
        public static DataReplicationProtectionState InitialReplicationStatesEnd { get; } = new DataReplicationProtectionState(InitialReplicationStatesEndValue);
        /// <summary> ProtectedStatesBegin. </summary>
        public static DataReplicationProtectionState ProtectedStatesBegin { get; } = new DataReplicationProtectionState(ProtectedStatesBeginValue);
        /// <summary> Protected. </summary>
        public static DataReplicationProtectionState Protected { get; } = new DataReplicationProtectionState(ProtectedValue);
        /// <summary> ProtectedStatesEnd. </summary>
        public static DataReplicationProtectionState ProtectedStatesEnd { get; } = new DataReplicationProtectionState(ProtectedStatesEndValue);
        /// <summary> PlannedFailoverTransitionStatesBegin. </summary>
        public static DataReplicationProtectionState PlannedFailoverTransitionStatesBegin { get; } = new DataReplicationProtectionState(PlannedFailoverTransitionStatesBeginValue);
        /// <summary> PlannedFailoverInitiated. </summary>
        public static DataReplicationProtectionState PlannedFailoverInitiated { get; } = new DataReplicationProtectionState(PlannedFailoverInitiatedValue);
        /// <summary> PlannedFailoverCompleting. </summary>
        public static DataReplicationProtectionState PlannedFailoverCompleting { get; } = new DataReplicationProtectionState(PlannedFailoverCompletingValue);
        /// <summary> PlannedFailoverCompleted. </summary>
        public static DataReplicationProtectionState PlannedFailoverCompleted { get; } = new DataReplicationProtectionState(PlannedFailoverCompletedValue);
        /// <summary> PlannedFailoverFailed. </summary>
        public static DataReplicationProtectionState PlannedFailoverFailed { get; } = new DataReplicationProtectionState(PlannedFailoverFailedValue);
        /// <summary> PlannedFailoverCompletionFailed. </summary>
        public static DataReplicationProtectionState PlannedFailoverCompletionFailed { get; } = new DataReplicationProtectionState(PlannedFailoverCompletionFailedValue);
        /// <summary> PlannedFailoverTransitionStatesEnd. </summary>
        public static DataReplicationProtectionState PlannedFailoverTransitionStatesEnd { get; } = new DataReplicationProtectionState(PlannedFailoverTransitionStatesEndValue);
        /// <summary> UnplannedFailoverTransitionStatesBegin. </summary>
        public static DataReplicationProtectionState UnplannedFailoverTransitionStatesBegin { get; } = new DataReplicationProtectionState(UnplannedFailoverTransitionStatesBeginValue);
        /// <summary> UnplannedFailoverInitiated. </summary>
        public static DataReplicationProtectionState UnplannedFailoverInitiated { get; } = new DataReplicationProtectionState(UnplannedFailoverInitiatedValue);
        /// <summary> UnplannedFailoverCompleting. </summary>
        public static DataReplicationProtectionState UnplannedFailoverCompleting { get; } = new DataReplicationProtectionState(UnplannedFailoverCompletingValue);
        /// <summary> UnplannedFailoverCompleted. </summary>
        public static DataReplicationProtectionState UnplannedFailoverCompleted { get; } = new DataReplicationProtectionState(UnplannedFailoverCompletedValue);
        /// <summary> UnplannedFailoverFailed. </summary>
        public static DataReplicationProtectionState UnplannedFailoverFailed { get; } = new DataReplicationProtectionState(UnplannedFailoverFailedValue);
        /// <summary> UnplannedFailoverCompletionFailed. </summary>
        public static DataReplicationProtectionState UnplannedFailoverCompletionFailed { get; } = new DataReplicationProtectionState(UnplannedFailoverCompletionFailedValue);
        /// <summary> UnplannedFailoverTransitionStatesEnd. </summary>
        public static DataReplicationProtectionState UnplannedFailoverTransitionStatesEnd { get; } = new DataReplicationProtectionState(UnplannedFailoverTransitionStatesEndValue);
        /// <summary> CommitFailoverStatesBegin. </summary>
        public static DataReplicationProtectionState CommitFailoverStatesBegin { get; } = new DataReplicationProtectionState(CommitFailoverStatesBeginValue);
        /// <summary> CommitFailoverInProgressOnPrimary. </summary>
        public static DataReplicationProtectionState CommitFailoverInProgressOnPrimary { get; } = new DataReplicationProtectionState(CommitFailoverInProgressOnPrimaryValue);
        /// <summary> CommitFailoverInProgressOnRecovery. </summary>
        public static DataReplicationProtectionState CommitFailoverInProgressOnRecovery { get; } = new DataReplicationProtectionState(CommitFailoverInProgressOnRecoveryValue);
        /// <summary> CommitFailoverCompleted. </summary>
        public static DataReplicationProtectionState CommitFailoverCompleted { get; } = new DataReplicationProtectionState(CommitFailoverCompletedValue);
        /// <summary> CommitFailoverFailedOnPrimary. </summary>
        public static DataReplicationProtectionState CommitFailoverFailedOnPrimary { get; } = new DataReplicationProtectionState(CommitFailoverFailedOnPrimaryValue);
        /// <summary> CommitFailoverFailedOnRecovery. </summary>
        public static DataReplicationProtectionState CommitFailoverFailedOnRecovery { get; } = new DataReplicationProtectionState(CommitFailoverFailedOnRecoveryValue);
        /// <summary> CommitFailoverStatesEnd. </summary>
        public static DataReplicationProtectionState CommitFailoverStatesEnd { get; } = new DataReplicationProtectionState(CommitFailoverStatesEndValue);
        /// <summary> CancelFailoverStatesBegin. </summary>
        public static DataReplicationProtectionState CancelFailoverStatesBegin { get; } = new DataReplicationProtectionState(CancelFailoverStatesBeginValue);
        /// <summary> CancelFailoverInProgressOnPrimary. </summary>
        public static DataReplicationProtectionState CancelFailoverInProgressOnPrimary { get; } = new DataReplicationProtectionState(CancelFailoverInProgressOnPrimaryValue);
        /// <summary> CancelFailoverInProgressOnRecovery. </summary>
        public static DataReplicationProtectionState CancelFailoverInProgressOnRecovery { get; } = new DataReplicationProtectionState(CancelFailoverInProgressOnRecoveryValue);
        /// <summary> CancelFailoverFailedOnPrimary. </summary>
        public static DataReplicationProtectionState CancelFailoverFailedOnPrimary { get; } = new DataReplicationProtectionState(CancelFailoverFailedOnPrimaryValue);
        /// <summary> CancelFailoverFailedOnRecovery. </summary>
        public static DataReplicationProtectionState CancelFailoverFailedOnRecovery { get; } = new DataReplicationProtectionState(CancelFailoverFailedOnRecoveryValue);
        /// <summary> CancelFailoverStatesEnd. </summary>
        public static DataReplicationProtectionState CancelFailoverStatesEnd { get; } = new DataReplicationProtectionState(CancelFailoverStatesEndValue);
        /// <summary> ChangeRecoveryPointStatesBegin. </summary>
        public static DataReplicationProtectionState ChangeRecoveryPointStatesBegin { get; } = new DataReplicationProtectionState(ChangeRecoveryPointStatesBeginValue);
        /// <summary> ChangeRecoveryPointInitiated. </summary>
        public static DataReplicationProtectionState ChangeRecoveryPointInitiated { get; } = new DataReplicationProtectionState(ChangeRecoveryPointInitiatedValue);
        /// <summary> ChangeRecoveryPointCompleted. </summary>
        public static DataReplicationProtectionState ChangeRecoveryPointCompleted { get; } = new DataReplicationProtectionState(ChangeRecoveryPointCompletedValue);
        /// <summary> ChangeRecoveryPointFailed. </summary>
        public static DataReplicationProtectionState ChangeRecoveryPointFailed { get; } = new DataReplicationProtectionState(ChangeRecoveryPointFailedValue);
        /// <summary> ChangeRecoveryPointStatesEnd. </summary>
        public static DataReplicationProtectionState ChangeRecoveryPointStatesEnd { get; } = new DataReplicationProtectionState(ChangeRecoveryPointStatesEndValue);
        /// <summary> ReprotectStatesBegin. </summary>
        public static DataReplicationProtectionState ReprotectStatesBegin { get; } = new DataReplicationProtectionState(ReprotectStatesBeginValue);
        /// <summary> ReprotectInitiated. </summary>
        public static DataReplicationProtectionState ReprotectInitiated { get; } = new DataReplicationProtectionState(ReprotectInitiatedValue);
        /// <summary> ReprotectFailed. </summary>
        public static DataReplicationProtectionState ReprotectFailed { get; } = new DataReplicationProtectionState(ReprotectFailedValue);
        /// <summary> ReprotectStatesEnd. </summary>
        public static DataReplicationProtectionState ReprotectStatesEnd { get; } = new DataReplicationProtectionState(ReprotectStatesEndValue);
        /// <summary> Determines if two <see cref="DataReplicationProtectionState"/> values are the same. </summary>
        public static bool operator ==(DataReplicationProtectionState left, DataReplicationProtectionState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataReplicationProtectionState"/> values are not the same. </summary>
        public static bool operator !=(DataReplicationProtectionState left, DataReplicationProtectionState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataReplicationProtectionState"/>. </summary>
        public static implicit operator DataReplicationProtectionState(string value) => new DataReplicationProtectionState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataReplicationProtectionState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataReplicationProtectionState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
